"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Tuple, Union, overload
import PySide6.QtCore

bytes = str


class QDeadlineTimer(object):
    """
    https://doc.qt.io/qt-6/qdeadlinetimer.html

    **Detailed Description**

    The QDeadlineTimer class is usually used to calculate future deadlines and
    verify whether the deadline has expired. QDeadlineTimer can also be used for
    deadlines without expiration ("forever"). It forms a counterpart to
    **QElapsedTimer** , which calculates how much time has elapsed since
    **QElapsedTimer::start** () was called.

    QDeadlineTimer provides a more convenient API compared to
    **QElapsedTimer::hasExpired** ().

    The typical use-case for the class is to create a QDeadlineTimer before the
    operation in question is started, and then use **remainingTime** () or
    **hasExpired** () to determine whether to continue trying the operation.
    QDeadlineTimer objects can be passed to functions being called to execute
    this operation so they know how long to still operate.

    void executeOperation(int msecs)
            {
                **QDeadlineTimer**
    deadline(msecs);
                do {
                    if
    (readFromDevice(deadline.remainingTime()))
                        break;
    waitForReadyRead(deadline);
                } while (!deadline.hasExpired());
    }

    Many QDeadlineTimer functions deal with time out values, which all are
    measured in milliseconds. There are two special values, the same as many
    other Qt functions named `waitFor` or similar:

    * 0: no time left, expired
      * -1: infinite time left, timer never expires

    **Reference Clocks**

    QDeadlineTimer will use the same clock as **QElapsedTimer**  (see
    **QElapsedTimer::clockType** () and **QElapsedTimer::isMonotonic** ()).

    **Timer types**

    Like **QTimer** , QDeadlineTimer can select among different levels of
    coarseness on the timers. You can select precise timing by passing
    **Qt::PreciseTimer**  to the functions that set of change the timer, or you
    can select coarse timing by passing **Qt::CoarseTimer** .
    **Qt::VeryCoarseTimer**  is currently interpreted the same way as
    **Qt::CoarseTimer** .

    This feature is dependent on support from the operating system: if the OS
    does not support a coarse timer functionality, then QDeadlineTimer will
    behave like **Qt::PreciseTimer**  was passed.

    QDeadlineTimer defaults to **Qt::CoarseTimer**  because on operating systems
    that do support coarse timing, making timing calls to that clock source is
    often much more efficient. The level of coarseness depends on the operating
    system, but should be in the order of a couple of milliseconds.

    **`std::chrono` Compatibility**

    QDeadlineTimer is compatible with the `std::chrono` API from C++11 and can
    be constructed from or compared to both `std::chrono::duration` and
    `std::chrono::time_point` objects. In addition, it is fully compatible with
    the time literals from C++14, which allow one to write code as:

    using namespace std::chrono;
            using namespace std::chrono_literals;
    **QDeadlineTimer**  deadline(30s);
    device->waitForReadyRead(deadline);
            if
    (deadline.remainingTime<nanoseconds>() > 300ms)
                cleanup();

    As can be seen in the example above, QDeadlineTimer offers a templated
    version of **remainingTime** () and **deadline** () that can be used to
    return `std::chrono` objects.

    Note that comparing to `time_point` is not as efficient as comparing to
    `duration`, since QDeadlineTimer may need to convert from its own internal
    clock source to the clock source used by the `time_point` object. Also note
    that, due to this conversion, the deadlines will not be precise, so the
    following code is not expected to compare equally:

    using namespace std::chrono;
            using namespace std::chrono_literals;
    auto now = steady_clock::now();
            **QDeadlineTimer**  deadline(now +
    1s);
            Q_ASSERT(deadline == now + 1s);

    **See also** **QTime** , **QTimer** , **QDeadlineTimer** , and
    **Qt::TimerType** .
    """

    Forever: QDeadlineTimer.ForeverConstant = ...

    class ForeverConstant(Enum):
        Forever: QDeadlineTimer.ForeverConstant = ...

    @overload
    def __init__(
        self,
        QDeadlineTimer: Union[
            PySide6.QtCore.QDeadlineTimer,
            PySide6.QtCore.QDeadlineTimer.ForeverConstant,
            PySide6.QtCore.Qt.TimerType,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#QDeadlineTimer

        **QDeadlineTimer::QDeadlineTimer(Qt::TimerType timerType =
        Qt::CoarseTimer)**

        Constructs an expired QDeadlineTimer object. For this object,
        **remainingTime** () will return 0.

        The timer type **timerType** may be ignored, since the timer is already
        expired. Similarly, for optimization purposes, this function will not
        attempt to obtain the current time and will use a value known to be in
        the past. Therefore, **deadline** () may return an unexpected value and
        this object cannot be used in calculation of how long it is overdue. If
        that functionality is required, use **QDeadlineTimer::current** ().

        **See also** **hasExpired** (), **remainingTime** (), **Qt::TimerType**
        , and **current** ().
        """
        ...

    @overload
    def __init__(
        self,
        arg__1: PySide6.QtCore.QDeadlineTimer.ForeverConstant,
        type_: PySide6.QtCore.Qt.TimerType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#QDeadlineTimer-1

        **QDeadlineTimer::QDeadlineTimer(QDeadlineTimer::ForeverConstant,
        Qt::TimerType timerType = Qt::CoarseTimer)**

        QDeadlineTimer objects created with **ForeverConstant**  never expire.
        For such objects, **remainingTime** () will return -1, **deadline** ()
        will return the maximum value, and **isForever** () will return true.

        The timer type **timerType** may be ignored, since the timer will never
        expire.

        **See also** **ForeverConstant** , **hasExpired** (), **isForever** (),
        **remainingTime** (), and **timerType** ().
        """
        ...

    @overload
    def __init__(self, msecs: int, type: PySide6.QtCore.Qt.TimerType = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#QDeadlineTimer-2

        **QDeadlineTimer::QDeadlineTimer(qint64 msecs , Qt::TimerType type =
        Qt::CoarseTimer)**

        Constructs a QDeadlineTimer object with an expiry time of **msecs**
        msecs from the moment of the creation of this object, if msecs is
        positive. If **msecs** is zero, this QDeadlineTimer will be marked as
        expired, causing **remainingTime** () to return zero and **deadline** ()
        to return an indeterminate time point in the past. If **msecs** is -1,
        the timer will be set to never expire, causing **remainingTime** () to
        return -1 and **deadline** () to return the maximum value.

        The QDeadlineTimer object will be constructed with the specified timer
        **type**.

        For optimization purposes, if **msecs** is zero, this function may skip
        obtaining the current time and may instead use a value known to be in
        the past. If that happens, **deadline** () may return an unexpected
        value and this object cannot be used in calculation of how long it is
        overdue. If that functionality is required, use
        **QDeadlineTimer::current** () and add time to it.

        **See also** **hasExpired** (), **isForever** (), **remainingTime** (),
        and **setRemainingTime** ().
        """
        ...

    @overload
    def __init__(self, type_: PySide6.QtCore.Qt.TimerType = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#QDeadlineTimer-3

        **template <typename Clock, typename Duration>
        QDeadlineTimer::QDeadlineTimer(std::chrono::time_point<Clock, Duration>
        deadline , Qt::TimerType type = Qt::CoarseTimer)**

        Constructs a QDeadlineTimer object with a deadline at **deadline** time
        point, converting from the clock source `Clock` to Qt's internal clock
        source (see **QElapsedTimer::clockType** ()).

        If **deadline** is in the past, this QDeadlineTimer object is set to
        expired, whereas if **deadline** is equal to `Duration::max()`, then
        this object is set to never expire.

        The QDeadlineTimer object will be constructed with the specified timer
        **type**.

        **See also** **hasExpired** (), **isForever** (), **remainingTime** (),
        and **setDeadline** ().
        """
        ...

    def __add__(self, msecs: int) -> PySide6.QtCore.QDeadlineTimer:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, msecs: int) -> PySide6.QtCore.QDeadlineTimer:
        ...

    def __isub__(self, msecs: int) -> PySide6.QtCore.QDeadlineTimer:
        ...

    @overload
    def __sub__(
        self,
        dt2: Union[
            PySide6.QtCore.QDeadlineTimer,
            PySide6.QtCore.QDeadlineTimer.ForeverConstant,
            PySide6.QtCore.Qt.TimerType,
            int,
        ],
    ) -> int:
        ...

    @overload
    def __sub__(self, msecs: int) -> PySide6.QtCore.QDeadlineTimer:
        ...

    def _q_data(self) -> Tuple[int, int]:
        ...

    @staticmethod
    def addNSecs(
        dt: Union[
            PySide6.QtCore.QDeadlineTimer,
            PySide6.QtCore.QDeadlineTimer.ForeverConstant,
            PySide6.QtCore.Qt.TimerType,
            int,
        ],
        nsecs: int,
    ) -> PySide6.QtCore.QDeadlineTimer:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#addNSecs

        **[static] QDeadlineTimer QDeadlineTimer::addNSecs(QDeadlineTimer dt ,
        qint64 nsecs )**

        Returns a **QDeadlineTimer**  object whose deadline is extended from
        **dt** 's deadline by **nsecs** nanoseconds. If **dt** was set to never
        expire, this function returns a **QDeadlineTimer**  that will not expire
        either.

        **Note:** if **dt** was created as expired, its deadline is
        indeterminate and adding an amount of time may or may not cause it to
        become unexpired.
        """
        ...

    @staticmethod
    def current(
        timerType: PySide6.QtCore.Qt.TimerType = ...,
    ) -> PySide6.QtCore.QDeadlineTimer:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#current

        **[static] QDeadlineTimer QDeadlineTimer::current(Qt::TimerType
        timerType = Qt::CoarseTimer)**

        Returns a **QDeadlineTimer**  that is expired but is guaranteed to
        contain the current time. Objects created by this function can
        participate in the calculation of how long a timer is overdue, using the
        **deadline** () function.

        The **QDeadlineTimer**  object will be constructed with the specified
        **timerType**.
        """
        ...

    def deadline(self) -> int:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#deadline

        **qint64 QDeadlineTimer::deadline() const**

        Returns the absolute time point for the deadline stored in
        **QDeadlineTimer**  object, calculated in milliseconds relative to the
        reference clock, the same as **QElapsedTimer::msecsSinceReference** ().
        The value will be in the past if this **QDeadlineTimer**  has expired.

        If this **QDeadlineTimer**  never expires, this function returns
        `std::numeric_limits<qint64>::max()`.

        This function can be used to calculate the amount of time a timer is
        overdue, by subtracting **QDeadlineTimer::current** () or
        **QElapsedTimer::msecsSinceReference** (), as in the following example:

        **qint64**  realTimeLeft = deadline.deadline();
                if (realTimeLeft
        != (std::numeric_limits<**qint64** >::max)()) {
                    realTimeLeft
        -= **QDeadlineTimer** ::current().deadline();
                    // or:
        //QElapsedTimer timer;
                    //timer.start();
        //realTimeLeft -= timer.msecsSinceReference();
                }

        **Note:** Timers that were created as expired have an indetermine time
        point in the past as their deadline, so the above calculation may not
        work.

        **See also** **remainingTime** (), **deadlineNSecs** (), and
        **setDeadline** ().
        """
        ...

    def deadlineNSecs(self) -> int:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#deadlineNSecs

        **qint64 QDeadlineTimer::deadlineNSecs() const**

        Returns the absolute time point for the deadline stored in
        **QDeadlineTimer**  object, calculated in nanoseconds relative to the
        reference clock, the same as **QElapsedTimer::msecsSinceReference** ().
        The value will be in the past if this **QDeadlineTimer**  has expired.

        If this **QDeadlineTimer**  never expires or the number of nanoseconds
        until the deadline can't be accommodated in the return type, this
        function returns `std::numeric_limits<qint64>::max()`.

        This function can be used to calculate the amount of time a timer is
        overdue, by subtracting **QDeadlineTimer::current** (), as in the
        following example:

        **qint64**  realTimeLeft = deadline.deadlineNSecs();
                if
        (realTimeLeft != std::numeric_limits<**qint64** >::max())
        realTimeLeft -= **QDeadlineTimer** ::current().deadlineNSecs();

        **Note:** Timers that were created as expired have an indetermine time
        point in the past as their deadline, so the above calculation may not
        work.

        **See also** **remainingTime** () and deadlineNSecs().
        """
        ...

    def hasExpired(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#hasExpired

        **bool QDeadlineTimer::hasExpired() const**

        Returns true if this **QDeadlineTimer**  object has expired, false if
        there remains time left. For objects that have expired,
        **remainingTime** () will return zero and **deadline** () will return a
        time point in the past.

        **QDeadlineTimer**  objects created with the **ForeverConstant**  never
        expire and this function always returns false for them.

        **See also** **isForever** () and **remainingTime** ().
        """
        ...

    def isForever(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#isForever

        **bool QDeadlineTimer::isForever() const**

        Returns true if this **QDeadlineTimer**  object never expires, false
        otherwise. For timers that never expire, **remainingTime** () always
        returns -1 and **deadline** () returns the maximum value.

        **See also** **ForeverConstant** , **hasExpired** (), and
        **remainingTime** ().
        """
        ...

    def remainingTime(self) -> int:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#remainingTime

        **qint64 QDeadlineTimer::remainingTime() const**

        Returns the remaining time in this **QDeadlineTimer**  object in
        milliseconds. If the timer has already expired, this function will
        return zero and it is not possible to obtain the amount of time overdue
        with this function (to do that, see **deadline** ()). If the timer was
        set to never expire, this function returns -1.

        This function is suitable for use in Qt APIs that take a millisecond
        timeout, such as the many **QIODevice**  `waitFor` functions or the
        timed lock functions in **QMutex** , **QWaitCondition** , **QSemaphore**
        , or **QReadWriteLock** . For example:

        mutex.tryLock(deadline.remainingTime());

        **See also** **setRemainingTime** (), **remainingTimeNSecs** (),
        **isForever** (), and **hasExpired** ().
        """
        ...

    def remainingTimeNSecs(self) -> int:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#remainingTimeNSecs

        **qint64 QDeadlineTimer::remainingTimeNSecs() const**

        Returns the remaining time in this **QDeadlineTimer**  object in
        nanoseconds. If the timer has already expired, this function will return
        zero and it is not possible to obtain the amount of time overdue with
        this function. If the timer was set to never expire, this function
        returns -1.

        **See also** **remainingTime** (), **isForever** (), and **hasExpired**
        ().
        """
        ...

    def setDeadline(
        self, msecs: int, timerType: PySide6.QtCore.Qt.TimerType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#setDeadline

        **void QDeadlineTimer::setDeadline(qint64 msecs , Qt::TimerType
        timerType = Qt::CoarseTimer)**

        Sets the deadline for this **QDeadlineTimer**  object to be the
        **msecs** absolute time point, counted in milliseconds since the
        reference clock (the same as **QElapsedTimer::msecsSinceReference** ()),
        and the timer type to **timerType**. If the value is in the past, this
        **QDeadlineTimer**  will be marked as expired.

        If **msecs** is `std::numeric_limits<qint64>::max()` or the deadline is
        beyond a representable point in the future, this **QDeadlineTimer**
        will be set to never expire.

        **See also** **setPreciseDeadline** (), **deadline** (),
        **deadlineNSecs** (), and **setRemainingTime** ().
        """
        ...

    def setPreciseDeadline(
        self, secs: int, nsecs: int = ..., type: PySide6.QtCore.Qt.TimerType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#setPreciseDeadline

        **void QDeadlineTimer::setPreciseDeadline(qint64 secs , qint64 nsecs =
        0, Qt::TimerType timerType = Qt::CoarseTimer)**

        Sets the deadline for this **QDeadlineTimer**  object to be **secs**
        seconds and **nsecs** nanoseconds since the reference clock epoch (the
        same as **QElapsedTimer::msecsSinceReference** ()), and the timer type
        to **timerType**. If the value is in the past, this **QDeadlineTimer**
        will be marked as expired.

        If **secs** or **nsecs** is `std::numeric_limits<qint64>::max()`, this
        **QDeadlineTimer**  will be set to never expire. If **nsecs** is more
        than 1 billion nanoseconds (1 second), then **secs** will be adjusted
        accordingly.

        **See also** **setDeadline** (), **deadline** (), **deadlineNSecs** (),
        and **setRemainingTime** ().
        """
        ...

    def setPreciseRemainingTime(
        self, secs: int, nsecs: int = ..., type: PySide6.QtCore.Qt.TimerType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#setPreciseRemainingTime

        **void QDeadlineTimer::setPreciseRemainingTime(qint64 secs , qint64
        nsecs = 0, Qt::TimerType timerType = Qt::CoarseTimer)**

        Sets the remaining time for this **QDeadlineTimer**  object to **secs**
        seconds plus **nsecs** nanoseconds from now, if **secs** has a positive
        value. If **secs** is -1, this **QDeadlineTimer**  will be set it to
        never expire. If both parameters are zero, this **QDeadlineTimer**  will
        be marked as expired.

        The timer type for this **QDeadlineTimer**  object will be set to the
        specified **timerType**.

        **See also** **setRemainingTime** (), **hasExpired** (), **isForever**
        (), and **remainingTime** ().
        """
        ...

    def setRemainingTime(
        self, msecs: int, type: PySide6.QtCore.Qt.TimerType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#setRemainingTime

        **void QDeadlineTimer::setRemainingTime(qint64 msecs , Qt::TimerType
        timerType = Qt::CoarseTimer)**

        Sets the remaining time for this **QDeadlineTimer**  object to **msecs**
        milliseconds from now, if **msecs** has a positive value. If **msecs**
        is zero, this **QDeadlineTimer**  object will be marked as expired,
        whereas a value of -1 will set it to never expire.

        The timer type for this **QDeadlineTimer**  object will be set to the
        specified **timerType**.

        **See also** **setPreciseRemainingTime** (), **hasExpired** (),
        **isForever** (), and **remainingTime** ().
        """
        ...

    def setTimerType(self, type: PySide6.QtCore.Qt.TimerType) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#setTimerType

        **void QDeadlineTimer::setTimerType(Qt::TimerType timerType )**

        Changes the timer type for this object to **timerType**.

        The behavior for each possible value of **timerType** is operating-
        system dependent. **Qt::PreciseTimer**  will use the most precise timer
        that Qt can find, with resolution of 1 millisecond or better, whereas
        **QDeadlineTimer**  will try to use a more coarse timer for
        **Qt::CoarseTimer**  and **Qt::VeryCoarseTimer** .

        **See also** **timerType** () and **Qt::TimerType** .
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtCore.QDeadlineTimer,
            PySide6.QtCore.QDeadlineTimer.ForeverConstant,
            PySide6.QtCore.Qt.TimerType,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#swap

        **void QDeadlineTimer::swap(QDeadlineTimer & other )**

        Swaps this deadline timer with the **other** deadline timer.
        """
        ...

    def timerType(self) -> PySide6.QtCore.Qt.TimerType:
        """
        https://doc.qt.io/qt-6/qdeadlinetimer.html#timerType

        **Qt::TimerType QDeadlineTimer::timerType() const**

        Returns the timer type is active for this object.

        **See also** **setTimerType** ().
        """
        ...
