"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore

bytes = str


class QCollatorSortKey(object):
    """
    https://doc.qt.io/qt-6/qcollatorsortkey.html

    **Detailed Description**

    The QCollatorSortKey class is always created by **QCollator::sortKey** ()
    and is used for fast strings collation, for example when collating many
    strings.

    **See also** **QCollator** , **QCollator::sortKey** (), and **compare** ().
    """

    def __init__(self, other: PySide6.QtCore.QCollatorSortKey) -> None:
        """
        https://doc.qt.io/qt-6/qcollatorsortkey.html#QCollatorSortKey

        **QCollatorSortKey::QCollatorSortKey(const QCollatorSortKey & other )**

        Constructs a copy of the **other** collator key.
        """
        ...

    def compare(self, key: PySide6.QtCore.QCollatorSortKey) -> int:
        """
        https://doc.qt.io/qt-6/qcollatorsortkey.html#compare

        **int QCollatorSortKey::compare(const QCollatorSortKey & otherKey )
        const**

        Compares this key to **otherKey** , which must have been created by the
        same **QCollator** 's sortKey() as this key. The comparison is performed
        in accordance with that **QCollator** 's sort order.

        Returns a negative value if this key sorts before **otherKey** , 0 if
        the two keys are equal or a positive value if this key sorts after
        **otherKey**.

        **See also** **operator<** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QCollatorSortKey) -> None:
        """
        https://doc.qt.io/qt-6/qcollatorsortkey.html#swap

        **void QCollatorSortKey::swap(QCollatorSortKey & other )**

        Swaps this collator key with **other**.
        """
        ...
