"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, List, Union, overload
import PySide6.QtCore

bytes = str


class QCborMap(object):
    """
    https://doc.qt.io/qt-6/qcbormap.html

    **Detailed Description**

    This class can be used to hold an associative container in CBOR, a map
    between a key and a value type. CBOR is the Concise Binary Object
    Representation, a very compact form of binary data encoding that is a
    superset of JSON. It was created by the IETF Constrained RESTful
    Environments (CoRE) WG, which has used it in many new RFCs. It is meant to
    be used alongside the **CoAP protocol** .

    Unlike JSON and **QVariantMap** , CBOR map keys can be of any type, not just
    strings. For that reason, QCborMap is effectively a map between
    **QCborValue**  keys to **QCborValue**  value elements.

    However, for all member functions that take a key parameter, QCborMap
    provides overloads that will work efficiently with integers and strings. In
    fact, the use of integer keys is encouraged, since they occupy fewer bytes
    to transmit and are simpler to encode and decode. Newer protocols designed
    by the IETF CoRE WG to work specifically with CBOR are known to use them.

    QCborMap is not sorted, because of that, searching for keys has linear
    complexity (O(n)). QCborMap actually keeps the elements in the order that
    they were inserted, which means that it is possible to make sorted QCborMaps
    by carefully inserting elements in sorted order. CBOR does not require
    sorting, but recommends it.

    QCborMap can also be converted to and from QVariantMap and **QJsonObject** .
    However, when performing the conversion, any non-string keys will be
    stringified using a one-way method that the conversion back to QCborMap will
    not undo.

    **See also** **QCborArray** , **QCborValue** , **QJsonDocument** , and
    **QVariantMap** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#QCborMap

        **QCborMap::QCborMap()**

        Constructs an empty CBOR Map object.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtCore.QCborMap) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#QCborMap-1

        **QCborMap::QCborMap(const QCborMap & other )**

        Creates a QCborMap object that is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#clear

        **void QCborMap::clear()**

        Empties this map.

        **See also** **isEmpty** ().
        """
        ...

    def compare(self, other: PySide6.QtCore.QCborMap) -> int:
        """
        https://doc.qt.io/qt-6/qcbormap.html#compare

        **int QCborMap::compare(const QCborMap & other ) const**

        Compares this map and **other** , comparing each element in sequence,
        and returns an integer that indicates whether this map should be sorted
        prior to (if the result is negative) or after **other** (if the result
        is positive). If this function returns 0, the two maps are equal and
        contain the same elements.

        Note that CBOR maps are unordered, which means that two maps containing
        the very same pairs but in different order will still compare
        differently. To avoid this, it is recommended to insert elements into
        the map in a predictable order, such as by ascending key value. In fact,
        maps with keys in sorted order are required for Canonical CBOR
        representation.

        For more information on CBOR sorting order, see **QCborValue::compare**
        ().

        **See also** **QCborValue::compare** (), **QCborArray::compare** (), and
        **operator==** ().
        """
        ...

    @overload
    def contains(self, key: str) -> bool:
        """
        https://doc.qt.io/qt-6/qcbormap.html#contains

        **bool QCborMap::contains(qint64 key ) const**

        Returns true if this map contains a key-value pair identified by key
        **key**. CBOR recommends using integer keys, since they occupy less
        space and are simpler to encode and decode.

        **See also** **value** (qint64), **operator[]** (qint64), **find**
        (qint64), **remove** (qint64), **contains** (QLatin1String), **remove**
        (const QString &), and **remove** (const QCborValue &).
        """
        ...

    @overload
    def contains(self, key: int) -> bool:
        """
        https://doc.qt.io/qt-6/qcbormap.html#contains-1

        **bool QCborMap::contains(QLatin1String key ) const**

        This is an overloaded function.

        Returns true if this map contains a key-value pair identified by key
        **key**.

        **See also** **value** (QLatin1String), **operator[]** (QLatin1String),
        **find** (QLatin1String), **remove** (QLatin1String), **contains**
        (qint64), **remove** (const QString &), and **remove** (const QCborValue
        &).
        """
        ...

    @overload
    def contains(
        self,
        key: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qcbormap.html#contains-2

        **bool QCborMap::contains(const QString & key ) const**

        This is an overloaded function.

        Returns true if this map contains a key-value pair identified by key
        **key**.

        **See also** **value** (const QString &), **operator[]** (const QString
        &), **find** (const QString &), **remove** (const QString &),
        **contains** (qint64), **remove** (QLatin1String), and **remove** (const
        QCborValue &).
        """
        ...

    def empty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcbormap.html#empty

        **bool QCborMap::empty() const**

        Synonym for **isEmpty** (). This function is provided for compatibility
        with generic code that uses the Standard Library API.

        Returns true if this map is empty (**size** () == 0).

        **See also** **isEmpty** () and **size** ().
        """
        ...

    @staticmethod
    def fromJsonObject(
        o: Dict[str, PySide6.QtCore.QJsonValue]
    ) -> PySide6.QtCore.QCborMap:
        """
        https://doc.qt.io/qt-6/qcbormap.html#fromJsonObject

        **[static] QCborMap QCborMap::fromJsonObject(const QJsonObject & obj )**

        Converts all JSON items found in the **obj** object to CBOR using
        QCborValue::fromJson(), and returns the map composed of those elements.

        This conversion is lossless, as the CBOR type system is a superset of
        JSON's. Moreover, the map returned by this function can be converted
        back to the original **obj** by using **toJsonObject** ().

        **See also** **toJsonObject** (), **toVariantMap** (),
        **QCborValue::fromJsonValue** (), and **QCborArray::fromJsonArray** ().
        """
        ...

    @staticmethod
    def fromVariantHash(hash: Dict[str, Any]) -> PySide6.QtCore.QCborMap:
        """
        https://doc.qt.io/qt-6/qcbormap.html#fromVariantHash

        **[static] QCborMap QCborMap::fromVariantHash(const QVariantHash & hash
        )**

        Converts all the items in **hash** to CBOR using
        **QCborValue::fromVariant** () and returns the map composed of those
        elements.

        Conversion from **QVariant**  is not completely lossless. Please see the
        documentation in **QCborValue::fromVariant** () for more information.

        **See also** **toVariantHash** (), **fromVariantMap** (),
        **fromJsonObject** (), and **QCborValue::fromVariant** ().
        """
        ...

    @staticmethod
    def fromVariantMap(map: Dict[str, Any]) -> PySide6.QtCore.QCborMap:
        """
        https://doc.qt.io/qt-6/qcbormap.html#fromVariantMap

        **[static] QCborMap QCborMap::fromVariantMap(const QVariantMap & map )**

        Converts all the items in **map** to CBOR using
        **QCborValue::fromVariant** () and returns the map composed of those
        elements.

        Conversion from **QVariant**  is not completely lossless. Please see the
        documentation in **QCborValue::fromVariant** () for more information.

        **See also** **toVariantMap** (), **fromVariantHash** (),
        **fromJsonObject** (), and **QCborValue::fromVariant** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcbormap.html#isEmpty

        **bool QCborMap::isEmpty() const**

        Returns true if this map is empty (that is, **size** () is 0).

        **See also** **size** () and **clear** ().
        """
        ...

    def keys(self) -> List[PySide6.QtCore.QCborValue]:
        """
        https://doc.qt.io/qt-6/qcbormap.html#keys

        **QList<QCborValue> QCborMap::keys() const**

        Returns a list of all keys in this map.

        **See also** **QMap::keys** () and **QHash::keys** ().
        """
        ...

    @overload
    def remove(self, key: str) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#remove

        **void QCborMap::remove(qint64 key )**

        Removes the key **key** and the corresponding value from the map, if it
        is found. If the map contains no such key, this function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        remove(**QLatin1String** ), remove(const **QString**  &), remove(const
        **QCborValue**  &)

        **See also** **value** (qint64), **operator[]** (qint64), **find**
        (qint64), and **contains** (qint64).
        """
        ...

    @overload
    def remove(self, key: int) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#remove-1

        **void QCborMap::remove(QLatin1String key )**

        This is an overloaded function.

        Removes the key **key** and the corresponding value from the map, if it
        is found. If the map contains no such key, this function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        remove(qint64), remove(const **QString**  &), remove(const
        **QCborValue**  &)

        **See also** **value** (QLatin1String), **operator[]** (QLatin1String),
        **find** (QLatin1String), and **contains** (QLatin1String).
        """
        ...

    @overload
    def remove(
        self,
        key: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#remove-2

        **void QCborMap::remove(const QString & key )**

        This is an overloaded function.

        Removes the key **key** and the corresponding value from the map, if it
        is found. If the map contains no such key, this function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        remove(qint64), remove(**QLatin1String** ), remove(const **QCborValue**
        &)

        **See also** **value** (const QString &), **operator[]** (const QString
        &), **find** (const QString &), and **contains** (const QString &).
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qcbormap.html#size

        **qsizetype QCborMap::size() const**

        Returns the number of elements in this map.

        **See also** **isEmpty** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QCborMap) -> None:
        """
        https://doc.qt.io/qt-6/qcbormap.html#swap

        **void QCborMap::swap(QCborMap & other )**

        Swaps the contents of this map and **other**.
        """
        ...

    @overload
    def take(self, key: str) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#take

        **QCborValue QCborMap::take(qint64 key )**

        Removes the key **key** and the corresponding value from the map and
        returns the value, if it is found. If the map contains no such key, this
        function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        **See also** **value** (qint64), **operator[]** (qint64), **find**
        (qint64), **contains** (qint64), **take** (QLatin1String), **take**
        (const QString &), **take** (const QCborValue &), and **insert** ().
        """
        ...

    @overload
    def take(self, key: int) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#take-1

        **QCborValue QCborMap::take(QLatin1String key )**

        Removes the key **key** and the corresponding value from the map and
        returns the value, if it is found. If the map contains no such key, this
        function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        **See also** **value** (QLatin1String), **operator[]** (QLatin1String),
        **find** (QLatin1String), **contains** (QLatin1String), **take**
        (qint64), **take** (const QString &), **take** (const QCborValue &), and
        **insert** ().
        """
        ...

    @overload
    def take(
        self,
        key: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#take-2

        **QCborValue QCborMap::take(const QString & key )**

        Removes the key **key** and the corresponding value from the map and
        returns the value, if it is found. If the map contains no such key, this
        function does nothing.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will remove. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        **See also** **value** (const QString &), **operator[]** (const QString
        &), **find** (const QString &), **contains** (const QString &), **take**
        (QLatin1String), **take** (qint64), **take** (const QCborValue &), and
        **insert** ().
        """
        ...

    def toCborValue(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#toCborValue

        **QCborValue QCborMap::toCborValue() const**

        Explicitly constructs a **QCborValue**  object that represents this map.
        This function is usually not necessary since **QCborValue**  has a
        constructor for **QCborMap** , so the conversion is implicit.

        Converting **QCborMap**  to **QCborValue**  allows it to be used in any
        context where QCborValues can be used, including as keys and mapped
        types in **QCborMap** , as well as **QCborValue::toCbor** ().

        **See also** **QCborValue::QCborValue** (const QCborMap &).
        """
        ...

    def toJsonObject(self) -> Dict[str, PySide6.QtCore.QJsonValue]:
        """
        https://doc.qt.io/qt-6/qcbormap.html#toJsonObject

        **QJsonObject QCborMap::toJsonObject() const**

        Recursively converts every **QCborValue**  value in this map to JSON
        using **QCborValue::toJsonValue** () and creates a string key for all
        keys that aren't strings, then returns the corresponding **QJsonObject**
        composed of those associations.

        Please note that CBOR contains a richer and wider type set than JSON, so
        some information may be lost in this conversion. For more details on
        what conversions are applied, see **QCborValue::toJsonValue** ().

        **Map key conversion to string**

        JSON objects are defined as having string keys, unlike CBOR, so the
        conversion of a **QCborMap**  to **QJsonObject**  will imply a step of
        "stringification" of the key values. The conversion will use the special
        handling of tags and extended types from above and will also convert the
        rest of the types as follows:

        TypeTransformation
        Bool"true" and "false"
        Null"null"
        Undefined"undefined"
        IntegerThe decimal string form of the number
        DoubleThe decimal string form of the number
        Byte arrayUnless tagged
        differently (see above), encoded as Base64url
        ArrayReplaced by the
        compact form of its **Diagnostic notation**
        MapReplaced by the compact
        form of its **Diagnostic notation**
        Tags and extended typesTag number
        is dropped and the tagged value is converted to string

        **See also** **fromJsonObject** (), **QCborValue::toJsonValue** (),
        **QCborArray::toJsonArray** (), and **toVariantMap** ().
        """
        ...

    def toVariantHash(self) -> Dict[str, Any]:
        """
        https://doc.qt.io/qt-6/qcbormap.html#toVariantHash

        **QVariantHash QCborMap::toVariantHash() const**

        Converts the CBOR values to **QVariant**  using
        **QCborValue::toVariant** () and "stringifies" all the CBOR keys in this
        map, returning the QVariantHash that results from that association list.

        QVariantMaps have string keys, unlike CBOR, so the conversion of a
        **QCborMap**  to QVariantMap will imply a step of "stringification" of
        the key values. See **QCborMap::toJsonObject** () for details.

        In addition, the conversion to **QVariant**  is not completely lossless.
        Please see the documentation in **QCborValue::toVariant** () for more
        information.

        **See also** **fromVariantHash** (), **toVariantMap** (),
        **toJsonObject** (), **QCborValue::toVariant** (), and
        **QCborArray::toVariantList** ().
        """
        ...

    def toVariantMap(self) -> Dict[str, Any]:
        """
        https://doc.qt.io/qt-6/qcbormap.html#toVariantMap

        **QVariantMap QCborMap::toVariantMap() const**

        Converts the CBOR values to **QVariant**  using
        **QCborValue::toVariant** () and "stringifies" all the CBOR keys in this
        map, returning the QVariantMap that results from that association list.

        QVariantMaps have string keys, unlike CBOR, so the conversion of a
        **QCborMap**  to QVariantMap will imply a step of "stringification" of
        the key values. See **QCborMap::toJsonObject** () for details.

        In addition, the conversion to **QVariant**  is not completely lossless.
        Please see the documentation in **QCborValue::toVariant** () for more
        information.

        **See also** **fromVariantMap** (), **toVariantHash** (),
        **toJsonObject** (), **QCborValue::toVariant** (), and
        **QCborArray::toVariantList** ().
        """
        ...

    @overload
    def value(self, key: str) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#value

        **QCborValue QCborMap::value(qint64 key ) const**

        Returns the **QCborValue**  element in this map that corresponds to key
        **key** , if there is one. CBOR recommends using integer keys, since
        they occupy less space and are simpler to encode and decode.

        If the map does not contain key **key** , this function returns a
        **QCborValue**  containing an undefined value. For that reason, it is
        not possible with this function to tell apart the situation where the
        key was not present from the situation where the key was mapped to an
        undefined value.

        If the map contains more than one key equal to **key** , it is undefined
        which one the return from function will reference. **QCborMap**  does
        not allow inserting duplicate keys, but it is possible to create such a
        map by decoding a CBOR stream with them. They are usually not permitted
        and having duplicate keys is usually an indication of a problem in the
        sender.

        value(**QLatin1String** ), value(const **QString**  &), value(const
        **QCborValue**  &)

        **See also** **operator[]** (qint64), **find** (qint64), **constFind**
        (qint64), **remove** (qint64), and **contains** (qint64).
        """
        ...

    @overload
    def value(self, key: int) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#value-1

        **QCborValue QCborMap::value(QLatin1String key ) const**

        This is an overloaded function.

        Returns the **QCborValue**  element in this map that corresponds to key
        **key** , if there is one.

        If the map does not contain key **key** , this function returns a
        **QCborValue**  containing an undefined value. For that reason, it is
        not possible with this function to tell apart the situation where the
        key was not present from the situation where the key was mapped to an
        undefined value.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will return. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        value(qint64), value(const **QString**  &), value(const **QCborValue**
        &)

        **See also** **operator[]** (QLatin1String), **find** (QLatin1String),
        **constFind** (QLatin1String), **remove** (QLatin1String), and
        **contains** (QLatin1String).
        """
        ...

    @overload
    def value(
        self,
        key: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcbormap.html#value-2

        **QCborValue QCborMap::value(const QString & key ) const**

        This is an overloaded function.

        Returns the **QCborValue**  element in this map that corresponds to key
        **key** , if there is one.

        If the map does not contain key **key** , this function returns a
        **QCborValue**  containing an undefined value. For that reason, it is
        not possible with this function to tell apart the situation where the
        key was not present from the situation where the key was mapped to an
        undefined value.

        If the map contains more than one key equal to **key** , it is undefined
        which one this function will return. **QCborMap**  does not allow
        inserting duplicate keys, but it is possible to create such a map by
        decoding a CBOR stream with them. They are usually not permitted and
        having duplicate keys is usually an indication of a problem in the
        sender.

        value(qint64), value(**QLatin1String** ), value(const **QCborValue**  &)

        **See also** **operator[]** (const QString &), **find** (const QString
        &), **constFind** (const QString &), **remove** (const QString &), and
        **contains** (const QString &).
        """
        ...
