"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Any, List, Sequence, Union, overload
import PySide6.QtCore

bytes = str


class QCborArray(object):
    """
    https://doc.qt.io/qt-6/qcborarray.html

    **Detailed Description**

    This class can be used to hold one sequential container in CBOR (an array).
    CBOR is the Concise Binary Object Representation, a very compact form of
    binary data encoding that is a superset of JSON. It was created by the IETF
    Constrained RESTful Environments (CoRE) WG, which has used it in many new
    RFCs. It is meant to be used alongside the **CoAP protocol** .

    QCborArray is very similar to **QVariantList**  and **QJsonArray**  and its
    API is almost identical to those two classes. It can also be converted to
    and from those two, though there may be loss of information in some
    conversions.

    **See also** **QCborValue** , **QCborMap** , **QJsonArray** , and **QList**
    .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#QCborArray

        **QCborArray::QCborArray()**

        Constructs an empty QCborArray.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtCore.QCborArray) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#QCborArray-1

        **QCborArray::QCborArray(const QCborArray & other )**

        Copies the contents of **other** into this object.
        """
        ...

    def __add__(
        self,
        v: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> PySide6.QtCore.QCborArray:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(
        self,
        v: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> PySide6.QtCore.QCborArray:
        ...

    def __lshift__(
        self,
        v: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> PySide6.QtCore.QCborArray:
        ...

    def append(
        self,
        value: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        ...

    def at(self, i: int) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#at

        **QCborValue QCborArray::at(qsizetype i ) const**

        Returns the **QCborValue**  element at position **i** in the array.

        If the array is smaller than **i** elements, this function returns a
        **QCborValue**  containing an undefined value. For that reason, it is
        not possible with this function to tell apart the situation where the
        array is not large enough from the case where the array starts with an
        undefined value.

        **See also** **operator[]** (), **first** (), **last** (), **insert**
        (), **prepend** (), **append** (), **removeAt** (), and **takeAt** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#clear

        **void QCborArray::clear()**

        Empties this array.

        **See also** **isEmpty** ().
        """
        ...

    def compare(self, other: PySide6.QtCore.QCborArray) -> int:
        """
        https://doc.qt.io/qt-6/qcborarray.html#compare

        **int QCborArray::compare(const QCborArray & other ) const**

        Compares this array and **other** , comparing each element in sequence,
        and returns an integer that indicates whether this array should be
        sorted before (if the result is negative) or after **other** (if the
        result is positive). If this function returns 0, the two arrays are
        equal and contain the same elements.

        For more information on CBOR sorting order, see **QCborValue::compare**
        ().

        **See also** **QCborValue::compare** (), **QCborMap::compare** (), and
        **operator==** ().
        """
        ...

    def contains(
        self,
        value: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qcborarray.html#contains

        **bool QCborArray::contains(const QCborValue & value ) const**

        Returns true if this array contains an element that is equal to
        **value**.
        """
        ...

    def empty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborarray.html#empty

        **bool QCborArray::empty() const**

        Synonym for **isEmpty** (). This function is provided for compatibility
        with generic code that uses the Standard Library API.

        Returns true if this array is empty (**size** () == 0).

        **See also** **isEmpty** () and **size** ().
        """
        ...

    def first(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#first

        **QCborValue QCborArray::first() const**

        Returns the first **QCborValue**  of this array.

        If the array is empty, this function returns a **QCborValue**
        containing an undefined value. For that reason, it is not possible with
        this function to tell apart the situation where the array is not large
        enough from the case where the array ends with an undefined value.

        **See also** **operator[]** (), **at** (), **last** (), **insert** (),
        **prepend** (), **append** (), **removeAt** (), and **takeAt** ().
        """
        ...

    @staticmethod
    def fromJsonArray(array: PySide6.QtCore.QJsonArray) -> PySide6.QtCore.QCborArray:
        """
        https://doc.qt.io/qt-6/qcborarray.html#fromJsonArray

        **[static] QCborArray QCborArray::fromJsonArray(const QJsonArray & array
        )**

        Converts all JSON items found in the **array** array to CBOR using
        QCborValue::fromJson(), and returns the CBOR array composed of those
        elements.

        This conversion is lossless, as the CBOR type system is a superset of
        JSON's. Moreover, the array returned by this function can be converted
        back to the original **array** by using **toJsonArray** ().

        **See also** **toJsonArray** (), **toVariantList** (),
        **QCborValue::fromJsonValue** (), and **QCborMap::fromJsonObject** ().
        """
        ...

    @staticmethod
    def fromStringList(list: Sequence[str]) -> PySide6.QtCore.QCborArray:
        """
        https://doc.qt.io/qt-6/qcborarray.html#fromStringList

        **[static] QCborArray QCborArray::fromStringList(const QStringList &
        list )**

        Returns a **QCborArray**  containing all the strings found in the
        **list** list.

        **See also** **fromVariantList** () and **fromJsonArray** ().
        """
        ...

    @staticmethod
    def fromVariantList(list: Sequence[Any]) -> PySide6.QtCore.QCborArray:
        """
        https://doc.qt.io/qt-6/qcborarray.html#fromVariantList

        **[static] QCborArray QCborArray::fromVariantList(const QVariantList &
        list )**

        Converts all the items in the **list** to CBOR using
        **QCborValue::fromVariant** () and returns the array composed of those
        elements.

        Conversion from **QVariant**  is not completely lossless. Please see the
        documentation in **QCborValue::fromVariant** () for more information.

        **See also** **toVariantList** (), **fromStringList** (),
        **fromJsonArray** (), and **QCborMap::fromVariantMap** ().
        """
        ...

    def insert(
        self,
        i: int,
        value: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborarray.html#isEmpty

        **bool QCborArray::isEmpty() const**

        Returns true if this **QCborArray**  is empty (that is if **size** () is
        0).

        **See also** **size** () and **clear** ().
        """
        ...

    def last(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#last

        **QCborValue QCborArray::last() const**

        Returns the last **QCborValue**  of this array.

        If the array is empty, this function returns a **QCborValue**
        containing an undefined value. For that reason, it is not possible with
        this function to tell apart the situation where the array is not large
        enough from the case where the array ends with an undefined value.

        **See also** **operator[]** (), **at** (), **first** (), **insert** (),
        **prepend** (), **append** (), **removeAt** (), and **takeAt** ().
        """
        ...

    def pop_back(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#pop_back

        **void QCborArray::pop_back()**

        Synonym for **removeLast** (). This function is provided for
        compatibility with generic code that uses the Standard Library API.

        Removes the last element of this array. The array must not be empty
        before the removal

        **See also** **removeLast** (), **takeLast** (), **pop_front** (),
        **push_back** (), **append** (), and **insert** ().
        """
        ...

    def pop_front(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#pop_front

        **void QCborArray::pop_front()**

        Synonym for **removeFirst** (). This function is provided for
        compatibility with generic code that uses the Standard Library API.

        Removes the first element of this array. The array must not be empty
        before the removal

        **See also** **removeFirst** (), **takeFirst** (), **pop_back** (),
        **push_front** (), **prepend** (), and **insert** ().
        """
        ...

    def prepend(
        self,
        value: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        ...

    def push_back(
        self,
        t: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#push_back

        **void QCborArray::push_back(const QCborValue & t )**

        Synonym for **append** (). This function is provided for compatibility
        with generic code that uses the Standard Library API.

        Appends the element **t** to this array.

        **See also** **append** (), **push_front** (), **pop_back** (),
        **prepend** (), and **insert** ().
        """
        ...

    def push_front(
        self,
        t: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#push_front

        **void QCborArray::push_front(const QCborValue & t )**

        Synonym for **prepend** (). This function is provided for compatibility
        with generic code that uses the Standard Library API.

        Prepends the element **t** to this array.

        **See also** **prepend** (), **push_back** (), **pop_front** (),
        **append** (), and **insert** ().
        """
        ...

    def removeAt(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#removeAt

        **void QCborArray::removeAt(qsizetype i )**

        Removes the item at position **i** from the array. The array must have
        more than **i** elements before the removal.

        **See also** **takeAt** (), **removeFirst** (), **removeLast** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def removeFirst(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#removeFirst

        **void QCborArray::removeFirst()**

        Removes the first item in the array, making the second element become
        the first. The array must not be empty before this call.

        **See also** **removeAt** (), **takeFirst** (), **removeLast** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def removeLast(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#removeLast

        **void QCborArray::removeLast()**

        Removes the last item in the array. The array must not be empty before
        this call.

        **See also** **removeAt** (), **takeLast** (), **removeFirst** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborarray.html#size

        **qsizetype QCborArray::size() const**

        Returns the size of this array.

        **See also** **isEmpty** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QCborArray) -> None:
        """
        https://doc.qt.io/qt-6/qcborarray.html#swap

        **void QCborArray::swap(QCborArray & other )**

        Swaps the contents of this object and **other**.
        """
        ...

    def takeAt(self, i: int) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#takeAt

        **QCborValue QCborArray::takeAt(qsizetype i )**

        Removes the item at position **i** from the array and returns it. The
        array must have more than **i** elements before the removal.

        **See also** **removeAt** (), **removeFirst** (), **removeLast** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def takeFirst(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#takeFirst

        **QCborValue QCborArray::takeFirst()**

        Removes the first item in the array and returns it, making the second
        element become the first. The array must not be empty before this call.

        **See also** **takeAt** (), **removeFirst** (), **removeLast** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def takeLast(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#takeLast

        **QCborValue QCborArray::takeLast()**

        Removes the last item in the array and returns it. The array must not be
        empty before this call.

        **See also** **takeAt** (), **removeLast** (), **removeFirst** (),
        **at** (), **operator[]** (), **insert** (), **prepend** (), and
        **append** ().
        """
        ...

    def toCborValue(self) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborarray.html#toCborValue

        **QCborValue QCborArray::toCborValue() const**

        Explicitly construcuts a **QCborValue**  object that represents this
        array. This function is usually not necessary since **QCborValue**  has
        a constructor for **QCborArray** , so the conversion is implicit.

        Converting **QCborArray**  to **QCborValue**  allows it to be used in
        any context where QCborValues can be used, including as items in
        QCborArrays and as keys and mapped types in **QCborMap** . Converting an
        array to **QCborValue**  allows access to **QCborValue::toCbor** ().

        **See also** **QCborValue::QCborValue** (const QCborArray &).
        """
        ...

    def toJsonArray(self) -> PySide6.QtCore.QJsonArray:
        """
        https://doc.qt.io/qt-6/qcborarray.html#toJsonArray

        **QJsonArray QCborArray::toJsonArray() const**

        Recursively converts every **QCborValue**  element in this array to JSON
        using **QCborValue::toJsonValue** () and returns the corresponding
        **QJsonArray**  composed of those elements.

        Please note that CBOR contains a richer and wider type set than JSON, so
        some information may be lost in this conversion. For more details on
        what conversions are applied, see **QCborValue::toJsonValue** ().

        **See also** **fromJsonArray** (), **QCborValue::toJsonValue** (),
        **QCborMap::toJsonObject** (), and **toVariantList** ().
        """
        ...

    def toVariantList(self) -> List[Any]:
        """
        https://doc.qt.io/qt-6/qcborarray.html#toVariantList

        **QVariantList QCborArray::toVariantList() const**

        Recursively converts each **QCborValue**  in this array using
        **QCborValue::toVariant** () and returns the QVariantList composed of
        the converted items.

        Conversion to **QVariant**  is not completely lossless. Please see the
        documentation in **QCborValue::toVariant** () for more information.

        **See also** **fromVariantList** (), **fromStringList** (),
        **toJsonArray** (), **QCborValue::toVariant** (), and
        **QCborMap::toVariantMap** ().
        """
        ...
