"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Tuple, Union, overload
import PySide6.QtCore

bytes = str


class QByteArray(object):
    """
    https://doc.qt.io/qt-6/qbytearray.html

    **Detailed Description**

    QByteArray can be used to store both raw bytes (including '\\0's) and
    traditional 8-bit '\\0'-terminated strings. Using QByteArray is much more
    convenient than using `const char *`. Behind the scenes, it always ensures
    that the data is followed by a '\\0' terminator, and uses **implicit
    sharing**  (copy-on-write) to reduce memory usage and avoid needless copying
    of data.

    In addition to QByteArray, Qt also provides the **QString**  class to store
    string data. For most purposes, **QString**  is the class you want to use.
    It understands its content as Unicode text (encoded using UTF-16) where
    QByteArray aims to avoid assumptions about the encoding or semantics of the
    bytes it stores (aside from a few legacy cases where it uses ASCII).
    Furthermore, **QString**  is used throughout in the Qt API. The two main
    cases where QByteArray is appropriate are when you need to store raw binary
    data, and when memory conservation is critical (e.g., with Qt for Embedded
    Linux).

    One way to initialize a QByteArray is simply to pass a `const char *` to its
    constructor. For example, the following code creates a byte array of size 5
    containing the data "Hello":

    **QByteArray**  ba("Hello");

    Although the **size** () is 5, the byte array also maintains an extra '\\0'
    byte at the end so that if a function is used that asks for a pointer to the
    underlying data (e.g. a call to **data** ()), the data pointed to is
    guaranteed to be '\\0'-terminated.

    QByteArray makes a deep copy of the `const char *` data, so you can modify
    it later without experiencing side effects. (If, for example for performance
    reasons, you don't want to take a deep copy of the data, use
    **QByteArray::fromRawData** () instead.)

    Another approach is to set the size of the array using **resize** () and to
    initialize the data byte by byte. QByteArray uses 0-based indexes, just like
    C++ arrays. To access the byte at a particular index position, you can use
    operator[](). On non-const byte arrays, operator[]() returns a reference to
    a byte that can be used on the left side of an assignment. For example:

    **QByteArray**  ba;
        ba.resize(5);
        ba[0] = 0x3c;
        ba[1] = 0xb8;
    ba[2] = 0x64;
        ba[3] = 0x18;
        ba[4] = 0xca;

    For read-only access, an alternative syntax is to use **at** ():

    for (qsizetype i = 0; i < ba.size(); ++i) {
            if (ba.at(i) >= 'a' &&
    ba.at(i) <= 'f')
                cout << "Found character in range [a-f]" <<
    Qt::endl;
        }

    **at** () can be faster than operator[](), because it never causes a **deep
    copy**  to occur.

    To extract many bytes at a time, use **first** (), **last** (), or
    **sliced** ().

    A QByteArray can embed '\\0' bytes. The **size** () function always returns
    the size of the whole array, including embedded '\\0' bytes, but excluding
    the terminating '\\0' added by QByteArray. For example:

    **QByteArray**  ba1("ca\\0r\\0t");
        ba1.size();                     //
    Returns 2.
        ba1.constData();                // Returns "ca" with
    terminating \\0.

        **QByteArray**  ba2("ca\\0r\\0t", 3);
        ba2.size();
    // Returns 3.
        ba2.constData();                // Returns "ca\\0" with
    terminating \\0.

        **QByteArray**  ba3("ca\\0r\\0t", 4);
        ba3.size();
    // Returns 4.
        ba3.constData();                // Returns "ca\\0r" with
    terminating \\0.

        const char cart[] = {'c', 'a', '\\0', 'r', '\\0',
    't'};
        **QByteArray**  ba4(**QByteArray** ::fromRawData(cart, 6));
    ba4.size();                     // Returns 6.
        ba4.constData();
    // Returns "ca\\0r\\0t" without terminating \\0.

    If you want to obtain the length of the data up to and excluding the first
    '\\0' byte, call **qstrlen** () on the byte array.

    After a call to **resize** (), newly allocated bytes have undefined values.
    To set all the bytes to a particular value, call **fill** ().

    To obtain a pointer to the actual bytes, call **data** () or **constData**
    (). These functions return a pointer to the beginning of the data. The
    pointer is guaranteed to remain valid until a non-const function is called
    on the QByteArray. It is also guaranteed that the data ends with a '\\0' byte
    unless the QByteArray was created from **raw data** . This '\\0' byte is
    automatically provided by QByteArray and is not counted in **size** ().

    QByteArray provides the following basic functions for modifying the byte
    data: **append** (), **prepend** (), **insert** (), **replace** (), and
    **remove** (). For example:

    **QByteArray**  x("and");
        x.prepend("rock ");         // x == "rock and"
    x.append(" roll");          // x == "rock and roll"
        x.replace(5, 3,
    "&");       // x == "rock & roll"

    In the above example the **replace** () function's first two arguments are
    the position from which to start replacing and the number of bytes that
    should be replaced.

    When data-modifying functions increase the size of the array, they may lead
    to reallocation of memory for the QByteArray object. When this happens,
    QByteArray expands by more than it immediately needs so as to have space for
    further expansion without reallocation until the size of the array has
    greatly increased.

    The **insert** (), **remove** () and, when replacing a sub-array with one of
    different size, **replace** () functions can be slow (**linear time** ) for
    large arrays, because they require moving many bytes in the array by at
    least one position in memory.

    If you are building a QByteArray gradually and know in advance approximately
    how many bytes the QByteArray will contain, you can call **reserve** (),
    asking QByteArray to preallocate a certain amount of memory. You can also
    call **capacity** () to find out how much memory the QByteArray actually has
    allocated.

    Note that using non-const operators and functions can cause QByteArray to do
    a deep copy of the data, due to **implicit sharing** .

    QByteArray provides **STL-style iterators**  (**QByteArray::const_iterator**
    and **QByteArray::iterator** ). In practice, iterators are handy when
    working with generic algorithms provided by the C++ standard library.

    **Note:** Iterators and references to individual QByteArray elements are
    subject to stability issues. They are often invalidated when a QByteArray-
    modifying operation (e.g. **insert** () or **remove** ()) is called. When
    stability and iterator-like functionality is required, you should use
    indexes instead of iterators as they are not tied to QByteArray's internal
    state and thus do not get invalidated.

    **Note:** Iterators over a QByteArray, and references to individual bytes
    within one, cannot be relied on to remain valid when any non-const method of
    the QByteArray is called. Accessing such an iterator or reference after the
    call to a non-const method leads to undefined behavior. When stability for
    iterator-like functionality is required, you should use indexes instead of
    iterators as they are not tied to QByteArray's internal state and thus do
    not get invalidated.

    If you want to find all occurrences of a particular byte or sequence of
    bytes in a QByteArray, use **indexOf** () or **lastIndexOf** (). The former
    searches forward starting from a given index position, the latter searches
    backward. Both return the index position of the byte sequence if they find
    it; otherwise, they return -1. For example, here's a typical loop that finds
    all occurrences of a particular string:

    **QByteArray**  ba("We must be <b>bold</b>, very <b>bold</b>");
    qsizetype j = 0;
        while ((j = ba.indexOf("<b>", j)) != -1) {
            cout
    << "Found <b> tag at index position " << j << Qt::endl;
            ++j;
        }

    If you simply want to check whether a QByteArray contains a particular byte
    sequence, use **contains** (). If you want to find out how many times a
    particular byte sequence occurs in the byte array, use **count** (). If you
    want to replace all occurrences of a particular value with another, use one
    of the two-parameter **replace** () overloads.

    **QByteArray** s can be compared using overloaded operators such as
    operator<(), operator<=(), operator==(), operator>=(), and so on. The
    comparison is based exclusively on the numeric values of the bytes and is
    very fast, but is not what a human would expect.
    **QString::localeAwareCompare** () is a better choice for sorting user-
    interface strings.

    For historical reasons, QByteArray distinguishes between a null byte array
    and an empty byte array. A **null** byte array is a byte array that is
    initialized using QByteArray's default constructor or by passing (const char
    *)0 to the constructor. An **empty** byte array is any byte array with size
    0. A null byte array is always empty, but an empty byte array isn't
    necessarily null:

    **QByteArray** ().isNull();          // returns true
        **QByteArray**
    ().isEmpty();         // returns true

        **QByteArray** ("").isNull();
    // returns false
        **QByteArray** ("").isEmpty();       // returns true
    **QByteArray** ("abc").isNull();     // returns false
        **QByteArray**
    ("abc").isEmpty();    // returns false

    All functions except **isNull** () treat null byte arrays the same as empty
    byte arrays. For example, **data** () returns a valid pointer ( **not**
    nullptr) to a '\\0' byte for a null byte array and QByteArray() compares
    equal to QByteArray(""). We recommend that you always use **isEmpty** () and
    avoid **isNull** ().

    **Maximum size and out-of-memory conditions**

    The maximum size of QByteArray depends on the architecture. Most 64-bit
    systems can allocate more than 2 GB of memory, with a typical limit of 2^63
    bytes. The actual value also depends on the overhead required for managing
    the data block. As a result, you can expect the maximum size of 2 GB minus
    overhead on 32-bit platforms, and 2^63 bytes minus overhead on 64-bit
    platforms. The number of elements that can be stored in a QByteArray is this
    maximum size.

    When memory allocation fails, QByteArray throws a `std::bad_alloc` exception
    if the application is being compiled with exception support. Out of memory
    conditions in Qt containers are the only case where Qt will throw
    exceptions. If exceptions are disabled, then running out of memory is
    undefined behavior.

    Note that the operating system may impose further limits on applications
    holding a lot of allocated memory, especially large, contiguous blocks. Such
    considerations, the configuration of such behavior or any mitigation are
    outside the scope of the QByteArray API.

    **C locale and ASCII functions**

    QByteArray generally handles data as bytes, without presuming any semantics;
    where it does presume semantics, it uses the C locale and ASCII encoding.
    Standard Unicode encodings are supported by **QString** , other encodings
    may be supported using **QStringEncoder**  and **QStringDecoder**  to
    convert to Unicode. For locale-specific interpretation of text, use
    **QLocale**  or **QString** .

    **C Strings**

    Traditional C strings, also known as '\\0'-terminated strings, are sequences
    of bytes, specified by a start-point and implicitly including each byte up
    to, but not including, the first '\\0' byte thereafter. Methods that accept
    such a pointer, without a length, will interpret it as this sequence of
    bytes. Such a sequence, by construction, cannot contain a '\\0' byte.

    Other overloads accept a start-pointer and a byte-count; these use the given
    number of bytes, following the start address, regardless of whether any of
    them happen to be '\\0' bytes. In some cases, where there is no overload
    taking only a pointer, passing a length of -1 will cause the method to use
    the offset of the first '\\0' byte after the pointer as the length; a length
    of -1 should only be passed if the method explicitly says it does this (in
    which case it is typically a default argument).

    **Spacing Characters**

    A frequent requirement is to remove spacing characters from a byte array
    (`'\\n'`, `'\\t'`, `' '`, etc.). If you want to remove spacing from both ends
    of a QByteArray, use **trimmed** (). If you want to also replace each run of
    spacing characters with a single space character within the byte array, use
    **simplified** (). Only ASCII spacing characters are recognized for these
    purposes.

    **Number-String Conversions**

    Functions that perform conversions between numeric data types and string
    representations are performed in the C locale, regardless of the user's
    locale settings. Use **QLocale**  to perform locale-aware conversions
    between numbers and strings.

    **Character Case**

    In QByteArray, the notion of uppercase and lowercase and of case-independent
    comparison is limited to ASCII. Non-ASCII characters are treated as
    caseless, since their case depends on encoding. This affects functions that
    support a case insensitive option or that change the case of their
    arguments. Functions that this affects include **contains** (), **indexOf**
    (), **lastIndexOf** (), **isLower** (), **isUpper** (), **toLower** () and
    **toUpper** ().

    This issue does not apply to **QString** s since they represent characters
    using Unicode.

    **See also** **QByteArrayView** , **QString** , and **QBitArray** .
    """

    Base64Encoding: QByteArray.Base64Option = ...
    IgnoreBase64DecodingErrors: QByteArray.Base64Option = ...
    KeepTrailingEquals: QByteArray.Base64Option = ...
    Base64UrlEncoding: QByteArray.Base64Option = ...
    OmitTrailingEquals: QByteArray.Base64Option = ...
    AbortOnBase64DecodingErrors: QByteArray.Base64Option = ...

    class Base64DecodingStatus(Enum):
        Ok: QByteArray.Base64DecodingStatus = ...
        IllegalInputLength: QByteArray.Base64DecodingStatus = ...
        IllegalCharacter: QByteArray.Base64DecodingStatus = ...
        IllegalPadding: QByteArray.Base64DecodingStatus = ...

    class Base64Option(Enum):
        Base64Encoding: QByteArray.Base64Option = ...
        IgnoreBase64DecodingErrors: QByteArray.Base64Option = ...
        KeepTrailingEquals: QByteArray.Base64Option = ...
        Base64UrlEncoding: QByteArray.Base64Option = ...
        OmitTrailingEquals: QByteArray.Base64Option = ...
        AbortOnBase64DecodingErrors: QByteArray.Base64Option = ...

    class Base64Options(object):
        ...

    class FromBase64Result(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, FromBase64Result: PySide6.QtCore.QByteArray.FromBase64Result
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def swap(self, other: PySide6.QtCore.QByteArray.FromBase64Result) -> None:
            ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray

        **QByteArray::QByteArray()**

        Constructs an empty byte array.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __init__(self, arg__1: bytearray) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray-1

        **QByteArray::QByteArray(const char * data , qsizetype size = -1)**

        Constructs a byte array containing the first **size** bytes of array
        **data**.

        If **data** is 0, a null byte array is constructed.

        If **size** is negative, **data** is assumed to point to a
        '\\0'-terminated string and its length is determined dynamically.

        QByteArray makes a deep copy of the string data.

        **See also** **fromRawData** ().
        """
        ...

    @overload
    def __init__(self, arg__1: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray-2

        **QByteArray::QByteArray(qsizetype size , char ch )**

        Constructs a byte array of size **size** with every byte set to **ch**.

        **See also** **fill** ().
        """
        ...

    @overload
    def __init__(self, arg__1: bytes, size: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray-3

        **[since 5.2] QByteArray::QByteArray(QByteArray && other )**

        Move-constructs a QByteArray instance, making it point at the same
        object that **other** was pointing to.

        This function was introduced in Qt 5.2.
        """
        ...

    @overload
    def __init__(self, arg__1: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray

        **QByteArray::QByteArray()**

        Constructs an empty byte array.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __init__(self, size: int, c: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#QByteArray

        **QByteArray::QByteArray()**

        Constructs an empty byte array.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __add__(self, a2: int) -> PySide6.QtCore.QByteArray:
        ...

    @overload
    def __add__(
        self, a2: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        ...

    @overload
    def __add__(self, arg__1: bytearray) -> PySide6.QtCore.QByteArray:
        ...

    @overload
    def __add__(self, arg__1: bytes) -> None:
        ...

    @overload
    def __add__(self, s: str) -> str:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def __iadd__(
        self, a: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        ...

    @overload
    def __iadd__(self, arg__1: bytearray) -> PySide6.QtCore.QByteArray:
        ...

    @overload
    def __iadd__(self, c: int) -> PySide6.QtCore.QByteArray:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __str__(self) -> object:
        ...

    @overload
    def append(
        self, a: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#append

        **QByteArray &QByteArray::append(const QByteArray & ba )**

        Appends the byte array **ba** onto the end of this byte array.

        Example:

        **QByteArray**  x("free");
            **QByteArray**  y("dom");
        x.append(y);
            // x == "freedom"

        This is the same as insert(**size** (), **ba** ).

        Note: **QByteArray**  is an **implicitly shared**  class. Consequently,
        if you append to an empty byte array, then the byte array will just
        share the data held in **ba**. In this case, no copying of data is done,
        taking **constant time** . If a shared instance is modified, it will be
        copied (copy-on-write), taking **linear time** .

        If the byte array being appended to is not empty, a deep copy of the
        data is performed, taking **linear time** .

        The append() function is typically very fast (**constant time** ),
        because **QByteArray**  preallocates extra space at the end of the data,
        so it can grow without reallocating the entire array each time.

        **See also** **operator+=** (), **prepend** (), and **insert** ().
        """
        ...

    @overload
    def append(self, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#append-1

        **QByteArray &QByteArray::append(char ch )**

        This is an overloaded function.

        Appends the byte **ch** to this byte array.
        """
        ...

    @overload
    def append(self, count: int, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#append-2

        **[since 5.7] QByteArray &QByteArray::append(qsizetype count , char ch
        )**

        This is an overloaded function.

        Appends **count** copies of byte **ch** to this byte array and returns a
        reference to this byte array.

        If **count** is negative or zero nothing is appended to the byte array.

        This function was introduced in Qt 5.7.
        """
        ...

    @overload
    def append(self, s: bytes, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#append-3

        **QByteArray &QByteArray::append(const char * str )**

        This is an overloaded function.

        Appends the '\\0'-terminated string **str** to this byte array.
        """
        ...

    def at(self, i: int) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#at

        **char QByteArray::at(qsizetype i ) const**

        Returns the byte at index position **i** in the byte array.

        **i** must be a valid index position in the byte array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **operator[]** ().
        """
        ...

    def back(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#back

        **[since 5.10] char QByteArray::back() const**

        Returns the last byte in the byte array. Same as `at(size() - 1)`.

        This function is provided for STL compatibility.

        **Warning:** Calling this function on an empty byte array constitutes
        undefined behavior.

        This function was introduced in Qt 5.10.

        **See also** **front** (), **at** (), and **operator[]** ().
        """
        ...

    def capacity(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#capacity

        **qsizetype QByteArray::capacity() const**

        Returns the maximum number of bytes that can be stored in the byte array
        without forcing a reallocation.

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function. If you want to know how many bytes are in the byte
        array, call **size** ().

        **Note:** a statically allocated byte array will report a capacity of 0,
        even if it's not empty.

        **Note:** The free space position in the allocated memory block is
        undefined. In other words, one should not assume that the free memory is
        always located after the initialized elements.

        **See also** **reserve** () and **squeeze** ().
        """
        ...

    def cbegin(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qbytearray.html#cbegin

        **[since 5.0] QByteArray::const_iterator QByteArray::cbegin() const**

        Returns a const **STL-style iterator**  pointing to the first byte in
        the byte-array.

        **Warning:** The returned iterator is invalidated on detachment or when
        the **QByteArray**  is modified.

        This function was introduced in Qt 5.0.

        **See also** **begin** () and **cend** ().
        """
        ...

    def cend(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qbytearray.html#cend

        **[since 5.0] QByteArray::const_iterator QByteArray::cend() const**

        Returns a const **STL-style iterator**  pointing just after the last
        byte in the byte-array.

        **Warning:** The returned iterator is invalidated on detachment or when
        the **QByteArray**  is modified.

        This function was introduced in Qt 5.0.

        **See also** **cbegin** () and **end** ().
        """
        ...

    def chop(self, n: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#chop

        **void QByteArray::chop(qsizetype n )**

        Removes **n** bytes from the end of the byte array.

        If **n** is greater than **size** (), the result is an empty byte array.

        Example:

        **QByteArray**  ba("STARTTLS\\r\\n");
            ba.chop(2);                 //
        ba == "STARTTLS"

        **See also** **truncate** (), **resize** (), and **first** ().
        """
        ...

    def chopped(self, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#chopped

        **[since 5.10] QByteArray QByteArray::chopped(qsizetype len ) const**

        Returns a byte array that contains the leftmost **size** () - **len**
        bytes of this byte array.

        **Note:** The behavior is undefined if **len** is negative or greater
        than **size** ().

        This function was introduced in Qt 5.10.

        **See also** **endsWith** (), **first** (), **last** (), **sliced** (),
        **chop** (), and **truncate** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#clear

        **void QByteArray::clear()**

        Clears the contents of the byte array and makes it null.

        **See also** **resize** () and **isNull** ().
        """
        ...

    def compare(
        self,
        a: Union[PySide6.QtCore.QByteArray, bytes],
        cs: PySide6.QtCore.Qt.CaseSensitivity = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#compare

        **[since 6.0] int QByteArray::compare(QByteArrayView bv ,
        Qt::CaseSensitivity cs = Qt::CaseSensitive) const**

        Returns an integer less than, equal to, or greater than zero depending
        on whether this **QByteArray**  sorts before, at the same position as,
        or after the **QByteArrayView**  **bv**. The comparison is performed
        according to case sensitivity **cs**.

        This function was introduced in Qt 6.0.

        **See also** **operator==**  and **Character Case** .
        """
        ...

    @overload
    def contains(self, bv: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#contains

        **[since 6.0] bool QByteArray::contains(QByteArrayView bv ) const**

        Returns `true` if this byte array contains an occurrence of the sequence
        of bytes viewed by **bv** ; otherwise returns `false`.

        This function was introduced in Qt 6.0.

        **See also** **indexOf** () and **count** ().
        """
        ...

    @overload
    def contains(self, c: int) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#contains-1

        **bool QByteArray::contains(char ch ) const**

        This is an overloaded function.

        Returns `true` if the byte array contains the byte **ch** ; otherwise
        returns `false`.
        """
        ...

    @overload
    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#count

        **[since 6.0] qsizetype QByteArray::count(QByteArrayView bv ) const**

        Returns the number of (potentially overlapping) occurrences of the
        sequence of bytes viewed by **bv** in this byte array.

        This function was introduced in Qt 6.0.

        **See also** **contains** () and **indexOf** ().
        """
        ...

    @overload
    def count(self, bv: Union[PySide6.QtCore.QByteArray, bytes]) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#count-1

        **qsizetype QByteArray::count(char ch ) const**

        This is an overloaded function.

        Returns the number of occurrences of byte **ch** in the byte array.

        **See also** **contains** () and **indexOf** ().
        """
        ...

    @overload
    def count(self, c: int) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#count-2

        **qsizetype QByteArray::count() const**

        This is an overloaded function.

        Same as **size** ().
        """
        ...

    def data(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qbytearray.html#data

        **char *QByteArray::data()**

        Returns a pointer to the data stored in the byte array. The pointer can
        be used to access and modify the bytes that compose the array. The data
        is '\\0'-terminated, i.e. the number of bytes you can access following
        the returned pointer is **size** () + 1, including the '\\0' terminator.

        Example:

        **QByteArray**  ba("Hello world");
            char *data = ba.data();
            while
        (*data) {
                cout << "[" << *data << "]" << Qt::endl;
        ++data;
            }

        The pointer remains valid as long as no detach happens and the
        **QByteArray**  is not modified.

        For read-only access, **constData** () is faster because it never causes
        a **deep copy**  to occur.

        This function is mostly useful to pass a byte array to a function that
        accepts a `const char *`.

        The following example makes a copy of the char* returned by data(), but
        it will corrupt the heap and cause a crash because it does not allocate
        a byte for the '\\0' at the end:

        **QString**  tmp = "test";
            **QByteArray**  text = tmp.toLocal8Bit();
        char *data = new char[text.size()];
            strcpy(data, text.data());
        delete [] data;

        This one allocates the correct amount of space:

        **QString**  tmp = "test";
            **QByteArray**  text = tmp.toLocal8Bit();
        char *data = new char[text.size() + 1];
            strcpy(data, text.data());
        delete [] data;

        Note: A **QByteArray**  can store any byte values including '\\0's, but
        most functions that take `char *` arguments assume that the data ends at
        the first '\\0' they encounter.

        **See also** **constData** () and **operator[]** ().
        """
        ...

    @overload
    def endsWith(self, bv: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#endsWith

        **[since 6.0] bool QByteArray::endsWith(QByteArrayView bv ) const**

        Returns `true` if this byte array ends with the sequence of bytes viewed
        by **bv** ; otherwise returns `false`.

        Example:

        **QByteArray**  url("http://qt-
        project.org/doc/qt-5.0/qtdoc/index.html");
            if
        (url.endsWith(".html"))
                ...

        This function was introduced in Qt 6.0.

        **See also** **startsWith** () and **last** ().
        """
        ...

    @overload
    def endsWith(self, c: int) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#endsWith-1

        **bool QByteArray::endsWith(char ch ) const**

        This is an overloaded function.

        Returns `true` if this byte array ends with byte **ch** ; otherwise
        returns `false`.
        """
        ...

    def erase(self, first: bytes, last: bytes) -> bytes:
        """
        https://doc.qt.io/qt-6/qbytearray.html#erase

        **[since 6.1] QByteArray::iterator
        QByteArray::erase(QByteArray::const_iterator first ,
        QByteArray::const_iterator last )**

        Removes from the byte array the characters in the half-open range [
        **first** , **last** ). Returns an iterator to the character referred to
        by **last** before the erase.

        This function was introduced in Qt 6.1.
        """
        ...

    def fill(self, c: int, size: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#fill

        **QByteArray &QByteArray::fill(char ch , qsizetype size = -1)**

        Sets every byte in the byte array to **ch**. If **size** is different
        from -1 (the default), the byte array is resized to size **size**
        beforehand.

        Example:

        **QByteArray**  ba("Istambul");
            ba.fill('o');
            // ba ==
        "oooooooo"

            ba.fill('X', 2);
            // ba == "XX"

        **See also** **resize** ().
        """
        ...

    def first(self, n: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#first

        **[since 6.0] QByteArray QByteArray::first(qsizetype n ) const**

        Returns the first **n** bytes of the byte array.

        **Note:** The behavior is undefined when **n** < 0 or **n** > **size**
        ().

        Example:

        **QByteArray**  x("Pineapple");
            **QByteArray**  y = x.first(4);
        // y == "Pine"

        This function was introduced in Qt 6.0.

        **See also** **last** (), **sliced** (), **startsWith** (), **chopped**
        (), **chop** (), and **truncate** ().
        """
        ...

    @staticmethod
    def fromBase64(
        base64: Union[PySide6.QtCore.QByteArray, bytes],
        options: PySide6.QtCore.QByteArray.Base64Options = ...,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#fromBase64

        **[static, since 5.2] QByteArray QByteArray::fromBase64(const QByteArray
        & base64 , QByteArray::Base64Options options = Base64Encoding)**

        Returns a decoded copy of the Base64 array **base64** , using the
        options defined by **options**. If **options** contains
        `IgnoreBase64DecodingErrors` (the default), the input is not checked for
        validity; invalid characters in the input are skipped, enabling the
        decoding process to continue with subsequent characters. If **options**
        contains `AbortOnBase64DecodingErrors`, then decoding will stop at the
        first invalid character.

        For example:

        **QByteArray**  text = **QByteArray** ::fromBase64("UXQgaXMgZ3JlYXQh");
        text.data();            // returns "Qt is great!"
        **QByteArray** ::fromBase64("PHA+SGVsbG8/PC9wPg==", **QByteArray**
        ::Base64Encoding); // returns "<p>Hello?</p>"
            **QByteArray**
        ::fromBase64("PHA-SGVsbG8_PC9wPg==", **QByteArray**
        ::Base64UrlEncoding); // returns "<p>Hello?</p>"

        The algorithm used to decode Base64-encoded data is defined in **RFC
        4648** .

        Returns the decoded data, or, if the `AbortOnBase64DecodingErrors`
        option was passed and the input data was invalid, an empty byte array.

        **Note:** The **fromBase64Encoding** () function is recommended in new
        code.

        This function was introduced in Qt 5.2.

        **See also** **toBase64** () and **fromBase64Encoding** ().
        """
        ...

    @staticmethod
    def fromBase64Encoding(
        base64: Union[PySide6.QtCore.QByteArray, bytes],
        options: PySide6.QtCore.QByteArray.Base64Options = ...,
    ) -> PySide6.QtCore.QByteArray.FromBase64Result:
        ...

    @staticmethod
    def fromHex(
        hexEncoded: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#fromHex

        **[static] QByteArray QByteArray::fromHex(const QByteArray & hexEncoded
        )**

        Returns a decoded copy of the hex encoded array **hexEncoded**. Input is
        not checked for validity; invalid characters in the input are skipped,
        enabling the decoding process to continue with subsequent characters.

        For example:

        **QByteArray**  text = **QByteArray**
        ::fromHex("517420697320677265617421");
            text.data();            //
        returns "Qt is great!"

        **See also** **toHex** ().
        """
        ...

    @staticmethod
    def fromPercentEncoding(
        pctEncoded: Union[PySide6.QtCore.QByteArray, bytes], percent: int = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#fromPercentEncoding

        **[static] QByteArray QByteArray::fromPercentEncoding(const QByteArray &
        input , char percent = '%')**

        Returns a decoded copy of the URI/URL-style percent-encoded **input**.
        The **percent** parameter allows you to replace the '%' character for
        another (for instance, '_' or '=').

        For example:

        **QByteArray**  text = **QByteArray**
        ::fromPercentEncoding("Qt%20is%20great%33");
            text.data();
        // returns "Qt is great!"

        **Note:** Given invalid input (such as a string containing the sequence
        "%G5", which is not a valid hexadecimal number) the output will be
        invalid as well. As an example: the sequence "%G5" could be decoded to
        'W'.

        **See also** **toPercentEncoding** () and **QUrl::fromPercentEncoding**
        ().
        """
        ...

    @staticmethod
    def fromRawData(data: bytes, size: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#fromRawData

        **[static] QByteArray QByteArray::fromRawData(const char * data ,
        qsizetype size )**

        Constructs a **QByteArray**  that uses the first **size** bytes of the
        **data** array. The bytes are **not** copied. The **QByteArray**  will
        contain the **data** pointer. The caller guarantees that **data** will
        not be deleted or modified as long as this **QByteArray**  and any
        copies of it exist that have not been modified. In other words, because
        **QByteArray**  is an **implicitly shared**  class and the instance
        returned by this function contains the **data** pointer, the caller must
        not delete **data** or modify it directly as long as the returned
        **QByteArray**  and any copies exist. However, **QByteArray**  does not
        take ownership of **data** , so the **QByteArray**  destructor will
        never delete the raw **data** , even when the last **QByteArray**
        referring to **data** is destroyed.

        A subsequent attempt to modify the contents of the returned
        **QByteArray**  or any copy made from it will cause it to create a deep
        copy of the **data** array before doing the modification. This ensures
        that the raw **data** array itself will never be modified by
        **QByteArray** .

        Here is an example of how to read data using a **QDataStream**  on raw
        data in memory without copying the raw data into a **QByteArray** :

        static const char mydata[] = {
                '\\x00', '\\x00', '\\x03', '\\x84',
        '\\x78', '\\x9c', '\\x3b', '\\x76',
                '\\xec', '\\x18', '\\xc3', '\\x31',
        '\\x0a', '\\xf1', '\\xcc', '\\x99',
                ...
                '\\x6d', '\\x5b'
        };

            **QByteArray**  data = **QByteArray** ::fromRawData(mydata,
        sizeof(mydata));
            **QDataStream**  in(&data, **QIODevice**
        ::ReadOnly);
            ...

        **Warning:** A byte array created with fromRawData() is **not**
        '\\0'-terminated, unless the raw data contains a '\\0' byte at position
        **size**. While that does not matter for **QDataStream**  or functions
        like **indexOf** (), passing the byte array to a function accepting a
        `const char *` expected to be '\\0'-terminated will fail.

        **See also** **setRawData** (), **data** (), and **constData** ().
        """
        ...

    def front(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#front

        **[since 5.10] char QByteArray::front() const**

        Returns the first byte in the byte array. Same as `at(0)`.

        This function is provided for STL compatibility.

        **Warning:** Calling this function on an empty byte array constitutes
        undefined behavior.

        This function was introduced in Qt 5.10.

        **See also** **back** (), **at** (), and **operator[]** ().
        """
        ...

    @overload
    def indexOf(
        self, bv: Union[PySide6.QtCore.QByteArray, bytes], from_: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#indexOf

        **[since 6.0] qsizetype QByteArray::indexOf(QByteArrayView bv ,
        qsizetype from = 0) const**

        Returns the index position of the start of the first occurrence of the
        sequence of bytes viewed by **bv** in this byte array, searching forward
        from index position **from**. Returns -1 if no match is found.

        Example:

        **QByteArray**  x("sticky question");
            **QByteArrayView**  y("sti");
        x.indexOf(y);               // returns 0
            x.indexOf(y, 1);
        // returns 10
            x.indexOf(y, 10);           // returns 10
        x.indexOf(y, 11);           // returns -1

        This function was introduced in Qt 6.0.

        **See also** **lastIndexOf** (), **contains** (), and **count** ().
        """
        ...

    @overload
    def indexOf(self, c: int, from_: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#indexOf-1

        **qsizetype QByteArray::indexOf(char ch , qsizetype from = 0) const**

        This is an overloaded function.

        Returns the index position of the start of the first occurrence of the
        byte **ch** in this byte array, searching forward from index position
        **from**. Returns -1 if no match is found.

        Example:

        **QByteArray**  ba("ABCBA");
            ba.indexOf("B");            // returns
        1
            ba.indexOf("B", 1);         // returns 1
            ba.indexOf("B", 2);
        // returns 3
            ba.indexOf("X");            // returns -1

        **See also** **lastIndexOf** () and **contains** ().
        """
        ...

    @overload
    def insert(self, i: int, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#insert

        **[since 6.0] QByteArray &QByteArray::insert(qsizetype i ,
        QByteArrayView data )**

        Inserts **data** at index position **i** and returns a reference to this
        byte array.

        Example:

        **QByteArray**  ba("Meal");
            ba.insert(1, **QByteArrayView**
        ("ontr"));
            // ba == "Montreal"

        For large byte arrays, this operation can be slow (**linear time** ),
        because it requires moving all the bytes at indexes **i** and above by
        at least one position further in memory.

        This array grows to accommodate the insertion. If **i** is beyond the
        end of the array, the array is first extended with space characters to
        reach this **i**.

        This function was introduced in Qt 6.0.

        **See also** **append** (), **prepend** (), **replace** (), and
        **remove** ().
        """
        ...

    @overload
    def insert(self, i: int, count: int, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#insert-1

        **QByteArray &QByteArray::insert(qsizetype i , const char * s )**

        Inserts **s** at index position **i** and returns a reference to this
        byte array.

        This array grows to accommodate the insertion. If **i** is beyond the
        end of the array, the array is first extended with space characters to
        reach this **i**.

        The function is equivalent to `insert(i, QByteArrayView(s))`

        **See also** **append** (), **prepend** (), **replace** (), and
        **remove** ().
        """
        ...

    @overload
    def insert(
        self, i: int, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#insert-2

        **QByteArray &QByteArray::insert(qsizetype i , const QByteArray & data
        )**

        Inserts **data** at index position **i** and returns a reference to this
        byte array.

        This array grows to accommodate the insertion. If **i** is beyond the
        end of the array, the array is first extended with space characters to
        reach this **i**.

        **See also** **append** (), **prepend** (), **replace** (), and
        **remove** ().
        """
        ...

    @overload
    def insert(self, i: int, s: bytes) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#insert-3

        **[since 5.7] QByteArray &QByteArray::insert(qsizetype i , qsizetype
        count , char ch )**

        This is an overloaded function.

        Inserts **count** copies of byte **ch** at index position **i** in the
        byte array.

        This array grows to accommodate the insertion. If **i** is beyond the
        end of the array, the array is first extended with space characters to
        reach this **i**.

        This function was introduced in Qt 5.7.
        """
        ...

    @overload
    def insert(self, i: int, s: bytes, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#insert-4

        **QByteArray &QByteArray::insert(qsizetype i , char ch )**

        This is an overloaded function.

        Inserts byte **ch** at index position **i** in the byte array.

        This array grows to accommodate the insertion. If **i** is beyond the
        end of the array, the array is first extended with space characters to
        reach this **i**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#isEmpty

        **bool QByteArray::isEmpty() const**

        Returns `true` if the byte array has size 0; otherwise returns `false`.

        Example:

        **QByteArray** ().isEmpty();         // returns true
            **QByteArray**
        ("").isEmpty();       // returns true
            **QByteArray**
        ("abc").isEmpty();    // returns false

        **See also** **size** ().
        """
        ...

    def isLower(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#isLower

        **[since 5.12] bool QByteArray::isLower() const**

        Returns `true` if this byte array contains only lowercase ASCII letters,
        otherwise returns `false`.

        This function was introduced in Qt 5.12.

        **See also** **isUpper** () and **toLower** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#isNull

        **bool QByteArray::isNull() const**

        Returns `true` if this byte array is null; otherwise returns `false`.

        Example:

        **QByteArray** ().isNull();          // returns true
            **QByteArray**
        ("").isNull();        // returns false
            **QByteArray**
        ("abc").isNull();     // returns false

        Qt makes a distinction between null byte arrays and empty byte arrays
        for historical reasons. For most applications, what matters is whether
        or not a byte array contains any data, and this can be determined using
        **isEmpty** ().

        **See also** **isEmpty** ().
        """
        ...

    def isSharedWith(self, other: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        ...

    def isUpper(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#isUpper

        **[since 5.12] bool QByteArray::isUpper() const**

        Returns `true` if this byte array contains only ASCII uppercase letters,
        otherwise returns `false`.

        This function was introduced in Qt 5.12.

        **See also** **isLower** () and **toUpper** ().
        """
        ...

    def last(self, n: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#last

        **[since 6.0] QByteArray QByteArray::last(qsizetype n ) const**

        Returns the last **n** bytes of the byte array.

        **Note:** The behavior is undefined when **n** < 0 or **n** > **size**
        ().

        Example:

        **QByteArray**  x("Pineapple");
            **QByteArray**  y = x.last(5);
        // y == "apple"

        This function was introduced in Qt 6.0.

        **See also** **first** (), **sliced** (), **endsWith** (), **chopped**
        (), **chop** (), and **truncate** ().
        """
        ...

    @overload
    def lastIndexOf(self, bv: Union[PySide6.QtCore.QByteArray, bytes]) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#lastIndexOf

        **[since 6.0] qsizetype QByteArray::lastIndexOf(QByteArrayView bv ,
        qsizetype from ) const**

        Returns the index position of the start of the last occurrence of the
        sequence of bytes viewed by **bv** in this byte array, searching
        backward from index position **from**. If **from** is -1, the search
        starts at the last character; if **from** is -2, at the next to last
        character and so on. Returns -1 if no match is found.

        Example:

        **QByteArray**  x("crazy azimuths");
            **QByteArrayView**  y("az");
        x.lastIndexOf(y);           // returns 6
            x.lastIndexOf(y, 6);
        // returns 6
            x.lastIndexOf(y, 5);        // returns 2
        x.lastIndexOf(y, 1);        // returns -1

        **Note:** When searching for a 0-length **bv** , the match at the end of
        the data is excluded from the search by a negative **from** , even
        though `-1` is normally thought of as searching from the end of the byte
        array: the match at the end is **after** the last character, so it is
        excluded. To include such a final empty match, either give a positive
        value for **from** or omit the **from** parameter entirely.

        This function was introduced in Qt 6.0.

        **See also** **indexOf** (), **contains** (), and **count** ().
        """
        ...

    @overload
    def lastIndexOf(
        self, bv: Union[PySide6.QtCore.QByteArray, bytes], from_: int
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#lastIndexOf-1

        **qsizetype QByteArray::lastIndexOf(char ch , qsizetype from = -1)
        const**

        This is an overloaded function.

        Returns the index position of the start of the last occurrence of byte
        **ch** in this byte array, searching backward from index position
        **from**. If **from** is -1 (the default), the search starts at the last
        byte (at index **size** () - 1). Returns -1 if no match is found.

        Example:

        **QByteArray**  ba("ABCBA");
            ba.lastIndexOf("B");        // returns
        3
            ba.lastIndexOf("B", 3);     // returns 3
            ba.lastIndexOf("B",
        2);     // returns 1
            ba.lastIndexOf("X");        // returns -1

        **See also** **indexOf** () and **contains** ().
        """
        ...

    @overload
    def lastIndexOf(self, c: int, from_: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#lastIndexOf-2

        **[since 6.2] qsizetype QByteArray::lastIndexOf(QByteArrayView bv )
        const**

        This is an overloaded function.

        Returns the index position of the start of the last occurrence of the
        sequence of bytes viewed by **bv** in this byte array, searching
        backward from the end of the byte array. Returns -1 if no match is
        found.

        Example:

        **QByteArray**  x("crazy azimuths");
            **QByteArrayView**  y("az");
        x.lastIndexOf(y);           // returns 6
            x.lastIndexOf(y, 6);
        // returns 6
            x.lastIndexOf(y, 5);        // returns 2
        x.lastIndexOf(y, 1);        // returns -1

        This function was introduced in Qt 6.2.

        **See also** **indexOf** (), **contains** (), and **count** ().
        """
        ...

    def left(self, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#left

        **QByteArray QByteArray::left(qsizetype len ) const**

        Returns a byte array that contains the first **len** bytes of this byte
        array.

        If you know that **len** cannot be out of bounds, use **first** ()
        instead in new code, because it is faster.

        The entire byte array is returned if **len** is greater than **size**
        ().

        Returns an empty **QByteArray**  if **len** is smaller than 0.

        **See also** **first** (), **last** (), **startsWith** (), **chopped**
        (), **chop** (), and **truncate** ().
        """
        ...

    def leftJustified(
        self, width: int, fill: int = ..., truncate: bool = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#leftJustified

        **QByteArray QByteArray::leftJustified(qsizetype width , char fill = '
        ', bool truncate = false) const**

        Returns a byte array of size **width** that contains this byte array
        padded with the **fill** byte.

        If **truncate** is false and the **size** () of the byte array is more
        than **width** , then the returned byte array is a copy of this byte
        array.

        If **truncate** is true and the **size** () of the byte array is more
        than **width** , then any bytes in a copy of the byte array after
        position **width** are removed, and the copy is returned.

        Example:

        **QByteArray**  x("apple");
            **QByteArray**  y = x.leftJustified(8,
        '.');   // y == "apple..."

        **See also** **rightJustified** ().
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#length

        **qsizetype QByteArray::length() const**

        Same as **size** ().
        """
        ...

    def mid(self, index: int, len: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#mid

        **QByteArray QByteArray::mid(qsizetype pos , qsizetype len = -1) const**

        Returns a byte array containing **len** bytes from this byte array,
        starting at position **pos**.

        If you know that **pos** and **len** cannot be out of bounds, use
        **sliced** () instead in new code, because it is faster.

        If **len** is -1 (the default), or **pos** \\+ **len** >= **size** (),
        returns a byte array containing all bytes starting at position **pos**
        until the end of the byte array.

        **See also** **first** (), **last** (), **sliced** (), **chopped** (),
        **chop** (), and **truncate** ().
        """
        ...

    @overload
    @staticmethod
    def number(
        arg__1: float, format: int = ..., precision: int = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#number

        **[static] QByteArray QByteArray::number(int n , int base = 10)**

        Returns a byte-array representing the whole number **n** as text.

        Returns a byte array containing a string representing **n** , using the
        specified **base** (ten by default). Bases 2 through 36 are supported,
        using letters for digits beyond 9: A is ten, B is eleven and so on.

        Example:

        int n = 63;
            **QByteArray** ::number(n);              // returns "63"
        **QByteArray** ::number(n, 16);          // returns "3f"
        **QByteArray** ::number(n, 16).toUpper();  // returns "3F"

        **Note:** The format of the number is not localized; the default C
        locale is used regardless of the user's locale. Use **QLocale**  to
        perform locale-aware conversions between numbers and strings.

        **See also** **setNum** () and **toInt** ().
        """
        ...

    @overload
    @staticmethod
    def number(arg__1: int, base: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#number-1

        **[static] QByteArray QByteArray::number(uint n , int base = 10)**

        This is an overloaded function.

        **See also** **toUInt** ().
        """
        ...

    @overload
    @staticmethod
    def number(arg__1: int, base: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#number-2

        **[static] QByteArray QByteArray::number(long n , int base = 10)**

        This is an overloaded function.

        **See also** **toLong** ().
        """
        ...

    @overload
    def prepend(
        self, a: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#prepend

        **QByteArray &QByteArray::prepend(QByteArrayView ba )**

        Prepends the byte array view **ba** to this byte array and returns a
        reference to this byte array.

        This operation is typically very fast (**constant time** ), because
        **QByteArray**  preallocates extra space at the beginning of the data,
        so it can grow without reallocating the entire array each time.

        Example:

        **QByteArray**  x("ship");
            **QByteArray**  y("air");
        x.prepend(y);
            // x == "airship"

        This is the same as insert(0, **ba** ).

        **See also** **append** () and **insert** ().
        """
        ...

    @overload
    def prepend(self, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#prepend-1

        **QByteArray &QByteArray::prepend(char ch )**

        This is an overloaded function.

        Prepends the byte **ch** to this byte array.
        """
        ...

    @overload
    def prepend(self, count: int, c: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#prepend-2

        **[since 5.7] QByteArray &QByteArray::prepend(qsizetype count , char ch
        )**

        This is an overloaded function.

        Prepends **count** copies of byte **ch** to this byte array.

        This function was introduced in Qt 5.7.
        """
        ...

    @overload
    def prepend(self, s: bytes, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#prepend-3

        **QByteArray &QByteArray::prepend(const char * str )**

        This is an overloaded function.

        Prepends the '\\0'-terminated string **str** to this byte array.
        """
        ...

    def push_back(self, a: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#push_back

        **void QByteArray::push_back(const QByteArray & other )**

        This function is provided for STL compatibility. It is equivalent to
        append( **other** ).
        """
        ...

    def push_front(self, a: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#push_front

        **void QByteArray::push_front(const QByteArray & other )**

        This function is provided for STL compatibility. It is equivalent to
        prepend( **other** ).
        """
        ...

    def remove(self, index: int, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#remove

        **QByteArray &QByteArray::remove(qsizetype pos , qsizetype len )**

        Removes **len** bytes from the array, starting at index position **pos**
        , and returns a reference to the array.

        If **pos** is out of range, nothing happens. If **pos** is valid, but
        **pos** \\+ **len** is larger than the size of the array, the array is
        truncated at position **pos**.

        Example:

        **QByteArray**  ba("Montreal");
            ba.remove(1, 4);
            // ba == "Meal"

        Element removal will preserve the array's capacity and not reduce the
        amount of allocated memory. To shed extra capacity and free as much
        memory as possible, call **squeeze** () after the last change to the
        array's size.

        **See also** **insert** (), **replace** (), and **squeeze** ().
        """
        ...

    def repeated(self, times: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#repeated

        **QByteArray QByteArray::repeated(qsizetype times ) const**

        Returns a copy of this byte array repeated the specified number of
        **times**.

        If **times** is less than 1, an empty byte array is returned.

        Example:

        **QByteArray**  ba("ab");
            ba.repeated(4);             // returns
        "abababab"
        """
        ...

    @overload
    def replace(
        self, before: bytes, bsize: int, after: bytes, asize: int
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace

        **QByteArray &QByteArray::replace(qsizetype pos , qsizetype len ,
        QByteArrayView after )**

        Replaces **len** bytes from index position **pos** with the byte array
        **after** , and returns a reference to this byte array.

        Example:

        **QByteArray**  x("Say yes!");
            **QByteArray**  y("no");
        x.replace(4, 3, y);
            // x == "Say no!"

        **See also** **insert** () and **remove** ().
        """
        ...

    @overload
    def replace(self, before: int, after: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace-1

        **QByteArray &QByteArray::replace(qsizetype pos , qsizetype len , const
        char * after , qsizetype alen )**

        This is an overloaded function.

        Replaces **len** bytes from index position **pos** with **alen** bytes
        starting at position **after**. The bytes inserted may include '\\0'
        bytes.
        """
        ...

    @overload
    def replace(
        self, before: int, after: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace-2

        **QByteArray &QByteArray::replace(char before , QByteArrayView after )**

        This is an overloaded function.

        Replaces every occurrence of the byte **before** with the byte array
        **after**.
        """
        ...

    @overload
    def replace(
        self,
        before: Union[PySide6.QtCore.QByteArray, bytes],
        after: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace-3

        **QByteArray &QByteArray::replace(const char * before , qsizetype bsize
        , const char * after , qsizetype asize )**

        This is an overloaded function.

        Replaces every occurrence of the **bsize** bytes starting at **before**
        with the **asize** bytes starting at **after**. Since the sizes of the
        strings are given by **bsize** and **asize** , they may contain '\\0'
        bytes and do not need to be '\\0'-terminated.
        """
        ...

    @overload
    def replace(
        self, index: int, len: int, s: bytes, alen: int
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace-4

        **[since 6.0] QByteArray &QByteArray::replace(QByteArrayView before ,
        QByteArrayView after )**

        This is an overloaded function.

        Replaces every occurrence of the byte array **before** with the byte
        array **after**.

        Example:

        **QByteArray**  ba("colour behaviour flavour neighbour");
        ba.replace(**QByteArray** ("ou"), **QByteArray** ("o"));
            // ba ==
        "color behavior flavor neighbor"

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    def replace(
        self, index: int, len: int, s: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#replace-5

        **QByteArray &QByteArray::replace(char before , char after )**

        This is an overloaded function.

        Replaces every occurrence of the byte **before** with the byte
        **after**.
        """
        ...

    def reserve(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#reserve

        **void QByteArray::reserve(qsizetype size )**

        Attempts to allocate memory for at least **size** bytes.

        If you know in advance how large the byte array will be, you can call
        this function, and if you call **resize** () often you are likely to get
        better performance.

        If in doubt about how much space shall be needed, it is usually better
        to use an upper bound as **size** , or a high estimate of the most
        likely size, if a strict upper bound would be much bigger than this. If
        **size** is an underestimate, the array will grow as needed once the
        reserved size is exceeded, which may lead to a larger allocation than
        your best overestimate would have and will slow the operation that
        triggers it.

        **Warning:** reserve() reserves memory but does not change the size of
        the byte array. Accessing data beyond the end of the byte array is
        undefined behavior. If you need to access memory beyond the current end
        of the array, use **resize** ().

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function.

        **See also** **squeeze** () and **capacity** ().
        """
        ...

    def resize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#resize

        **void QByteArray::resize(qsizetype size )**

        Sets the size of the byte array to **size** bytes.

        If **size** is greater than the current size, the byte array is extended
        to make it **size** bytes with the extra bytes added to the end. The new
        bytes are uninitialized.

        If **size** is less than the current size, bytes beyond position
        **size** are excluded from the byte array.

        **Note:** While resize() will grow the capacity if needed, it never
        shrinks capacity. To shed excess capacity, use **squeeze** ().

        **See also** **size** (), **truncate** (), and **squeeze** ().
        """
        ...

    def right(self, len: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#right

        **QByteArray QByteArray::right(qsizetype len ) const**

        Returns a byte array that contains the last **len** bytes of this byte
        array.

        If you know that **len** cannot be out of bounds, use **last** ()
        instead in new code, because it is faster.

        The entire byte array is returned if **len** is greater than **size**
        ().

        Returns an empty **QByteArray**  if **len** is smaller than 0.

        **See also** **endsWith** (), **last** (), **first** (), **sliced** (),
        **chopped** (), **chop** (), and **truncate** ().
        """
        ...

    def rightJustified(
        self, width: int, fill: int = ..., truncate: bool = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#rightJustified

        **QByteArray QByteArray::rightJustified(qsizetype width , char fill = '
        ', bool truncate = false) const**

        Returns a byte array of size **width** that contains the **fill** byte
        followed by this byte array.

        If **truncate** is false and the size of the byte array is more than
        **width** , then the returned byte array is a copy of this byte array.

        If **truncate** is true and the size of the byte array is more than
        **width** , then the resulting byte array is truncated at position
        **width**.

        Example:

        **QByteArray**  x("apple");
            **QByteArray**  y = x.rightJustified(8,
        '.');    // y == "...apple"

        **See also** **leftJustified** ().
        """
        ...

    @overload
    def setNum(
        self, arg__1: float, format: int = ..., precision: int = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#setNum

        **QByteArray &QByteArray::setNum(int n , int base = 10)**

        Represent the whole number **n** as text.

        Sets this byte array to a string representing **n** in base **base**
        (ten by default) and returns a reference to this byte array. Bases 2
        through 36 are supported, using letters for digits beyond 9; A is ten, B
        is eleven and so on.

        Example:

        **QByteArray**  ba;
            int n = 63;
            ba.setNum(n);           // ba ==
        "63"
            ba.setNum(n, 16);       // ba == "3f"

        **Note:** The format of the number is not localized; the default C
        locale is used regardless of the user's locale. Use **QLocale**  to
        perform locale-aware conversions between numbers and strings.

        **See also** **number** () and **toInt** ().
        """
        ...

    @overload
    def setNum(self, arg__1: int, base: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#setNum-1

        **QByteArray &QByteArray::setNum(short n , int base = 10)**

        This is an overloaded function.

        **See also** **toShort** ().
        """
        ...

    @overload
    def setNum(self, arg__1: int, base: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#setNum-2

        **QByteArray &QByteArray::setNum(ushort n , int base = 10)**

        This is an overloaded function.

        **See also** **toUShort** ().
        """
        ...

    def setRawData(self, a: bytes, n: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#setRawData

        **QByteArray &QByteArray::setRawData(const char * data , qsizetype size
        )**

        Resets the **QByteArray**  to use the first **size** bytes of the
        **data** array. The bytes are **not** copied. The **QByteArray**  will
        contain the **data** pointer. The caller guarantees that **data** will
        not be deleted or modified as long as this **QByteArray**  and any
        copies of it exist that have not been modified.

        This function can be used instead of **fromRawData** () to re-use
        existing **QByteArray**  objects to save memory re-allocations.

        **See also** **fromRawData** (), **data** (), and **constData** ().
        """
        ...

    def shrink_to_fit(self) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#shrink_to_fit

        **[since 5.10] void QByteArray::shrink_to_fit()**

        This function is provided for STL compatibility. It is equivalent to
        **squeeze** ().

        This function was introduced in Qt 5.10.
        """
        ...

    def simplified(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#simplified

        **QByteArray QByteArray::simplified() const**

        Returns a copy of this byte array that has spacing characters removed
        from the start and end, and in which each sequence of internal spacing
        characters is replaced with a single space.

        The spacing characters are those for which the standard C++ `isspace()`
        function returns `true` in the C locale; these are the ASCII characters
        tabulation '\\t', line feed '\\n', carriage return '\\r', vertical
        tabulation '\\v', form feed '\\f', and space ' '.

        Example:

        **QByteArray**  ba("  lots\\t of\\nwhitespace\\r\\n ");
            ba =
        ba.simplified();
            // ba == "lots of whitespace";

        **See also** **trimmed** (), **QChar::SpecialCharacter** , and **Spacing
        Characters** .
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qbytearray.html#size

        **qsizetype QByteArray::size() const**

        Returns the number of bytes in this byte array.

        The last byte in the byte array is at position size() - 1. In addition,
        **QByteArray**  ensures that the byte at position size() is always '\\0',
        so that you can use the return value of **data** () and **constData** ()
        as arguments to functions that expect '\\0'-terminated strings. If the
        **QByteArray**  object was created from a **raw data**  that didn't
        include the trailing '\\0'-termination byte, then **QByteArray**  doesn't
        add it automatically unless a **deep copy**  is created.

        Example:

        **QByteArray**  ba("Hello");
            qsizetype n = ba.size();    // n == 5
        ba.data()[0];               // returns 'H'
            ba.data()[4];
        // returns 'o'
            ba.data()[5];               // returns '\\0'

        **See also** **isEmpty** () and **resize** ().
        """
        ...

    @overload
    def sliced(self, pos: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#sliced

        **[since 6.0] QByteArray QByteArray::sliced(qsizetype pos , qsizetype n
        ) const**

        Returns a byte array containing the **n** bytes of this object starting
        at position **pos**.

        **Note:** The behavior is undefined when **pos** < 0, **n** < 0, or
        **pos** \\+ **n** > **size** ().

        Example:

        **QByteArray**  x("Five pineapples");
            **QByteArray**  y =
        x.sliced(5, 4);     // y == "pine"
            **QByteArray**  z = x.sliced(5);
        // z == "pineapples"

        This function was introduced in Qt 6.0.

        **See also** **first** (), **last** (), **chopped** (), **chop** (), and
        **truncate** ().
        """
        ...

    @overload
    def sliced(self, pos: int, n: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#sliced-1

        **[since 6.0] QByteArray QByteArray::sliced(qsizetype pos ) const**

        This is an overloaded function.

        Returns a byte array containing the bytes starting at position **pos**
        in this object, and extending to the end of this object.

        **Note:** The behavior is undefined when **pos** < 0 or **pos** >
        **size** ().

        This function was introduced in Qt 6.0.

        **See also** **first** (), **last** (), **sliced** (), **chopped** (),
        **chop** (), and **truncate** ().
        """
        ...

    def split(self, sep: int) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#split

        **QList<QByteArray> QByteArray::split(char sep ) const**

        Splits the byte array into subarrays wherever **sep** occurs, and
        returns the list of those arrays. If **sep** does not match anywhere in
        the byte array, split() returns a single-element list containing this
        byte array.
        """
        ...

    def squeeze(self) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#squeeze

        **void QByteArray::squeeze()**

        Releases any memory not required to store the array's data.

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function.

        **See also** **reserve** () and **capacity** ().
        """
        ...

    @overload
    def startsWith(self, bv: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#startsWith

        **[since 6.0] bool QByteArray::startsWith(QByteArrayView bv ) const**

        Returns `true` if this byte array starts with the sequence of bytes
        viewed by **bv** ; otherwise returns `false`.

        Example:

        **QByteArray**  url("ftp://ftp.qt-project.org/");
            if
        (url.startsWith("ftp:"))
                ...

        This function was introduced in Qt 6.0.

        **See also** **endsWith** () and **first** ().
        """
        ...

    @overload
    def startsWith(self, c: int) -> bool:
        """
        https://doc.qt.io/qt-6/qbytearray.html#startsWith-1

        **bool QByteArray::startsWith(char ch ) const**

        This is an overloaded function.

        Returns `true` if this byte array starts with byte **ch** ; otherwise
        returns `false`.
        """
        ...

    def swap(self, other: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#swap

        **void QByteArray::swap(QByteArray & other )**

        Swaps byte array **other** with this byte array. This operation is very
        fast and never fails.
        """
        ...

    def toBase64(
        self, options: PySide6.QtCore.QByteArray.Base64Options = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toBase64

        **[since 5.2] QByteArray QByteArray::toBase64(QByteArray::Base64Options
        options = Base64Encoding) const**

        Returns a copy of the byte array, encoded using the options **options**.

        **QByteArray**  text("Qt is great!");
            text.toBase64();        //
        returns "UXQgaXMgZ3JlYXQh"

            **QByteArray**
        text("<p>Hello?</p>");
            text.toBase64(**QByteArray** ::Base64Encoding
        | **QByteArray** ::OmitTrailingEquals);      // returns
        "PHA+SGVsbG8/PC9wPg"
            text.toBase64(**QByteArray** ::Base64Encoding);
        // returns "PHA+SGVsbG8/PC9wPg=="
            text.toBase64(**QByteArray**
        ::Base64UrlEncoding);                                    // returns
        "PHA-SGVsbG8_PC9wPg=="
            text.toBase64(**QByteArray**
        ::Base64UrlEncoding | **QByteArray** ::OmitTrailingEquals);   // returns
        "PHA-SGVsbG8_PC9wPg"

        The algorithm used to encode Base64-encoded data is defined in **RFC
        4648** .

        This function was introduced in Qt 5.2.

        **See also** **fromBase64** ().
        """
        ...

    def toDouble(self) -> Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toDouble

        **double QByteArray::toDouble(bool * ok = nullptr) const**

        Returns the byte array converted to a `double` value.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for other reasons (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  string("1234.56");
            bool ok;
            double a =
        string.toDouble(&ok);   // a == 1234.56, ok == true

            string =
        "1234.56 Volt";
            a = str.toDouble(&ok);             // a == 0, ok ==
        false

        **Warning:** The **QByteArray**  content may only contain valid
        numerical characters which includes the plus/minus sign, the character e
        used in scientific notation, and the decimal point. Including the unit
        or additional characters leads to a conversion error.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        This function ignores leading and trailing whitespace.

        **See also** **number** ().
        """
        ...

    def toFloat(self) -> Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toFloat

        **float QByteArray::toFloat(bool * ok = nullptr) const**

        Returns the byte array converted to a `float` value.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for other reasons (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  string("1234.56");
            bool ok;
            float a =
        string.toFloat(&ok);    // a == 1234.56, ok == true

            string =
        "1234.56 Volt";
            a = str.toFloat(&ok);              // a == 0, ok ==
        false

        **Warning:** The **QByteArray**  content may only contain valid
        numerical characters which includes the plus/minus sign, the character e
        used in scientific notation, and the decimal point. Including the unit
        or additional characters leads to a conversion error.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        This function ignores leading and trailing whitespace.

        **See also** **number** ().
        """
        ...

    def toHex(self, separator: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toHex

        **[since 5.9] QByteArray QByteArray::toHex(char separator = '\\0')
        const**

        Returns a hex encoded copy of the byte array.

        The hex encoding uses the numbers 0-9 and the letters a-f.

        If **separator** is not '\\0', the separator character is inserted
        between the hex bytes.

        Example:

        **QByteArray**  macAddress = **QByteArray** ::fromHex("123456abcdef");
        macAddress.toHex(':'); // returns "12:34:56:ab:cd:ef"
        macAddress.toHex(0);   // returns "123456abcdef"

        This function was introduced in Qt 5.9.

        **See also** **fromHex** ().
        """
        ...

    def toInt(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toInt

        **int QByteArray::toInt(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `int` using base **base** , which
        is ten by default. Bases 0 and 2 through 36 are supported, using letters
        for digits beyond 9; A is ten, B is eleven and so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  str("FF");
            bool ok;
            int hex = str.toInt(&ok,
        16);     // hex == 255, ok == true
            int dec = str.toInt(&ok, 10);
        // dec == 0, ok == false

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toLong(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toLong

        **long QByteArray::toLong(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to a `long` int using base **base** ,
        which is ten by default. Bases 0 and 2 through 36 are supported, using
        letters for digits beyond 9; A is ten, B is eleven and so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  str("FF");
            bool ok;
            long hex = str.toLong(&ok,
        16);   // hex == 255, ok == true
            long dec = str.toLong(&ok, 10);
        // dec == 0, ok == false

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toLongLong(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toLongLong

        **qlonglong QByteArray::toLongLong(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to a `long long` using base **base** ,
        which is ten by default. Bases 0 and 2 through 36 are supported, using
        letters for digits beyond 9; A is ten, B is eleven and so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toLower(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toLower

        **QByteArray QByteArray::toLower() const**

        Returns a copy of the byte array in which each ASCII uppercase letter
        converted to lowercase.

        Example:

        **QByteArray**  x("Qt by THE QT COMPANY");
            **QByteArray**  y =
        x.toLower();
            // y == "qt by the qt company"

        **See also** **isLower** (), **toUpper** (), and **Character Case** .
        """
        ...

    def toPercentEncoding(
        self,
        exclude: Union[PySide6.QtCore.QByteArray, bytes] = ...,
        include: Union[PySide6.QtCore.QByteArray, bytes] = ...,
        percent: int = ...,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toPercentEncoding

        **QByteArray QByteArray::toPercentEncoding(const QByteArray & exclude =
        QByteArray(), const QByteArray & include = QByteArray(), char percent =
        '%') const**

        Returns a URI/URL-style percent-encoded copy of this byte array. The
        **percent** parameter allows you to override the default '%' character
        for another.

        By default, this function will encode all bytes that are not one of the
        following:

        ALPHA ("a" to "z" and "A" to "Z") / DIGIT (0 to 9) / "-" / "." / "_" /
        "~"

        To prevent bytes from being encoded pass them to **exclude**. To force
        bytes to be encoded pass them to **include**. The **percent** character
        is always encoded.

        Example:

        **QByteArray**  text = "{a fishy string?}";
            **QByteArray**  ba =
        text.toPercentEncoding("{}", "s");
            **qDebug** (ba.constData());
        // prints "{a fi%73hy %73tring%3F}"

        The hex encoding uses the numbers 0-9 and the uppercase letters A-F.

        **See also** **fromPercentEncoding** () and **QUrl::toPercentEncoding**
        ().
        """
        ...

    def toShort(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toShort

        **short QByteArray::toShort(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to a `short` using base **base** ,
        which is ten by default. Bases 0 and 2 through 36 are supported, using
        letters for digits beyond 9; A is ten, B is eleven and so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; otherwise, if it begins with "0", it is assumed to be
        octal; otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toUInt(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toUInt

        **uint QByteArray::toUInt(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `unsigned int` using base
        **base** , which is ten by default. Bases 0 and 2 through 36 are
        supported, using letters for digits beyond 9; A is ten, B is eleven and
        so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toULong(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toULong

        **ulong QByteArray::toULong(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `unsigned long int` using base
        **base** , which is ten by default. Bases 0 and 2 through 36 are
        supported, using letters for digits beyond 9; A is ten, B is eleven and
        so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toULongLong(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toULongLong

        **qulonglong QByteArray::toULongLong(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to an `unsigned long long` using base
        **base** , which is ten by default. Bases 0 and 2 through 36 are
        supported, using letters for digits beyond 9; A is ten, B is eleven and
        so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal (base 16); otherwise, if it begins with "0", it is assumed
        to be octal (base 8); otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toUShort(self, base: int = ...) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toUShort

        **ushort QByteArray::toUShort(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to an `unsigned short` using base
        **base** , which is ten by default. Bases 0 and 2 through 36 are
        supported, using letters for digits beyond 9; A is ten, B is eleven and
        so on.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; otherwise, if it begins with "0", it is assumed to be
        octal; otherwise it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, regardless of the user's locale. Use **QLocale**  to perform
        locale-aware conversions between numbers and strings.

        **See also** **number** ().
        """
        ...

    def toUpper(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#toUpper

        **QByteArray QByteArray::toUpper() const**

        Returns a copy of the byte array in which each ASCII lowercase letter
        converted to uppercase.

        Example:

        **QByteArray**  x("Qt by THE QT COMPANY");
            **QByteArray**  y =
        x.toUpper();
            // y == "QT BY THE QT COMPANY"

        **See also** **isUpper** (), **toLower** (), and **Character Case** .
        """
        ...

    def trimmed(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearray.html#trimmed

        **QByteArray QByteArray::trimmed() const**

        Returns a copy of this byte array with spacing characters removed from
        the start and end.

        The spacing characters are those for which the standard C++ `isspace()`
        function returns `true` in the C locale; these are the ASCII characters
        tabulation '\\t', line feed '\\n', carriage return '\\r', vertical
        tabulation '\\v', form feed '\\f', and space ' '.

        Example:

        **QByteArray**  ba("  lots\\t of\\nwhitespace\\r\\n ");
            ba =
        ba.trimmed();
            // ba == "lots\\t of\\nwhitespace";

        Unlike **simplified** (), trimmed() leaves internal spacing unchanged.

        **See also** **simplified** (), **QChar::SpecialCharacter** , and
        **Spacing Characters** .
        """
        ...

    def truncate(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearray.html#truncate

        **void QByteArray::truncate(qsizetype pos )**

        Truncates the byte array at index position **pos**.

        If **pos** is beyond the end of the array, nothing happens.

        Example:

        **QByteArray**  ba("Stockholm");
            ba.truncate(5);             // ba
        == "Stock"

        **See also** **chop** (), **resize** (), and **first** ().
        """
        ...
