"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QValueAxis(PySide6.QtCharts.QAbstractAxis):
    """
    https://doc.qt.io/qt-6/qvalueaxis.html

    **Detailed Description**

    A value axis can be set up to show an axis line with tick marks, grid lines,
    and shades. The values on the axis are drawn at the positions of tick marks.

    The following example code illustrates how to use the QValueAxis class:

    **QChartView**  *chartView = new **QChartView** ;
        **QLineSeries**
    *series = new **QLineSeries** ;
        // ...
    chartView->chart()->addSeries(series);

        **QValueAxis**  *axisX = new
    **QValueAxis** ;
        axisX->setRange(10, 20.5);
        axisX->setTickCount(10);
    axisX->setLabelFormat("%.2f");
        chartView->chart()->setAxisX(axisX,
    series);
    """

    TicksDynamic: QValueAxis.TickType = ...
    TicksFixed: QValueAxis.TickType = ...

    class TickType(Enum):
        TicksDynamic: QValueAxis.TickType = ...
        TicksFixed: QValueAxis.TickType = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#QValueAxis

        **QValueAxis::QValueAxis(QObject * parent = nullptr)**

        Constructs an axis object that is a child of **parent**.
        """
        ...

    def applyNiceNumbers(self) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#applyNiceNumbers

        **[slot] void QValueAxis::applyNiceNumbers()**

        Modifies the current range and number of tick marks on the axis to look
        **nice**. The algorithm considers numbers that can be expressed as a
        form of 1*10^n, 2* 10^n, or 5*10^n to be nice numbers. These numbers are
        used for setting spacing for the tick marks.

        **See also** **setRange** () and **setTickCount** ().
        """
        ...

    def labelFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#labelFormat-prop

        **labelFormat : QString**

        This property holds the label format of the axis.

        The format string supports the following conversion specifiers, length
        modifiers, and flags provided by `printf()` in the standard C++ library:
        d, i, o, x, X, f, F, e, E, g, G, c.

        If **QChart::localizeNumbers**  is `true`, the supported specifiers are
        limited to: d, e, E, f, g, G, and i. Also, only the precision modifier
        is supported. The rest of the formatting comes from the default
        **QLocale**  of the application.

        **Access functions:**

        QString **labelFormat** () const
        void **setLabelFormat** (const
        QString & **format** )

        **Notifier signal:**

        void ****labelFormatChanged** ** (const QString & **format** )

        **See also** **QString::asprintf** ().
        """
        ...

    def max(self) -> float:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#max-prop

        **max : qreal**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        qreal **max** () const
        void **setMax** (qreal **max** )

        **Notifier signal:**

        void ****maxChanged** ** (qreal **max** )
        """
        ...

    def min(self) -> float:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#min-prop

        **min : qreal**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        qreal **min** () const
        void **setMin** (qreal **min** )

        **Notifier signal:**

        void ****minChanged** ** (qreal **min** )
        """
        ...

    def minorTickCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#minorTickCount-prop

        **minorTickCount : int**

        This property holds the number of minor tick marks on the axis. This
        indicates how many grid lines are drawn between major ticks on the
        chart. Labels are not drawn for minor ticks. The default value is 0.

        **Access functions:**

        int **minorTickCount** () const
        void **setMinorTickCount** (int
        **count** )

        **Notifier signal:**

        void ****minorTickCountChanged** ** (int **minorTickCount** )
        """
        ...

    def setLabelFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#labelFormat-prop

        **labelFormat : QString**

        This property holds the label format of the axis.

        The format string supports the following conversion specifiers, length
        modifiers, and flags provided by `printf()` in the standard C++ library:
        d, i, o, x, X, f, F, e, E, g, G, c.

        If **QChart::localizeNumbers**  is `true`, the supported specifiers are
        limited to: d, e, E, f, g, G, and i. Also, only the precision modifier
        is supported. The rest of the formatting comes from the default
        **QLocale**  of the application.

        **Access functions:**

        QString **labelFormat** () const
        void **setLabelFormat** (const
        QString & **format** )

        **Notifier signal:**

        void ****labelFormatChanged** ** (const QString & **format** )

        **See also** **QString::asprintf** ().
        """
        ...

    def setMax(self, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#max-prop

        **max : qreal**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        qreal **max** () const
        void **setMax** (qreal **max** )

        **Notifier signal:**

        void ****maxChanged** ** (qreal **max** )
        """
        ...

    def setMin(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#min-prop

        **min : qreal**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        qreal **min** () const
        void **setMin** (qreal **min** )

        **Notifier signal:**

        void ****minChanged** ** (qreal **min** )
        """
        ...

    def setMinorTickCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#minorTickCount-prop

        **minorTickCount : int**

        This property holds the number of minor tick marks on the axis. This
        indicates how many grid lines are drawn between major ticks on the
        chart. Labels are not drawn for minor ticks. The default value is 0.

        **Access functions:**

        int **minorTickCount** () const
        void **setMinorTickCount** (int
        **count** )

        **Notifier signal:**

        void ****minorTickCountChanged** ** (int **minorTickCount** )
        """
        ...

    def setRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#setRange

        **void QValueAxis::setRange(qreal min , qreal max )**

        Sets the range from **min** to **max** on the axis. If **min** is
        greater than **max** , this function returns without making any changes.
        """
        ...

    def setTickAnchor(self, anchor: float) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickAnchor-prop

        **[since 5.12] tickAnchor : qreal**

        This property holds the base value where the dynamically placed tick
        marks and labels are started from.

        This property was introduced in Qt 5.12.

        **Access functions:**

        qreal **tickAnchor** () const
        void **setTickAnchor** (qreal **anchor**
        )

        **Notifier signal:**

        void **tickAnchorChanged** (qreal **anchor** )
        """
        ...

    def setTickCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickCount-prop

        **tickCount : int**

        This property holds the number of tick marks on the axis. This indicates
        how many grid lines are drawn on the chart. The default value is 5, and
        the number cannot be less than 2.

        **Access functions:**

        int **tickCount** () const
        void **setTickCount** (int **count** )

        **Notifier signal:**

        void ****tickCountChanged** ** (int **tickCount** )
        """
        ...

    def setTickInterval(self, insterval: float) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickInterval-prop

        **[since 5.12] tickInterval : qreal**

        This property holds the interval between dynamically placed tick marks
        and labels.

        This property was introduced in Qt 5.12.

        **Access functions:**

        qreal **tickInterval** () const
        void **setTickInterval** (qreal
        **insterval** )

        **Notifier signal:**

        void **tickIntervalChanged** (qreal **interval** )
        """
        ...

    def setTickType(self, type: PySide6.QtCharts.QValueAxis.TickType) -> None:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickType-prop

        **[since 5.12] tickType : TickType**

        This property holds the positioning method of tick and labels.

        This property was introduced in Qt 5.12.

        **Access functions:**

        QValueAxis::TickType **tickType** () const
        void **setTickType**
        (QValueAxis::TickType **type** )

        **Notifier signal:**

        void **tickTypeChanged** (QValueAxis::TickType **type** )

        **Member Function Documentation**
        """
        ...

    def tickAnchor(self) -> float:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickAnchor-prop

        **[since 5.12] tickAnchor : qreal**

        This property holds the base value where the dynamically placed tick
        marks and labels are started from.

        This property was introduced in Qt 5.12.

        **Access functions:**

        qreal **tickAnchor** () const
        void **setTickAnchor** (qreal **anchor**
        )

        **Notifier signal:**

        void **tickAnchorChanged** (qreal **anchor** )
        """
        ...

    def tickCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickCount-prop

        **tickCount : int**

        This property holds the number of tick marks on the axis. This indicates
        how many grid lines are drawn on the chart. The default value is 5, and
        the number cannot be less than 2.

        **Access functions:**

        int **tickCount** () const
        void **setTickCount** (int **count** )

        **Notifier signal:**

        void ****tickCountChanged** ** (int **tickCount** )
        """
        ...

    def tickInterval(self) -> float:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickInterval-prop

        **[since 5.12] tickInterval : qreal**

        This property holds the interval between dynamically placed tick marks
        and labels.

        This property was introduced in Qt 5.12.

        **Access functions:**

        qreal **tickInterval** () const
        void **setTickInterval** (qreal
        **insterval** )

        **Notifier signal:**

        void **tickIntervalChanged** (qreal **interval** )
        """
        ...

    def tickType(self) -> PySide6.QtCharts.QValueAxis.TickType:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickType-prop

        **[since 5.12] tickType : TickType**

        This property holds the positioning method of tick and labels.

        This property was introduced in Qt 5.12.

        **Access functions:**

        QValueAxis::TickType **tickType** () const
        void **setTickType**
        (QValueAxis::TickType **type** )

        **Notifier signal:**

        void **tickTypeChanged** (QValueAxis::TickType **type** )

        **Member Function Documentation**
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#type

        **[override virtual] QAbstractAxis::AxisType QValueAxis::type() const**

        Reimplements: **QAbstractAxis::type() const** .

        Returns the type of the axis.
        """
        ...

    @property
    def labelFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#labelFormatChanged

        **[signal] void QValueAxis::labelFormatChanged(const QString & format
        )**

        This signal is emitted when the **format** of axis labels changes.

        **Note:** Notifier signal for property **labelFormat** .
        """
        ...

    @property
    def maxChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#maxChanged

        **[signal] void QValueAxis::maxChanged(qreal max )**

        This signal is emitted when the maximum value of the axis, specified by
        **max** , changes.

        **Note:** Notifier signal for property **max** .
        """
        ...

    @property
    def minChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#minChanged

        **[signal] void QValueAxis::minChanged(qreal min )**

        This signal is emitted when the minimum value of the axis, specified by
        **min** , changes.

        **Note:** Notifier signal for property **min** .
        """
        ...

    @property
    def minorTickCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#minorTickCountChanged

        **[signal] void QValueAxis::minorTickCountChanged(int minorTickCount )**

        This signal is emitted when the number of minor tick marks on the axis,
        specified by **minorTickCount** , changes.

        **Note:** Notifier signal for property **minorTickCount** .
        """
        ...

    @property
    def rangeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#rangeChanged

        **[signal] void QValueAxis::rangeChanged(qreal min , qreal max )**

        This signal is emitted when the minimum or maximum value of the axis,
        specified by **min** and **max** , changes.
        """
        ...

    @property
    def tickAnchorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def tickCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvalueaxis.html#tickCountChanged

        **[signal] void QValueAxis::tickCountChanged(int tickCount )**

        This signal is emitted when the number of tick marks on the axis,
        specified by **tickCount** , changes.

        **Note:** Notifier signal for property **tickCount** .
        """
        ...

    @property
    def tickIntervalChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def tickTypeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
