"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QVXYModelMapper(PySide6.QtCharts.QXYModelMapper):
    """
    https://doc.qt.io/qt-6/qvxymodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A vertical model
    mapper is used to create a connection between a line, spline, or scatter
    series and the data model that has **X** and **Y** columns for the
    coordinates and holds the data points for the **XYSeries**  as rows. A
    **TableModel** is a natural choice for the model.

    Both model and series properties can be used to manipulate the data. The
    model mapper keeps the series and the data model in sync.

    **See also** **QHXYModelMapper** , **QXYSeries** , and **Model Data
    Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#QVXYModelMapper

        **QVXYModelMapper::QVXYModelMapper(QObject * parent = nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def firstRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the data for the
        first point of the series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for series.

        The minimum and default value is -1 (the number is limited by the number
        of rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QXYSeries:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#series-prop

        **series : QXYSeries***

        This property holds the series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QXYSeries * **series** () const
        void **setSeries** (QXYSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setFirstRow(self, firstRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the data for the
        first point of the series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setRowCount(self, rowCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for series.

        The minimum and default value is -1 (the number is limited by the number
        of rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QXYSeries) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#series-prop

        **series : QXYSeries***

        This property holds the series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QXYSeries * **series** () const
        void **setSeries** (QXYSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setXColumn(self, xColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#xColumn-prop

        **xColumn : int**

        This property holds the column of the model that contains the
        x-coordinates of data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **xColumn** () const
        void **setXColumn** (int **xColumn** )

        **Notifier signal:**

        void ****xColumnChanged** ** ()
        """
        ...

    def setYColumn(self, yColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#yColumn-prop

        **yColumn : int**

        This property holds the column of the model that contains the
        y-coordinates of data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **yColumn** () const
        void **setYColumn** (int **yColumn** )

        **Notifier signal:**

        void ****yColumnChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def xColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#xColumn-prop

        **xColumn : int**

        This property holds the column of the model that contains the
        x-coordinates of data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **xColumn** () const
        void **setXColumn** (int **xColumn** )

        **Notifier signal:**

        void ****xColumnChanged** ** ()
        """
        ...

    def yColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#yColumn-prop

        **yColumn : int**

        This property holds the column of the model that contains the
        y-coordinates of data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **yColumn** () const
        void **setYColumn** (int **yColumn** )

        **Notifier signal:**

        void ****yColumnChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def firstRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#firstRowChanged

        **[signal] void QVXYModelMapper::firstRowChanged()**

        This signal is emitted when the first row changes.

        **Note:** Notifier signal for property **firstRow** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#modelReplaced

        **[signal] void QVXYModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def rowCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#rowCountChanged

        **[signal] void QVXYModelMapper::rowCountChanged()**

        This signal is emitted when the number of rows changes.

        **Note:** Notifier signal for property **rowCount** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#seriesReplaced

        **[signal] void QVXYModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...

    @property
    def xColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#xColumnChanged

        **[signal] void QVXYModelMapper::xColumnChanged()**

        This signal is emitted when the column that contains the x-coordinates
        of data points changes.

        **Note:** Notifier signal for property **xColumn** .
        """
        ...

    @property
    def yColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvxymodelmapper.html#yColumnChanged

        **[signal] void QVXYModelMapper::yColumnChanged()**

        This signal is emitted when the column that contains the y-coordinates
        of data points changes.

        **Note:** Notifier signal for property **yColumn** .
        """
        ...
