"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QVPieModelMapper(PySide6.QtCharts.QPieModelMapper):
    """
    https://doc.qt.io/qt-6/qvpiemodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A vertical model
    mapper is used to create a connection between a data model and
    **QPieSeries** , so that each row in the data model defines a pie slice and
    each column maps to the label or the value of the pie slice.

    Both model and pie series properties can be used to manipulate the data. The
    model mapper keeps the pie series and the data model in sync.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#QVPieModelMapper

        **QVPieModelMapper::QVPieModelMapper(QObject * parent = nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def firstRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first slice
        value.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def labelsColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#labelsColumn

        **int QVPieModelMapper::labelsColumn() const**

        Returns the column of the model that is kept in sync with the labels of
        the pie's slices.

        **Note:** Getter function for property labelsColumn.

        **See also** **setLabelsColumn** ().
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for a pie series.

        The minimum and default value is -1 (number limited by the number of
        rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QPieSeries:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#series-prop

        **series : QPieSeries***

        This property holds the pie series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QPieSeries * **series** () const
        void **setSeries** (QPieSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setFirstRow(self, firstRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first slice
        value.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def setLabelsColumn(self, labelsColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#setLabelsColumn

        **void QVPieModelMapper::setLabelsColumn(int labelsColumn )**

        Sets the model column that is kept in sync with the pies slices' labels
        to **labelsColumn**.

        **Note:** Setter function for property **labelsColumn** .

        **See also** **labelsColumn** ().
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setRowCount(self, rowCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for a pie series.

        The minimum and default value is -1 (number limited by the number of
        rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QPieSeries) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#series-prop

        **series : QPieSeries***

        This property holds the pie series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QPieSeries * **series** () const
        void **setSeries** (QPieSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setValuesColumn(self, valuesColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#setValuesColumn

        **void QVPieModelMapper::setValuesColumn(int valuesColumn )**

        Sets the model column that is kept in sync with the pie slices' values
        to **valuesColumn**.

        **Note:** Setter function for property **valuesColumn** .

        **See also** **valuesColumn** ().
        """
        ...

    def valuesColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#valuesColumn

        **int QVPieModelMapper::valuesColumn() const**

        Returns the column of the model that is kept in sync with the values of
        the pie's slices.

        **Note:** Getter function for property valuesColumn.

        **See also** **setValuesColumn** ().
        """
        ...

    @property
    def firstRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#firstRowChanged

        **[signal] void QVPieModelMapper::firstRowChanged()**

        This signal is emitted when the first row changes.

        **Note:** Notifier signal for property **firstRow** .
        """
        ...

    @property
    def labelsColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#labelsColumnChanged

        **[signal] void QVPieModelMapper::labelsColumnChanged()**

        This signal is emitted when the labels column changes.

        **Note:** Notifier signal for property **labelsColumn** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#modelReplaced

        **[signal] void QVPieModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def rowCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#rowCountChanged

        **[signal] void QVPieModelMapper::rowCountChanged()**

        This signal is emitted when the number of rows changes.

        **Note:** Notifier signal for property **rowCount** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#seriesReplaced

        **[signal] void QVPieModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...

    @property
    def valuesColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvpiemodelmapper.html#valuesColumnChanged

        **[signal] void QVPieModelMapper::valuesColumnChanged()**

        This signal is emitted when the values column changes.

        **Note:** Notifier signal for property **valuesColumn** .
        """
        ...
