"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QVBoxPlotModelMapper(PySide6.QtCharts.QBoxPlotModelMapper):
    """
    https://doc.qt.io/qt-6/qvboxplotmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A vertical model
    mapper is used to create a connection between a data model and a
    **QBoxPlotSeries**  object, so that each column in the data model defines a
    box-and-whiskers item and each row maps to the range and three median values
    of the box-and-whiskers item.

    Both model and series properties can be used to manipulate the data. The
    model mapper keeps the series and the data model in sync.

    The model mapper ensures that all the bar box-and-whiskers items in the box
    plot series have equal sizes. Therefore, adding or removing a value from a
    box-and-whiskers item causes the same change to be made in all the box-and-
    whiskers items in the box plot series.

    **See also** **QHBoxPlotModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#QVBoxPlotModelMapper

        **QVBoxPlotModelMapper::QVBoxPlotModelMapper(QObject * parent =
        nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def firstBoxSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstBoxSetColumn-prop

        **firstBoxSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBoxSetColumn** () const
        void **setFirstBoxSetColumn** (int
        **firstBoxSetColumn** )

        **Notifier signal:**

        void ****firstBoxSetColumnChanged** ** ()
        """
        ...

    def firstRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first values
        of the box-and-whiskers items in the box plot series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def lastBoxSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#lastBoxSetColumn-prop

        **lastBoxSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBoxSetColumn** () const
        void **setLastBoxSetColumn** (int
        **lastBoxSetColumn** )

        **Notifier signal:**

        void ****lastBoxSetColumnChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for the box plot series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QBoxPlotSeries:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#series-prop

        **series : QBoxPlotSeries***

        This property holds the box plot series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QBoxPlotSeries * **series** () const
        void **setSeries**
        (QBoxPlotSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setFirstBoxSetColumn(self, firstBoxSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstBoxSetColumn-prop

        **firstBoxSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBoxSetColumn** () const
        void **setFirstBoxSetColumn** (int
        **firstBoxSetColumn** )

        **Notifier signal:**

        void ****firstBoxSetColumnChanged** ** ()
        """
        ...

    def setFirstRow(self, firstRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first values
        of the box-and-whiskers items in the box plot series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def setLastBoxSetColumn(self, lastBoxSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#lastBoxSetColumn-prop

        **lastBoxSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBoxSetColumn** () const
        void **setLastBoxSetColumn** (int
        **lastBoxSetColumn** )

        **Notifier signal:**

        void ****lastBoxSetColumnChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setRowCount(self, rowCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for the box plot series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QBoxPlotSeries) -> None:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#series-prop

        **series : QBoxPlotSeries***

        This property holds the box plot series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QBoxPlotSeries * **series** () const
        void **setSeries**
        (QBoxPlotSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def firstBoxSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstBoxSetColumnChange
        d

        **[signal] void QVBoxPlotModelMapper::firstBoxSetColumnChanged()**

        This signal is emitted when the first box-and-whiskers item column
        changes.

        **Note:** Notifier signal for property **firstBoxSetColumn** .
        """
        ...

    @property
    def firstRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#firstRowChanged

        **[signal] void QVBoxPlotModelMapper::firstRowChanged()**

        This signal is emitted when the first row changes.

        **Note:** Notifier signal for property **firstRow** .
        """
        ...

    @property
    def lastBoxSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#lastBoxSetColumnChanged

        **[signal] void QVBoxPlotModelMapper::lastBoxSetColumnChanged()**

        This signal is emitted when the last box-and-whiskers item column
        changes.

        **Note:** Notifier signal for property **lastBoxSetColumn** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#modelReplaced

        **[signal] void QVBoxPlotModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def rowCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#rowCountChanged

        **[signal] void QVBoxPlotModelMapper::rowCountChanged()**

        This signal is emitted when the number of rows changes.

        **Note:** Notifier signal for property **rowCount** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvboxplotmodelmapper.html#seriesReplaced

        **[signal] void QVBoxPlotModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...
