"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QVBarModelMapper(PySide6.QtCharts.QBarModelMapper):
    """
    https://doc.qt.io/qt-6/qvbarmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A vertical model
    mapper is used to create a connection between a data model and
    **QAbstractBarSeries** , so that each column in the data model defines a bar
    set and each row maps to a category in a bar series.

    Both model and bar series properties can be used to manipulate the data. The
    model mapper keeps the bar series and the data model in sync.

    The model mapper ensures that all the bar sets in the bar series have equal
    sizes. Therefore, adding or removing a value from a bar set causes the same
    change to be made in all the bar sets in the bar series.

    For more information, see **BarModelMapper Example** .

    **See also** **QHBarModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#QVBarModelMapper

        **QVBarModelMapper::QVBarModelMapper(QObject * parent = nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def firstBarSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstBarSetColumn-prop

        **firstBarSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBarSetColumn** () const
        void **setFirstBarSetColumn** (int
        **firstBarSetColumn** )

        **Notifier signal:**

        void ****firstBarSetColumnChanged** ** ()
        """
        ...

    def firstRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first values
        of the bar sets in the bar series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def lastBarSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#lastBarSetColumn-prop

        **lastBarSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBarSetColumn** () const
        void **setLastBarSetColumn** (int
        **lastBarSetColumn** )

        **Notifier signal:**

        void ****lastBarSetColumnChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the data model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for the bar series.

        The minimum and default value is -1 (number limited to the number of
        rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QAbstractBarSeries:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#series-prop

        **series : QAbstractBarSeries***

        This property holds the bar series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QAbstractBarSeries * **series** () const
        void **setSeries**
        (QAbstractBarSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setFirstBarSetColumn(self, firstBarSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstBarSetColumn-prop

        **firstBarSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBarSetColumn** () const
        void **setFirstBarSetColumn** (int
        **firstBarSetColumn** )

        **Notifier signal:**

        void ****firstBarSetColumnChanged** ** ()
        """
        ...

    def setFirstRow(self, firstRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstRow-prop

        **firstRow : int**

        This property holds the row of the model that contains the first values
        of the bar sets in the bar series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstRow** () const
        void **setFirstRow** (int **firstRow** )

        **Notifier signal:**

        void ****firstRowChanged** ** ()
        """
        ...

    def setLastBarSetColumn(self, lastBarSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#lastBarSetColumn-prop

        **lastBarSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBarSetColumn** () const
        void **setLastBarSetColumn** (int
        **lastBarSetColumn** )

        **Notifier signal:**

        void ****lastBarSetColumnChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the data model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setRowCount(self, rowCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#rowCount-prop

        **rowCount : int**

        This property holds the number of rows of the model that are mapped as
        the data for the bar series.

        The minimum and default value is -1 (number limited to the number of
        rows in the model).

        **Access functions:**

        int **rowCount** () const
        void **setRowCount** (int **rowCount** )

        **Notifier signal:**

        void ****rowCountChanged** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QAbstractBarSeries) -> None:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#series-prop

        **series : QAbstractBarSeries***

        This property holds the bar series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QAbstractBarSeries * **series** () const
        void **setSeries**
        (QAbstractBarSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def firstBarSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstBarSetColumnChanged

        **[signal] void QVBarModelMapper::firstBarSetColumnChanged()**

        This signal is emitted when the first bar set column changes.

        **Note:** Notifier signal for property **firstBarSetColumn** .
        """
        ...

    @property
    def firstRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#firstRowChanged

        **[signal] void QVBarModelMapper::firstRowChanged()**

        This signal is emitted when the first row changes.

        **Note:** Notifier signal for property **firstRow** .
        """
        ...

    @property
    def lastBarSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#lastBarSetColumnChanged

        **[signal] void QVBarModelMapper::lastBarSetColumnChanged()**

        This signal is emitted when the last bar set column changes.

        **Note:** Notifier signal for property **lastBarSetColumn** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#modelReplaced

        **[signal] void QVBarModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def rowCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#rowCountChanged

        **[signal] void QVBarModelMapper::rowCountChanged()**

        This signal is emitted when the number of rows changes.

        **Note:** Notifier signal for property **rowCount** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvbarmodelmapper.html#seriesReplaced

        **[signal] void QVBarModelMapper::seriesReplaced()**

        This signal is emitted when the bar series that the mapper is connected
        to changes.

        **Note:** Notifier signal for property **series** .
        """
        ...
