"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QSplineSeries(PySide6.QtCharts.QLineSeries):
    """
    https://doc.qt.io/qt-6/qsplineseries.html

    **Detailed Description**

    A spline series stores the data points and the segment control points needed
    by **QPainterPath**  to draw a spline. The control points are automatically
    calculated when the data changes. The algorithm computes the points so that
    the normal spline can be drawn.

    ![](images/examples_splinechart.png)

    The following code snippet illustrates how to create a basic spline chart:

    **QSplineSeries** * series = new **QSplineSeries** ();
        series->append(0,
    6);
        series->append(2, 4);
        ...
        chart->addSeries(series);
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsplineseries.html#QSplineSeries

        **QSplineSeries::QSplineSeries(QObject * parent = nullptr)**

        Constructs an empty series object that is a child of **parent**. When
        the series object is added to a **QChart**  instance, the ownerships is
        transferred.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qsplineseries.html#type

        **[override virtual] QAbstractSeries::SeriesType QSplineSeries::type()
        const**

        Reimplements: **QLineSeries::type() const** .
        """
        ...
