"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QPieSlice(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qpieslice.html

    **Detailed Description**

    A pie slice has a value and a label. When the slice is added to a pie
    series, the **QPieSeries**  object calculates the percentage of the slice
    compared with the sum of all slices in the series to determine the actual
    size of the slice in the chart.

    By default, the label is hidden. If it is visible, it can be either located
    outside the slice and connected to it with an arm or centered inside the
    slice either horizontally or in parallel with the tangential or normal of
    the slice's arc.

    By default, the visual appearance of the slice is set by a theme, but the
    theme can be overridden by specifying slice properties. However, if the
    theme is changed after the slices are customized, all customization will be
    lost.

    To enable user interaction with the pie chart, some basic signals are
    emitted when users click pie slices or hover the mouse over them.

    **See also** **QPieSeries** .
    """

    LabelOutside: QPieSlice.LabelPosition = ...
    LabelInsideHorizontal: QPieSlice.LabelPosition = ...
    LabelInsideTangential: QPieSlice.LabelPosition = ...
    LabelInsideNormal: QPieSlice.LabelPosition = ...

    class LabelPosition(Enum):
        LabelOutside: QPieSlice.LabelPosition = ...
        LabelInsideHorizontal: QPieSlice.LabelPosition = ...
        LabelInsideTangential: QPieSlice.LabelPosition = ...
        LabelInsideNormal: QPieSlice.LabelPosition = ...

    @overload
    def __init__(
        self, label: str, value: float, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#QPieSlice

        **QPieSlice::QPieSlice(QObject * parent = nullptr)**

        Constructs an empty slice with the parent **parent**.

        **See also** **QPieSeries::append** () and **QPieSeries::insert** ().
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#QPieSlice-1

        **QPieSlice::QPieSlice(QString label , qreal value , QObject * parent =
        nullptr)**

        Constructs an empty slice with the specified **value** , **label** , and
        **parent**.

        **See also** **QPieSeries::append** () and **QPieSeries::insert** ().
        """
        ...

    def angleSpan(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#angleSpan-prop

        **[read-only] angleSpan : const qreal**

        This property holds the span of the slice in degrees. A full pie is 360
        degrees, where 0 degrees is at 12 a'clock. Updated automatically once
        the slice is added to the series.

        **Access functions:**

        qreal **angleSpan** () const

        **Notifier signal:**

        void ****angleSpanChanged** ** ()
        """
        ...

    def borderColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderColor-prop

        **borderColor : QColor**

        This property holds the color used to draw the slice border. This is a
        convenience property for modifying the slice pen.

        **Access functions:**

        QColor **borderColor** ()
        void **setBorderColor** (QColor **color** )

        **Notifier signal:**

        void ****borderColorChanged** ** ()

        **See also** **pen**  and **borderWidth** .
        """
        ...

    def borderWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderWidth-prop

        **borderWidth : int**

        This property holds the width of the slice border. This is a convenience
        property for modifying the slice pen.

        **Access functions:**

        int **borderWidth** ()
        void **setBorderWidth** (int **width** )

        **Notifier signal:**

        void ****borderWidthChanged** ** ()

        **See also** **pen**  and **borderColor** .
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpieslice.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the slice.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qpieslice.html#color-prop

        **color : QColor**

        This property holds the fill (brush) color of the slice. This is a
        convenience property for modifying the slice brush.

        **Access functions:**

        QColor **color** ()
        void **setColor** (QColor **color** )

        **Notifier signal:**

        void ****colorChanged** ** ()

        **See also** **brush** .
        """
        ...

    def explodeDistanceFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#explodeDistanceFactor-prop

        **explodeDistanceFactor : qreal**

        Determines how far away from the pie the slice is exploded.

        * 1.0 means that the distance is the same as the radius.
          * 0.5 means
        that the distance is half of the radius.

        By default, the distance is 0.15

        **Access functions:**

        qreal **explodeDistanceFactor** () const
        void
        **setExplodeDistanceFactor** (qreal **factor** )

        **See also** **exploded** .
        """
        ...

    def isExploded(self) -> bool:
        ...

    def isLabelVisible(self) -> bool:
        ...

    def label(self) -> str:
        """
        https://doc.qt.io/qt-6/qpieslice.html#label-prop

        **label : QString**

        This property holds the label of the slice.

        **Note:** The string can be HTML formatted.

        **Access functions:**

        QString **label** () const
        void **setLabel** (QString **label** )

        **Notifier signal:**

        void ****labelChanged** ** ()

        **See also** **labelVisible** , **labelBrush** , **labelFont** , and
        **labelArmLengthFactor** .
        """
        ...

    def labelArmLengthFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelArmLengthFactor-prop

        **labelArmLengthFactor : qreal**

        This property holds the length of the label arm. The factor is relative
        to the pie radius. For example:

        * 1.0 means that the length is the same as the radius.
          * 0.5 means
        that the length is half of the radius.

        By default, the arm length is 0.15

        **Access functions:**

        qreal **labelArmLengthFactor** () const
        void
        **setLabelArmLengthFactor** (qreal **factor** )

        **See also** **label** , **labelVisible** , **labelBrush** , and
        **labelFont** .
        """
        ...

    def labelBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelBrush-prop

        **labelBrush : QBrush**

        This property holds the brush used to draw the label and label arm of
        the slice.

        **Access functions:**

        QBrush **labelBrush** () const
        void **setLabelBrush** (const QBrush &
        **brush** )

        **Notifier signal:**

        void ****labelBrushChanged** ** ()

        **See also** **label** , **labelVisible** , **labelFont** , and
        **labelArmLengthFactor** .
        """
        ...

    def labelColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelColor-prop

        **labelColor : QColor**

        This property holds the color used to draw the slice label. This is a
        convenience property for modifying the slice label brush.

        **Access functions:**

        QColor **labelColor** ()
        void **setLabelColor** (QColor **color** )

        **Notifier signal:**

        void ****labelColorChanged** ** ()

        **See also** **labelBrush** .
        """
        ...

    def labelFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelFont-prop

        **labelFont : QFont**

        This property holds the font used for drawing the label text.

        **Access functions:**

        QFont **labelFont** () const
        void **setLabelFont** (const QFont &
        **font** )

        **Notifier signal:**

        void ****labelFontChanged** ** ()

        **See also** **label** , **labelVisible** , and **labelArmLengthFactor**
        .
        """
        ...

    def labelPosition(self) -> PySide6.QtCharts.QPieSlice.LabelPosition:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelPosition-prop

        **labelPosition : LabelPosition**

        This property holds the position of the slice label.

        **Access functions:**

        QPieSlice::LabelPosition **labelPosition** ()
        void
        **setLabelPosition** (QPieSlice::LabelPosition **position** )

        **See also** **label**  and **labelVisible** .
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qpieslice.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the slice border.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()
        """
        ...

    def percentage(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#percentage-prop

        **[read-only] percentage : const qreal**

        This property holds the percentage of the slice compared to the sum of
        all slices in the series. The actual value ranges from 0.0 to 1.0.
        Updated automatically once the slice is added to the series.

        **Access functions:**

        qreal **percentage** () const

        **Notifier signal:**

        void ****percentageChanged** ** ()

        **See also** **value**  and **QPieSeries::sum** .
        """
        ...

    def series(self) -> PySide6.QtCharts.QPieSeries:
        """
        https://doc.qt.io/qt-6/qpieslice.html#series

        **QPieSeries *QPieSlice::series() const**

        Returns the series that this slice belongs to.

        **See also** **QPieSeries::append** ().
        """
        ...

    def setBorderColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderColor-prop

        **borderColor : QColor**

        This property holds the color used to draw the slice border. This is a
        convenience property for modifying the slice pen.

        **Access functions:**

        QColor **borderColor** ()
        void **setBorderColor** (QColor **color** )

        **Notifier signal:**

        void ****borderColorChanged** ** ()

        **See also** **pen**  and **borderWidth** .
        """
        ...

    def setBorderWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderWidth-prop

        **borderWidth : int**

        This property holds the width of the slice border. This is a convenience
        property for modifying the slice pen.

        **Access functions:**

        int **borderWidth** ()
        void **setBorderWidth** (int **width** )

        **Notifier signal:**

        void ****borderWidthChanged** ** ()

        **See also** **pen**  and **borderColor** .
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the slice.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#color-prop

        **color : QColor**

        This property holds the fill (brush) color of the slice. This is a
        convenience property for modifying the slice brush.

        **Access functions:**

        QColor **color** ()
        void **setColor** (QColor **color** )

        **Notifier signal:**

        void ****colorChanged** ** ()

        **See also** **brush** .
        """
        ...

    def setExplodeDistanceFactor(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#explodeDistanceFactor-prop

        **explodeDistanceFactor : qreal**

        Determines how far away from the pie the slice is exploded.

        * 1.0 means that the distance is the same as the radius.
          * 0.5 means
        that the distance is half of the radius.

        By default, the distance is 0.15

        **Access functions:**

        qreal **explodeDistanceFactor** () const
        void
        **setExplodeDistanceFactor** (qreal **factor** )

        **See also** **exploded** .
        """
        ...

    def setExploded(self, exploded: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#exploded-prop

        **exploded : bool**

        This property holds whether the slice is separated from the pie.

        **Access functions:**

        bool **isExploded** () const
        void **setExploded** (bool **exploded** =
        true)

        **See also** **explodeDistanceFactor** .
        """
        ...

    def setLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#label-prop

        **label : QString**

        This property holds the label of the slice.

        **Note:** The string can be HTML formatted.

        **Access functions:**

        QString **label** () const
        void **setLabel** (QString **label** )

        **Notifier signal:**

        void ****labelChanged** ** ()

        **See also** **labelVisible** , **labelBrush** , **labelFont** , and
        **labelArmLengthFactor** .
        """
        ...

    def setLabelArmLengthFactor(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelArmLengthFactor-prop

        **labelArmLengthFactor : qreal**

        This property holds the length of the label arm. The factor is relative
        to the pie radius. For example:

        * 1.0 means that the length is the same as the radius.
          * 0.5 means
        that the length is half of the radius.

        By default, the arm length is 0.15

        **Access functions:**

        qreal **labelArmLengthFactor** () const
        void
        **setLabelArmLengthFactor** (qreal **factor** )

        **See also** **label** , **labelVisible** , **labelBrush** , and
        **labelFont** .
        """
        ...

    def setLabelBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelBrush-prop

        **labelBrush : QBrush**

        This property holds the brush used to draw the label and label arm of
        the slice.

        **Access functions:**

        QBrush **labelBrush** () const
        void **setLabelBrush** (const QBrush &
        **brush** )

        **Notifier signal:**

        void ****labelBrushChanged** ** ()

        **See also** **label** , **labelVisible** , **labelFont** , and
        **labelArmLengthFactor** .
        """
        ...

    def setLabelColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelColor-prop

        **labelColor : QColor**

        This property holds the color used to draw the slice label. This is a
        convenience property for modifying the slice label brush.

        **Access functions:**

        QColor **labelColor** ()
        void **setLabelColor** (QColor **color** )

        **Notifier signal:**

        void ****labelColorChanged** ** ()

        **See also** **labelBrush** .
        """
        ...

    def setLabelFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelFont-prop

        **labelFont : QFont**

        This property holds the font used for drawing the label text.

        **Access functions:**

        QFont **labelFont** () const
        void **setLabelFont** (const QFont &
        **font** )

        **Notifier signal:**

        void ****labelFontChanged** ** ()

        **See also** **label** , **labelVisible** , and **labelArmLengthFactor**
        .
        """
        ...

    def setLabelPosition(
        self, position: PySide6.QtCharts.QPieSlice.LabelPosition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelPosition-prop

        **labelPosition : LabelPosition**

        This property holds the position of the slice label.

        **Access functions:**

        QPieSlice::LabelPosition **labelPosition** ()
        void
        **setLabelPosition** (QPieSlice::LabelPosition **position** )

        **See also** **label**  and **labelVisible** .
        """
        ...

    def setLabelVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelVisible-prop

        **labelVisible : bool**

        This property holds the visibility of the slice label. By default, the
        label is not visible.

        **Access functions:**

        bool **isLabelVisible** () const
        void **setLabelVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****labelVisibleChanged** ** ()

        **See also** **label** , **labelBrush** , **labelFont** , and
        **labelArmLengthFactor** .
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the slice border.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()
        """
        ...

    def setValue(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieslice.html#value-prop

        **value : qreal**

        This property holds the value of the slice.

        **Note:** A negative value is converted to a positive value.

        **Access functions:**

        qreal **value** () const
        void **setValue** (qreal **value** )

        **Notifier signal:**

        void ****valueChanged** ** ()

        **See also** **percentage** () and **QPieSeries::sum** ().

        **Member Function Documentation**
        """
        ...

    def startAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#startAngle-prop

        **[read-only] startAngle : const qreal**

        This property holds the starting angle of this slice in the series it
        belongs to. A full pie is 360 degrees, where 0 degrees is at 12 a'clock.
        Updated automatically once the slice is added to the series.

        **Access functions:**

        qreal **startAngle** () const

        **Notifier signal:**

        void ****startAngleChanged** ** ()
        """
        ...

    def value(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieslice.html#value-prop

        **value : qreal**

        This property holds the value of the slice.

        **Note:** A negative value is converted to a positive value.

        **Access functions:**

        qreal **value** () const
        void **setValue** (qreal **value** )

        **Notifier signal:**

        void ****valueChanged** ** ()

        **See also** **percentage** () and **QPieSeries::sum** ().

        **Member Function Documentation**
        """
        ...

    @property
    def angleSpanChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#angleSpanChanged

        **[signal] void QPieSlice::angleSpanChanged()**

        This signal is emitted when the angle span of the slice changes.

        **Note:** Notifier signal for property **angleSpan** .

        **See also** **angleSpan** .
        """
        ...

    @property
    def borderColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderColorChanged

        **[signal] void QPieSlice::borderColorChanged()**

        This signal is emitted when the slice border color changes.

        **Note:** Notifier signal for property **borderColor** .

        **See also** **pen**  and **borderColor** .
        """
        ...

    @property
    def borderWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#borderWidthChanged

        **[signal] void QPieSlice::borderWidthChanged()**

        This signal is emitted when the slice border width changes.

        **Note:** Notifier signal for property **borderWidth** .

        **See also** **pen**  and **borderWidth** .
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#brushChanged

        **[signal] void QPieSlice::brushChanged()**

        This signal is emitted when the brush used to fill the slice changes.

        **Note:** Notifier signal for property **brush** .

        **See also** **brush** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#clicked

        **[signal] void QPieSlice::clicked()**

        This signal is emitted when the slice is clicked.

        **See also** **QPieSeries::clicked** ().
        """
        ...

    @property
    def colorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#colorChanged

        **[signal] void QPieSlice::colorChanged()**

        This signal is emitted when the slice color changes.

        **Note:** Notifier signal for property **color** .

        **See also** **brush** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#doubleClicked

        **[signal] void QPieSlice::doubleClicked()**

        This signal is emitted when user double-clicks the slice.

        **See also** **QPieSeries::doubleClicked** ().
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#hovered

        **[signal] void QPieSlice::hovered(bool state )**

        This signal is emitted when a mouse is hovered over the slice. When the
        mouse moves over the slice, **state** turns `true`, and when the mouse
        moves away again, it turns `false`.

        **See also** **QPieSeries::hovered** ().
        """
        ...

    @property
    def labelBrushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelBrushChanged

        **[signal] void QPieSlice::labelBrushChanged()**

        This signal is emitted when the label brush of the slice changes.

        **Note:** Notifier signal for property **labelBrush** .

        **See also** **labelBrush** .
        """
        ...

    @property
    def labelChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelChanged

        **[signal] void QPieSlice::labelChanged()**

        This signal is emitted when the slice label changes.

        **Note:** Notifier signal for property **label** .

        **See also** **label** .
        """
        ...

    @property
    def labelColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelColorChanged

        **[signal] void QPieSlice::labelColorChanged()**

        This signal is emitted when the slice label color changes.

        **Note:** Notifier signal for property **labelColor** .

        **See also** **labelColor** .
        """
        ...

    @property
    def labelFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelFontChanged

        **[signal] void QPieSlice::labelFontChanged()**

        This signal is emitted when the label font of the slice changes.

        **Note:** Notifier signal for property **labelFont** .

        **See also** **labelFont** .
        """
        ...

    @property
    def labelVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#labelVisibleChanged

        **[signal] void QPieSlice::labelVisibleChanged()**

        This signal is emitted when the visibility of the slice label changes.

        **Note:** Notifier signal for property **labelVisible** .

        **See also** **labelVisible** .
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#penChanged

        **[signal] void QPieSlice::penChanged()**

        This signal is emitted when the pen used to draw the slice border
        changes.

        **Note:** Notifier signal for property **pen** .

        **See also** **pen** .
        """
        ...

    @property
    def percentageChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#percentageChanged

        **[signal] void QPieSlice::percentageChanged()**

        This signal is emitted when the percentage of the slice changes.

        **Note:** Notifier signal for property **percentage** .

        **See also** **percentage** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#pressed

        **[signal] void QPieSlice::pressed()**

        This signal is emitted when the user clicks the slice and holds down the
        mouse button.

        **See also** **QPieSeries::pressed** ().
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#released

        **[signal] void QPieSlice::released()**

        This signal is emitted when the user releases the mouse press on the
        slice.

        **See also** **QPieSeries::released** ().
        """
        ...

    @property
    def startAngleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#startAngleChanged

        **[signal] void QPieSlice::startAngleChanged()**

        This signal is emitted when the starting angle of the slice changes.

        **Note:** Notifier signal for property **startAngle** .

        **See also** **startAngle** .
        """
        ...

    @property
    def valueChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieslice.html#valueChanged

        **[signal] void QPieSlice::valueChanged()**

        This signal is emitted when the slice value changes.

        **Note:** Notifier signal for property **value** .

        **See also** **value** .
        """
        ...
