"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QHXYModelMapper(PySide6.QtCharts.QXYModelMapper):
    """
    https://doc.qt.io/qt-6/qhxymodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A horizontal
    model mapper is used to create a connection between a line, spline, or
    scatter series and the data model that has **X** and **Y** rows for the
    coordinates and holds the data points for the **XYSeries**  as columns. A
    **TableModel** is a natural choice for the model.

    Both model and series properties can be used to manipulate the data. The
    model mapper keeps the series and the data model in sync.

    **See also** **QVXYModelMapper** , **QXYSeries** , and **Model Data
    Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#QHXYModelMapper

        **QHXYModelMapper::QHXYModelMapper(QObject * parent = nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for series.

        The minimum and default value is -1 (the number is limited by the number
        of columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int
        **columnCount** )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def firstColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the data for
        the first point of the series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QXYSeries:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#series-prop

        **series : QXYSeries***

        This property holds the series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QXYSeries * **series** () const
        void **setSeries** (QXYSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setColumnCount(self, columnCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for series.

        The minimum and default value is -1 (the number is limited by the number
        of columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int
        **columnCount** )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def setFirstColumn(self, firstColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the data for
        the first point of the series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QXYSeries) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#series-prop

        **series : QXYSeries***

        This property holds the series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QXYSeries * **series** () const
        void **setSeries** (QXYSeries *
        **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()
        """
        ...

    def setXRow(self, xRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#xRow-prop

        **xRow : int**

        This property holds the row of the model that contains the x-coordinates
        of the data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **xRow** () const
        void **setXRow** (int **xRow** )

        **Notifier signal:**

        void ****xRowChanged** ** ()
        """
        ...

    def setYRow(self, yRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#yRow-prop

        **yRow : int**

        This property holds the row of the model that contains the y-coordinates
        of the data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **yRow** () const
        void **setYRow** (int **yRow** )

        **Notifier signal:**

        void ****yRowChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def xRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#xRow-prop

        **xRow : int**

        This property holds the row of the model that contains the x-coordinates
        of the data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **xRow** () const
        void **setXRow** (int **xRow** )

        **Notifier signal:**

        void ****xRowChanged** ** ()
        """
        ...

    def yRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#yRow-prop

        **yRow : int**

        This property holds the row of the model that contains the y-coordinates
        of the data points.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **yRow** () const
        void **setYRow** (int **yRow** )

        **Notifier signal:**

        void ****yRowChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def columnCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#columnCountChanged

        **[signal] void QHXYModelMapper::columnCountChanged()**

        This signal is emitted when the number of columns changes.

        **Note:** Notifier signal for property **columnCount** .
        """
        ...

    @property
    def firstColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#firstColumnChanged

        **[signal] void QHXYModelMapper::firstColumnChanged()**

        This signal is emitted when the first column changes.

        **Note:** Notifier signal for property **firstColumn** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#modelReplaced

        **[signal] void QHXYModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#seriesReplaced

        **[signal] void QHXYModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...

    @property
    def xRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#xRowChanged

        **[signal] void QHXYModelMapper::xRowChanged()**

        This signal is emitted when the row that contains the x-coordinates of
        data points changes.

        **Note:** Notifier signal for property **xRow** .
        """
        ...

    @property
    def yRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhxymodelmapper.html#yRowChanged

        **[signal] void QHXYModelMapper::yRowChanged()**

        This signal is emitted when the row that contains the y-coordinates of
        data points changes.

        **Note:** Notifier signal for property **yRow** .
        """
        ...
