"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QHCandlestickModelMapper(PySide6.QtCharts.QCandlestickModelMapper):
    """
    https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A horizontal
    model mapper is used to create a connection between a data model and
    **QCandlestickSeries** , so that each row in the data model defines a
    candlestick item and each column maps to the open, high, low, close, and
    timestamp values of the candlestick item.

    Both model and candlestick series properties can be used to manipulate the
    data. The model mapper keeps the candlestick series and the data model in
    sync.

    The model mapper ensures that all the candlestick items in the candlestick
    series have equal sizes. Therefore, adding or removing a value from a
    candlestick item causes the same change to be made in all the candlestick
    items in the candlestick series.

    **See also** **QCandlestickSeries** , **QCandlestickSet** , and
    **QVCandlestickModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#QHCandlestickModelM
        apper

        **QHCandlestickModelMapper::QHCandlestickModelMapper(QObject * parent =
        nullptr)**

        Constructs a horizontal model mapper object which is a child of
        **parent**.
        """
        ...

    def closeColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#closeColumn-prop

        **closeColumn : int**

        This property holds the column of the model that contains the close
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **closeColumn** () const
        void **setCloseColumn** (int
        **closeColumn** )

        **Notifier signal:**

        void ****closeColumnChanged** ** ()
        """
        ...

    def firstSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#firstSetRow-prop

        **firstSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstSetRow** () const
        void **setFirstSetRow** (int
        **firstSetRow** )

        **Notifier signal:**

        void ****firstSetRowChanged** ** ()
        """
        ...

    def highColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#highColumn-prop

        **highColumn : int**

        This property holds the column of the model that contains the high
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **highColumn** () const
        void **setHighColumn** (int **highColumn**
        )

        **Notifier signal:**

        void ****highColumnChanged** ** ()
        """
        ...

    def lastSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lastSetRow-prop

        **lastSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastSetRow** () const
        void **setLastSetRow** (int **lastSetRow**
        )

        **Notifier signal:**

        void ****lastSetRowChanged** ** ()
        """
        ...

    def lowColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lowColumn-prop

        **lowColumn : int**

        This property holds the column of the model that contains the low values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lowColumn** () const
        void **setLowColumn** (int **lowColumn** )

        **Notifier signal:**

        void ****lowColumnChanged** ** ()
        """
        ...

    def openColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#openColumn-prop

        **openColumn : int**

        This property holds the column of the model that contains the open
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **openColumn** () const
        void **setOpenColumn** (int **openColumn**
        )

        **Notifier signal:**

        void ****openColumnChanged** ** ()
        """
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#orientation

        **[override virtual] Qt::Orientation
        QHCandlestickModelMapper::orientation() const**

        Reimplements: **QCandlestickModelMapper::orientation() const** .

        Returns **Qt::Horizontal** . This means that values of the item are read
        from rows.
        """
        ...

    def setCloseColumn(self, closeColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#closeColumn-prop

        **closeColumn : int**

        This property holds the column of the model that contains the close
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **closeColumn** () const
        void **setCloseColumn** (int
        **closeColumn** )

        **Notifier signal:**

        void ****closeColumnChanged** ** ()
        """
        ...

    def setFirstSetRow(self, firstSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#firstSetRow-prop

        **firstSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstSetRow** () const
        void **setFirstSetRow** (int
        **firstSetRow** )

        **Notifier signal:**

        void ****firstSetRowChanged** ** ()
        """
        ...

    def setHighColumn(self, highColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#highColumn-prop

        **highColumn : int**

        This property holds the column of the model that contains the high
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **highColumn** () const
        void **setHighColumn** (int **highColumn**
        )

        **Notifier signal:**

        void ****highColumnChanged** ** ()
        """
        ...

    def setLastSetRow(self, lastSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lastSetRow-prop

        **lastSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastSetRow** () const
        void **setLastSetRow** (int **lastSetRow**
        )

        **Notifier signal:**

        void ****lastSetRowChanged** ** ()
        """
        ...

    def setLowColumn(self, lowColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lowColumn-prop

        **lowColumn : int**

        This property holds the column of the model that contains the low values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lowColumn** () const
        void **setLowColumn** (int **lowColumn** )

        **Notifier signal:**

        void ****lowColumnChanged** ** ()
        """
        ...

    def setOpenColumn(self, openColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#openColumn-prop

        **openColumn : int**

        This property holds the column of the model that contains the open
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **openColumn** () const
        void **setOpenColumn** (int **openColumn**
        )

        **Notifier signal:**

        void ****openColumnChanged** ** ()
        """
        ...

    def setTimestampColumn(self, timestampColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#timestampColumn-
        prop

        **timestampColumn : int**

        This property holds the column of the model that contains the timestamp
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **timestampColumn** () const
        void **setTimestampColumn** (int
        **timestampColumn** )

        **Notifier signal:**

        void ****timestampColumnChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def timestampColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#timestampColumn-
        prop

        **timestampColumn : int**

        This property holds the column of the model that contains the timestamp
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **timestampColumn** () const
        void **setTimestampColumn** (int
        **timestampColumn** )

        **Notifier signal:**

        void ****timestampColumnChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def closeColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#closeColumnChanged

        **[signal] void QHCandlestickModelMapper::closeColumnChanged()**

        Emitted when the column of the model that contains close values is
        changed.

        **Note:** Notifier signal for property **closeColumn** .

        **See also** **closeColumn** .
        """
        ...

    @property
    def firstSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#firstSetRowChanged

        **[signal] void QHCandlestickModelMapper::firstSetRowChanged()**

        Emitted when the row of the model that contains the data of the first
        item is changed.

        **Note:** Notifier signal for property **firstSetRow** .

        **See also** **firstSetRow** .
        """
        ...

    @property
    def highColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#highColumnChanged

        **[signal] void QHCandlestickModelMapper::highColumnChanged()**

        Emitted when the column of the model that contains high values is
        changed.

        **Note:** Notifier signal for property **highColumn** .

        **See also** **highColumn** .
        """
        ...

    @property
    def lastSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lastSetRowChanged

        **[signal] void QHCandlestickModelMapper::lastSetRowChanged()**

        Emitted when the row of the model that contains the data of the last
        item is changed.

        **Note:** Notifier signal for property **lastSetRow** .

        **See also** **lastSetRow** .
        """
        ...

    @property
    def lowColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#lowColumnChanged

        **[signal] void QHCandlestickModelMapper::lowColumnChanged()**

        Emitted when the column of the model that contains low values is
        changed.

        **Note:** Notifier signal for property **lowColumn** .

        **See also** **lowColumn** .
        """
        ...

    @property
    def openColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#openColumnChanged

        **[signal] void QHCandlestickModelMapper::openColumnChanged()**

        Emitted when the column of the model that contains open values is
        changed.

        **Note:** Notifier signal for property **openColumn** .

        **See also** **openColumn** .
        """
        ...

    @property
    def timestampColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhcandlestickmodelmapper.html#timestampColumnChan
        ged

        **[signal] void QHCandlestickModelMapper::timestampColumnChanged()**

        Emitted when the column of the model that contains timestamp values is
        changed

        **Note:** Notifier signal for property **timestampColumn** .

        **See also** **timestampColumn** .
        """
        ...
