"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QHBoxPlotModelMapper(PySide6.QtCharts.QBoxPlotModelMapper):
    """
    https://doc.qt.io/qt-6/qhboxplotmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A horizontal
    model mapper is used to create a connection between a data model and
    **QBoxPlotSeries**  object, so that each row in the data model defines a
    box-and-whiskers item and each column maps to the range and three median
    values of the box-and-whiskers item.

    Both model and series properties can be used to manipulate the data. The
    model mapper keeps the series and the data model in sync.

    The model mapper ensures that all the box-and-whiskers items in the box plot
    series have equal sizes. Therefore, adding or removing a value from a box-
    and-whiskers item causes the same change to be made in all the box-and-
    whiskers items in the box plot series.

    **See also** **QVBoxPlotModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#QHBoxPlotModelMapper

        **QHBoxPlotModelMapper::QHBoxPlotModelMapper(QObject * parent =
        nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for the box plot series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int **rowCount**
        )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def firstBoxSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstBoxSetRow-prop

        **firstBoxSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBoxSetRow** () const
        void **setFirstBoxSetRow** (int
        **firstBoxSetRow** )

        **Notifier signal:**

        void ****firstBoxSetRowChanged** ** ()
        """
        ...

    def firstColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the first
        values of the box-and-whiskers items in the box plot series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def lastBoxSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#lastBoxSetRow-prop

        **lastBoxSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBoxSetRow** () const
        void **setLastBoxSetRow** (int
        **lastBoxSetRow** )

        **Notifier signal:**

        void ****lastBoxSetRowChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QBoxPlotSeries:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#series-prop

        **series : QBoxPlotSeries***

        This property holds the box plot series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QBoxPlotSeries * **series** () const
        void **setSeries**
        (QBoxPlotSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setColumnCount(self, rowCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for the box plot series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int **rowCount**
        )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def setFirstBoxSetRow(self, firstBoxSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstBoxSetRow-prop

        **firstBoxSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBoxSetRow** () const
        void **setFirstBoxSetRow** (int
        **firstBoxSetRow** )

        **Notifier signal:**

        void ****firstBoxSetRowChanged** ** ()
        """
        ...

    def setFirstColumn(self, firstColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the first
        values of the box-and-whiskers items in the box plot series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def setLastBoxSetRow(self, lastBoxSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#lastBoxSetRow-prop

        **lastBoxSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last box-and-whiskers item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBoxSetRow** () const
        void **setLastBoxSetRow** (int
        **lastBoxSetRow** )

        **Notifier signal:**

        void ****lastBoxSetRowChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        This property holds the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QBoxPlotSeries) -> None:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#series-prop

        **series : QBoxPlotSeries***

        This property holds the box plot series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QBoxPlotSeries * **series** () const
        void **setSeries**
        (QBoxPlotSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def columnCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#columnCountChanged

        **[signal] void QHBoxPlotModelMapper::columnCountChanged()**

        This signal is emitted when the number of columns changes.

        **Note:** Notifier signal for property **columnCount** .
        """
        ...

    @property
    def firstBoxSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstBoxSetRowChanged

        **[signal] void QHBoxPlotModelMapper::firstBoxSetRowChanged()**

        This signal is emitted when the first box-and-whiskers item row changes.

        **Note:** Notifier signal for property **firstBoxSetRow** .
        """
        ...

    @property
    def firstColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#firstColumnChanged

        **[signal] void QHBoxPlotModelMapper::firstColumnChanged()**

        This signal is emitted when the first column changes.

        **Note:** Notifier signal for property **firstColumn** .
        """
        ...

    @property
    def lastBoxSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#lastBoxSetRowChanged

        **[signal] void QHBoxPlotModelMapper::lastBoxSetRowChanged()**

        This signal is emitted when the last box-and-whiskers item row changes.

        **Note:** Notifier signal for property **lastBoxSetRow** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#modelReplaced

        **[signal] void QHBoxPlotModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhboxplotmodelmapper.html#seriesReplaced

        **[signal] void QHBoxPlotModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...
