"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QChartView(PySide6.QtWidgets.QGraphicsView):
    """
    https://doc.qt.io/qt-6/qchartview.html

    **Detailed Description**

    A chart view does not require a **QGraphicsScene**  object to work. To
    display a chart in an existing **QGraphicsScene** , the **QChart**  or
    **QPolarChart**  class should be used instead.

    **See also** **QChart**  and **QPolarChart** .
    """

    NoRubberBand: QChartView.RubberBand = ...
    VerticalRubberBand: QChartView.RubberBand = ...
    HorizontalRubberBand: QChartView.RubberBand = ...
    RectangleRubberBand: QChartView.RubberBand = ...
    ClickThroughRubberBand: QChartView.RubberBand = ...

    class RubberBand(Enum):
        NoRubberBand: QChartView.RubberBand = ...
        VerticalRubberBand: QChartView.RubberBand = ...
        HorizontalRubberBand: QChartView.RubberBand = ...
        RectangleRubberBand: QChartView.RubberBand = ...
        ClickThroughRubberBand: QChartView.RubberBand = ...

    class RubberBands(object):
        ...

    @overload
    def __init__(
        self,
        chart: PySide6.QtCharts.QChart,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#QChartView

        **QChartView::QChartView(QWidget * parent = nullptr)**

        Constructs a chart view object with the parent **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#QChartView-1

        **QChartView::QChartView(QChart * chart , QWidget * parent = nullptr)**

        Constructs a chart view object with the parent **parent** to display the
        chart **chart**. The ownership of the chart is passed to the chart view.
        """
        ...

    def chart(self) -> PySide6.QtCharts.QChart:
        """
        https://doc.qt.io/qt-6/qchartview.html#chart

        **QChart *QChartView::chart() const**

        Returns the pointer to the associated chart.

        **See also** **setChart** ().
        """
        ...

    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#mouseMoveEvent

        **[override virtual protected] void
        QChartView::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QGraphicsView::mouseMoveEvent** (QMouseEvent *event).

        If the rubber band rectangle is displayed in the press event specified
        by **event** , the event data is used to update the rubber band
        geometry. Otherwise, the default **QGraphicsView::mouseMoveEvent** ()
        implementation is called.
        """
        ...

    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#mousePressEvent

        **[override virtual protected] void
        QChartView::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QGraphicsView::mousePressEvent** (QMouseEvent *event).

        If the left mouse button is pressed and the rubber band is enabled, the
        event **event** is accepted and the rubber band is displayed on the
        screen. This enables the user to select the zoom area.

        If some other mouse button is pressed or the rubber band is disabled,
        the event is passed to **QGraphicsView::mousePressEvent** ().
        """
        ...

    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#mouseReleaseEvent

        **[override virtual protected] void
        QChartView::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QGraphicsView::mouseReleaseEvent** (QMouseEvent *event).

        If the left mouse button is released and the rubber band is enabled, the
        event **event** is accepted and the view is zoomed into the rectangle
        specified by the rubber band. If releasing the right mouse button
        triggered the event, the view is zoomed out.
        """
        ...

    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#resizeEvent

        **[override virtual protected] void QChartView::resizeEvent(QResizeEvent
        * event )**

        Reimplements: **QGraphicsView::resizeEvent** (QResizeEvent *event).

        Resizes and updates the chart area using the data specified by
        **event**.
        """
        ...

    def rubberBand(self) -> PySide6.QtCharts.QChartView.RubberBands:
        """
        https://doc.qt.io/qt-6/qchartview.html#rubberBand

        **QChartView::RubberBands QChartView::rubberBand() const**

        Returns the rubber band flags that are currently being used by the chart
        view.

        **See also** **setRubberBand** ().
        """
        ...

    def setChart(self, chart: PySide6.QtCharts.QChart) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#setChart

        **void QChartView::setChart(QChart * chart )**

        Sets the current chart to **chart**. The ownership of the new chart is
        passed to the chart view and the ownership of the previous chart is
        released.

        To avoid memory leaks, the previous chart must be deleted.

        **See also** **chart** ().
        """
        ...

    def setRubberBand(
        self, rubberBands: PySide6.QtCharts.QChartView.RubberBands
    ) -> None:
        """
        https://doc.qt.io/qt-6/qchartview.html#setRubberBand

        **void QChartView::setRubberBand(const QChartView::RubberBands &
        rubberBand )**

        Sets the rubber band flags to **rubberBand**. The selected flags
        determine the way zooming is performed.

        **Note:** Rubber band zooming is not supported for polar charts.

        **See also** **rubberBand** ().
        """
        ...
