"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QCategoryAxis(PySide6.QtCharts.QValueAxis):
    """
    https://doc.qt.io/qt-6/qcategoryaxis.html

    **Detailed Description**

    This class can be used to explain the underlying data by adding labeled
    categories. Unlike **QBarCategoryAxis** , QCategoryAxis allows the widths of
    the category ranges to be specified freely.

    Example code on how to use QCategoryAxis:

    ![](images/api_category_axis.png)

    **QChartView**  *chartView = new **QChartView** ;
        **QLineSeries**
    *series = new **QLineSeries** ;
        // ...
    chartView->chart()->addSeries(series);

        **QCategoryAxis**  *axisY =
    new **QCategoryAxis** ;
        axisY->setMin(0);
        axisY->setMax(52);
    axisY->setStartValue(15);
        axisY->append("First", 20);
    axisY->append("Second", 37);
        axisY->append("Third", 52);
    chartView->chart()->setAxisY(axisY, series);
    """

    AxisLabelsPositionCenter: QCategoryAxis.AxisLabelsPosition = ...
    AxisLabelsPositionOnValue: QCategoryAxis.AxisLabelsPosition = ...

    class AxisLabelsPosition(Enum):
        AxisLabelsPositionCenter: QCategoryAxis.AxisLabelsPosition = ...
        AxisLabelsPositionOnValue: QCategoryAxis.AxisLabelsPosition = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#QCategoryAxis

        **QCategoryAxis::QCategoryAxis(QObject * parent = nullptr)**

        Constructs an axis object that is a child of **parent**.
        """
        ...

    def append(self, label: str, categoryEndValue: float) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#append

        **void QCategoryAxis::append(const QString & categoryLabel , qreal
        categoryEndValue )**

        Appends a new category to the axis with the label **categoryLabel**. A
        category label has to be unique. **categoryEndValue** specifies the high
        end limit of the category. It has to be greater than the high end limit
        of the previous category. Otherwise the method returns without adding a
        new category.
        """
        ...

    def categoriesLabels(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#categoriesLabels

        **QStringList QCategoryAxis::categoriesLabels()**

        Returns the list of the categories' labels.

        **Note:** Getter function for property categoriesLabels.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#count

        **int QCategoryAxis::count() const**

        Returns the number of categories.

        **Note:** Getter function for property count.
        """
        ...

    def endValue(self, categoryLabel: str) -> float:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#endValue

        **qreal QCategoryAxis::endValue(const QString & categoryLabel ) const**

        Returns the high end limit of the category specified by
        **categoryLabel**.
        """
        ...

    def labelsPosition(self) -> PySide6.QtCharts.QCategoryAxis.AxisLabelsPosition:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#labelsPosition-prop

        **labelsPosition : AxisLabelsPosition**

        This property holds the position of the category labels. The labels in
        the beginning and in the end of the axes may overlap other axes' labels
        when positioned on value.

        **Access functions:**

        QCategoryAxis::AxisLabelsPosition **labelsPosition** () const
        void
        **setLabelsPosition** (QCategoryAxis::AxisLabelsPosition **position** )

        **Notifier signal:**

        void **labelsPositionChanged** (QCategoryAxis::AxisLabelsPosition
        **position** )
        """
        ...

    def remove(self, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#remove

        **void QCategoryAxis::remove(const QString & categoryLabel )**

        Removes a category specified by the label **categoryLabel** from the
        axis.
        """
        ...

    def replaceLabel(self, oldLabel: str, newLabel: str) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#replaceLabel

        **void QCategoryAxis::replaceLabel(const QString & oldLabel , const
        QString & newLabel )**

        Replaces an existing category label specified by **oldLabel** with
        **newLabel**. If the old label does not exist, the method returns
        without making any changes.
        """
        ...

    def setLabelsPosition(
        self, position: PySide6.QtCharts.QCategoryAxis.AxisLabelsPosition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#labelsPosition-prop

        **labelsPosition : AxisLabelsPosition**

        This property holds the position of the category labels. The labels in
        the beginning and in the end of the axes may overlap other axes' labels
        when positioned on value.

        **Access functions:**

        QCategoryAxis::AxisLabelsPosition **labelsPosition** () const
        void
        **setLabelsPosition** (QCategoryAxis::AxisLabelsPosition **position** )

        **Notifier signal:**

        void **labelsPositionChanged** (QCategoryAxis::AxisLabelsPosition
        **position** )
        """
        ...

    def setStartValue(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#setStartValue

        **void QCategoryAxis::setStartValue(qreal min )**

        Sets **min** to be the low end limit of the first category on the axis.
        If categories have already been added to the axis, the passed value must
        be less than the high end value of the already defined first category
        range. Otherwise nothing is done.

        **Note:** Setter function for property **startValue** .

        **See also** **startValue** ().
        """
        ...

    def startValue(self, categoryLabel: str = ...) -> float:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#startValue

        **qreal QCategoryAxis::startValue(const QString & categoryLabel =
        QString()) const**

        Returns the low end limit of the category specified by
        **categoryLabel**.

        **Note:** Getter function for property startValue.

        **See also** **setStartValue** ().
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#type

        **[override virtual] QAbstractAxis::AxisType QCategoryAxis::type()
        const**

        Reimplements: **QValueAxis::type() const** .

        Returns the type of the axis.
        """
        ...

    @property
    def categoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcategoryaxis.html#categoriesChanged

        **[signal] void QCategoryAxis::categoriesChanged()**

        This signal is emitted when the categories of the axis change.
        """
        ...

    @property
    def labelsPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
