"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QBoxPlotSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qboxplotseries.html

    **Detailed Description**

    A box plot series acts as a container for box-and-whiskers items. Items from
    multiple series are grouped into categories according to their index value.

    The **QBarCategoryAxis**  class is used to add the categories to the chart's
    axis. Category labels have to be unique. If the same category label is
    defined for several box-and-whiskers items, only the first one is drawn.

    See the **box-and-whiskers chart example**  to learn how to create a box-
    and-whiskers chart.

    ![](images/examples_boxplotchart.png)

    **See also** **QBoxSet**  and **QBarCategoryAxis** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#QBoxPlotSeries

        **QBoxPlotSeries::QBoxPlotSeries(QObject * parent = nullptr)**

        Constructs an empty box plot series that is a **QObject**  and a child
        of **parent**.
        """
        ...

    @overload
    def append(self, box: PySide6.QtCharts.QBoxSet) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#append

        **bool QBoxPlotSeries::append(QBoxSet * set )**

        Adds a single box-and-whiskers item specified by **set** to the series
        and takes ownership of it. If the item is null or it already belongs to
        the series, it will not be appended. Returns `true` if appending
        succeeded.
        """
        ...

    @overload
    def append(self, boxes: Sequence[PySide6.QtCharts.QBoxSet]) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#append-1

        **bool QBoxPlotSeries::append(const QList<QBoxSet *> & sets )**

        Adds a list of box-and-whiskers items specified by **sets** to the
        series and takes ownership of them. If the list is null or the items
        already belong to the series, it will not be appended. Returns `true` if
        appending succeeded.
        """
        ...

    def boxOutlineVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxOutlineVisible-prop

        **boxOutlineVisible : bool**

        This property holds the visibility of the box outline.

        **Access functions:**

        bool **boxOutlineVisible** ()
        void **setBoxOutlineVisible** (bool
        **visible** )

        **Notifier signal:**

        void ****boxOutlineVisibilityChanged** ** ()
        """
        ...

    def boxSets(self) -> List[PySide6.QtCharts.QBoxSet]:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxSets

        **QList<QBoxSet *> QBoxPlotSeries::boxSets() const**

        Returns a list of box-and-whiskers items in a box plot series. Keeps the
        ownership of the items.
        """
        ...

    def boxWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxWidth-prop

        **boxWidth : qreal**

        This property holds the width of the box-and-whiskers item. The value
        indicates the relative width of the item within its category. The value
        can be between 0.0 and 1.0. Negative values are replaced with 0.0 and
        values greater than 1.0 are replaced with 1.0.

        **Access functions:**

        qreal **boxWidth** ()
        void **setBoxWidth** (qreal **width** )

        **Notifier signal:**

        void ****boxWidthChanged** ** ()
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the boxes of the box-and-
        whiskers items.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#clear

        **void QBoxPlotSeries::clear()**

        Removes all box-and-whiskers items from the series and permanently
        deletes them.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#count

        **int QBoxPlotSeries::count() const**

        Returns the number of box-and-whiskers items in a box plot series.

        **Note:** Getter function for property count.
        """
        ...

    def insert(self, index: int, box: PySide6.QtCharts.QBoxSet) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#insert

        **bool QBoxPlotSeries::insert(int index , QBoxSet * set )**

        Inserts a box-and-whiskers item specified by **set** to a series at the
        position specified by **index** and takes ownership of the item. If the
        item is null or already belongs to the series, it will not be appended.
        Returns `true` if inserting succeeds.
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the box-and-
        whiskers items.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def remove(self, box: PySide6.QtCharts.QBoxSet) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#remove

        **bool QBoxPlotSeries::remove(QBoxSet * set )**

        Removes the box-and-whiskers item specified by **set** from the series
        and permanently deletes it if the removal succeeds. Returns `true` if
        the item was removed.
        """
        ...

    def setBoxOutlineVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxOutlineVisible-prop

        **boxOutlineVisible : bool**

        This property holds the visibility of the box outline.

        **Access functions:**

        bool **boxOutlineVisible** ()
        void **setBoxOutlineVisible** (bool
        **visible** )

        **Notifier signal:**

        void ****boxOutlineVisibilityChanged** ** ()
        """
        ...

    def setBoxWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxWidth-prop

        **boxWidth : qreal**

        This property holds the width of the box-and-whiskers item. The value
        indicates the relative width of the item within its category. The value
        can be between 0.0 and 1.0. Negative values are replaced with 0.0 and
        values greater than 1.0 are replaced with 1.0.

        **Access functions:**

        qreal **boxWidth** ()
        void **setBoxWidth** (qreal **width** )

        **Notifier signal:**

        void ****boxWidthChanged** ** ()
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the boxes of the box-and-
        whiskers items.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the box-and-
        whiskers items.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def take(self, box: PySide6.QtCharts.QBoxSet) -> bool:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#take

        **bool QBoxPlotSeries::take(QBoxSet * set )**

        Takes the box-and-whiskers item specified by **set** from the series.
        Does not delete the item.

        **Note:** The series remains the item's parent object. You must set the
        parent object to take full ownership.

        Returns `true` if the take operation succeeds.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#type

        **[override virtual] QAbstractSeries::SeriesType QBoxPlotSeries::type()
        const**

        Reimplements an access function for property: **QAbstractSeries::type**
        .

        Returns the type of the series.

        **See also** **QAbstractSeries**  and **SeriesType** .
        """
        ...

    @property
    def boxOutlineVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxOutlineVisibilityChanged

        **[signal] void QBoxPlotSeries::boxOutlineVisibilityChanged()**

        This signal is emitted when the box outline visibility changes.

        **Note:** Notifier signal for property **boxOutlineVisible** .
        """
        ...

    @property
    def boxWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxWidthChanged

        **[signal] void QBoxPlotSeries::boxWidthChanged()**

        This signal is emitted when the width of the box-and-whiskers item
        changes.

        **Note:** Notifier signal for property **boxWidth** .
        """
        ...

    @property
    def boxsetsAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxsetsAdded

        **[signal] void QBoxPlotSeries::boxsetsAdded(const QList<QBoxSet *> &
        sets )**

        This signal is emitted when the list of box-and-whiskers items specified
        by **sets** is added to the series.
        """
        ...

    @property
    def boxsetsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#boxsetsRemoved

        **[signal] void QBoxPlotSeries::boxsetsRemoved(const QList<QBoxSet *> &
        sets )**

        This signal is emitted when the list of box-and-whiskers items specified
        by **sets** is removed from the series.
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#brushChanged

        **[signal] void QBoxPlotSeries::brushChanged()**

        This signal is emitted when the brush used to fill the boxes of the box-
        and-whiskers items changes.

        **Note:** Notifier signal for property **brush** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#clicked

        **[signal] void QBoxPlotSeries::clicked(QBoxSet * boxset )**

        This signal is emitted when the user clicks the box-and-whiskers item
        specified by **boxset** in the chart.
        """
        ...

    @property
    def countChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#countChanged

        **[signal] void QBoxPlotSeries::countChanged()**

        This signal is emitted when the number of box-and-whiskers items in the
        series changes.

        **Note:** Notifier signal for property **count** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#doubleClicked

        **[signal] void QBoxPlotSeries::doubleClicked(QBoxSet * boxset )**

        This signal is emitted when the user double-clicks the box-and-whiskers
        item specified by **boxset** in the chart.
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#hovered

        **[signal] void QBoxPlotSeries::hovered(bool status , QBoxSet * boxset
        )**

        This signal is emitted when a mouse is hovered over the box-and-whiskers
        item specified by **boxset** in the chart. When the mouse moves over the
        item, **status** turns `true`, and when the mouse moves away again, it
        turns `false`.
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#penChanged

        **[signal] void QBoxPlotSeries::penChanged()**

        This signal is emitted when the pen used to draw the lines of the box-
        and-whiskers items changes.

        **Note:** Notifier signal for property **pen** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#pressed

        **[signal] void QBoxPlotSeries::pressed(QBoxSet * boxset )**

        This signal is emitted when the user clicks the box-and-whiskers item
        specified by **boxset** in the chart and holds down the mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxplotseries.html#released

        **[signal] void QBoxPlotSeries::released(QBoxSet * boxset )**

        This signal is emitted when the user releases the mouse press on the
        box-and-whiskers item specified by **boxset** in the chart.
        """
        ...
