"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QBarSet(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qbarset.html

    **Detailed Description**

    A bar set contains one data value for each category. The first value of a
    set is assumed to belong to the first category, the second one to the second
    category, and so on. If the set has fewer values than there are categories,
    the missing values are assumed to be located at the end of the set. For
    missing values in the middle of a set, the numerical value of zero is used.
    Labels for zero value sets are not shown.

    **See also** **QAbstractBarSeries** , **QBarSeries** , **QStackedBarSeries**
    , **QPercentBarSeries** , **QHorizontalBarSeries** ,
    **QHorizontalStackedBarSeries** , and **QHorizontalPercentBarSeries** .
    """

    def __init__(
        self, label: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#QBarSet

        **QBarSet::QBarSet(const QString label , QObject * parent = nullptr)**

        Constructs a bar set with the label **label** and the parent **parent**.
        """
        ...

    def __lshift__(self, value: float) -> PySide6.QtCharts.QBarSet:
        ...

    @overload
    def append(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#append

        **void QBarSet::append(const qreal value )**

        Appends the new value specified by **value** to the end of the bar set.
        """
        ...

    @overload
    def append(self, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#append-1

        **void QBarSet::append(const QList<qreal> & values )**

        Appends the list of real values specified by **values** to the end of
        the bar set.

        **See also** **append** ().
        """
        ...

    def at(self, index: int) -> float:
        """
        https://doc.qt.io/qt-6/qbarset.html#at

        **qreal QBarSet::at(const int index ) const**

        Returns the value specified by **index** from the bar set. If the index
        is out of bounds, 0.0 is returned.
        """
        ...

    def borderColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qbarset.html#borderColor

        **QColor QBarSet::borderColor()**

        Returns the line color for the bar set.

        **Note:** Getter function for property borderColor.

        **See also** **setBorderColor** ().
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qbarset.html#brush

        **QBrush QBarSet::brush() const**

        Returns the brush used to fill the bars in the bar set.

        **Note:** Getter function for property brush.

        **See also** **setBrush** ().
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qbarset.html#color

        **QColor QBarSet::color()**

        Returns the fill color for the bar set.

        **Note:** Getter function for property color.

        **See also** **setColor** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qbarset.html#count

        **int QBarSet::count() const**

        Returns the number of values in a bar set.
        """
        ...

    def deselectAllBars(self) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#deselectAllBars

        **[since 6.2] void QBarSet::deselectAllBars()**

        Deselects all bars in the series.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def deselectBar(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#deselectBar

        **[since 6.2] void QBarSet::deselectBar(int index )**

        Deselects the bar at **index**.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def deselectBars(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#deselectBars

        **[since 6.2] void QBarSet::deselectBars(const QList<int> & indexes )**

        Marks multiple bars passed in an **indexes** list as deselected.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def insert(self, index: int, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#insert

        **void QBarSet::insert(const int index , const qreal value )**

        Inserts **value** in the position specified by **index**. The values
        following the inserted value are moved up one position.

        **See also** **remove** ().
        """
        ...

    def isBarSelected(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qbarset.html#isBarSelected

        **[since 6.2] bool QBarSet::isBarSelected(int index ) const**

        Returns `true` if the bar at the given **index** is among selected bars
        and `false` otherwise.

        **Note:** Selected bars are drawn using the selected color if it was
        specified using **QBarSet::setSelectedColor** .

        This function was introduced in Qt 6.2.

        **See also** **selectedBars** (), **setBarSelected** (), and
        **setSelectedColor** ().
        """
        ...

    def label(self) -> str:
        """
        https://doc.qt.io/qt-6/qbarset.html#label

        **QString QBarSet::label() const**

        Returns the label of the bar set.

        **Note:** Getter function for property label.

        **See also** **setLabel** ().
        """
        ...

    def labelBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelBrush

        **QBrush QBarSet::labelBrush() const**

        Returns the brush used to draw values on top of this bar set.

        **Note:** Getter function for property labelBrush.

        **See also** **setLabelBrush** ().
        """
        ...

    def labelColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelColor

        **QColor QBarSet::labelColor()**

        Returns the text color for the bar set.

        **Note:** Getter function for property labelColor.

        **See also** **setLabelColor** ().
        """
        ...

    def labelFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelFont

        **QFont QBarSet::labelFont() const**

        Returns the pen used to draw values on top of this bar set.

        **Note:** Getter function for property labelFont.

        **See also** **setLabelFont** ().
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qbarset.html#pen

        **QPen QBarSet::pen() const**

        Returns the pen used to draw the lines in the bar set.

        **Note:** Getter function for property pen.

        **See also** **setPen** ().
        """
        ...

    def remove(self, index: int, count: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#remove

        **void QBarSet::remove(const int index , const int count = 1)**

        Removes the number of values specified by **count** from the bar set
        starting with the value specified by **index**.

        **See also** **insert** ().
        """
        ...

    def replace(self, index: int, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#replace

        **void QBarSet::replace(const int index , const qreal value )**

        Adds the value specified by **value** to the bar set at the position
        specified by **index**.
        """
        ...

    def selectAllBars(self) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#selectAllBars

        **[since 6.2] void QBarSet::selectAllBars()**

        Marks all bars in the series as selected.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def selectBar(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#selectBar

        **[since 6.2] void QBarSet::selectBar(int index )**

        Marks the bar at **index** as selected.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def selectBars(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#selectBars

        **[since 6.2] void QBarSet::selectBars(const QList<int> & indexes )**

        Marks multiple bars passed in an **indexes** list as selected.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def selectedBars(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qbarset.html#selectedBars

        **[since 6.2] QList<int> QBarSet::selectedBars() const**

        Returns a list of bars marked as selected.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    def selectedColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qbarset.html#selectedColor

        **[since 6.2] QColor QBarSet::selectedColor() const**

        Returns the color of the selected bars.

        This is the fill (brush) color of bars marked as selected. If not
        specified, value of **QBarSet::color**  is used as default.

        This function was introduced in Qt 6.2.

        **See also** **setSelectedColor** () and **color** .
        """
        ...

    def setBarSelected(self, index: int, selected: bool) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setBarSelected

        **[since 6.2] void QBarSet::setBarSelected(int index , bool selected )**

        Marks the bar at **index** as either selected or deselected as specified
        by **selected**.

        **Note:** Selected bars are drawn using the selected color if it was
        specified. Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **isBarSelected** () and **setSelectedColor** ().
        """
        ...

    def setBorderColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setBorderColor

        **void QBarSet::setBorderColor(QColor color )**

        Sets the line color for the bar set to **color**.

        **Note:** Setter function for property **borderColor** .

        **See also** **borderColor** ().
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setBrush

        **void QBarSet::setBrush(const QBrush & brush )**

        Sets the brush used to fill the bars in the bar set to **brush**.

        **Note:** Setter function for property **brush** .

        **See also** **brush** ().
        """
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setColor

        **void QBarSet::setColor(QColor color )**

        Sets the fill color for the bar set to **color**.

        **Note:** Setter function for property **color** .

        **See also** **color** ().
        """
        ...

    def setLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setLabel

        **void QBarSet::setLabel(const QString label )**

        Sets **label** as the new label for the bar set.

        **Note:** Setter function for property **label** .

        **See also** **label** ().
        """
        ...

    def setLabelBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setLabelBrush

        **void QBarSet::setLabelBrush(const QBrush & brush )**

        Sets the brush used to draw values on top of this bar set to **brush**.

        **Note:** Setter function for property **labelBrush** .

        **See also** **labelBrush** ().
        """
        ...

    def setLabelColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setLabelColor

        **void QBarSet::setLabelColor(QColor color )**

        Sets the text color for the bar set to **color**.

        **Note:** Setter function for property **labelColor** .

        **See also** **labelColor** ().
        """
        ...

    def setLabelFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setLabelFont

        **void QBarSet::setLabelFont(const QFont & font )**

        Sets the font used to draw values on top of this bar set to **font**.

        **Note:** Setter function for property **labelFont** .

        **See also** **labelFont** ().
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setPen

        **void QBarSet::setPen(const QPen & pen )**

        Sets the pen used to draw the lines in the bar set to **pen**.

        **Note:** Setter function for property **pen** .

        **See also** **pen** ().
        """
        ...

    def setSelectedColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#setSelectedColor

        **[since 6.2] void QBarSet::setSelectedColor(const QColor & color )**

        Sets the **color** of the selected bars.

        This function was introduced in Qt 6.2.

        **See also** **selectedColor** .
        """
        ...

    def sum(self) -> float:
        """
        https://doc.qt.io/qt-6/qbarset.html#sum

        **qreal QBarSet::sum() const**

        Returns the sum of all values in the bar set.
        """
        ...

    def toggleSelection(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qbarset.html#toggleSelection

        **[since 6.2] void QBarSet::toggleSelection(const QList<int> & indexes
        )**

        Changes the selection state of bars at the given **indexes** to the
        opposite one.

        **Note:** Emits QBarSet::selectedBarsChanged.

        This function was introduced in Qt 6.2.

        **See also** **setBarSelected** ().
        """
        ...

    @property
    def borderColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#borderColorChanged

        **[signal] void QBarSet::borderColorChanged(QColor color )**

        This signal is emitted when the line (pen) color of the bar set changes
        to **color**.

        **Note:** Notifier signal for property **borderColor** .
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#brushChanged

        **[signal] void QBarSet::brushChanged()**

        This signal is emitted when the brush used to draw the bar set changes.

        **Note:** Notifier signal for property **brush** .

        **See also** **brush** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#clicked

        **[signal] void QBarSet::clicked(int index )**

        This signal is emitted when the user clicks the bar specified by
        **index** in a bar set.
        """
        ...

    @property
    def colorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#colorChanged

        **[signal] void QBarSet::colorChanged(QColor color )**

        This signal is emitted when the fill (brush) color of the bar set
        changes to **color**.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#doubleClicked

        **[signal] void QBarSet::doubleClicked(int index )**

        This signal is emitted when the user double-clicks the bar specified by
        **index** in a bar set.
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#hovered

        **[signal] void QBarSet::hovered(bool status , int index )**

        This signal is emitted when a mouse is hovered over the bar specified by
        **index** in a bar set. When the mouse moves over the bar, **status**
        turns `true`, and when the mouse moves away again, it turns `false`.
        """
        ...

    @property
    def labelBrushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelBrushChanged

        **[signal] void QBarSet::labelBrushChanged()**

        This signal is emitted when the brush used to draw the bar set's label
        changes.

        **Note:** Notifier signal for property **labelBrush** .

        **See also** **labelBrush** .
        """
        ...

    @property
    def labelChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelChanged

        **[signal] void QBarSet::labelChanged()**

        This signal is emitted when the label of the bar set changes.

        **Note:** Notifier signal for property **label** .

        **See also** **label** .
        """
        ...

    @property
    def labelColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelColorChanged

        **[signal] void QBarSet::labelColorChanged(QColor color )**

        This signal is emitted when the text (label) color of the bar set
        changes to **color**.

        **Note:** Notifier signal for property **labelColor** .
        """
        ...

    @property
    def labelFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#labelFontChanged

        **[signal] void QBarSet::labelFontChanged()**

        This signal is emitted when the font of the bar set's label changes.

        **Note:** Notifier signal for property **labelFont** .

        **See also** **labelBrush** .
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#penChanged

        **[signal] void QBarSet::penChanged()**

        This signal is emitted when the pen used to draw the bar set changes.

        **Note:** Notifier signal for property **pen** .

        **See also** **pen** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#pressed

        **[signal] void QBarSet::pressed(int index )**

        This signal is emitted when the user clicks the bar specified by
        **index** in a bar set and holds down the mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#released

        **[signal] void QBarSet::released(int index )**

        This signal is emitted when the user releases the mouse press on the bar
        specified by **index** in a bar set.
        """
        ...

    @property
    def valueChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#valueChanged

        **[signal] void QBarSet::valueChanged(int index )**

        This signal is emitted when the value at the position specified by
        **index** is modified.

        **See also** **at** ().
        """
        ...

    @property
    def valuesAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#valuesAdded

        **[signal] void QBarSet::valuesAdded(int index , int count )**

        This signal is emitted when new values are added to the bar set.
        **index** indicates the position of the first inserted value, and
        **count** is the number of inserted values.

        **See also** **append** () and **insert** ().
        """
        ...

    @property
    def valuesRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarset.html#valuesRemoved

        **[signal] void QBarSet::valuesRemoved(int index , int count )**

        This signal is emitted when values are removed from the bar set.
        **index** indicates the position of the first removed value, and
        **count** is the number of removed values.

        **See also** **remove** ().
        """
        ...
