"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QAbstractSeries(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstractseries.html

    **Detailed Description**

    Usually, the series type specific inherited classes are used instead of the
    base class.

    **See also** **QXYSeries** , **QLineSeries** , **QSplineSeries** ,
    **QScatterSeries** , **QAreaSeries** , **QAbstractBarSeries** ,
    **QBarSeries** , **QStackedBarSeries** , **QPercentBarSeries** ,
    **QHorizontalBarSeries** , **QHorizontalStackedBarSeries** ,
    **QHorizontalPercentBarSeries** , and **QPieSeries** .
    """

    SeriesTypeLine: QAbstractSeries.SeriesType = ...
    SeriesTypeArea: QAbstractSeries.SeriesType = ...
    SeriesTypeBar: QAbstractSeries.SeriesType = ...
    SeriesTypeStackedBar: QAbstractSeries.SeriesType = ...
    SeriesTypePercentBar: QAbstractSeries.SeriesType = ...
    SeriesTypePie: QAbstractSeries.SeriesType = ...
    SeriesTypeScatter: QAbstractSeries.SeriesType = ...
    SeriesTypeSpline: QAbstractSeries.SeriesType = ...
    SeriesTypeHorizontalBar: QAbstractSeries.SeriesType = ...
    SeriesTypeHorizontalStackedBar: QAbstractSeries.SeriesType = ...
    SeriesTypeHorizontalPercentBar: QAbstractSeries.SeriesType = ...
    SeriesTypeBoxPlot: QAbstractSeries.SeriesType = ...
    SeriesTypeCandlestick: QAbstractSeries.SeriesType = ...

    class SeriesType(Enum):
        SeriesTypeLine: QAbstractSeries.SeriesType = ...
        SeriesTypeArea: QAbstractSeries.SeriesType = ...
        SeriesTypeBar: QAbstractSeries.SeriesType = ...
        SeriesTypeStackedBar: QAbstractSeries.SeriesType = ...
        SeriesTypePercentBar: QAbstractSeries.SeriesType = ...
        SeriesTypePie: QAbstractSeries.SeriesType = ...
        SeriesTypeScatter: QAbstractSeries.SeriesType = ...
        SeriesTypeSpline: QAbstractSeries.SeriesType = ...
        SeriesTypeHorizontalBar: QAbstractSeries.SeriesType = ...
        SeriesTypeHorizontalStackedBar: QAbstractSeries.SeriesType = ...
        SeriesTypeHorizontalPercentBar: QAbstractSeries.SeriesType = ...
        SeriesTypeBoxPlot: QAbstractSeries.SeriesType = ...
        SeriesTypeCandlestick: QAbstractSeries.SeriesType = ...

    def attachAxis(self, axis: PySide6.QtCharts.QAbstractAxis) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#attachAxis

        **bool QAbstractSeries::attachAxis(QAbstractAxis * axis )**

        Attaches the axis specified by **axis** to the series.

        Returns `true` if the axis was attached successfully, `false` otherwise.

        **Note:** If multiple axes of the same orientation are attached to the
        same series, they will have the same minimum and maximum values.

        **See also** **QChart::addAxis** () and **QChart::createDefaultAxes**
        ().
        """
        ...

    def attachedAxes(self) -> List[PySide6.QtCharts.QAbstractAxis]:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#attachedAxes

        **QList<QAbstractAxis *> QAbstractSeries::attachedAxes()**

        Returns the list of axes attached to the series. Usually, an x-axis and
        a y-axis are attached to a series, except for **QPieSeries** , which
        does not have any axes attached.

        **See also** **attachAxis** () and **detachAxis** ().
        """
        ...

    def chart(self) -> PySide6.QtCharts.QChart:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#chart

        **QChart *QAbstractSeries::chart() const**

        Returns the chart that the series belongs to.

        Set automatically when the series is added to the chart, and unset when
        the series is removed from the chart.
        """
        ...

    def detachAxis(self, axis: PySide6.QtCharts.QAbstractAxis) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#detachAxis

        **bool QAbstractSeries::detachAxis(QAbstractAxis * axis )**

        Detaches the axis specified by **axis** from the series.

        Returns `true` if the axis was detached successfully, `false` otherwise.

        **See also** **QChart::removeAxis** ().
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#hide

        **void QAbstractSeries::hide()**

        Sets the visibility of the series to `false`.

        **See also** **setVisible** () and **isVisible** ().
        """
        ...

    def isVisible(self) -> bool:
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#name-prop

        **name : QString**

        This property holds the name of the series.

        The name is displayed in the legend for the series and it supports HTML
        formatting.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void ****nameChanged** ** ()
        """
        ...

    def opacity(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#opacity-prop

        **opacity : qreal**

        This property holds the opacity of the series.

        By default, the opacity is 1.0. The valid values range from 0.0
        (transparent) to 1.0 (opaque).

        **Access functions:**

        qreal **opacity** () const
        void **setOpacity** (qreal **opacity** )

        **Notifier signal:**

        void ****opacityChanged** ** ()
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#name-prop

        **name : QString**

        This property holds the name of the series.

        The name is displayed in the legend for the series and it supports HTML
        formatting.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void ****nameChanged** ** ()
        """
        ...

    def setOpacity(self, opacity: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#opacity-prop

        **opacity : qreal**

        This property holds the opacity of the series.

        By default, the opacity is 1.0. The valid values range from 0.0
        (transparent) to 1.0 (opaque).

        **Access functions:**

        qreal **opacity** () const
        void **setOpacity** (qreal **opacity** )

        **Notifier signal:**

        void ****opacityChanged** ** ()
        """
        ...

    def setUseOpenGL(self, enable: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#useOpenGL-prop

        **useOpenGL : bool**

        Specifies whether or not drawing the series is accelerated by using
        OpenGL.

        Acceleration using OpenGL is supported only for **QLineSeries**  and
        **QScatterSeries** . A line series used as an edge series for
        **QAreaSeries**  cannot use OpenGL acceleration. When a chart contains
        any series that are drawn with OpenGL, a transparent QOpenGLWidget is
        created on top of the chart plot area. The accelerated series are not
        drawn on the underlying **QGraphicsView** , but are instead drawn on the
        created QOpenGLWidget.

        Performance gained from using OpenGL to accelerate series drawing
        depends on the underlying hardware, but in most cases it is significant.
        For example, on a standard desktop computer, enabling OpenGL
        acceleration for a series typically allows rendering at least a hundred
        times more points without reduction on the frame rate. Chart size also
        has less effect on the frame rate.

        The OpenGL acceleration of series drawing is meant for use cases that
        need fast drawing of large numbers of points. It is optimized for
        efficiency, and therefore the series using it lack support for many
        features available to non-accelerated series:

        * Series animations are not supported for accelerated series.
          * Point
        labels are not supported for accelerated series.
          * Pen styles, marker
        shapes and light markers are ignored for accelerated series. Only solid
        lines and plain scatter dots are supported. The scatter dots may be
        circular or rectangular, depending on the underlying graphics hardware
        and drivers.
          * Polar charts do not support accelerated series.
          *
        Enabling chart drop shadow or using transparent chart background color
        is not recommended when using accelerated series, as that can slow the
        frame rate down significantly.

        These additional restrictions stem from the fact that the accelerated
        series is drawn on a separate widget on top of the chart:

        * If you draw any graphics items on top of a chart containing an
        accelerated series, the accelerated series is drawn over those items.
        * To enable QOpenGLWidget to be partially transparent, it needs to be
        stacked on top of all other widgets. This means you cannot have other
        widgets partially covering the chart when using accelerated series.
          *
        Accelerated series are not supported for use cases where the graphics
        scene has more than one graphics view attached to it.
          * Accelerated
        series are not supported for use cases where the chart has non-default
        geometry. For example, adding transforms to the graphics view causes the
        accelerated series to be drawn in an incorrect position related to the
        chart.

        The default value is `false`.

        **Access functions:**

        bool **useOpenGL** () const
        void **setUseOpenGL** (bool **enable** =
        true)

        **Notifier signal:**

        void ****useOpenGLChanged** ** ()
        """
        ...

    def setVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#visible-prop

        **visible : bool**

        This property holds whether the series is visible or not.

        By default, `true`.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** =
        true)

        **Notifier signal:**

        void ****visibleChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#show

        **void QAbstractSeries::show()**

        Sets the visibility of the series to `true`.

        **See also** **setVisible** () and **isVisible** ().
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#type-prop

        **[read-only] type : const SeriesType**

        This property holds the type of the series.

        **Access functions:**

        virtual QAbstractSeries::SeriesType **type** () const = 0
        """
        ...

    def useOpenGL(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#useOpenGL-prop

        **useOpenGL : bool**

        Specifies whether or not drawing the series is accelerated by using
        OpenGL.

        Acceleration using OpenGL is supported only for **QLineSeries**  and
        **QScatterSeries** . A line series used as an edge series for
        **QAreaSeries**  cannot use OpenGL acceleration. When a chart contains
        any series that are drawn with OpenGL, a transparent QOpenGLWidget is
        created on top of the chart plot area. The accelerated series are not
        drawn on the underlying **QGraphicsView** , but are instead drawn on the
        created QOpenGLWidget.

        Performance gained from using OpenGL to accelerate series drawing
        depends on the underlying hardware, but in most cases it is significant.
        For example, on a standard desktop computer, enabling OpenGL
        acceleration for a series typically allows rendering at least a hundred
        times more points without reduction on the frame rate. Chart size also
        has less effect on the frame rate.

        The OpenGL acceleration of series drawing is meant for use cases that
        need fast drawing of large numbers of points. It is optimized for
        efficiency, and therefore the series using it lack support for many
        features available to non-accelerated series:

        * Series animations are not supported for accelerated series.
          * Point
        labels are not supported for accelerated series.
          * Pen styles, marker
        shapes and light markers are ignored for accelerated series. Only solid
        lines and plain scatter dots are supported. The scatter dots may be
        circular or rectangular, depending on the underlying graphics hardware
        and drivers.
          * Polar charts do not support accelerated series.
          *
        Enabling chart drop shadow or using transparent chart background color
        is not recommended when using accelerated series, as that can slow the
        frame rate down significantly.

        These additional restrictions stem from the fact that the accelerated
        series is drawn on a separate widget on top of the chart:

        * If you draw any graphics items on top of a chart containing an
        accelerated series, the accelerated series is drawn over those items.
        * To enable QOpenGLWidget to be partially transparent, it needs to be
        stacked on top of all other widgets. This means you cannot have other
        widgets partially covering the chart when using accelerated series.
          *
        Accelerated series are not supported for use cases where the graphics
        scene has more than one graphics view attached to it.
          * Accelerated
        series are not supported for use cases where the chart has non-default
        geometry. For example, adding transforms to the graphics view causes the
        accelerated series to be drawn in an incorrect position related to the
        chart.

        The default value is `false`.

        **Access functions:**

        bool **useOpenGL** () const
        void **setUseOpenGL** (bool **enable** =
        true)

        **Notifier signal:**

        void ****useOpenGLChanged** ** ()
        """
        ...

    @property
    def nameChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#nameChanged

        **[signal] void QAbstractSeries::nameChanged()**

        This signal is emitted when the series name changes.

        **Note:** Notifier signal for property **name** .
        """
        ...

    @property
    def opacityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#opacityChanged

        **[signal] void QAbstractSeries::opacityChanged()**

        This signal is emitted when the opacity of the series changes.

        **Note:** Notifier signal for property **opacity** .
        """
        ...

    @property
    def useOpenGLChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#useOpenGLChanged

        **[signal] void QAbstractSeries::useOpenGLChanged()**

        This signal is emitted when accelerating the drawing of the series by
        using OpenGL is enabled or disabled.

        **Note:** Notifier signal for property **useOpenGL** .
        """
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractseries.html#visibleChanged

        **[signal] void QAbstractSeries::visibleChanged()**

        This signal is emitted when the series visibility changes.

        **Note:** Notifier signal for property **visible** .
        """
        ...
