"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QAbstractBarSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qabstractbarseries.html

    **Detailed Description**

    In bar charts, bars are defined as bar sets that contain one data value for
    each category. The position of a bar is specified by the category and its
    height by the data value. Bar series that contain multiple bar sets group
    together bars that belong to the same category. The way the bars are
    displayed is determined by the subclass of this class chosen to create the
    bar chart.

    If a **QValueAxis**  is used instead of **QBarCategoryAxis**  for the main
    bar axis, the bars are grouped around the index value of the category.

    See the **bar chart example**  to learn how to use the **QBarSeries**  class
    to create a simple bar chart.

    ![](images/examples_barchart.png)

    **See also** **QBarSet** , **QBarSeries** , **QStackedBarSeries** ,
    **QPercentBarSeries** , **QHorizontalBarSeries** ,
    **QHorizontalStackedBarSeries** , and **QHorizontalPercentBarSeries** .
    """

    LabelsCenter: QAbstractBarSeries.LabelsPosition = ...
    LabelsInsideEnd: QAbstractBarSeries.LabelsPosition = ...
    LabelsInsideBase: QAbstractBarSeries.LabelsPosition = ...
    LabelsOutsideEnd: QAbstractBarSeries.LabelsPosition = ...

    class LabelsPosition(Enum):
        LabelsCenter: QAbstractBarSeries.LabelsPosition = ...
        LabelsInsideEnd: QAbstractBarSeries.LabelsPosition = ...
        LabelsInsideBase: QAbstractBarSeries.LabelsPosition = ...
        LabelsOutsideEnd: QAbstractBarSeries.LabelsPosition = ...

    @overload
    def append(self, set: PySide6.QtCharts.QBarSet) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#append

        **bool QAbstractBarSeries::append(QBarSet * set )**

        Adds a set of bars specified by **set** to the bar series and takes
        ownership of it. If the set is null or it already belongs to the series,
        it will not be appended. Returns `true` if appending succeeded.
        """
        ...

    @overload
    def append(self, sets: Sequence[PySide6.QtCharts.QBarSet]) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#append-1

        **bool QAbstractBarSeries::append(const QList<QBarSet *> & sets )**

        Adds a list of bar sets specified by **sets** to a bar series and takes
        ownership of the sets. Returns `true` if all sets were appended
        successfully. If any of the sets is null or was previously appended to
        the series, nothing is appended and this function returns `false`. If
        any of the sets appears in the list more than once, nothing is appended
        and this function returns `false`.
        """
        ...

    def barSets(self) -> List[PySide6.QtCharts.QBarSet]:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#barSets

        **QList<QBarSet *> QAbstractBarSeries::barSets() const**

        Returns a list of bar sets in a bar series. Keeps the ownership of the
        bar sets.
        """
        ...

    def barWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#barWidth

        **qreal QAbstractBarSeries::barWidth() const**

        Returns the width of the bars of the series.

        **Note:** Getter function for property barWidth.

        **See also** **setBarWidth** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#clear

        **void QAbstractBarSeries::clear()**

        Removes all bar sets from the series and permanently deletes them.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#count

        **int QAbstractBarSeries::count() const**

        Returns the number of bar sets in a bar series.

        **Note:** Getter function for property count.
        """
        ...

    def insert(self, index: int, set: PySide6.QtCharts.QBarSet) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#insert

        **bool QAbstractBarSeries::insert(int index , QBarSet * set )**

        Inserts a bar set specified by **set** to a series at the position
        specified by **index** and takes ownership of the set. If the set is
        null or already belongs to the series, it will not be appended. Returns
        `true` if inserting succeeds.
        """
        ...

    def isLabelsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#isLabelsVisible

        **bool QAbstractBarSeries::isLabelsVisible() const**

        Returns the visibility of labels.

        **Note:** Getter function for property **labelsVisible** .
        """
        ...

    def labelsAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsAngle-prop

        **labelsAngle : qreal**

        This property holds the angle of the value labels in degrees.

        **Access functions:**

        qreal **labelsAngle** () const
        void **setLabelsAngle** (qreal
        **angle** )

        **Notifier signal:**

        void ****labelsAngleChanged** ** (qreal **angle** )
        """
        ...

    def labelsFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsFormat-prop

        **labelsFormat : QString**

        This property holds the format used for showing labels in a bar series.

        **QAbstractBarSeries**  supports the following format tag:

        @valueThe value of the bar

        For example, the following usage of the format tags would produce labels
        that show the value followed by the unit (u):

        series->setLabelsFormat("@value u");

        By default, the labels show the value of the bar. For the percent bar
        series, **%** is added after the value. The labels are shown on the plot
        area, if the bars are close to each other, the labels may overlap.

        **Access functions:**

        QString **labelsFormat** () const
        void **setLabelsFormat** (const
        QString & **format** )

        **Notifier signal:**

        void ****labelsFormatChanged** ** (const QString & **format** )

        **See also** **labelsVisible** , **labelsPosition** , and
        **labelsPrecision** .
        """
        ...

    def labelsPosition(self) -> PySide6.QtCharts.QAbstractBarSeries.LabelsPosition:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPosition-prop

        **labelsPosition : LabelsPosition**

        This property holds the position of value labels.

        **Access functions:**

        QAbstractBarSeries::LabelsPosition **labelsPosition** () const
        void
        **setLabelsPosition** (QAbstractBarSeries::LabelsPosition **position** )

        **Notifier signal:**

        void ****labelsPositionChanged** ** (QAbstractBarSeries::LabelsPosition
        **position** )

        **See also** **labelsVisible**  and **labelsFormat** .
        """
        ...

    def labelsPrecision(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPrecision-prop

        **labelsPrecision : int**

        This property holds the maximum amount of significant digits shown in
        value labels.

        Default value is 6.

        **Access functions:**

        int **labelsPrecision** () const
        void **setLabelsPrecision** (int
        **precision** )

        **Notifier signal:**

        void ****labelsPrecisionChanged** ** (int **precision** )
        """
        ...

    def remove(self, set: PySide6.QtCharts.QBarSet) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#remove

        **bool QAbstractBarSeries::remove(QBarSet * set )**

        Removes the bar set specified by **set** from the series and permanently
        deletes it if the removal succeeds. Returns `true` if the set was
        removed.
        """
        ...

    def setBarWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#setBarWidth

        **void QAbstractBarSeries::setBarWidth(qreal width )**

        Sets the width of the bars of the series to **width**.

        **Note:** Setter function for property **barWidth** .

        **See also** **barWidth** ().
        """
        ...

    def setLabelsAngle(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsAngle-prop

        **labelsAngle : qreal**

        This property holds the angle of the value labels in degrees.

        **Access functions:**

        qreal **labelsAngle** () const
        void **setLabelsAngle** (qreal
        **angle** )

        **Notifier signal:**

        void ****labelsAngleChanged** ** (qreal **angle** )
        """
        ...

    def setLabelsFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsFormat-prop

        **labelsFormat : QString**

        This property holds the format used for showing labels in a bar series.

        **QAbstractBarSeries**  supports the following format tag:

        @valueThe value of the bar

        For example, the following usage of the format tags would produce labels
        that show the value followed by the unit (u):

        series->setLabelsFormat("@value u");

        By default, the labels show the value of the bar. For the percent bar
        series, **%** is added after the value. The labels are shown on the plot
        area, if the bars are close to each other, the labels may overlap.

        **Access functions:**

        QString **labelsFormat** () const
        void **setLabelsFormat** (const
        QString & **format** )

        **Notifier signal:**

        void ****labelsFormatChanged** ** (const QString & **format** )

        **See also** **labelsVisible** , **labelsPosition** , and
        **labelsPrecision** .
        """
        ...

    def setLabelsPosition(
        self, position: PySide6.QtCharts.QAbstractBarSeries.LabelsPosition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPosition-prop

        **labelsPosition : LabelsPosition**

        This property holds the position of value labels.

        **Access functions:**

        QAbstractBarSeries::LabelsPosition **labelsPosition** () const
        void
        **setLabelsPosition** (QAbstractBarSeries::LabelsPosition **position** )

        **Notifier signal:**

        void ****labelsPositionChanged** ** (QAbstractBarSeries::LabelsPosition
        **position** )

        **See also** **labelsVisible**  and **labelsFormat** .
        """
        ...

    def setLabelsPrecision(self, precision: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPrecision-prop

        **labelsPrecision : int**

        This property holds the maximum amount of significant digits shown in
        value labels.

        Default value is 6.

        **Access functions:**

        int **labelsPrecision** () const
        void **setLabelsPrecision** (int
        **precision** )

        **Notifier signal:**

        void ****labelsPrecisionChanged** ** (int **precision** )
        """
        ...

    def setLabelsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#setLabelsVisible

        **void QAbstractBarSeries::setLabelsVisible(bool visible = true)**

        Sets the visibility of labels in a bar series to **visible**.

        **Note:** Setter function for property **labelsVisible** .

        **See also** **isLabelsVisible** ().
        """
        ...

    def take(self, set: PySide6.QtCharts.QBarSet) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#take

        **bool QAbstractBarSeries::take(QBarSet * set )**

        Takes a single **set** from the series. Does not delete the bar set
        object.

        **Note:** The series remains the barset's parent object. You must set
        the parent object to take full ownership.

        Returns `true` if the take operation succeeds.
        """
        ...

    @property
    def barsetsAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#barsetsAdded

        **[signal] void QAbstractBarSeries::barsetsAdded(const QList<QBarSet *>
        & sets )**

        This signal is emitted when the bar sets specified by **sets** are added
        to the series.

        **See also** **append** () and **insert** ().
        """
        ...

    @property
    def barsetsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#barsetsRemoved

        **[signal] void QAbstractBarSeries::barsetsRemoved(const QList<QBarSet
        *> & sets )**

        This signal is emitted when the bar sets specified by **sets** are
        removed from the series.

        **See also** **remove** ().
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#clicked

        **[signal] void QAbstractBarSeries::clicked(int index , QBarSet * barset
        )**

        This signal is emitted when the user clicks the bar specified by
        **index** in the bar set specified by **barset**.
        """
        ...

    @property
    def countChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#countChanged

        **[signal] void QAbstractBarSeries::countChanged()**

        This signal is emitted when the number of bar sets is changed, for
        example by **append** () or **remove** ().

        **Note:** Notifier signal for property **count** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#doubleClicked

        **[signal] void QAbstractBarSeries::doubleClicked(int index , QBarSet *
        barset )**

        This signal is emitted when the user double-clicks the bar specified by
        **index** in the bar set specified by **barset**.
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#hovered

        **[signal] void QAbstractBarSeries::hovered(bool status , int index ,
        QBarSet * barset )**

        This signal is emitted when a mouse is hovered over the bar specified by
        **index** in the bar set specified by **barset**. When the mouse moves
        over the bar, **status** turns `true`, and when the mouse moves away
        again, it turns `false`.
        """
        ...

    @property
    def labelsAngleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsAngleChanged

        **[signal] void QAbstractBarSeries::labelsAngleChanged(qreal angle )**

        This signal is emitted when the **angle** of the value labels changes.

        **Note:** Notifier signal for property **labelsAngle** .
        """
        ...

    @property
    def labelsFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsFormatChanged

        **[signal] void QAbstractBarSeries::labelsFormatChanged(const QString &
        format )**

        This signal is emitted when the **format** of data value labels changes.

        **Note:** Notifier signal for property **labelsFormat** .
        """
        ...

    @property
    def labelsPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPositionChanged

        **[signal] void QAbstractBarSeries::labelsPositionChanged(QAbstractBarSe
        ries::LabelsPosition position )**

        This signal is emitted when the **position** of value labels changes.

        **Note:** Notifier signal for property **labelsPosition** .
        """
        ...

    @property
    def labelsPrecisionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsPrecisionChanged

        **[signal] void QAbstractBarSeries::labelsPrecisionChanged(int precision
        )**

        This signal is emitted when the **precision** of the value labels
        changes.

        **Note:** Notifier signal for property **labelsPrecision** .
        """
        ...

    @property
    def labelsVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#labelsVisibleChanged

        **[signal] void QAbstractBarSeries::labelsVisibleChanged()**

        This signal is emitted when the labels' visibility changes.

        **Note:** Notifier signal for property **labelsVisible** .

        **See also** **isLabelsVisible** () and **setLabelsVisible** ().
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#pressed

        **[signal] void QAbstractBarSeries::pressed(int index , QBarSet * barset
        )**

        This signal is emitted when the user clicks the bar specified by
        **index** in the bar set specified by **barset** and holds down the
        mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbarseries.html#released

        **[signal] void QAbstractBarSeries::released(int index , QBarSet *
        barset )**

        This signal is emitted when the user releases the mouse press on the bar
        specified by **index** in the bar set specified by **barset**.
        """
        ...
