"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Sequence, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QAbstractAxis(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstractaxis.html

    **Detailed Description**

    Each series can be bound to one or more horizontal and vertical axes, but
    mixing axis types that would result in different domains is not supported,
    such as specifying **QValueAxis**  and **QLogValueAxis**  on the same
    orientation.

    The properties and visibility of various axis elements, such as axis line,
    title, labels, grid lines, and shades, can be individually controlled.
    """

    AxisTypeNoAxis: QAbstractAxis.AxisType = ...
    AxisTypeValue: QAbstractAxis.AxisType = ...
    AxisTypeBarCategory: QAbstractAxis.AxisType = ...
    AxisTypeCategory: QAbstractAxis.AxisType = ...
    AxisTypeDateTime: QAbstractAxis.AxisType = ...
    AxisTypeLogValue: QAbstractAxis.AxisType = ...
    AxisTypeColor: QAbstractAxis.AxisType = ...

    class AxisType(Enum):
        AxisTypeNoAxis: QAbstractAxis.AxisType = ...
        AxisTypeValue: QAbstractAxis.AxisType = ...
        AxisTypeBarCategory: QAbstractAxis.AxisType = ...
        AxisTypeCategory: QAbstractAxis.AxisType = ...
        AxisTypeDateTime: QAbstractAxis.AxisType = ...
        AxisTypeLogValue: QAbstractAxis.AxisType = ...
        AxisTypeColor: QAbstractAxis.AxisType = ...

    def alignment(self) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#alignment-prop

        **[read-only] alignment : const Qt::Alignment**

        This property holds the alignment of the axis.

        Can be **Qt::AlignLeft** , **Qt::AlignRight** , **Qt::AlignBottom** , or
        **Qt::AlignTop** .

        **Access functions:**

        Qt::Alignment **alignment** () const
        """
        ...

    def gridLineColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridLineColor-prop

        **gridLineColor : QColor**

        This property holds the color of the grid line.

        **Access functions:**

        QColor **gridLineColor** ()
        void **setGridLineColor** (const QColor &
        **color** )

        **Notifier signal:**

        void ****gridLineColorChanged** ** (const QColor & **color** )
        """
        ...

    def gridLinePen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridLinePen

        **QPen QAbstractAxis::gridLinePen() const**

        Returns the pen used to draw the grid.

        **Note:** Getter function for property gridLinePen.

        **See also** **setGridLinePen** ().
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#hide

        **void QAbstractAxis::hide()**

        Makes the axis, shades, labels, and grid lines invisible.
        """
        ...

    def isGridLineVisible(self) -> bool:
        ...

    def isLineVisible(self) -> bool:
        ...

    def isMinorGridLineVisible(self) -> bool:
        ...

    def isReverse(self) -> bool:
        ...

    def isTitleVisible(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def labelsAngle(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsAngle-prop

        **labelsAngle : int**

        This property holds the angle of the axis labels in degrees.

        **Access functions:**

        int **labelsAngle** () const
        void **setLabelsAngle** (int **angle** )

        **Notifier signal:**

        void ****labelsAngleChanged** ** (int **angle** )
        """
        ...

    def labelsBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsBrush

        **QBrush QAbstractAxis::labelsBrush() const**

        Returns the brush used to draw labels.

        **Note:** Getter function for property labelsBrush.

        **See also** **setLabelsBrush** ().
        """
        ...

    def labelsColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsColor-prop

        **labelsColor : QColor**

        This property holds the color of the axis labels.

        **Access functions:**

        QColor **labelsColor** () const
        void **setLabelsColor** (QColor
        **color** )

        **Notifier signal:**

        void ****labelsColorChanged** ** (QColor **color** )
        """
        ...

    def labelsEditable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsEditable

        **[since 5.13] bool QAbstractAxis::labelsEditable() const**

        Returns `true` if axis labels are editable.

        This function was introduced in Qt 5.13.

        **See also** **setLabelsEditable** ().
        """
        ...

    def labelsFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsFont

        **QFont QAbstractAxis::labelsFont() const**

        Returns the font used to draw labels.

        **Note:** Getter function for property labelsFont.

        **See also** **setLabelsFont** ().
        """
        ...

    def labelsTruncated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsTruncated-prop

        **[read-only] labelsTruncated : const bool**

        Returns `true` if at least one label on the axis is truncated.

        Returned value will not be accurate before the axis is shown.

        **Access functions:**

        bool **labelsTruncated** () const

        **Notifier signal:**

        void ****labelsTruncatedChanged** ** (bool **labelsTruncated** )
        """
        ...

    def labelsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsVisible-prop

        **labelsVisible : bool**

        This property holds whether axis labels are visible.

        **Access functions:**

        bool **labelsVisible** () const
        void **setLabelsVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****labelsVisibleChanged** ** (bool **visible** )
        """
        ...

    def linePen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#linePen

        **QPen QAbstractAxis::linePen() const**

        Returns the pen used to draw the axis line and tick marks.

        **Note:** Getter function for property linePen.

        **See also** **setLinePen** ().
        """
        ...

    def linePenColor(self) -> PySide6.QtGui.QColor:
        ...

    def minorGridLineColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLineColor-prop

        **minorGridLineColor : QColor**

        This property holds the color of the minor grid line.

        Applies only to axes that support minor grid lines.

        **Access functions:**

        QColor **minorGridLineColor** ()
        void **setMinorGridLineColor** (const
        QColor & **color** )

        **Notifier signal:**

        void ****minorGridLineColorChanged** ** (const QColor & **color** )
        """
        ...

    def minorGridLinePen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLinePen-prop

        **minorGridLinePen : QPen**

        This property holds the pen used to draw the minor grid line.

        Applies only to axes that support minor grid lines.

        **Access functions:**

        QPen **minorGridLinePen** () const
        void **setMinorGridLinePen** (const
        QPen & **pen** )

        **Notifier signal:**

        void ****minorGridLinePenChanged** ** (const QPen & **pen** )
        """
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#orientation

        **Qt::Orientation QAbstractAxis::orientation() const**

        Returns the orientation of the axis (vertical or horizontal).

        **Note:** Getter function for property orientation.
        """
        ...

    def setGridLineColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridLineColor-prop

        **gridLineColor : QColor**

        This property holds the color of the grid line.

        **Access functions:**

        QColor **gridLineColor** ()
        void **setGridLineColor** (const QColor &
        **color** )

        **Notifier signal:**

        void ****gridLineColorChanged** ** (const QColor & **color** )
        """
        ...

    def setGridLinePen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setGridLinePen

        **void QAbstractAxis::setGridLinePen(const QPen & pen )**

        Sets the pen used to draw the grid lines to **pen**.

        **Note:** Setter function for property **gridLinePen** .

        **See also** **gridLinePen** ().
        """
        ...

    def setGridLineVisible(self, visible: bool = ...) -> None:
        ...

    def setLabelsAngle(self, angle: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsAngle-prop

        **labelsAngle : int**

        This property holds the angle of the axis labels in degrees.

        **Access functions:**

        int **labelsAngle** () const
        void **setLabelsAngle** (int **angle** )

        **Notifier signal:**

        void ****labelsAngleChanged** ** (int **angle** )
        """
        ...

    def setLabelsBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setLabelsBrush

        **void QAbstractAxis::setLabelsBrush(const QBrush & brush )**

        Sets the brush used to draw labels to **brush**.

        **Note:** Setter function for property **labelsBrush** .

        **See also** **labelsBrush** ().
        """
        ...

    def setLabelsColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsColor-prop

        **labelsColor : QColor**

        This property holds the color of the axis labels.

        **Access functions:**

        QColor **labelsColor** () const
        void **setLabelsColor** (QColor
        **color** )

        **Notifier signal:**

        void ****labelsColorChanged** ** (QColor **color** )
        """
        ...

    def setLabelsEditable(self, editable: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setLabelsEditable

        **[since 5.13] void QAbstractAxis::setLabelsEditable(bool editable =
        true)**

        Sets axis labels editability to **editable**.

        When the labels are editable the user will be able to change the range
        of the axis conveniently by editing any of the labels. This feature is
        only supported for the **QValueAxis**  and the **QDateTimeAxis** .

        By default, labels are not editable.

        This function was introduced in Qt 5.13.

        **See also** **labelsEditable** ().
        """
        ...

    def setLabelsFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setLabelsFont

        **void QAbstractAxis::setLabelsFont(const QFont & font )**

        Sets the font used to draw labels to **font**.

        **Note:** Setter function for property **labelsFont** .

        **See also** **labelsFont** ().
        """
        ...

    def setLabelsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsVisible-prop

        **labelsVisible : bool**

        This property holds whether axis labels are visible.

        **Access functions:**

        bool **labelsVisible** () const
        void **setLabelsVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****labelsVisibleChanged** ** (bool **visible** )
        """
        ...

    def setLinePen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setLinePen

        **void QAbstractAxis::setLinePen(const QPen & pen )**

        Sets the pen used to draw the axis line and tick marks to **pen**.

        **Note:** Setter function for property **linePen** .

        **See also** **linePen** ().
        """
        ...

    def setLinePenColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        ...

    def setLineVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setLineVisible

        **void QAbstractAxis::setLineVisible(bool visible = true)**

        Determines whether the axis line and tick marks are **visible**.

        **Note:** Setter function for property **lineVisible** .

        **See also** **isLineVisible** ().
        """
        ...

    def setMax(self, max: Any) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setMax

        **void QAbstractAxis::setMax(const QVariant & max )**

        Sets the maximum value shown on the axis. Depending on the actual axis
        type, the **max** parameter is converted to the appropriate type of
        value. If the conversion is impossible, the function call does nothing.
        """
        ...

    def setMin(self, min: Any) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setMin

        **void QAbstractAxis::setMin(const QVariant & min )**

        Sets the minimum value shown on the axis. Depending on the actual axis
        type, the **min** parameter is converted to the appropriate type of
        value. If the conversion is impossible, the function call does nothing.
        """
        ...

    def setMinorGridLineColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLineColor-prop

        **minorGridLineColor : QColor**

        This property holds the color of the minor grid line.

        Applies only to axes that support minor grid lines.

        **Access functions:**

        QColor **minorGridLineColor** ()
        void **setMinorGridLineColor** (const
        QColor & **color** )

        **Notifier signal:**

        void ****minorGridLineColorChanged** ** (const QColor & **color** )
        """
        ...

    def setMinorGridLinePen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLinePen-prop

        **minorGridLinePen : QPen**

        This property holds the pen used to draw the minor grid line.

        Applies only to axes that support minor grid lines.

        **Access functions:**

        QPen **minorGridLinePen** () const
        void **setMinorGridLinePen** (const
        QPen & **pen** )

        **Notifier signal:**

        void ****minorGridLinePenChanged** ** (const QPen & **pen** )
        """
        ...

    def setMinorGridLineVisible(self, visible: bool = ...) -> None:
        ...

    def setRange(self, min: Any, max: Any) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setRange

        **void QAbstractAxis::setRange(const QVariant & min , const QVariant &
        max )**

        Sets the range shown on the axis. Depending on the actual axis type, the
        **min** and **max** parameters are converted to appropriate types of
        values. If the conversion is impossible, the function call does nothing.
        """
        ...

    def setReverse(self, reverse: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#reverse-prop

        **reverse : bool**

        This property holds whether a reverse axis is used.

        By default, the value is `false`.

        The reverse axis is supported with a line, spline, and scatter series,
        as well as an area series with a cartesian chart. All axes of the same
        orientation attached to the same series must be reversed if one is
        reversed or the behavior is undefined.

        **Access functions:**

        bool **isReverse** () const
        void **setReverse** (bool **reverse** =
        true)

        **Notifier signal:**

        void **reverseChanged** (bool **reverse** )
        """
        ...

    def setShadesBorderColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesBorderColor-prop

        **shadesBorderColor : QColor**

        This property holds the border (pen) color of the axis shades.

        **Access functions:**

        QColor **shadesBorderColor** () const
        void **setShadesBorderColor**
        (QColor **color** )

        **Notifier signal:**

        void ****shadesBorderColorChanged** ** (QColor **color** )
        """
        ...

    def setShadesBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setShadesBrush

        **void QAbstractAxis::setShadesBrush(const QBrush & brush )**

        Sets the brush used to draw shades to **brush**.

        **Note:** Setter function for property **shadesBrush** .

        **See also** **shadesBrush** ().
        """
        ...

    def setShadesColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesColor-prop

        **shadesColor : QColor**

        This property holds the fill (brush) color of the axis shades.

        **Access functions:**

        QColor **shadesColor** () const
        void **setShadesColor** (QColor
        **color** )

        **Notifier signal:**

        void ****shadesColorChanged** ** (QColor **color** )
        """
        ...

    def setShadesPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setShadesPen

        **void QAbstractAxis::setShadesPen(const QPen & pen )**

        Sets the pen used to draw shades to **pen**.

        **Note:** Setter function for property **shadesPen** .

        **See also** **shadesPen** ().
        """
        ...

    def setShadesVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesVisible-prop

        **shadesVisible : bool**

        This property holds the visibility of the axis shades.

        **Access functions:**

        bool **shadesVisible** () const
        void **setShadesVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****shadesVisibleChanged** ** (bool **visible** )
        """
        ...

    def setTitleBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setTitleBrush

        **void QAbstractAxis::setTitleBrush(const QBrush & brush )**

        Sets the brush used to draw titles to **brush**.

        **Note:** Setter function for property **titleBrush** .

        **See also** **titleBrush** ().
        """
        ...

    def setTitleFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setTitleFont

        **void QAbstractAxis::setTitleFont(const QFont & font )**

        Sets the font used to draw titles to **font**.

        **Note:** Setter function for property **titleFont** .

        **See also** **titleFont** ().
        """
        ...

    def setTitleText(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleText-prop

        **titleText : QString**

        This property holds the title of the axis.

        Empty by default. Axis titles support HTML formatting.

        **Access functions:**

        QString **titleText** () const
        void **setTitleText** (const QString &
        **title** )

        **Notifier signal:**

        void ****titleTextChanged** ** (const QString & **text** )
        """
        ...

    def setTitleVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleVisible-prop

        **titleVisible : bool**

        This property holds the visibility of the axis title.

        By default, the value is `true`.

        **Access functions:**

        bool **isTitleVisible** () const
        void **setTitleVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****titleVisibleChanged** ** (bool **visible** )
        """
        ...

    def setTruncateLabels(self, truncateLabels: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#truncateLabels-prop

        **truncateLabels : bool**

        This property holds the truncation state of labels.

        Indicates whether labels should be truncated if there is no enough space
        for full text. It is equal to `true` by default.

        **Access functions:**

        bool **truncateLabels** () const
        void **setTruncateLabels** (bool
        **truncateLabels** = true)

        **Notifier signal:**

        void ****truncateLabelsChanged** ** (bool **truncateLabels** )
        """
        ...

    def setVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#setVisible

        **void QAbstractAxis::setVisible(bool visible = true)**

        Sets the visibility of the axis, shades, labels, and grid lines to
        **visible**.

        **Note:** Setter function for property **visible** .

        **See also** **isVisible** ().
        """
        ...

    def shadesBorderColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesBorderColor-prop

        **shadesBorderColor : QColor**

        This property holds the border (pen) color of the axis shades.

        **Access functions:**

        QColor **shadesBorderColor** () const
        void **setShadesBorderColor**
        (QColor **color** )

        **Notifier signal:**

        void ****shadesBorderColorChanged** ** (QColor **color** )
        """
        ...

    def shadesBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesBrush

        **QBrush QAbstractAxis::shadesBrush() const**

        Returns the brush used to draw shades.

        **Note:** Getter function for property shadesBrush.

        **See also** **setShadesBrush** ().
        """
        ...

    def shadesColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesColor-prop

        **shadesColor : QColor**

        This property holds the fill (brush) color of the axis shades.

        **Access functions:**

        QColor **shadesColor** () const
        void **setShadesColor** (QColor
        **color** )

        **Notifier signal:**

        void ****shadesColorChanged** ** (QColor **color** )
        """
        ...

    def shadesPen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesPen

        **QPen QAbstractAxis::shadesPen() const**

        Returns the pen used to draw shades.

        **Note:** Getter function for property shadesPen.

        **See also** **setShadesPen** ().
        """
        ...

    def shadesVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesVisible-prop

        **shadesVisible : bool**

        This property holds the visibility of the axis shades.

        **Access functions:**

        bool **shadesVisible** () const
        void **setShadesVisible** (bool
        **visible** = true)

        **Notifier signal:**

        void ****shadesVisibleChanged** ** (bool **visible** )
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#show

        **void QAbstractAxis::show()**

        Makes the axis, shades, labels, and grid lines visible.
        """
        ...

    def titleBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleBrush

        **QBrush QAbstractAxis::titleBrush() const**

        Returns the brush used to draw titles.

        **Note:** Getter function for property titleBrush.

        **See also** **setTitleBrush** ().
        """
        ...

    def titleFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleFont

        **QFont QAbstractAxis::titleFont() const**

        Returns the font used to draw titles.

        **Note:** Getter function for property titleFont.

        **See also** **setTitleFont** ().
        """
        ...

    def titleText(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleText-prop

        **titleText : QString**

        This property holds the title of the axis.

        Empty by default. Axis titles support HTML formatting.

        **Access functions:**

        QString **titleText** () const
        void **setTitleText** (const QString &
        **title** )

        **Notifier signal:**

        void ****titleTextChanged** ** (const QString & **text** )
        """
        ...

    def truncateLabels(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#truncateLabels-prop

        **truncateLabels : bool**

        This property holds the truncation state of labels.

        Indicates whether labels should be truncated if there is no enough space
        for full text. It is equal to `true` by default.

        **Access functions:**

        bool **truncateLabels** () const
        void **setTruncateLabels** (bool
        **truncateLabels** = true)

        **Notifier signal:**

        void ****truncateLabelsChanged** ** (bool **truncateLabels** )
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#type

        **[pure virtual] QAbstractAxis::AxisType QAbstractAxis::type() const**

        Returns the type of the axis.
        """
        ...

    @property
    def colorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#colorChanged

        **[signal] void QAbstractAxis::colorChanged(QColor color )**

        This signal is emitted when the color of the axis changes to **color**.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def gridLineColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridLineColorChanged

        **[signal] void QAbstractAxis::gridLineColorChanged(const QColor & color
        )**

        This signal is emitted when the color of the pen used to draw the grid
        line changes to **color**.

        **Note:** Notifier signal for property **gridLineColor** .
        """
        ...

    @property
    def gridLinePenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridLinePenChanged

        **[signal] void QAbstractAxis::gridLinePenChanged(const QPen & pen )**

        This signal is emitted when the pen used to draw the grid line changes
        to **pen**.

        **Note:** Notifier signal for property **gridLinePen** .
        """
        ...

    @property
    def gridVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#gridVisibleChanged

        **[signal] void QAbstractAxis::gridVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the grid lines of the axis
        changes to **visible**.

        **Note:** Notifier signal for property **gridVisible** .
        """
        ...

    @property
    def labelsAngleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsAngleChanged

        **[signal] void QAbstractAxis::labelsAngleChanged(int angle )**

        This signal is emitted when the angle of the axis labels changes to
        **angle**.

        **Note:** Notifier signal for property **labelsAngle** .
        """
        ...

    @property
    def labelsBrushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsBrushChanged

        **[signal] void QAbstractAxis::labelsBrushChanged(const QBrush & brush
        )**

        This signal is emitted when the brush used to draw the axis labels
        changes to **brush**.

        **Note:** Notifier signal for property **labelsBrush** .
        """
        ...

    @property
    def labelsColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsColorChanged

        **[signal] void QAbstractAxis::labelsColorChanged(QColor color )**

        This signal is emitted when the color of the axis labels changes to
        **color**.

        **Note:** Notifier signal for property **labelsColor** .
        """
        ...

    @property
    def labelsEditableChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsEditableChanged

        **[signal, since 5.13] void QAbstractAxis::labelsEditableChanged(bool
        editable )**

        This signal is emitted when the **editable** state of the label changes.

        This function was introduced in Qt 5.13.
        """
        ...

    @property
    def labelsFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsFontChanged

        **[signal] void QAbstractAxis::labelsFontChanged(const QFont & font )**

        This signal is emitted when the font of the axis labels changes to
        **font**.

        **Note:** Notifier signal for property **labelsFont** .
        """
        ...

    @property
    def labelsTruncatedChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsTruncatedChanged

        **[signal, since 6.2] void QAbstractAxis::labelsTruncatedChanged(bool
        labelsTruncated )**

        This signal is emitted in two cases; when the axis changes from having
        one or more truncated labels to having no truncated labels, and when the
        axis changes from having no truncated labels to having one or more
        truncated labels. Current state is identified by **labelsTruncated**.

        **Note:** Notifier signal for property **labelsTruncated** .

        This function was introduced in Qt 6.2.
        """
        ...

    @property
    def labelsVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#labelsVisibleChanged

        **[signal] void QAbstractAxis::labelsVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the labels of the axis
        changes to **visible**.

        **Note:** Notifier signal for property **labelsVisible** .
        """
        ...

    @property
    def linePenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#linePenChanged

        **[signal] void QAbstractAxis::linePenChanged(const QPen & pen )**

        This signal is emitted when the pen used to draw the line of the axis
        changes to **pen**.

        **Note:** Notifier signal for property **linePen** .
        """
        ...

    @property
    def lineVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#lineVisibleChanged

        **[signal] void QAbstractAxis::lineVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the axis line changes to
        **visible**.

        **Note:** Notifier signal for property **lineVisible** .
        """
        ...

    @property
    def minorGridLineColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLineColorChanged

        **[signal] void QAbstractAxis::minorGridLineColorChanged(const QColor &
        color )**

        This signal is emitted when the color of the pen used to draw the minor
        grid line changes to **color**.

        **Note:** Notifier signal for property **minorGridLineColor** .
        """
        ...

    @property
    def minorGridLinePenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridLinePenChanged

        **[signal] void QAbstractAxis::minorGridLinePenChanged(const QPen & pen
        )**

        This signal is emitted when the pen used to draw the minor grid line
        changes to **pen**.

        **Note:** Notifier signal for property **minorGridLinePen** .
        """
        ...

    @property
    def minorGridVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#minorGridVisibleChanged

        **[signal] void QAbstractAxis::minorGridVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the minor grid lines of
        the axis changes to **visible**.

        **Note:** Notifier signal for property **minorGridVisible** .
        """
        ...

    @property
    def reverseChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def shadesBorderColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesBorderColorChanged

        **[signal] void QAbstractAxis::shadesBorderColorChanged(QColor color )**

        This signal is emitted when the border color of the axis shades changes
        to **color**.

        **Note:** Notifier signal for property **shadesBorderColor** .
        """
        ...

    @property
    def shadesBrushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesBrushChanged

        **[signal] void QAbstractAxis::shadesBrushChanged(const QBrush & brush
        )**

        This signal is emitted when the brush used to draw the axis shades
        changes to **brush**.

        **Note:** Notifier signal for property **shadesBrush** .
        """
        ...

    @property
    def shadesColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesColorChanged

        **[signal] void QAbstractAxis::shadesColorChanged(QColor color )**

        This signal is emitted when the color of the axis shades changes to
        **color**.

        **Note:** Notifier signal for property **shadesColor** .
        """
        ...

    @property
    def shadesPenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesPenChanged

        **[signal] void QAbstractAxis::shadesPenChanged(const QPen & pen )**

        This signal is emitted when the pen used to draw the axis shades changes
        to **pen**.

        **Note:** Notifier signal for property **shadesPen** .
        """
        ...

    @property
    def shadesVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#shadesVisibleChanged

        **[signal] void QAbstractAxis::shadesVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the axis shades changes to
        **visible**.

        **Note:** Notifier signal for property **shadesVisible** .
        """
        ...

    @property
    def titleBrushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleBrushChanged

        **[signal] void QAbstractAxis::titleBrushChanged(const QBrush & brush
        )**

        This signal is emitted when the brush used to draw the axis title
        changes to **brush**.

        **Note:** Notifier signal for property **titleBrush** .
        """
        ...

    @property
    def titleFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleFontChanged

        **[signal] void QAbstractAxis::titleFontChanged(const QFont & font )**

        This signal is emitted when the font of the axis title changes to
        **font**.

        **Note:** Notifier signal for property **titleFont** .
        """
        ...

    @property
    def titleTextChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleTextChanged

        **[signal] void QAbstractAxis::titleTextChanged(const QString & text )**

        This signal is emitted when the text of the axis title changes to
        **text**.

        **Note:** Notifier signal for property **titleText** .
        """
        ...

    @property
    def titleVisibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#titleVisibleChanged

        **[signal] void QAbstractAxis::titleVisibleChanged(bool visible )**

        This signal is emitted when the visibility of the title text of the axis
        changes to **visible**.

        **Note:** Notifier signal for property **titleVisible** .
        """
        ...

    @property
    def truncateLabelsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#truncateLabelsChanged

        **[signal, since 6.2] void QAbstractAxis::truncateLabelsChanged(bool
        truncateLabels )**

        This signal is emitted when the truncation of the labels changes to
        **truncateLabels**.

        **Note:** Notifier signal for property **truncateLabels** .

        This function was introduced in Qt 6.2.
        """
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractaxis.html#visibleChanged

        **[signal] void QAbstractAxis::visibleChanged(bool visible )**

        This signal is emitted when the visibility of the axis changes to
        **visible**.

        **Note:** Notifier signal for property **visible** .
        """
        ...
