"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QLowEnergyDescriptorData(object):
    """
    https://doc.qt.io/qt-6/qlowenergydescriptordata.html

    **Detailed Description**

    An object of this class provides a descriptor to be added to a
    **QLowEnergyCharacteristicData**  object via
    **QLowEnergyCharacteristicData::addDescriptor** ().

    **Note:** The member functions related to access permissions are only
    applicable to those types of descriptors for which the Bluetooth
    specification does not prescribe if and how their values can be accessed.

    **See also** **QLowEnergyCharacteristicData** , **QLowEnergyServiceData** ,
    and **QLowEnergyController::addService** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#QLowEnergyDescripto
        rData

        **QLowEnergyDescriptorData::QLowEnergyDescriptorData()**

        Creates a new invalid object of this class.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtBluetooth.QLowEnergyDescriptorData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#QLowEnergyDescripto
        rData-1

        **QLowEnergyDescriptorData::QLowEnergyDescriptorData(const
        QBluetoothUuid & uuid , const QByteArray & value )**

        Creates a new object of this class with UUID and value being provided by
        **uuid** and **value** , respectively.
        """
        ...

    @overload
    def __init__(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
        value: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#QLowEnergyDescripto
        rData-2

        **QLowEnergyDescriptorData::QLowEnergyDescriptorData(const
        QLowEnergyDescriptorData & other )**

        Constructs a new object of this class that is a copy of **other**.
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#isReadable

        **bool QLowEnergyDescriptorData::isReadable() const**

        Returns `true` if the value of this descriptor is readable and `false`
        otherwise.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#isValid

        **bool QLowEnergyDescriptorData::isValid() const**

        Returns true if and only if this object has a non-null UUID.
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#isWritable

        **bool QLowEnergyDescriptorData::isWritable() const**

        Returns `true` if the value of this descriptor is writable and `false`
        otherwise.
        """
        ...

    def readConstraints(self) -> PySide6.QtBluetooth.QBluetooth.AttAccessConstraints:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#readConstraints

        **QBluetooth::AttAccessConstraints
        QLowEnergyDescriptorData::readConstraints() const**

        Returns the constraints under which the value of this descriptor can be
        read. This value is only relevant if **isReadable** () returns `true`.
        """
        ...

    def setReadPermissions(
        self,
        readable: bool,
        constraints: PySide6.QtBluetooth.QBluetooth.AttAccessConstraints = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#setReadPermissions

        **void QLowEnergyDescriptorData::setReadPermissions(bool readable ,
        QBluetooth::AttAccessConstraints constraints =
        QBluetooth::AttAccessConstraints())**

        Specifies whether the value of this descriptor is **readable** and if
        so, under which **constraints**.

        **See also** **setWritePermissions** ().
        """
        ...

    def setUuid(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#setUuid

        **void QLowEnergyDescriptorData::setUuid(const QBluetoothUuid & uuid )**

        Sets the UUID of this descriptor to **uuid**.

        **See also** **uuid** ().
        """
        ...

    def setValue(self, value: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#setValue

        **void QLowEnergyDescriptorData::setValue(const QByteArray & value )**

        Sets the value of this descriptor to **value**. It will be sent to a
        peer device exactly the way it is provided here, so callers need to take
        care of things such as endianness.

        **See also** **value** ().
        """
        ...

    def setWritePermissions(
        self,
        writable: bool,
        constraints: PySide6.QtBluetooth.QBluetooth.AttAccessConstraints = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#setWritePermissions

        **void QLowEnergyDescriptorData::setWritePermissions(bool writable ,
        QBluetooth::AttAccessConstraints constraints =
        QBluetooth::AttAccessConstraints())**

        Specifies whether the value of this descriptor is **writable** and if
        so, under which **constraints**.

        **See also** **setReadPermissions** ().
        """
        ...

    def swap(self, other: PySide6.QtBluetooth.QLowEnergyDescriptorData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#swap

        **void QLowEnergyDescriptorData::swap(QLowEnergyDescriptorData & other
        )**

        Swaps this object with **other**.
        """
        ...

    def uuid(self) -> PySide6.QtBluetooth.QBluetoothUuid:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#uuid

        **QBluetoothUuid QLowEnergyDescriptorData::uuid() const**

        Returns the UUID of this descriptor.

        **See also** **setUuid** ().
        """
        ...

    def value(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#value

        **QByteArray QLowEnergyDescriptorData::value() const**

        Returns the value of this descriptor.

        **See also** **setValue** ().
        """
        ...

    def writeConstraints(self) -> PySide6.QtBluetooth.QBluetooth.AttAccessConstraints:
        """
        https://doc.qt.io/qt-6/qlowenergydescriptordata.html#writeConstraints

        **QBluetooth::AttAccessConstraints
        QLowEnergyDescriptorData::writeConstraints() const**

        Returns the constraints under which the value of this descriptor can be
        written. This value is only relevant if **isWritable** () returns
        `true`.
        """
        ...
