"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QLowEnergyAdvertisingParameters(object):
    """
    https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html

    **Detailed Description**

    When running the advertising procedure, a number of parameters can be
    configured, such as how fast to advertise or which clients, if any, can
    connect to the advertising device. These parameters are set via this class,
    and their values will be used when advertising is started by calling
    **QLowEnergyController::startAdvertising** ().

    **See also** **QLowEnergyAdvertisingData**  and
    **QLowEnergyController::startAdvertising** ().
    """

    IgnoreWhiteList: QLowEnergyAdvertisingParameters.FilterPolicy = ...
    UseWhiteListForScanning: QLowEnergyAdvertisingParameters.FilterPolicy = ...
    UseWhiteListForConnecting: QLowEnergyAdvertisingParameters.FilterPolicy = ...
    UseWhiteListForScanningAndConnecting: QLowEnergyAdvertisingParameters.FilterPolicy = (
        ...
    )
    AdvInd: QLowEnergyAdvertisingParameters.Mode = ...
    AdvScanInd: QLowEnergyAdvertisingParameters.Mode = ...
    AdvNonConnInd: QLowEnergyAdvertisingParameters.Mode = ...

    class AddressInfo(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            AddressInfo: PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.AddressInfo,
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            addr: PySide6.QtBluetooth.QBluetoothAddress,
            t: PySide6.QtBluetooth.QLowEnergyController.RemoteAddressType,
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class FilterPolicy(Enum):
        IgnoreWhiteList: QLowEnergyAdvertisingParameters.FilterPolicy = ...
        UseWhiteListForScanning: QLowEnergyAdvertisingParameters.FilterPolicy = ...
        UseWhiteListForConnecting: QLowEnergyAdvertisingParameters.FilterPolicy = ...
        UseWhiteListForScanningAndConnecting: QLowEnergyAdvertisingParameters.FilterPolicy = (
            ...
        )

    class Mode(Enum):
        AdvInd: QLowEnergyAdvertisingParameters.Mode = ...
        AdvScanInd: QLowEnergyAdvertisingParameters.Mode = ...
        AdvNonConnInd: QLowEnergyAdvertisingParameters.Mode = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#QLowEnergyAd
        vertisingParameters

        **QLowEnergyAdvertisingParameters::QLowEnergyAdvertisingParameters()**

        Constructs a new object of this class. All values are initialized to
        their defaults according to the Bluetooth Low Energy specification.
        """
        ...

    @overload
    def __init__(
        self, other: PySide6.QtBluetooth.QLowEnergyAdvertisingParameters
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#QLowEnergyAd
        vertisingParameters-1

        **QLowEnergyAdvertisingParameters::QLowEnergyAdvertisingParameters(const
        QLowEnergyAdvertisingParameters & other )**

        Constructs a new object of this class that is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def filterPolicy(
        self,
    ) -> PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.FilterPolicy:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#filterPolicy

        **QLowEnergyAdvertisingParameters::FilterPolicy
        QLowEnergyAdvertisingParameters::filterPolicy() const**

        Returns the filter policy that determines how the white list is used.
        The default is **QLowEnergyAdvertisingParameters::IgnoreWhiteList** .
        """
        ...

    def maximumInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#maximumInter
        val

        **int QLowEnergyAdvertisingParameters::maximumInterval() const**

        Returns the maximum advertising interval in milliseconds. The default is
        1280.
        """
        ...

    def minimumInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#minimumInter
        val

        **int QLowEnergyAdvertisingParameters::minimumInterval() const**

        Returns the minimum advertising interval in milliseconds. The default is
        1280.
        """
        ...

    def mode(self) -> PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.Mode:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#mode

        **QLowEnergyAdvertisingParameters::Mode
        QLowEnergyAdvertisingParameters::mode() const**

        Returns the advertising mode. The default is
        **QLowEnergyAdvertisingParameters::AdvInd** .

        **See also** **setMode** ().
        """
        ...

    def setInterval(self, minimum: int, maximum: int) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#setInterval

        **void QLowEnergyAdvertisingParameters::setInterval(quint16 minimum ,
        quint16 maximum )**

        Sets the advertising interval. This is a range that gives the controller
        an upper and a lower bound for how often to send the advertising data.
        Both **minimum** and **maximum** are given in milliseconds. If
        **maximum** is smaller than **minimum** , it will be set to the value of
        **minimum**.

        **Note:** There are limits for the minimum and maximum interval; the
        exact values depend on the mode. If they are exceeded, the lowest or
        highest possible value will be used, respectively.
        """
        ...

    def setMode(
        self, mode: PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.Mode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#setMode

        **void QLowEnergyAdvertisingParameters::setMode(QLowEnergyAdvertisingPar
        ameters::Mode mode )**

        Sets the advertising mode to **mode**.

        **See also** **mode** ().
        """
        ...

    def setWhiteList(
        self,
        whiteList: Sequence[
            PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.AddressInfo
        ],
        policy: PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.FilterPolicy,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#setWhiteList

        **void QLowEnergyAdvertisingParameters::setWhiteList(const
        QList<QLowEnergyAdvertisingParameters::AddressInfo> & whiteList ,
        QLowEnergyAdvertisingParameters::FilterPolicy policy )**

        Sets the white list that is potentially used for filtering scan and
        connection requests. The **whiteList** parameter is the list of
        addresses to use for filtering, and **policy** specifies how exactly to
        use **whiteList**.

        **See also** **whiteList** ().
        """
        ...

    def swap(self, other: PySide6.QtBluetooth.QLowEnergyAdvertisingParameters) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#swap

        **void
        QLowEnergyAdvertisingParameters::swap(QLowEnergyAdvertisingParameters &
        other )**

        Swaps this object with **other**.
        """
        ...

    def whiteList(
        self,
    ) -> List[PySide6.QtBluetooth.QLowEnergyAdvertisingParameters.AddressInfo]:
        """
        https://doc.qt.io/qt-6/qlowenergyadvertisingparameters.html#whiteList

        **QList<QLowEnergyAdvertisingParameters::AddressInfo>
        QLowEnergyAdvertisingParameters::whiteList() const**

        Returns the white list used for filtering scan and connection requests.
        By default, this list is empty.

        **See also** **setWhiteList** ().
        """
        ...
