"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QBluetoothHostInfo(object):
    """
    https://doc.qt.io/qt-6/qbluetoothhostinfo.html

    **Detailed Description**

    This class holds the name and address of a local Bluetooth device.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#QBluetoothHostInfo

        **QBluetoothHostInfo::QBluetoothHostInfo()**

        Constructs a null QBluetoothHostInfo object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtBluetooth.QBluetoothHostInfo) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#QBluetoothHostInfo-1

        **QBluetoothHostInfo::QBluetoothHostInfo(const QBluetoothHostInfo &
        other )**

        Constructs a new QBluetoothHostInfo which is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def address(self) -> PySide6.QtBluetooth.QBluetoothAddress:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#address

        **QBluetoothAddress QBluetoothHostInfo::address() const**

        Returns the Bluetooth address as a **QBluetoothAddress** .

        **See also** **setAddress** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#name

        **QString QBluetoothHostInfo::name() const**

        Returns the user visible name of the host info object.

        **See also** **setName** ().
        """
        ...

    def setAddress(self, address: PySide6.QtBluetooth.QBluetoothAddress) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#setAddress

        **void QBluetoothHostInfo::setAddress(const QBluetoothAddress & address
        )**

        Sets the Bluetooth **address** for this Bluetooth host info object.

        **See also** **address** ().
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothhostinfo.html#setName

        **void QBluetoothHostInfo::setName(const QString & name )**

        Sets the **name** of the host info object.

        **See also** **name** ().
        """
        ...
