"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtAxContainer, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtAxContainer

bytes = str


class QAxScriptManager(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaxscriptmanager.html

    **Detailed Description**

    The QAxScriptManager acts as a bridge between the COM objects embedded in
    the Qt application through **QAxObject**  or **QAxWidget** , and the
    scripting languages available through the Windows Script technologies,
    usually JScript and VBScript.

    Create one QAxScriptManager for each separate document in your application,
    and add the COM objects the scripts need to access using **addObject** ().
    Then **load** () the script sources and invoke the functions using **call**
    ().

    **Warning:** This class is not available with the bcc5.5 compiler.

    **See also** **QAxScript** , **QAxScriptEngine** , **QAxBase** , and
    **ActiveQt Framework** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#QAxScriptManager

        **QAxScriptManager::QAxScriptManager(QObject * parent = nullptr)**

        Creates a QAxScriptManager object. **parent** is passed on to the
        **QObject**  constructor.

        It is usual to create one QAxScriptManager for each document in an
        application.
        """
        ...

    def addObject(self, object: PySide6.QtAxContainer.QAxBase) -> None:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#addObject

        **void QAxScriptManager::addObject(QAxBase * object )**

        Adds **object** to the manager. Scripts handled by this manager can
        access the object in the code using the object's **objectName**
        property.

        You must add all the necessary objects before loading any scripts.
        """
        ...

    @overload
    def call(self, function: str, arguments: Sequence[Any]) -> Any:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#call

        **QVariant QAxScriptManager::call(const QString & function , const
        QVariant & var1 = QVariant(), const QVariant & var2 = QVariant(), const
        QVariant & var3 = QVariant(), const QVariant & var4 = QVariant(), const
        QVariant & var5 = QVariant(), const QVariant & var6 = QVariant(), const
        QVariant & var7 = QVariant(), const QVariant & var8 = QVariant())**

        Calls **function** , passing the parameters **var1** , **var1** ,
        **var2** , **var3** , **var4** , **var5** , **var6** , **var7** and
        **var8** as arguments and returns the value returned by the function, or
        an invalid **QVariant**  if the function does not return a value or when
        the function call failed. The call returns when the script's execution
        has finished.

        In most script engines the only supported parameter type is "const
        **QVariant** &", for example, to call a JavaScript function

        function setNumber(number)
            {
                n = number;
            }

        use

        QValueList args;
            args << 5;
            script->call("setNumber(const
        QVariant&)", args);

        As with **dynamicCall**  the parameters can directly be embedded in the
        function string.

        script->call("setNumber(5)");

        However, this is slower.

        Functions provided by script engines that don't support introspection
        are not available and must be called directly using **QAxScript::call**
        () on the respective **script**  object.

        Note that calling this function can be significantely slower than using
        call() on the respective **QAxScript**  directly.
        """
        ...

    @overload
    def call(
        self,
        function: str,
        v1: Any = ...,
        v2: Any = ...,
        v3: Any = ...,
        v4: Any = ...,
        v5: Any = ...,
        v6: Any = ...,
        v7: Any = ...,
        v8: Any = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#call-1

        **QVariant QAxScriptManager::call(const QString & function ,
        QList<QVariant> & arguments )**

        This is an overloaded function.

        Calls **function** passing **arguments** as parameters, and returns the
        result. Returns when the script's execution has finished.
        """
        ...

    def functions(
        self, arg__1: PySide6.QtAxContainer.QAxScript.FunctionFlags = ...
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#functions

        **QStringList QAxScriptManager::functions(QAxScript::FunctionFlags flags
        = QAxScript::FunctionNames) const**

        Returns a list with all the functions that are available. Functions
        provided by script engines that don't support introspection are not
        included in the list. The functions are either provided with full
        prototypes or only as names, depending on the value of **flags**.
        """
        ...

    @overload
    def load(
        self, code: str, name: str, language: str
    ) -> PySide6.QtAxContainer.QAxScript:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#load

        **QAxScript *QAxScriptManager::load(const QString & code , const QString
        & name , const QString & language )**

        Loads the script source **code** using the script engine for
        **language**. The script can later be referred to using its **name**
        which should not be empty.

        The function returns a pointer to the script for the given **code** if
        the **code** was loaded successfully; otherwise it returns 0.

        If **language** is empty it will be determined heuristically. If
        **code** contains the string "End Sub" it will be interpreted as
        VBScript, otherwise as JScript. Additional script engines can be
        registered using **registerEngine** ().

        You must add all the objects necessary (using **addObject** ())
        **before** loading any scripts. If **code** declares a function that is
        already available (no matter in which language) the first function is
        overloaded and can no longer be called via **call** (); but it will
        still be available by calling its **script**  directly.

        **See also** **addObject** (), **scriptNames** (), and **functions** ().
        """
        ...

    @overload
    def load(self, file: str, name: str) -> PySide6.QtAxContainer.QAxScript:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#load-1

        **QAxScript *QAxScriptManager::load(const QString & file , const QString
        & name )**

        This is an overloaded function.

        Loads the source code from the **file**. The script can later be
        referred to using its **name** which should not be empty.

        The function returns a pointer to the script engine for the code in
        **file** if **file** was loaded successfully; otherwise it returns 0.

        The script engine used is determined from the file's extension. By
        default ".js" files are interpreted as JScript files, and ".vbs" and
        ".dsm" files are interpreted as VBScript. Additional script engines can
        be registered using **registerEngine** ().
        """
        ...

    @staticmethod
    def registerEngine(name: str, extension: str, code: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#registerEngine

        **[static] bool QAxScriptManager::registerEngine(const QString & name ,
        const QString & extension , const QString & code = QString())**

        Registers the script engine called **name** and returns true if the
        engine was found; otherwise does nothing and returns false.

        The script engine will be used when loading files with the given
        **extension** , or when loading source code that contains the string
        **code**.
        """
        ...

    def script(self, name: str) -> PySide6.QtAxContainer.QAxScript:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#script

        **QAxScript *QAxScriptManager::script(const QString & name ) const**

        Returns the script called **name**.

        You can use the returned pointer to call functions directly through
        **QAxScript::call** (), to access the script engine directly, or to
        delete and thus unload the script.
        """
        ...

    @staticmethod
    def scriptFileFilter() -> str:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#scriptFileFilter

        **[static] QString QAxScriptManager::scriptFileFilter()**

        Returns a file filter listing all the supported script languages. This
        filter string is convenient for use with **QFileDialog** .
        """
        ...

    def scriptNames(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#scriptNames

        **QStringList QAxScriptManager::scriptNames() const**

        Returns a list with the names of all the scripts.
        """
        ...

    @property
    def error(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscriptmanager.html#error

        **[signal] void QAxScriptManager::error(QAxScript * script , int code ,
        const QString & description , int sourcePosition , const QString &
        sourceText )**

        This signal is emitted when an execution error occurred while running
        **script**.

        **code** , **description** , **sourcePosition** and **sourceText**
        contain information about the execution error.

        **Warning:** Do not delete **script** in a slot connected to this
        signal. Use **deleteLater** () instead.
        """
        ...
