"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtAxContainer, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtAxContainer

bytes = str


class QAxScriptEngine(PySide6.QtAxContainer.QAxObject):
    """
    https://doc.qt.io/qt-6/qaxscriptengine.html

    **Detailed Description**

    Every instance of the QAxScriptEngine class represents an interpreter for
    script code in a particular scripting language. The class is usually not
    used directly. The **QAxScript**  and **QAxScriptManager**  classes provide
    convenient functions to handle and call script code.

    Direct access to the script engine is provided through **queryInterface**
    ().

    **Warning:** This class is not available with the bcc5.5 compiler.

    **See also** **QAxScript** , **QAxScriptManager** , **QAxBase** , and
    **ActiveQt Framework** .
    """

    Uninitialized: QAxScriptEngine.State = ...
    Started: QAxScriptEngine.State = ...
    Connected: QAxScriptEngine.State = ...
    Disconnected: QAxScriptEngine.State = ...
    Closed: QAxScriptEngine.State = ...
    Initialized: QAxScriptEngine.State = ...

    class State(Enum):
        Uninitialized: QAxScriptEngine.State = ...
        Started: QAxScriptEngine.State = ...
        Connected: QAxScriptEngine.State = ...
        Disconnected: QAxScriptEngine.State = ...
        Closed: QAxScriptEngine.State = ...
        Initialized: QAxScriptEngine.State = ...

    def __init__(self, language: str, script: PySide6.QtAxContainer.QAxScript) -> None:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#QAxScriptEngine

        **QAxScriptEngine::QAxScriptEngine(const QString & language , QAxScript
        * script )**

        Constructs a QAxScriptEngine object interpreting script code in
        **language** provided by the code in **script**. This is usually done by
        the **QAxScript**  class when **loading a script** .

        Instances of QAxScriptEngine should always have both a language and a
        script.
        """
        ...

    def addItem(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#addItem

        **void QAxScriptEngine::addItem(const QString & name )**

        Registers an item with the script engine. Script code can refer to this
        item using **name**.
        """
        ...

    def hasIntrospection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#hasIntrospection

        **bool QAxScriptEngine::hasIntrospection() const**

        Returns true if the script engine supports introspection; otherwise
        returns false.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#isValid

        **bool QAxScriptEngine::isValid() const**

        Returns true if the script engine has been initialized correctly;
        otherwise returns false.
        """
        ...

    def scriptLanguage(self) -> str:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#scriptLanguage

        **QString QAxScriptEngine::scriptLanguage() const**

        Returns the scripting language, for example "VBScript", or "JScript".
        """
        ...

    def setState(self, st: PySide6.QtAxContainer.QAxScriptEngine.State) -> None:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#setState

        **void QAxScriptEngine::setState(QAxScriptEngine::State st )**

        Sets the state of the script engine to **st**. Calling this function is
        usually not necessary.

        **See also** **state** ().
        """
        ...

    def state(self) -> PySide6.QtAxContainer.QAxScriptEngine.State:
        """
        https://doc.qt.io/qt-6/qaxscriptengine.html#state

        **QAxScriptEngine::State QAxScriptEngine::state() const**

        Returns the state of the script engine.

        **See also** **setState** ().
        """
        ...
