"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.Qt3DRender, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.Qt3DCore
import PySide6.Qt3DRender

bytes = str


class Qt3DRender(object):
    """
    https://doc.qt.io/qt-6/qt3drender.html

    **Detailed Description**
    """

    class API(Enum):
        OpenGL: Qt3DRender.API = ...
        Vulkan: Qt3DRender.API = ...
        DirectX: Qt3DRender.API = ...
        Metal: Qt3DRender.API = ...
        RHI: Qt3DRender.API = ...
        Null: Qt3DRender.API = ...

    class PropertyReaderInterface(object):
        def __init__(self) -> None:
            ...

        def readProperty(self, v: Any) -> Any:
            ...

    class QAbstractLight(PySide6.Qt3DCore.Qt3DCore.QComponent):
        PointLight: Qt3DRender.QAbstractLight.Type = ...
        DirectionalLight: Qt3DRender.QAbstractLight.Type = ...
        SpotLight: Qt3DRender.QAbstractLight.Type = ...

        class Type(Enum):
            PointLight: Qt3DRender.QAbstractLight.Type = ...
            DirectionalLight: Qt3DRender.QAbstractLight.Type = ...
            SpotLight: Qt3DRender.QAbstractLight.Type = ...

        def color(self) -> PySide6.QtGui.QColor:
            ...

        def intensity(self) -> float:
            ...

        def setColor(
            self,
            color: Union[
                PySide6.QtGui.QColor,
                PySide6.QtGui.QRgba64,
                Any,
                PySide6.QtCore.Qt.GlobalColor,
                str,
                int,
            ],
        ) -> None:
            ...

        def setIntensity(self, intensity: float) -> None:
            ...

        def type(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractLight.Type:
            ...

    class QAbstractRayCaster(PySide6.Qt3DCore.Qt3DCore.QComponent):
        AcceptAnyMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
        AcceptAllMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
        DiscardAnyMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
        DiscardAllMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
        Continuous: Qt3DRender.QAbstractRayCaster.RunMode = ...
        SingleShot: Qt3DRender.QAbstractRayCaster.RunMode = ...

        class FilterMode(Enum):
            AcceptAnyMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
            AcceptAllMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
            DiscardAnyMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...
            DiscardAllMatchingLayers: Qt3DRender.QAbstractRayCaster.FilterMode = ...

        class RunMode(Enum):
            Continuous: Qt3DRender.QAbstractRayCaster.RunMode = ...
            SingleShot: Qt3DRender.QAbstractRayCaster.RunMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addLayer(self, layer: PySide6.Qt3DRender.Qt3DRender.QLayer) -> None:
            ...

        def filterMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode:
            ...

        def hits(self) -> List[PySide6.Qt3DRender.Qt3DRender.QRayCasterHit]:
            ...

        def layers(self) -> List[PySide6.Qt3DRender.Qt3DRender.QLayer]:
            ...

        def removeLayer(self, layer: PySide6.Qt3DRender.Qt3DRender.QLayer) -> None:
            ...

        def runMode(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode:
            ...

        def setFilterMode(
            self,
            filterMode: PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode,
        ) -> None:
            ...

        def setRunMode(
            self, runMode: PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode
        ) -> None:
            ...

    class QAbstractTexture(PySide6.Qt3DCore.Qt3DCore.QNode):
        CompareNever: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareLess: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareLessEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareGreater: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CommpareNotEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareGreaterEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareAlways: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
        CompareNone: Qt3DRender.QAbstractTexture.ComparisonMode = ...
        CompareRefToTexture: Qt3DRender.QAbstractTexture.ComparisonMode = ...
        CubeMapPositiveX: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        CubeMapNegativeX: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        CubeMapPositiveY: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        CubeMapNegativeY: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        CubeMapPositiveZ: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        CubeMapNegativeZ: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        AllFaces: Qt3DRender.QAbstractTexture.CubeMapFace = ...
        Nearest: Qt3DRender.QAbstractTexture.Filter = ...
        Linear: Qt3DRender.QAbstractTexture.Filter = ...
        NearestMipMapNearest: Qt3DRender.QAbstractTexture.Filter = ...
        LinearMipMapNearest: Qt3DRender.QAbstractTexture.Filter = ...
        NearestMipMapLinear: Qt3DRender.QAbstractTexture.Filter = ...
        LinearMipMapLinear: Qt3DRender.QAbstractTexture.Filter = ...
        NoHandle: Qt3DRender.QAbstractTexture.HandleType = ...
        OpenGLTextureId: Qt3DRender.QAbstractTexture.HandleType = ...
        None_: Qt3DRender.QAbstractTexture.Status = ...
        Loading: Qt3DRender.QAbstractTexture.Status = ...
        Ready: Qt3DRender.QAbstractTexture.Status = ...
        Error: Qt3DRender.QAbstractTexture.Status = ...
        TargetAutomatic: Qt3DRender.QAbstractTexture.Target = ...
        Target1D: Qt3DRender.QAbstractTexture.Target = ...
        Target2D: Qt3DRender.QAbstractTexture.Target = ...
        Target3D: Qt3DRender.QAbstractTexture.Target = ...
        TargetRectangle: Qt3DRender.QAbstractTexture.Target = ...
        TargetCubeMap: Qt3DRender.QAbstractTexture.Target = ...
        Target1DArray: Qt3DRender.QAbstractTexture.Target = ...
        Target2DArray: Qt3DRender.QAbstractTexture.Target = ...
        TargetBuffer: Qt3DRender.QAbstractTexture.Target = ...
        TargetCubeMapArray: Qt3DRender.QAbstractTexture.Target = ...
        Target2DMultisample: Qt3DRender.QAbstractTexture.Target = ...
        Target2DMultisampleArray: Qt3DRender.QAbstractTexture.Target = ...
        NoFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        Automatic: Qt3DRender.QAbstractTexture.TextureFormat = ...
        DepthFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        AlphaFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBAFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        LuminanceFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        LuminanceAlphaFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG3B2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA4: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB5A1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB10A2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D16: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D24: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D32: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA_DXT3: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA_DXT5: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D24S8: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG11B10F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB9E5: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB8: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB8_Alpha8: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB_Alpha_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB_Alpha_DXT3: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB_Alpha_DXT5: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
        D32FS8X24: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R5G6B5: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8_ETC1: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R_ATI1N_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R_ATI1N_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG_ATI2N_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG_ATI2N_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB_BP_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB_BP_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB_BP_SIGNED_FLOAT: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB_BP_UNSIGNED_FLOAT: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB10A2U: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R11_EAC_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        R11_EAC_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG11_EAC_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RG11_EAC_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB8_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
        RGBA8_ETC2_EAC: Qt3DRender.QAbstractTexture.TextureFormat = ...
        SRGB8_Alpha8_ETC2_EAC: Qt3DRender.QAbstractTexture.TextureFormat = ...

        class ComparisonFunction(Enum):
            CompareNever: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareLess: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareLessEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareGreater: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CommpareNotEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareGreaterEqual: Qt3DRender.QAbstractTexture.ComparisonFunction = ...
            CompareAlways: Qt3DRender.QAbstractTexture.ComparisonFunction = ...

        class ComparisonMode(Enum):
            CompareNone: Qt3DRender.QAbstractTexture.ComparisonMode = ...
            CompareRefToTexture: Qt3DRender.QAbstractTexture.ComparisonMode = ...

        class CubeMapFace(Enum):
            CubeMapPositiveX: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            CubeMapNegativeX: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            CubeMapPositiveY: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            CubeMapNegativeY: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            CubeMapPositiveZ: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            CubeMapNegativeZ: Qt3DRender.QAbstractTexture.CubeMapFace = ...
            AllFaces: Qt3DRender.QAbstractTexture.CubeMapFace = ...

        class Filter(Enum):
            Nearest: Qt3DRender.QAbstractTexture.Filter = ...
            Linear: Qt3DRender.QAbstractTexture.Filter = ...
            NearestMipMapNearest: Qt3DRender.QAbstractTexture.Filter = ...
            LinearMipMapNearest: Qt3DRender.QAbstractTexture.Filter = ...
            NearestMipMapLinear: Qt3DRender.QAbstractTexture.Filter = ...
            LinearMipMapLinear: Qt3DRender.QAbstractTexture.Filter = ...

        class HandleType(Enum):
            NoHandle: Qt3DRender.QAbstractTexture.HandleType = ...
            OpenGLTextureId: Qt3DRender.QAbstractTexture.HandleType = ...

        class Status(Enum):
            None_: Qt3DRender.QAbstractTexture.Status = ...
            Loading: Qt3DRender.QAbstractTexture.Status = ...
            Ready: Qt3DRender.QAbstractTexture.Status = ...
            Error: Qt3DRender.QAbstractTexture.Status = ...

        class Target(Enum):
            TargetAutomatic: Qt3DRender.QAbstractTexture.Target = ...
            Target1D: Qt3DRender.QAbstractTexture.Target = ...
            Target2D: Qt3DRender.QAbstractTexture.Target = ...
            Target3D: Qt3DRender.QAbstractTexture.Target = ...
            TargetRectangle: Qt3DRender.QAbstractTexture.Target = ...
            TargetCubeMap: Qt3DRender.QAbstractTexture.Target = ...
            Target1DArray: Qt3DRender.QAbstractTexture.Target = ...
            Target2DArray: Qt3DRender.QAbstractTexture.Target = ...
            TargetBuffer: Qt3DRender.QAbstractTexture.Target = ...
            TargetCubeMapArray: Qt3DRender.QAbstractTexture.Target = ...
            Target2DMultisample: Qt3DRender.QAbstractTexture.Target = ...
            Target2DMultisampleArray: Qt3DRender.QAbstractTexture.Target = ...

        class TextureFormat(Enum):
            NoFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            Automatic: Qt3DRender.QAbstractTexture.TextureFormat = ...
            DepthFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            AlphaFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBAFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            LuminanceFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            LuminanceAlphaFormat: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG3B2: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA4: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB5A1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB10A2: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D16: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D24: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D32: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG8_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG16_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA_DXT3: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA_DXT5: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB16F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D24S8: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG11B10F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB9E5: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB8: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB8_Alpha8: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB_Alpha_DXT1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB_Alpha_DXT3: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB_Alpha_DXT5: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D32F: Qt3DRender.QAbstractTexture.TextureFormat = ...
            D32FS8X24: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R5G6B5: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8_ETC1: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB32U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB16U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB32I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB16I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8I: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R_ATI1N_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R_ATI1N_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG_ATI2N_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG_ATI2N_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB_BP_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB_BP_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB_BP_SIGNED_FLOAT: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB_BP_UNSIGNED_FLOAT: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA8_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGBA16_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB10A2U: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R11_EAC_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            R11_EAC_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG11_EAC_UNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RG11_EAC_SNorm: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB8_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ...
            RGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = (
                ...
            )
            SRGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = (
                ...
            )
            RGBA8_ETC2_EAC: Qt3DRender.QAbstractTexture.TextureFormat = ...
            SRGB8_Alpha8_ETC2_EAC: Qt3DRender.QAbstractTexture.TextureFormat = ...

        @overload
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            target: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Target,
            parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...,
        ) -> None:
            ...

        def addTextureImage(
            self, textureImage: PySide6.Qt3DRender.Qt3DRender.QAbstractTextureImage
        ) -> None:
            ...

        def comparisonFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction:
            ...

        def comparisonMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode:
            ...

        def depth(self) -> int:
            ...

        def format(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat:
            ...

        def generateMipMaps(self) -> bool:
            ...

        def handle(self) -> Any:
            ...

        def handleType(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType:
            ...

        def height(self) -> int:
            ...

        def layers(self) -> int:
            ...

        def magnificationFilter(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter:
            ...

        def maximumAnisotropy(self) -> float:
            ...

        def minificationFilter(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter:
            ...

        def mipLevels(self) -> int:
            ...

        def removeTextureImage(
            self, textureImage: PySide6.Qt3DRender.Qt3DRender.QAbstractTextureImage
        ) -> None:
            ...

        def samples(self) -> int:
            ...

        def setComparisonFunction(
            self,
            function: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction,
        ) -> None:
            ...

        def setComparisonMode(
            self, mode: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode
        ) -> None:
            ...

        def setDepth(self, depth: int) -> None:
            ...

        def setFormat(
            self, format: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat
        ) -> None:
            ...

        def setGenerateMipMaps(self, gen: bool) -> None:
            ...

        def setHandle(self, handle: Any) -> None:
            ...

        def setHandleType(
            self, type: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType
        ) -> None:
            ...

        def setHeight(self, height: int) -> None:
            ...

        def setLayers(self, layers: int) -> None:
            ...

        def setMagnificationFilter(
            self, f: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter
        ) -> None:
            ...

        def setMaximumAnisotropy(self, anisotropy: float) -> None:
            ...

        def setMinificationFilter(
            self, f: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter
        ) -> None:
            ...

        def setMipLevels(self, mipLevels: int) -> None:
            ...

        def setSamples(self, samples: int) -> None:
            ...

        def setSize(self, width: int, height: int = ..., depth: int = ...) -> None:
            ...

        def setStatus(
            self, status: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Status
        ) -> None:
            ...

        def setWidth(self, width: int) -> None:
            ...

        def setWrapMode(
            self, wrapMode: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode
        ) -> None:
            ...

        def status(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Status:
            ...

        def target(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Target:
            ...

        def textureImages(
            self,
        ) -> List[PySide6.Qt3DRender.Qt3DRender.QAbstractTextureImage]:
            ...

        def updateData(
            self, update: PySide6.Qt3DRender.Qt3DRender.QTextureDataUpdate
        ) -> None:
            ...

        def width(self) -> int:
            ...

        def wrapMode(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode:
            ...

    class QAbstractTextureImage(PySide6.Qt3DCore.Qt3DCore.QNode):
        def face(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace:
            ...

        def layer(self) -> int:
            ...

        def mipLevel(self) -> int:
            ...

        def notifyDataGeneratorChanged(self) -> None:
            ...

        def setFace(
            self, face: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace
        ) -> None:
            ...

        def setLayer(self, layer: int) -> None:
            ...

        def setMipLevel(self, level: int) -> None:
            ...

    class QAlphaCoverage(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QAlphaTest(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Never: Qt3DRender.QAlphaTest.AlphaFunction = ...
        Less: Qt3DRender.QAlphaTest.AlphaFunction = ...
        Equal: Qt3DRender.QAlphaTest.AlphaFunction = ...
        LessOrEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
        Greater: Qt3DRender.QAlphaTest.AlphaFunction = ...
        NotEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
        GreaterOrEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
        Always: Qt3DRender.QAlphaTest.AlphaFunction = ...

        class AlphaFunction(Enum):
            Never: Qt3DRender.QAlphaTest.AlphaFunction = ...
            Less: Qt3DRender.QAlphaTest.AlphaFunction = ...
            Equal: Qt3DRender.QAlphaTest.AlphaFunction = ...
            LessOrEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
            Greater: Qt3DRender.QAlphaTest.AlphaFunction = ...
            NotEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
            GreaterOrEqual: Qt3DRender.QAlphaTest.AlphaFunction = ...
            Always: Qt3DRender.QAlphaTest.AlphaFunction = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def alphaFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction:
            ...

        def referenceValue(self) -> float:
            ...

        def setAlphaFunction(
            self, alphaFunction: PySide6.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction
        ) -> None:
            ...

        def setReferenceValue(self, referenceValue: float) -> None:
            ...

    class QBlendEquation(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Add: Qt3DRender.QBlendEquation.BlendFunction = ...
        Min: Qt3DRender.QBlendEquation.BlendFunction = ...
        Max: Qt3DRender.QBlendEquation.BlendFunction = ...
        Subtract: Qt3DRender.QBlendEquation.BlendFunction = ...
        ReverseSubtract: Qt3DRender.QBlendEquation.BlendFunction = ...

        class BlendFunction(Enum):
            Add: Qt3DRender.QBlendEquation.BlendFunction = ...
            Min: Qt3DRender.QBlendEquation.BlendFunction = ...
            Max: Qt3DRender.QBlendEquation.BlendFunction = ...
            Subtract: Qt3DRender.QBlendEquation.BlendFunction = ...
            ReverseSubtract: Qt3DRender.QBlendEquation.BlendFunction = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def blendFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction:
            ...

        def setBlendFunction(
            self,
            blendFunction: PySide6.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction,
        ) -> None:
            ...

    class QBlendEquationArguments(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Zero: Qt3DRender.QBlendEquationArguments.Blending = ...
        One: Qt3DRender.QBlendEquationArguments.Blending = ...
        SourceColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusSourceColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        SourceAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusSourceAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        Source1Alpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        DestinationAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        Source1Color: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusDestinationAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        DestinationColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusDestinationColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        SourceAlphaSaturate: Qt3DRender.QBlendEquationArguments.Blending = ...
        ConstantColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusConstantColor: Qt3DRender.QBlendEquationArguments.Blending = ...
        ConstantAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusConstantAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusSource1Alpha: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusSource1Color: Qt3DRender.QBlendEquationArguments.Blending = ...
        OneMinusSource1Color0: Qt3DRender.QBlendEquationArguments.Blending = ...

        class Blending(Enum):
            Zero: Qt3DRender.QBlendEquationArguments.Blending = ...
            One: Qt3DRender.QBlendEquationArguments.Blending = ...
            SourceColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusSourceColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            SourceAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusSourceAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            Source1Alpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            DestinationAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            Source1Color: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusDestinationAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            DestinationColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusDestinationColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            SourceAlphaSaturate: Qt3DRender.QBlendEquationArguments.Blending = ...
            ConstantColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusConstantColor: Qt3DRender.QBlendEquationArguments.Blending = ...
            ConstantAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusConstantAlpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusSource1Alpha: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusSource1Color: Qt3DRender.QBlendEquationArguments.Blending = ...
            OneMinusSource1Color0: Qt3DRender.QBlendEquationArguments.Blending = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def bufferIndex(self) -> int:
            ...

        def destinationAlpha(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending:
            ...

        def destinationRgb(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending:
            ...

        def setBufferIndex(self, index: int) -> None:
            ...

        def setDestinationAlpha(
            self,
            destinationAlpha: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def setDestinationRgb(
            self,
            destinationRgb: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def setDestinationRgba(
            self,
            destinationRgba: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def setSourceAlpha(
            self,
            sourceAlpha: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def setSourceRgb(
            self,
            sourceRgb: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def setSourceRgba(
            self,
            sourceRgba: PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending,
        ) -> None:
            ...

        def sourceAlpha(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending:
            ...

        def sourceRgb(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending:
            ...

    class QBlitFramebuffer(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        Nearest: Qt3DRender.QBlitFramebuffer.InterpolationMethod = ...
        Linear: Qt3DRender.QBlitFramebuffer.InterpolationMethod = ...

        class InterpolationMethod(Enum):
            Nearest: Qt3DRender.QBlitFramebuffer.InterpolationMethod = ...
            Linear: Qt3DRender.QBlitFramebuffer.InterpolationMethod = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def destination(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderTarget:
            ...

        def destinationAttachmentPoint(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint:
            ...

        def destinationRect(self) -> PySide6.QtCore.QRectF:
            ...

        def interpolationMethod(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod:
            ...

        def setDestination(
            self, destination: PySide6.Qt3DRender.Qt3DRender.QRenderTarget
        ) -> None:
            ...

        def setDestinationAttachmentPoint(
            self,
            destinationAttachmentPoint: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint,
        ) -> None:
            ...

        def setDestinationRect(
            self, destinationRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
        ) -> None:
            ...

        def setInterpolationMethod(
            self,
            interpolationMethod: PySide6.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod,
        ) -> None:
            ...

        def setSource(
            self, source: PySide6.Qt3DRender.Qt3DRender.QRenderTarget
        ) -> None:
            ...

        def setSourceAttachmentPoint(
            self,
            sourceAttachmentPoint: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint,
        ) -> None:
            ...

        def setSourceRect(
            self, sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
        ) -> None:
            ...

        def source(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderTarget:
            ...

        def sourceAttachmentPoint(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint:
            ...

        def sourceRect(self) -> PySide6.QtCore.QRectF:
            ...

    class QBufferCapture(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QCamera(PySide6.Qt3DCore.Qt3DCore.QEntity):
        TranslateViewCenter: Qt3DRender.QCamera.CameraTranslationOption = ...
        DontTranslateViewCenter: Qt3DRender.QCamera.CameraTranslationOption = ...

        class CameraTranslationOption(Enum):
            TranslateViewCenter: Qt3DRender.QCamera.CameraTranslationOption = ...
            DontTranslateViewCenter: Qt3DRender.QCamera.CameraTranslationOption = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def aspectRatio(self) -> float:
            ...

        def bottom(self) -> float:
            ...

        def exposure(self) -> float:
            ...

        def farPlane(self) -> float:
            ...

        def fieldOfView(self) -> float:
            ...

        def left(self) -> float:
            ...

        def lens(self) -> PySide6.Qt3DRender.Qt3DRender.QCameraLens:
            ...

        def nearPlane(self) -> float:
            ...

        @overload
        def pan(self, angle: float) -> None:
            ...

        @overload
        def pan(self, angle: float, axis: PySide6.QtGui.QVector3D) -> None:
            ...

        @overload
        def panAboutViewCenter(self, angle: float) -> None:
            ...

        @overload
        def panAboutViewCenter(
            self, angle: float, axis: PySide6.QtGui.QVector3D
        ) -> None:
            ...

        def panRotation(self, angle: float) -> PySide6.QtGui.QQuaternion:
            ...

        def position(self) -> PySide6.QtGui.QVector3D:
            ...

        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def projectionType(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType:
            ...

        def right(self) -> float:
            ...

        def roll(self, angle: float) -> None:
            ...

        def rollAboutViewCenter(self, angle: float) -> None:
            ...

        def rollRotation(self, angle: float) -> PySide6.QtGui.QQuaternion:
            ...

        def rotate(self, q: PySide6.QtGui.QQuaternion) -> None:
            ...

        def rotateAboutViewCenter(self, q: PySide6.QtGui.QQuaternion) -> None:
            ...

        def rotation(
            self, angle: float, axis: PySide6.QtGui.QVector3D
        ) -> PySide6.QtGui.QQuaternion:
            ...

        def setAspectRatio(self, aspectRatio: float) -> None:
            ...

        def setBottom(self, bottom: float) -> None:
            ...

        def setExposure(self, exposure: float) -> None:
            ...

        def setFarPlane(self, farPlane: float) -> None:
            ...

        def setFieldOfView(self, fieldOfView: float) -> None:
            ...

        def setLeft(self, left: float) -> None:
            ...

        def setNearPlane(self, nearPlane: float) -> None:
            ...

        def setPosition(self, position: PySide6.QtGui.QVector3D) -> None:
            ...

        def setProjectionMatrix(
            self,
            projectionMatrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        ) -> None:
            ...

        def setProjectionType(
            self, type: PySide6.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType
        ) -> None:
            ...

        def setRight(self, right: float) -> None:
            ...

        def setTop(self, top: float) -> None:
            ...

        def setUpVector(self, upVector: PySide6.QtGui.QVector3D) -> None:
            ...

        def setViewCenter(self, viewCenter: PySide6.QtGui.QVector3D) -> None:
            ...

        def tilt(self, angle: float) -> None:
            ...

        def tiltAboutViewCenter(self, angle: float) -> None:
            ...

        def tiltRotation(self, angle: float) -> PySide6.QtGui.QQuaternion:
            ...

        def top(self) -> float:
            ...

        def transform(self) -> PySide6.Qt3DCore.Qt3DCore.QTransform:
            ...

        def translate(
            self,
            vLocal: PySide6.QtGui.QVector3D,
            option: PySide6.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption = ...,
        ) -> None:
            ...

        def translateWorld(
            self,
            vWorld: PySide6.QtGui.QVector3D,
            option: PySide6.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption = ...,
        ) -> None:
            ...

        def upVector(self) -> PySide6.QtGui.QVector3D:
            ...

        def viewAll(self) -> None:
            ...

        def viewCenter(self) -> PySide6.QtGui.QVector3D:
            ...

        def viewEntity(self, entity: PySide6.Qt3DCore.Qt3DCore.QEntity) -> None:
            ...

        def viewMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def viewSphere(self, center: PySide6.QtGui.QVector3D, radius: float) -> None:
            ...

        def viewVector(self) -> PySide6.QtGui.QVector3D:
            ...

    class QCameraLens(PySide6.Qt3DCore.Qt3DCore.QComponent):
        OrthographicProjection: Qt3DRender.QCameraLens.ProjectionType = ...
        PerspectiveProjection: Qt3DRender.QCameraLens.ProjectionType = ...
        FrustumProjection: Qt3DRender.QCameraLens.ProjectionType = ...
        CustomProjection: Qt3DRender.QCameraLens.ProjectionType = ...

        class ProjectionType(Enum):
            OrthographicProjection: Qt3DRender.QCameraLens.ProjectionType = ...
            PerspectiveProjection: Qt3DRender.QCameraLens.ProjectionType = ...
            FrustumProjection: Qt3DRender.QCameraLens.ProjectionType = ...
            CustomProjection: Qt3DRender.QCameraLens.ProjectionType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def aspectRatio(self) -> float:
            ...

        def bottom(self) -> float:
            ...

        def exposure(self) -> float:
            ...

        def farPlane(self) -> float:
            ...

        def fieldOfView(self) -> float:
            ...

        def left(self) -> float:
            ...

        def nearPlane(self) -> float:
            ...

        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def projectionType(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType:
            ...

        def right(self) -> float:
            ...

        def setAspectRatio(self, aspectRatio: float) -> None:
            ...

        def setBottom(self, bottom: float) -> None:
            ...

        def setExposure(self, exposure: float) -> None:
            ...

        def setFarPlane(self, farPlane: float) -> None:
            ...

        def setFieldOfView(self, fieldOfView: float) -> None:
            ...

        def setFrustumProjection(
            self,
            left: float,
            right: float,
            bottom: float,
            top: float,
            nearPlane: float,
            farPlane: float,
        ) -> None:
            ...

        def setLeft(self, left: float) -> None:
            ...

        def setNearPlane(self, nearPlane: float) -> None:
            ...

        def setOrthographicProjection(
            self,
            left: float,
            right: float,
            bottom: float,
            top: float,
            nearPlane: float,
            farPlane: float,
        ) -> None:
            ...

        def setPerspectiveProjection(
            self, fieldOfView: float, aspect: float, nearPlane: float, farPlane: float
        ) -> None:
            ...

        def setProjectionMatrix(
            self,
            projectionMatrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        ) -> None:
            ...

        def setProjectionType(
            self,
            projectionType: PySide6.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType,
        ) -> None:
            ...

        def setRight(self, right: float) -> None:
            ...

        def setTop(self, top: float) -> None:
            ...

        def top(self) -> float:
            ...

        def viewAll(self, cameraId: PySide6.Qt3DCore.Qt3DCore.QNodeId) -> None:
            ...

        def viewEntity(
            self,
            entityId: PySide6.Qt3DCore.Qt3DCore.QNodeId,
            cameraId: PySide6.Qt3DCore.Qt3DCore.QNodeId,
        ) -> None:
            ...

    class QCameraSelector(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def camera(self) -> PySide6.Qt3DCore.Qt3DCore.QEntity:
            ...

        def setCamera(self, camera: PySide6.Qt3DCore.Qt3DCore.QEntity) -> None:
            ...

    class QClearBuffers(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        AllBuffers: Qt3DRender.QClearBuffers.BufferType = ...
        None_: Qt3DRender.QClearBuffers.BufferType = ...
        ColorBuffer: Qt3DRender.QClearBuffers.BufferType = ...
        DepthBuffer: Qt3DRender.QClearBuffers.BufferType = ...
        ColorDepthBuffer: Qt3DRender.QClearBuffers.BufferType = ...
        StencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...
        DepthStencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...
        ColorDepthStencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...

        class BufferType(Enum):
            AllBuffers: Qt3DRender.QClearBuffers.BufferType = ...
            None_: Qt3DRender.QClearBuffers.BufferType = ...
            ColorBuffer: Qt3DRender.QClearBuffers.BufferType = ...
            DepthBuffer: Qt3DRender.QClearBuffers.BufferType = ...
            ColorDepthBuffer: Qt3DRender.QClearBuffers.BufferType = ...
            StencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...
            DepthStencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...
            ColorDepthStencilBuffer: Qt3DRender.QClearBuffers.BufferType = ...

        class BufferTypeFlags(object):
            ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def buffers(self) -> PySide6.Qt3DRender.Qt3DRender.QClearBuffers.BufferType:
            ...

        def clearColor(self) -> PySide6.QtGui.QColor:
            ...

        def clearDepthValue(self) -> float:
            ...

        def clearStencilValue(self) -> int:
            ...

        def colorBuffer(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput:
            ...

        def setBuffers(
            self, buffers: PySide6.Qt3DRender.Qt3DRender.QClearBuffers.BufferType
        ) -> None:
            ...

        def setClearColor(
            self,
            color: Union[
                PySide6.QtGui.QColor,
                PySide6.QtGui.QRgba64,
                Any,
                PySide6.QtCore.Qt.GlobalColor,
                str,
                int,
            ],
        ) -> None:
            ...

        def setClearDepthValue(self, clearDepthValue: float) -> None:
            ...

        def setClearStencilValue(self, clearStencilValue: int) -> None:
            ...

        def setColorBuffer(
            self, buffer: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput
        ) -> None:
            ...

    class QClipPlane(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def distance(self) -> float:
            ...

        def normal(self) -> PySide6.QtGui.QVector3D:
            ...

        def planeIndex(self) -> int:
            ...

        def setDistance(self, arg__1: float) -> None:
            ...

        def setNormal(self, arg__1: PySide6.QtGui.QVector3D) -> None:
            ...

        def setPlaneIndex(self, arg__1: int) -> None:
            ...

    class QColorMask(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def isAlphaMasked(self) -> bool:
            ...

        def isBlueMasked(self) -> bool:
            ...

        def isGreenMasked(self) -> bool:
            ...

        def isRedMasked(self) -> bool:
            ...

        def setAlphaMasked(self, alphaMasked: bool) -> None:
            ...

        def setBlueMasked(self, blueMasked: bool) -> None:
            ...

        def setGreenMasked(self, greenMasked: bool) -> None:
            ...

        def setRedMasked(self, redMasked: bool) -> None:
            ...

    class QComputeCommand(PySide6.Qt3DCore.Qt3DCore.QComponent):
        Continuous: Qt3DRender.QComputeCommand.RunType = ...
        Manual: Qt3DRender.QComputeCommand.RunType = ...

        class RunType(Enum):
            Continuous: Qt3DRender.QComputeCommand.RunType = ...
            Manual: Qt3DRender.QComputeCommand.RunType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def runType(self) -> PySide6.Qt3DRender.Qt3DRender.QComputeCommand.RunType:
            ...

        def setRunType(
            self, runType: PySide6.Qt3DRender.Qt3DRender.QComputeCommand.RunType
        ) -> None:
            ...

        def setWorkGroupX(self, workGroupX: int) -> None:
            ...

        def setWorkGroupY(self, workGroupY: int) -> None:
            ...

        def setWorkGroupZ(self, workGroupZ: int) -> None:
            ...

        @overload
        def trigger(self, frameCount: int = ...) -> None:
            ...

        @overload
        def trigger(
            self,
            workGroupX: int,
            workGroupY: int,
            workGroupZ: int,
            frameCount: int = ...,
        ) -> None:
            ...

        def workGroupX(self) -> int:
            ...

        def workGroupY(self) -> int:
            ...

        def workGroupZ(self) -> int:
            ...

    class QCullFace(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        NoCulling: Qt3DRender.QCullFace.CullingMode = ...
        Front: Qt3DRender.QCullFace.CullingMode = ...
        Back: Qt3DRender.QCullFace.CullingMode = ...
        FrontAndBack: Qt3DRender.QCullFace.CullingMode = ...

        class CullingMode(Enum):
            NoCulling: Qt3DRender.QCullFace.CullingMode = ...
            Front: Qt3DRender.QCullFace.CullingMode = ...
            Back: Qt3DRender.QCullFace.CullingMode = ...
            FrontAndBack: Qt3DRender.QCullFace.CullingMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def mode(self) -> PySide6.Qt3DRender.Qt3DRender.QCullFace.CullingMode:
            ...

        def setMode(
            self, mode: PySide6.Qt3DRender.Qt3DRender.QCullFace.CullingMode
        ) -> None:
            ...

    class QDepthRange(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def farValue(self) -> float:
            ...

        def nearValue(self) -> float:
            ...

        def setFarValue(self, value: float) -> None:
            ...

        def setNearValue(self, value: float) -> None:
            ...

    class QDepthTest(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Never: Qt3DRender.QDepthTest.DepthFunction = ...
        Less: Qt3DRender.QDepthTest.DepthFunction = ...
        Equal: Qt3DRender.QDepthTest.DepthFunction = ...
        LessOrEqual: Qt3DRender.QDepthTest.DepthFunction = ...
        Greater: Qt3DRender.QDepthTest.DepthFunction = ...
        NotEqual: Qt3DRender.QDepthTest.DepthFunction = ...
        GreaterOrEqual: Qt3DRender.QDepthTest.DepthFunction = ...
        Always: Qt3DRender.QDepthTest.DepthFunction = ...

        class DepthFunction(Enum):
            Never: Qt3DRender.QDepthTest.DepthFunction = ...
            Less: Qt3DRender.QDepthTest.DepthFunction = ...
            Equal: Qt3DRender.QDepthTest.DepthFunction = ...
            LessOrEqual: Qt3DRender.QDepthTest.DepthFunction = ...
            Greater: Qt3DRender.QDepthTest.DepthFunction = ...
            NotEqual: Qt3DRender.QDepthTest.DepthFunction = ...
            GreaterOrEqual: Qt3DRender.QDepthTest.DepthFunction = ...
            Always: Qt3DRender.QDepthTest.DepthFunction = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def depthFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction:
            ...

        def setDepthFunction(
            self, depthFunction: PySide6.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction
        ) -> None:
            ...

    class QDirectionalLight(PySide6.Qt3DRender.Qt3DRender.QAbstractLight):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setWorldDirection(self, worldDirection: PySide6.QtGui.QVector3D) -> None:
            ...

        def worldDirection(self) -> PySide6.QtGui.QVector3D:
            ...

    class QDispatchCompute(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setWorkGroupX(self, workGroupX: int) -> None:
            ...

        def setWorkGroupY(self, workGroupY: int) -> None:
            ...

        def setWorkGroupZ(self, workGroupZ: int) -> None:
            ...

        def workGroupX(self) -> int:
            ...

        def workGroupY(self) -> int:
            ...

        def workGroupZ(self) -> int:
            ...

    class QDithering(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QEffect(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

        def addTechnique(self, t: PySide6.Qt3DRender.Qt3DRender.QTechnique) -> None:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

        def removeTechnique(self, t: PySide6.Qt3DRender.Qt3DRender.QTechnique) -> None:
            ...

        def techniques(self) -> List[PySide6.Qt3DRender.Qt3DRender.QTechnique]:
            ...

    class QEnvironmentLight(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def irradiance(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture:
            ...

        def setIrradiance(
            self, irradiance: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture
        ) -> None:
            ...

        def setSpecular(
            self, specular: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture
        ) -> None:
            ...

        def specular(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture:
            ...

    class QFilterKey(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def name(self) -> str:
            ...

        def setName(self, customType: str) -> None:
            ...

        def setValue(self, value: Any) -> None:
            ...

        def value(self) -> Any:
            ...

    class QFrameGraphNode(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def parentFrameGraphNode(self) -> PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode:
            ...

    class QFrontFace(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        ClockWise: Qt3DRender.QFrontFace.WindingDirection = ...
        CounterClockWise: Qt3DRender.QFrontFace.WindingDirection = ...

        class WindingDirection(Enum):
            ClockWise: Qt3DRender.QFrontFace.WindingDirection = ...
            CounterClockWise: Qt3DRender.QFrontFace.WindingDirection = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def direction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection:
            ...

        def setDirection(
            self, direction: PySide6.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection
        ) -> None:
            ...

    class QFrustumCulling(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QGeometryRenderer(PySide6.Qt3DCore.Qt3DCore.QBoundingVolume):
        Points: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        Lines: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        LineLoop: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        LineStrip: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        Triangles: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        TriangleStrip: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        TriangleFan: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        LinesAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        LineStripAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        TrianglesAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        TriangleStripAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
        Patches: Qt3DRender.QGeometryRenderer.PrimitiveType = ...

        class PrimitiveType(Enum):
            Points: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            Lines: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            LineLoop: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            LineStrip: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            Triangles: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            TriangleStrip: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            TriangleFan: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            LinesAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            LineStripAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            TrianglesAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            TriangleStripAdjacency: Qt3DRender.QGeometryRenderer.PrimitiveType = ...
            Patches: Qt3DRender.QGeometryRenderer.PrimitiveType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def firstInstance(self) -> int:
            ...

        def firstVertex(self) -> int:
            ...

        def geometry(self) -> PySide6.Qt3DCore.Qt3DCore.QGeometry:
            ...

        def indexBufferByteOffset(self) -> int:
            ...

        def indexOffset(self) -> int:
            ...

        def instanceCount(self) -> int:
            ...

        def primitiveRestartEnabled(self) -> bool:
            ...

        def primitiveType(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType:
            ...

        def restartIndexValue(self) -> int:
            ...

        def setFirstInstance(self, firstInstance: int) -> None:
            ...

        def setFirstVertex(self, firstVertex: int) -> None:
            ...

        def setGeometry(self, geometry: PySide6.Qt3DCore.Qt3DCore.QGeometry) -> None:
            ...

        def setIndexBufferByteOffset(self, offset: int) -> None:
            ...

        def setIndexOffset(self, indexOffset: int) -> None:
            ...

        def setInstanceCount(self, instanceCount: int) -> None:
            ...

        def setPrimitiveRestartEnabled(self, enabled: bool) -> None:
            ...

        def setPrimitiveType(
            self,
            primitiveType: PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType,
        ) -> None:
            ...

        def setRestartIndexValue(self, index: int) -> None:
            ...

        def setSortIndex(self, sortIndex: float) -> None:
            ...

        def setVertexCount(self, vertexCount: int) -> None:
            ...

        def setVerticesPerPatch(self, verticesPerPatch: int) -> None:
            ...

        def sortIndex(self) -> float:
            ...

        def vertexCount(self) -> int:
            ...

        def verticesPerPatch(self) -> int:
            ...

    class QGraphicsApiFilter(PySide6.QtCore.QObject):
        OpenGL: Qt3DRender.QGraphicsApiFilter.Api = ...
        OpenGLES: Qt3DRender.QGraphicsApiFilter.Api = ...
        Vulkan: Qt3DRender.QGraphicsApiFilter.Api = ...
        DirectX: Qt3DRender.QGraphicsApiFilter.Api = ...
        RHI: Qt3DRender.QGraphicsApiFilter.Api = ...
        NoProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...
        CoreProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...
        CompatibilityProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...

        class Api(Enum):
            OpenGL: Qt3DRender.QGraphicsApiFilter.Api = ...
            OpenGLES: Qt3DRender.QGraphicsApiFilter.Api = ...
            Vulkan: Qt3DRender.QGraphicsApiFilter.Api = ...
            DirectX: Qt3DRender.QGraphicsApiFilter.Api = ...
            RHI: Qt3DRender.QGraphicsApiFilter.Api = ...

        class OpenGLProfile(Enum):
            NoProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...
            CoreProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...
            CompatibilityProfile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ...

        def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
            ...

        def api(self) -> PySide6.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api:
            ...

        def extensions(self) -> List[str]:
            ...

        def majorVersion(self) -> int:
            ...

        def minorVersion(self) -> int:
            ...

        def profile(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile:
            ...

        def setApi(
            self, api: PySide6.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api
        ) -> None:
            ...

        def setExtensions(self, extensions: Sequence[str]) -> None:
            ...

        def setMajorVersion(self, majorVersion: int) -> None:
            ...

        def setMinorVersion(self, minorVersion: int) -> None:
            ...

        def setProfile(
            self,
            profile: PySide6.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile,
        ) -> None:
            ...

        def setVendor(self, vendor: str) -> None:
            ...

        def vendor(self) -> str:
            ...

    class QLayer(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def recursive(self) -> bool:
            ...

        def setRecursive(self, recursive: bool) -> None:
            ...

    class QLayerFilter(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        AcceptAnyMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
        AcceptAllMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
        DiscardAnyMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
        DiscardAllMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...

        class FilterMode(Enum):
            AcceptAnyMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
            AcceptAllMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
            DiscardAnyMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...
            DiscardAllMatchingLayers: Qt3DRender.QLayerFilter.FilterMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addLayer(self, layer: PySide6.Qt3DRender.Qt3DRender.QLayer) -> None:
            ...

        def filterMode(self) -> PySide6.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode:
            ...

        def layers(self) -> List[PySide6.Qt3DRender.Qt3DRender.QLayer]:
            ...

        def removeLayer(self, layer: PySide6.Qt3DRender.Qt3DRender.QLayer) -> None:
            ...

        def setFilterMode(
            self, filterMode: PySide6.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode
        ) -> None:
            ...

    class QLevelOfDetail(PySide6.Qt3DCore.Qt3DCore.QComponent):
        DistanceToCameraThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = ...
        ProjectedScreenPixelSizeThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = ...

        class ThresholdType(Enum):
            DistanceToCameraThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = ...
            ProjectedScreenPixelSizeThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = (
                ...
            )

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def camera(self) -> PySide6.Qt3DRender.Qt3DRender.QCamera:
            ...

        def createBoundingSphere(
            self, center: PySide6.QtGui.QVector3D, radius: float
        ) -> PySide6.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere:
            ...

        def currentIndex(self) -> int:
            ...

        def setCamera(self, camera: PySide6.Qt3DRender.Qt3DRender.QCamera) -> None:
            ...

        def setCurrentIndex(self, currentIndex: int) -> None:
            ...

        def setThresholdType(
            self,
            thresholdType: PySide6.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType,
        ) -> None:
            ...

        def setThresholds(self, thresholds: Sequence[float]) -> None:
            ...

        def setVolumeOverride(
            self,
            volumeOverride: PySide6.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere,
        ) -> None:
            ...

        def thresholdType(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType:
            ...

        def thresholds(self) -> List[float]:
            ...

        def volumeOverride(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere:
            ...

    class QLevelOfDetailBoundingSphere(object):
        @overload
        def __init__(
            self, center: PySide6.QtGui.QVector3D = ..., radius: float = ...
        ) -> None:
            ...

        @overload
        def __init__(
            self, other: PySide6.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere
        ) -> None:
            ...

        def center(self) -> PySide6.QtGui.QVector3D:
            ...

        def isEmpty(self) -> bool:
            ...

        def radius(self) -> float:
            ...

    class QLevelOfDetailSwitch(PySide6.Qt3DRender.Qt3DRender.QLevelOfDetail):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QLineWidth(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setSmooth(self, enabled: bool) -> None:
            ...

        def setValue(self, value: float) -> None:
            ...

        def smooth(self) -> bool:
            ...

        def value(self) -> float:
            ...

    class QMaterial(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

        def effect(self) -> PySide6.Qt3DRender.Qt3DRender.QEffect:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

        def setEffect(self, effect: PySide6.Qt3DRender.Qt3DRender.QEffect) -> None:
            ...

    class QMemoryBarrier(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        All: Qt3DRender.QMemoryBarrier.Operation = ...
        None_: Qt3DRender.QMemoryBarrier.Operation = ...
        VertexAttributeArray: Qt3DRender.QMemoryBarrier.Operation = ...
        ElementArray: Qt3DRender.QMemoryBarrier.Operation = ...
        Uniform: Qt3DRender.QMemoryBarrier.Operation = ...
        TextureFetch: Qt3DRender.QMemoryBarrier.Operation = ...
        ShaderImageAccess: Qt3DRender.QMemoryBarrier.Operation = ...
        Command: Qt3DRender.QMemoryBarrier.Operation = ...
        PixelBuffer: Qt3DRender.QMemoryBarrier.Operation = ...
        TextureUpdate: Qt3DRender.QMemoryBarrier.Operation = ...
        BufferUpdate: Qt3DRender.QMemoryBarrier.Operation = ...
        FrameBuffer: Qt3DRender.QMemoryBarrier.Operation = ...
        TransformFeedback: Qt3DRender.QMemoryBarrier.Operation = ...
        AtomicCounter: Qt3DRender.QMemoryBarrier.Operation = ...
        ShaderStorage: Qt3DRender.QMemoryBarrier.Operation = ...
        QueryBuffer: Qt3DRender.QMemoryBarrier.Operation = ...

        class Operation(Enum):
            All: Qt3DRender.QMemoryBarrier.Operation = ...
            None_: Qt3DRender.QMemoryBarrier.Operation = ...
            VertexAttributeArray: Qt3DRender.QMemoryBarrier.Operation = ...
            ElementArray: Qt3DRender.QMemoryBarrier.Operation = ...
            Uniform: Qt3DRender.QMemoryBarrier.Operation = ...
            TextureFetch: Qt3DRender.QMemoryBarrier.Operation = ...
            ShaderImageAccess: Qt3DRender.QMemoryBarrier.Operation = ...
            Command: Qt3DRender.QMemoryBarrier.Operation = ...
            PixelBuffer: Qt3DRender.QMemoryBarrier.Operation = ...
            TextureUpdate: Qt3DRender.QMemoryBarrier.Operation = ...
            BufferUpdate: Qt3DRender.QMemoryBarrier.Operation = ...
            FrameBuffer: Qt3DRender.QMemoryBarrier.Operation = ...
            TransformFeedback: Qt3DRender.QMemoryBarrier.Operation = ...
            AtomicCounter: Qt3DRender.QMemoryBarrier.Operation = ...
            ShaderStorage: Qt3DRender.QMemoryBarrier.Operation = ...
            QueryBuffer: Qt3DRender.QMemoryBarrier.Operation = ...

        class Operations(object):
            ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setWaitOperations(
            self, operations: PySide6.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations
        ) -> None:
            ...

        def waitOperations(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations:
            ...

    class QMesh(PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer):
        None_: Qt3DRender.QMesh.Status = ...
        Loading: Qt3DRender.QMesh.Status = ...
        Ready: Qt3DRender.QMesh.Status = ...
        Error: Qt3DRender.QMesh.Status = ...

        class Status(Enum):
            None_: Qt3DRender.QMesh.Status = ...
            Loading: Qt3DRender.QMesh.Status = ...
            Ready: Qt3DRender.QMesh.Status = ...
            Error: Qt3DRender.QMesh.Status = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def meshName(self) -> str:
            ...

        def setMeshName(self, meshName: str) -> None:
            ...

        def setSource(self, source: Union[PySide6.QtCore.QUrl, str]) -> None:
            ...

        def source(self) -> PySide6.QtCore.QUrl:
            ...

        def status(self) -> PySide6.Qt3DRender.Qt3DRender.QMesh.Status:
            ...

    class QMultiSampleAntiAliasing(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QNoDepthMask(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QNoDraw(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QNoPicking(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QObjectPicker(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def containsMouse(self) -> bool:
            ...

        def isDragEnabled(self) -> bool:
            ...

        def isHoverEnabled(self) -> bool:
            ...

        def isPressed(self) -> bool:
            ...

        def priority(self) -> int:
            ...

        def setDragEnabled(self, dragEnabled: bool) -> None:
            ...

        def setHoverEnabled(self, hoverEnabled: bool) -> None:
            ...

        def setPriority(self, priority: int) -> None:
            ...

    class QPaintedTextureImage(PySide6.Qt3DRender.Qt3DRender.QAbstractTextureImage):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def height(self) -> int:
            ...

        def paint(self, painter: PySide6.QtGui.QPainter) -> None:
            ...

        def setHeight(self, h: int) -> None:
            ...

        def setSize(self, size: PySide6.QtCore.QSize) -> None:
            ...

        def setWidth(self, w: int) -> None:
            ...

        def size(self) -> PySide6.QtCore.QSize:
            ...

        def update(self, rect: PySide6.QtCore.QRect = ...) -> None:
            ...

        def width(self) -> int:
            ...

    class QParameter(PySide6.Qt3DCore.Qt3DCore.QNode):
        @overload
        def __init__(
            self,
            name: str,
            texture: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture,
            parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...,
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            name: str,
            value: Any,
            parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...,
        ) -> None:
            ...

        @overload
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def name(self) -> str:
            ...

        def setName(self, name: str) -> None:
            ...

        def setValue(self, dv: Any) -> None:
            ...

        def value(self) -> Any:
            ...

    class QPickEvent(PySide6.QtCore.QObject):
        NoButton: Qt3DRender.QPickEvent.Buttons = ...
        LeftButton: Qt3DRender.QPickEvent.Buttons = ...
        RightButton: Qt3DRender.QPickEvent.Buttons = ...
        MiddleButton: Qt3DRender.QPickEvent.Buttons = ...
        BackButton: Qt3DRender.QPickEvent.Buttons = ...
        NoModifier: Qt3DRender.QPickEvent.Modifiers = ...
        ShiftModifier: Qt3DRender.QPickEvent.Modifiers = ...
        ControlModifier: Qt3DRender.QPickEvent.Modifiers = ...
        AltModifier: Qt3DRender.QPickEvent.Modifiers = ...
        MetaModifier: Qt3DRender.QPickEvent.Modifiers = ...
        KeypadModifier: Qt3DRender.QPickEvent.Modifiers = ...

        class Buttons(Enum):
            NoButton: Qt3DRender.QPickEvent.Buttons = ...
            LeftButton: Qt3DRender.QPickEvent.Buttons = ...
            RightButton: Qt3DRender.QPickEvent.Buttons = ...
            MiddleButton: Qt3DRender.QPickEvent.Buttons = ...
            BackButton: Qt3DRender.QPickEvent.Buttons = ...

        class Modifiers(Enum):
            NoModifier: Qt3DRender.QPickEvent.Modifiers = ...
            ShiftModifier: Qt3DRender.QPickEvent.Modifiers = ...
            ControlModifier: Qt3DRender.QPickEvent.Modifiers = ...
            AltModifier: Qt3DRender.QPickEvent.Modifiers = ...
            MetaModifier: Qt3DRender.QPickEvent.Modifiers = ...
            KeypadModifier: Qt3DRender.QPickEvent.Modifiers = ...

        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
            button: PySide6.Qt3DRender.Qt3DRender.QPickEvent.Buttons,
            buttons: int,
            modifiers: int,
        ) -> None:
            ...

        def button(self) -> PySide6.Qt3DRender.Qt3DRender.QPickEvent.Buttons:
            ...

        def buttons(self) -> int:
            ...

        def distance(self) -> float:
            ...

        def entity(self) -> PySide6.Qt3DCore.Qt3DCore.QEntity:
            ...

        def isAccepted(self) -> bool:
            ...

        def localIntersection(self) -> PySide6.QtGui.QVector3D:
            ...

        def modifiers(self) -> int:
            ...

        def position(self) -> PySide6.QtCore.QPointF:
            ...

        def setAccepted(self, accepted: bool) -> None:
            ...

        def viewport(self) -> PySide6.Qt3DRender.Qt3DRender.QViewport:
            ...

        def worldIntersection(self) -> PySide6.QtGui.QVector3D:
            ...

    class QPickLineEvent(PySide6.Qt3DRender.Qt3DRender.QPickEvent):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
            edgeIndex: int,
            vertex1Index: int,
            vertex2Index: int,
            button: PySide6.Qt3DRender.Qt3DRender.QPickEvent.Buttons,
            buttons: int,
            modifiers: int,
        ) -> None:
            ...

        def edgeIndex(self) -> int:
            ...

        def vertex1Index(self) -> int:
            ...

        def vertex2Index(self) -> int:
            ...

    class QPickPointEvent(PySide6.Qt3DRender.Qt3DRender.QPickEvent):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
            pointIndex: int,
            button: PySide6.Qt3DRender.Qt3DRender.QPickEvent.Buttons,
            buttons: int,
            modifiers: int,
        ) -> None:
            ...

        def pointIndex(self) -> int:
            ...

    class QPickTriangleEvent(PySide6.Qt3DRender.Qt3DRender.QPickEvent):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
            triangleIndex: int,
            vertex1Index: int,
            vertex2Index: int,
            vertex3Index: int,
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            position: Union[
                PySide6.QtCore.QPointF,
                PySide6.QtCore.QPoint,
                PySide6.QtGui.QPainterPath.Element,
            ],
            worldIntersection: PySide6.QtGui.QVector3D,
            localIntersection: PySide6.QtGui.QVector3D,
            distance: float,
            triangleIndex: int,
            vertex1Index: int,
            vertex2Index: int,
            vertex3Index: int,
            button: PySide6.Qt3DRender.Qt3DRender.QPickEvent.Buttons,
            buttons: int,
            modifiers: int,
            uvw: PySide6.QtGui.QVector3D,
        ) -> None:
            ...

        def triangleIndex(self) -> int:
            ...

        def uvw(self) -> PySide6.QtGui.QVector3D:
            ...

        def vertex1Index(self) -> int:
            ...

        def vertex2Index(self) -> int:
            ...

        def vertex3Index(self) -> int:
            ...

    class QPickingProxy(PySide6.Qt3DCore.Qt3DCore.QBoundingVolume):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QPickingSettings(PySide6.Qt3DCore.Qt3DCore.QNode):
        FrontFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ...
        BackFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ...
        FrontAndBackFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ...
        BoundingVolumePicking: Qt3DRender.QPickingSettings.PickMethod = ...
        TrianglePicking: Qt3DRender.QPickingSettings.PickMethod = ...
        LinePicking: Qt3DRender.QPickingSettings.PickMethod = ...
        PointPicking: Qt3DRender.QPickingSettings.PickMethod = ...
        PrimitivePicking: Qt3DRender.QPickingSettings.PickMethod = ...
        NearestPick: Qt3DRender.QPickingSettings.PickResultMode = ...
        AllPicks: Qt3DRender.QPickingSettings.PickResultMode = ...
        NearestPriorityPick: Qt3DRender.QPickingSettings.PickResultMode = ...

        class FaceOrientationPickingMode(Enum):
            FrontFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ...
            BackFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ...
            FrontAndBackFace: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = (
                ...
            )

        class PickMethod(Enum):
            BoundingVolumePicking: Qt3DRender.QPickingSettings.PickMethod = ...
            TrianglePicking: Qt3DRender.QPickingSettings.PickMethod = ...
            LinePicking: Qt3DRender.QPickingSettings.PickMethod = ...
            PointPicking: Qt3DRender.QPickingSettings.PickMethod = ...
            PrimitivePicking: Qt3DRender.QPickingSettings.PickMethod = ...

        class PickResultMode(Enum):
            NearestPick: Qt3DRender.QPickingSettings.PickResultMode = ...
            AllPicks: Qt3DRender.QPickingSettings.PickResultMode = ...
            NearestPriorityPick: Qt3DRender.QPickingSettings.PickResultMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def faceOrientationPickingMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode:
            ...

        def pickMethod(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod:
            ...

        def pickResultMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode:
            ...

        def setFaceOrientationPickingMode(
            self,
            faceOrientationPickingMode: PySide6.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode,
        ) -> None:
            ...

        def setPickMethod(
            self, pickMethod: PySide6.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod
        ) -> None:
            ...

        def setPickResultMode(
            self,
            pickResultMode: PySide6.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode,
        ) -> None:
            ...

        def setWorldSpaceTolerance(self, worldSpaceTolerance: float) -> None:
            ...

        def worldSpaceTolerance(self) -> float:
            ...

    class QPointLight(PySide6.Qt3DRender.Qt3DRender.QAbstractLight):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def constantAttenuation(self) -> float:
            ...

        def linearAttenuation(self) -> float:
            ...

        def quadraticAttenuation(self) -> float:
            ...

        def setConstantAttenuation(self, value: float) -> None:
            ...

        def setLinearAttenuation(self, value: float) -> None:
            ...

        def setQuadraticAttenuation(self, value: float) -> None:
            ...

    class QPointSize(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Fixed: Qt3DRender.QPointSize.SizeMode = ...
        Programmable: Qt3DRender.QPointSize.SizeMode = ...

        class SizeMode(Enum):
            Fixed: Qt3DRender.QPointSize.SizeMode = ...
            Programmable: Qt3DRender.QPointSize.SizeMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setSizeMode(
            self, sizeMode: PySide6.Qt3DRender.Qt3DRender.QPointSize.SizeMode
        ) -> None:
            ...

        def setValue(self, value: float) -> None:
            ...

        def sizeMode(self) -> PySide6.Qt3DRender.Qt3DRender.QPointSize.SizeMode:
            ...

        def value(self) -> float:
            ...

    class QPolygonOffset(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def depthSteps(self) -> float:
            ...

        def scaleFactor(self) -> float:
            ...

        def setDepthSteps(self, depthSteps: float) -> None:
            ...

        def setScaleFactor(self, scaleFactor: float) -> None:
            ...

    class QProximityFilter(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def distanceThreshold(self) -> float:
            ...

        def entity(self) -> PySide6.Qt3DCore.Qt3DCore.QEntity:
            ...

        def setDistanceThreshold(self, distanceThreshold: float) -> None:
            ...

        def setEntity(self, entity: PySide6.Qt3DCore.Qt3DCore.QEntity) -> None:
            ...

    class QRasterMode(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        Front: Qt3DRender.QRasterMode.FaceMode = ...
        Back: Qt3DRender.QRasterMode.FaceMode = ...
        FrontAndBack: Qt3DRender.QRasterMode.FaceMode = ...
        Points: Qt3DRender.QRasterMode.RasterMode = ...
        Lines: Qt3DRender.QRasterMode.RasterMode = ...
        Fill: Qt3DRender.QRasterMode.RasterMode = ...

        class FaceMode(Enum):
            Front: Qt3DRender.QRasterMode.FaceMode = ...
            Back: Qt3DRender.QRasterMode.FaceMode = ...
            FrontAndBack: Qt3DRender.QRasterMode.FaceMode = ...

        class RasterMode(Enum):
            Points: Qt3DRender.QRasterMode.RasterMode = ...
            Lines: Qt3DRender.QRasterMode.RasterMode = ...
            Fill: Qt3DRender.QRasterMode.RasterMode = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def faceMode(self) -> PySide6.Qt3DRender.Qt3DRender.QRasterMode.FaceMode:
            ...

        def rasterMode(self) -> PySide6.Qt3DRender.Qt3DRender.QRasterMode.RasterMode:
            ...

        def setFaceMode(
            self, faceMode: PySide6.Qt3DRender.Qt3DRender.QRasterMode.FaceMode
        ) -> None:
            ...

        def setRasterMode(
            self, rasterMode: PySide6.Qt3DRender.Qt3DRender.QRasterMode.RasterMode
        ) -> None:
            ...

    class QRayCaster(PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def direction(self) -> PySide6.QtGui.QVector3D:
            ...

        def length(self) -> float:
            ...

        def origin(self) -> PySide6.QtGui.QVector3D:
            ...

        def pick(
            self,
            origin: PySide6.QtGui.QVector3D,
            direction: PySide6.QtGui.QVector3D,
            length: float,
        ) -> List[PySide6.Qt3DRender.Qt3DRender.QRayCasterHit]:
            ...

        def setDirection(self, direction: PySide6.QtGui.QVector3D) -> None:
            ...

        def setLength(self, length: float) -> None:
            ...

        def setOrigin(self, origin: PySide6.QtGui.QVector3D) -> None:
            ...

        @overload
        def trigger(self) -> None:
            ...

        @overload
        def trigger(
            self,
            origin: PySide6.QtGui.QVector3D,
            direction: PySide6.QtGui.QVector3D,
            length: float,
        ) -> None:
            ...

    class QRayCasterHit(object):
        TriangleHit: Qt3DRender.QRayCasterHit.HitType = ...
        LineHit: Qt3DRender.QRayCasterHit.HitType = ...
        PointHit: Qt3DRender.QRayCasterHit.HitType = ...
        EntityHit: Qt3DRender.QRayCasterHit.HitType = ...

        class HitType(Enum):
            TriangleHit: Qt3DRender.QRayCasterHit.HitType = ...
            LineHit: Qt3DRender.QRayCasterHit.HitType = ...
            PointHit: Qt3DRender.QRayCasterHit.HitType = ...
            EntityHit: Qt3DRender.QRayCasterHit.HitType = ...

        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, other: PySide6.Qt3DRender.Qt3DRender.QRayCasterHit) -> None:
            ...

        @overload
        def __init__(
            self,
            type: PySide6.Qt3DRender.Qt3DRender.QRayCasterHit.HitType,
            id: PySide6.Qt3DCore.Qt3DCore.QNodeId,
            distance: float,
            localIntersect: PySide6.QtGui.QVector3D,
            worldIntersect: PySide6.QtGui.QVector3D,
            primitiveIndex: int,
            v1: int,
            v2: int,
            v3: int,
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def distance(self) -> float:
            ...

        def entity(self) -> PySide6.Qt3DCore.Qt3DCore.QEntity:
            ...

        def entityId(self) -> PySide6.Qt3DCore.Qt3DCore.QNodeId:
            ...

        def localIntersection(self) -> PySide6.QtGui.QVector3D:
            ...

        def primitiveIndex(self) -> int:
            ...

        def toString(self) -> str:
            ...

        def type(self) -> PySide6.Qt3DRender.Qt3DRender.QRayCasterHit.HitType:
            ...

        def vertex1Index(self) -> int:
            ...

        def vertex2Index(self) -> int:
            ...

        def vertex3Index(self) -> int:
            ...

        def worldIntersection(self) -> PySide6.QtGui.QVector3D:
            ...

    class QRenderAspect(PySide6.Qt3DCore.Qt3DCore.QAbstractAspect):
        Automatic: Qt3DRender.QRenderAspect.SubmissionType = ...
        Manual: Qt3DRender.QRenderAspect.SubmissionType = ...

        class SubmissionType(Enum):
            Automatic: Qt3DRender.QRenderAspect.SubmissionType = ...
            Manual: Qt3DRender.QRenderAspect.SubmissionType = ...

        @overload
        def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
            ...

        @overload
        def __init__(
            self,
            submissionType: PySide6.Qt3DRender.Qt3DRender.QRenderAspect.SubmissionType,
            parent: Optional[PySide6.QtCore.QObject] = ...,
        ) -> None:
            ...

        def dependencies(self) -> List[str]:
            ...

    class QRenderCapabilities(PySide6.QtCore.QObject):
        OpenGL: Qt3DRender.QRenderCapabilities.API = ...
        OpenGLES: Qt3DRender.QRenderCapabilities.API = ...
        Vulkan: Qt3DRender.QRenderCapabilities.API = ...
        DirectX: Qt3DRender.QRenderCapabilities.API = ...
        RHI: Qt3DRender.QRenderCapabilities.API = ...
        NoProfile: Qt3DRender.QRenderCapabilities.Profile = ...
        CoreProfile: Qt3DRender.QRenderCapabilities.Profile = ...
        CompatibilityProfile: Qt3DRender.QRenderCapabilities.Profile = ...

        class API(Enum):
            OpenGL: Qt3DRender.QRenderCapabilities.API = ...
            OpenGLES: Qt3DRender.QRenderCapabilities.API = ...
            Vulkan: Qt3DRender.QRenderCapabilities.API = ...
            DirectX: Qt3DRender.QRenderCapabilities.API = ...
            RHI: Qt3DRender.QRenderCapabilities.API = ...

        class Profile(Enum):
            NoProfile: Qt3DRender.QRenderCapabilities.Profile = ...
            CoreProfile: Qt3DRender.QRenderCapabilities.Profile = ...
            CompatibilityProfile: Qt3DRender.QRenderCapabilities.Profile = ...

        def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
            ...

        def api(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderCapabilities.API:
            ...

        def driverVersion(self) -> str:
            ...

        def extensions(self) -> List[str]:
            ...

        def glslVersion(self) -> str:
            ...

        def isValid(self) -> bool:
            ...

        def majorVersion(self) -> int:
            ...

        def maxComputeInvocations(self) -> int:
            ...

        def maxComputeSharedMemorySize(self) -> int:
            ...

        def maxImageUnits(self) -> int:
            ...

        def maxSSBOBindings(self) -> int:
            ...

        def maxSSBOSize(self) -> int:
            ...

        def maxSamples(self) -> int:
            ...

        def maxTextureLayers(self) -> int:
            ...

        def maxTextureSize(self) -> int:
            ...

        def maxTextureUnits(self) -> int:
            ...

        def maxUBOBindings(self) -> int:
            ...

        def maxUBOSize(self) -> int:
            ...

        def maxWorkGroupCountX(self) -> int:
            ...

        def maxWorkGroupCountY(self) -> int:
            ...

        def maxWorkGroupCountZ(self) -> int:
            ...

        def maxWorkGroupSizeX(self) -> int:
            ...

        def maxWorkGroupSizeY(self) -> int:
            ...

        def maxWorkGroupSizeZ(self) -> int:
            ...

        def minorVersion(self) -> int:
            ...

        def profile(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderCapabilities.Profile:
            ...

        def renderer(self) -> str:
            ...

        def supportsCompute(self) -> bool:
            ...

        def supportsImageStore(self) -> bool:
            ...

        def supportsSSBO(self) -> bool:
            ...

        def supportsUBO(self) -> bool:
            ...

        def vendor(self) -> str:
            ...

    class QRenderCapture(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        @overload
        def requestCapture(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderCaptureReply:
            ...

        @overload
        def requestCapture(
            self, captureId: int
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderCaptureReply:
            ...

        @overload
        def requestCapture(
            self, rect: PySide6.QtCore.QRect
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderCaptureReply:
            ...

    class QRenderCaptureReply(PySide6.QtCore.QObject):
        def captureId(self) -> int:
            ...

        def image(self) -> PySide6.QtGui.QImage:
            ...

        def isComplete(self) -> bool:
            ...

        def saveImage(self, fileName: str) -> bool:
            ...

    class QRenderPass(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addFilterKey(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def addParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

        def addRenderState(
            self, state: PySide6.Qt3DRender.Qt3DRender.QRenderState
        ) -> None:
            ...

        def filterKeys(self) -> List[PySide6.Qt3DRender.Qt3DRender.QFilterKey]:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeFilterKey(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def removeParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

        def removeRenderState(
            self, state: PySide6.Qt3DRender.Qt3DRender.QRenderState
        ) -> None:
            ...

        def renderStates(self) -> List[PySide6.Qt3DRender.Qt3DRender.QRenderState]:
            ...

        def setShaderProgram(
            self, shaderProgram: PySide6.Qt3DRender.Qt3DRender.QShaderProgram
        ) -> None:
            ...

        def shaderProgram(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderProgram:
            ...

    class QRenderPassFilter(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addMatch(self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey) -> None:
            ...

        def addParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

        def matchAny(self) -> List[PySide6.Qt3DRender.Qt3DRender.QFilterKey]:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeMatch(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def removeParameter(
            self, parameter: PySide6.Qt3DRender.Qt3DRender.QParameter
        ) -> None:
            ...

    class QRenderSettings(PySide6.Qt3DCore.Qt3DCore.QComponent):
        OnDemand: Qt3DRender.QRenderSettings.RenderPolicy = ...
        Always: Qt3DRender.QRenderSettings.RenderPolicy = ...

        class RenderPolicy(Enum):
            OnDemand: Qt3DRender.QRenderSettings.RenderPolicy = ...
            Always: Qt3DRender.QRenderSettings.RenderPolicy = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def activeFrameGraph(self) -> PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode:
            ...

        def pickingSettings(self) -> PySide6.Qt3DRender.Qt3DRender.QPickingSettings:
            ...

        def renderCapabilities(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderCapabilities:
            ...

        def renderPolicy(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy:
            ...

        def setActiveFrameGraph(
            self, activeFrameGraph: PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode
        ) -> None:
            ...

        def setRenderPolicy(
            self,
            renderPolicy: PySide6.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy,
        ) -> None:
            ...

    class QRenderState(PySide6.Qt3DCore.Qt3DCore.QNode):
        ...

    class QRenderStateSet(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addRenderState(
            self, state: PySide6.Qt3DRender.Qt3DRender.QRenderState
        ) -> None:
            ...

        def removeRenderState(
            self, state: PySide6.Qt3DRender.Qt3DRender.QRenderState
        ) -> None:
            ...

        def renderStates(self) -> List[PySide6.Qt3DRender.Qt3DRender.QRenderState]:
            ...

    class QRenderSurfaceSelector(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def externalRenderTargetSize(self) -> PySide6.QtCore.QSize:
            ...

        def setExternalRenderTargetSize(self, size: PySide6.QtCore.QSize) -> None:
            ...

        def setSurface(self, surfaceObject: PySide6.QtCore.QObject) -> None:
            ...

        def setSurfacePixelRatio(self, ratio: float) -> None:
            ...

        def surface(self) -> PySide6.QtCore.QObject:
            ...

        def surfacePixelRatio(self) -> float:
            ...

    class QRenderTarget(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addOutput(
            self, output: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput
        ) -> None:
            ...

        def outputs(self) -> List[PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput]:
            ...

        def removeOutput(
            self, output: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput
        ) -> None:
            ...

    class QRenderTargetOutput(PySide6.Qt3DCore.Qt3DCore.QNode):
        Color0: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color1: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color2: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color3: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color4: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color5: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color6: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color7: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color8: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color9: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color10: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color11: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color12: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color13: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color14: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Color15: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Depth: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        Stencil: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
        DepthStencil: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...

        class AttachmentPoint(Enum):
            Color0: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color1: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color2: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color3: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color4: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color5: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color6: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color7: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color8: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color9: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color10: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color11: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color12: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color13: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color14: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Color15: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Depth: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            Stencil: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...
            DepthStencil: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def attachmentPoint(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint:
            ...

        def face(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace:
            ...

        def layer(self) -> int:
            ...

        def mipLevel(self) -> int:
            ...

        def setAttachmentPoint(
            self,
            attachmentPoint: PySide6.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint,
        ) -> None:
            ...

        def setFace(
            self, face: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace
        ) -> None:
            ...

        def setLayer(self, layer: int) -> None:
            ...

        def setMipLevel(self, level: int) -> None:
            ...

        def setTexture(
            self, texture: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture
        ) -> None:
            ...

        def texture(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture:
            ...

    class QRenderTargetSelector(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setTarget(
            self, target: PySide6.Qt3DRender.Qt3DRender.QRenderTarget
        ) -> None:
            ...

        def target(self) -> PySide6.Qt3DRender.Qt3DRender.QRenderTarget:
            ...

    class QSceneLoader(PySide6.Qt3DCore.Qt3DCore.QComponent):
        UnknownComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        GeometryRendererComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        TransformComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        MaterialComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        LightComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        CameraLensComponent: Qt3DRender.QSceneLoader.ComponentType = ...
        None_: Qt3DRender.QSceneLoader.Status = ...
        Loading: Qt3DRender.QSceneLoader.Status = ...
        Ready: Qt3DRender.QSceneLoader.Status = ...
        Error: Qt3DRender.QSceneLoader.Status = ...

        class ComponentType(Enum):
            UnknownComponent: Qt3DRender.QSceneLoader.ComponentType = ...
            GeometryRendererComponent: Qt3DRender.QSceneLoader.ComponentType = ...
            TransformComponent: Qt3DRender.QSceneLoader.ComponentType = ...
            MaterialComponent: Qt3DRender.QSceneLoader.ComponentType = ...
            LightComponent: Qt3DRender.QSceneLoader.ComponentType = ...
            CameraLensComponent: Qt3DRender.QSceneLoader.ComponentType = ...

        class Status(Enum):
            None_: Qt3DRender.QSceneLoader.Status = ...
            Loading: Qt3DRender.QSceneLoader.Status = ...
            Ready: Qt3DRender.QSceneLoader.Status = ...
            Error: Qt3DRender.QSceneLoader.Status = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def component(
            self,
            entityName: str,
            componentType: PySide6.Qt3DRender.Qt3DRender.QSceneLoader.ComponentType,
        ) -> PySide6.Qt3DCore.Qt3DCore.QComponent:
            ...

        def entity(self, entityName: str) -> PySide6.Qt3DCore.Qt3DCore.QEntity:
            ...

        def entityNames(self) -> List[str]:
            ...

        def setSource(self, arg: Union[PySide6.QtCore.QUrl, str]) -> None:
            ...

        def source(self) -> PySide6.QtCore.QUrl:
            ...

        def status(self) -> PySide6.Qt3DRender.Qt3DRender.QSceneLoader.Status:
            ...

    class QScissorTest(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def bottom(self) -> int:
            ...

        def height(self) -> int:
            ...

        def left(self) -> int:
            ...

        def setBottom(self, bottom: int) -> None:
            ...

        def setHeight(self, height: int) -> None:
            ...

        def setLeft(self, left: int) -> None:
            ...

        def setWidth(self, width: int) -> None:
            ...

        def width(self) -> int:
            ...

    class QScreenRayCaster(PySide6.Qt3DRender.Qt3DRender.QAbstractRayCaster):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def pick(
            self, position: PySide6.QtCore.QPoint
        ) -> List[PySide6.Qt3DRender.Qt3DRender.QRayCasterHit]:
            ...

        def position(self) -> PySide6.QtCore.QPoint:
            ...

        def setPosition(self, position: PySide6.QtCore.QPoint) -> None:
            ...

        @overload
        def trigger(self) -> None:
            ...

        @overload
        def trigger(self, position: PySide6.QtCore.QPoint) -> None:
            ...

    class QSeamlessCubemap(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QSetFence(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        NoHandle: Qt3DRender.QSetFence.HandleType = ...
        OpenGLFenceId: Qt3DRender.QSetFence.HandleType = ...

        class HandleType(Enum):
            NoHandle: Qt3DRender.QSetFence.HandleType = ...
            OpenGLFenceId: Qt3DRender.QSetFence.HandleType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def handle(self) -> Any:
            ...

        def handleType(self) -> PySide6.Qt3DRender.Qt3DRender.QSetFence.HandleType:
            ...

    class QShaderData(PySide6.Qt3DCore.Qt3DCore.QComponent):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def event(self, event: PySide6.QtCore.QEvent) -> bool:
            ...

    class QShaderImage(PySide6.Qt3DCore.Qt3DCore.QNode):
        ReadOnly: Qt3DRender.QShaderImage.Access = ...
        WriteOnly: Qt3DRender.QShaderImage.Access = ...
        ReadWrite: Qt3DRender.QShaderImage.Access = ...
        NoFormat: Qt3DRender.QShaderImage.ImageFormat = ...
        Automatic: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RGB10A2: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        R8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        R16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RG8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RG16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        R16F: Qt3DRender.QShaderImage.ImageFormat = ...
        R32F: Qt3DRender.QShaderImage.ImageFormat = ...
        RG16F: Qt3DRender.QShaderImage.ImageFormat = ...
        RG32F: Qt3DRender.QShaderImage.ImageFormat = ...
        R8I: Qt3DRender.QShaderImage.ImageFormat = ...
        R8U: Qt3DRender.QShaderImage.ImageFormat = ...
        R16I: Qt3DRender.QShaderImage.ImageFormat = ...
        R16U: Qt3DRender.QShaderImage.ImageFormat = ...
        R32I: Qt3DRender.QShaderImage.ImageFormat = ...
        R32U: Qt3DRender.QShaderImage.ImageFormat = ...
        RG8I: Qt3DRender.QShaderImage.ImageFormat = ...
        RG8U: Qt3DRender.QShaderImage.ImageFormat = ...
        RG16I: Qt3DRender.QShaderImage.ImageFormat = ...
        RG16U: Qt3DRender.QShaderImage.ImageFormat = ...
        RG32I: Qt3DRender.QShaderImage.ImageFormat = ...
        RG32U: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA32F: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA16F: Qt3DRender.QShaderImage.ImageFormat = ...
        RG11B10F: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA32U: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA16U: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA8U: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA32I: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA16I: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA8I: Qt3DRender.QShaderImage.ImageFormat = ...
        R8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RG8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        R16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RG16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RGBA16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
        RGB10A2U: Qt3DRender.QShaderImage.ImageFormat = ...

        class Access(Enum):
            ReadOnly: Qt3DRender.QShaderImage.Access = ...
            WriteOnly: Qt3DRender.QShaderImage.Access = ...
            ReadWrite: Qt3DRender.QShaderImage.Access = ...

        class ImageFormat(Enum):
            NoFormat: Qt3DRender.QShaderImage.ImageFormat = ...
            Automatic: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RGB10A2: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            R8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            R16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RG8_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RG16_UNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            R16F: Qt3DRender.QShaderImage.ImageFormat = ...
            R32F: Qt3DRender.QShaderImage.ImageFormat = ...
            RG16F: Qt3DRender.QShaderImage.ImageFormat = ...
            RG32F: Qt3DRender.QShaderImage.ImageFormat = ...
            R8I: Qt3DRender.QShaderImage.ImageFormat = ...
            R8U: Qt3DRender.QShaderImage.ImageFormat = ...
            R16I: Qt3DRender.QShaderImage.ImageFormat = ...
            R16U: Qt3DRender.QShaderImage.ImageFormat = ...
            R32I: Qt3DRender.QShaderImage.ImageFormat = ...
            R32U: Qt3DRender.QShaderImage.ImageFormat = ...
            RG8I: Qt3DRender.QShaderImage.ImageFormat = ...
            RG8U: Qt3DRender.QShaderImage.ImageFormat = ...
            RG16I: Qt3DRender.QShaderImage.ImageFormat = ...
            RG16U: Qt3DRender.QShaderImage.ImageFormat = ...
            RG32I: Qt3DRender.QShaderImage.ImageFormat = ...
            RG32U: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA32F: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA16F: Qt3DRender.QShaderImage.ImageFormat = ...
            RG11B10F: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA32U: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA16U: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA8U: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA32I: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA16I: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA8I: Qt3DRender.QShaderImage.ImageFormat = ...
            R8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RG8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA8_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            R16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RG16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RGBA16_SNorm: Qt3DRender.QShaderImage.ImageFormat = ...
            RGB10A2U: Qt3DRender.QShaderImage.ImageFormat = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def access(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderImage.Access:
            ...

        def format(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat:
            ...

        def layer(self) -> int:
            ...

        def layered(self) -> bool:
            ...

        def mipLevel(self) -> int:
            ...

        def setAccess(
            self, access: PySide6.Qt3DRender.Qt3DRender.QShaderImage.Access
        ) -> None:
            ...

        def setFormat(
            self, format: PySide6.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat
        ) -> None:
            ...

        def setLayer(self, layer: int) -> None:
            ...

        def setLayered(self, layered: bool) -> None:
            ...

        def setMipLevel(self, mipLevel: int) -> None:
            ...

        def setTexture(
            self, texture: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture
        ) -> None:
            ...

        def texture(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture:
            ...

    class QShaderProgram(PySide6.Qt3DCore.Qt3DCore.QNode):
        GLSL: Qt3DRender.QShaderProgram.Format = ...
        SPIRV: Qt3DRender.QShaderProgram.Format = ...
        Vertex: Qt3DRender.QShaderProgram.ShaderType = ...
        Fragment: Qt3DRender.QShaderProgram.ShaderType = ...
        TessellationControl: Qt3DRender.QShaderProgram.ShaderType = ...
        TessellationEvaluation: Qt3DRender.QShaderProgram.ShaderType = ...
        Geometry: Qt3DRender.QShaderProgram.ShaderType = ...
        Compute: Qt3DRender.QShaderProgram.ShaderType = ...
        NotReady: Qt3DRender.QShaderProgram.Status = ...
        Ready: Qt3DRender.QShaderProgram.Status = ...
        Error: Qt3DRender.QShaderProgram.Status = ...

        class Format(Enum):
            GLSL: Qt3DRender.QShaderProgram.Format = ...
            SPIRV: Qt3DRender.QShaderProgram.Format = ...

        class ShaderType(Enum):
            Vertex: Qt3DRender.QShaderProgram.ShaderType = ...
            Fragment: Qt3DRender.QShaderProgram.ShaderType = ...
            TessellationControl: Qt3DRender.QShaderProgram.ShaderType = ...
            TessellationEvaluation: Qt3DRender.QShaderProgram.ShaderType = ...
            Geometry: Qt3DRender.QShaderProgram.ShaderType = ...
            Compute: Qt3DRender.QShaderProgram.ShaderType = ...

        class Status(Enum):
            NotReady: Qt3DRender.QShaderProgram.Status = ...
            Ready: Qt3DRender.QShaderProgram.Status = ...
            Error: Qt3DRender.QShaderProgram.Status = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def computeShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def format(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderProgram.Format:
            ...

        def fragmentShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def geometryShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        @staticmethod
        def loadSource(
            sourceUrl: Union[PySide6.QtCore.QUrl, str]
        ) -> PySide6.QtCore.QByteArray:
            ...

        def log(self) -> str:
            ...

        def setComputeShaderCode(
            self, computeShaderCode: Union[PySide6.QtCore.QByteArray, bytes]
        ) -> None:
            ...

        def setFormat(
            self, format: PySide6.Qt3DRender.Qt3DRender.QShaderProgram.Format
        ) -> None:
            ...

        def setFragmentShaderCode(
            self, fragmentShaderCode: Union[PySide6.QtCore.QByteArray, bytes]
        ) -> None:
            ...

        def setGeometryShaderCode(
            self, geometryShaderCode: Union[PySide6.QtCore.QByteArray, bytes]
        ) -> None:
            ...

        def setShaderCode(
            self,
            type: PySide6.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType,
            shaderCode: Union[PySide6.QtCore.QByteArray, bytes],
        ) -> None:
            ...

        def setTessellationControlShaderCode(
            self, tessellationControlShaderCode: Union[PySide6.QtCore.QByteArray, bytes]
        ) -> None:
            ...

        def setTessellationEvaluationShaderCode(
            self,
            tessellationEvaluationShaderCode: Union[PySide6.QtCore.QByteArray, bytes],
        ) -> None:
            ...

        def setVertexShaderCode(
            self, vertexShaderCode: Union[PySide6.QtCore.QByteArray, bytes]
        ) -> None:
            ...

        def shaderCode(
            self, type: PySide6.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType
        ) -> PySide6.QtCore.QByteArray:
            ...

        def status(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderProgram.Status:
            ...

        def tessellationControlShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def tessellationEvaluationShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def vertexShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

    class QShaderProgramBuilder(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def computeShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def computeShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

        def enabledLayers(self) -> List[str]:
            ...

        def fragmentShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def fragmentShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

        def geometryShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def geometryShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

        def setComputeShaderGraph(
            self, computeShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def setEnabledLayers(self, layers: Sequence[str]) -> None:
            ...

        def setFragmentShaderGraph(
            self, fragmentShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def setGeometryShaderGraph(
            self, geometryShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def setShaderProgram(
            self, program: PySide6.Qt3DRender.Qt3DRender.QShaderProgram
        ) -> None:
            ...

        def setTessellationControlShaderGraph(
            self, tessellationControlShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def setTessellationEvaluationShaderGraph(
            self, tessellationEvaluationShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def setVertexShaderGraph(
            self, vertexShaderGraph: Union[PySide6.QtCore.QUrl, str]
        ) -> None:
            ...

        def shaderProgram(self) -> PySide6.Qt3DRender.Qt3DRender.QShaderProgram:
            ...

        def tessellationControlShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def tessellationControlShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

        def tessellationEvaluationShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def tessellationEvaluationShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

        def vertexShaderCode(self) -> PySide6.QtCore.QByteArray:
            ...

        def vertexShaderGraph(self) -> PySide6.QtCore.QUrl:
            ...

    class QSharedGLTexture(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def setTextureId(self, id: int) -> None:
            ...

        def textureId(self) -> int:
            ...

    class QSortPolicy(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        StateChangeCost: Qt3DRender.QSortPolicy.SortType = ...
        BackToFront: Qt3DRender.QSortPolicy.SortType = ...
        Material: Qt3DRender.QSortPolicy.SortType = ...
        FrontToBack: Qt3DRender.QSortPolicy.SortType = ...
        Texture: Qt3DRender.QSortPolicy.SortType = ...
        Uniform: Qt3DRender.QSortPolicy.SortType = ...

        class SortType(Enum):
            StateChangeCost: Qt3DRender.QSortPolicy.SortType = ...
            BackToFront: Qt3DRender.QSortPolicy.SortType = ...
            Material: Qt3DRender.QSortPolicy.SortType = ...
            FrontToBack: Qt3DRender.QSortPolicy.SortType = ...
            Texture: Qt3DRender.QSortPolicy.SortType = ...
            Uniform: Qt3DRender.QSortPolicy.SortType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        @overload
        def setSortTypes(
            self,
            sortTypes: Sequence[PySide6.Qt3DRender.Qt3DRender.QSortPolicy.SortType],
        ) -> None:
            ...

        @overload
        def setSortTypes(self, sortTypesInt: Sequence[int]) -> None:
            ...

        def sortTypes(self) -> List[PySide6.Qt3DRender.Qt3DRender.QSortPolicy.SortType]:
            ...

        def sortTypesInt(self) -> List[int]:
            ...

    class QSpotLight(PySide6.Qt3DRender.Qt3DRender.QAbstractLight):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def constantAttenuation(self) -> float:
            ...

        def cutOffAngle(self) -> float:
            ...

        def linearAttenuation(self) -> float:
            ...

        def localDirection(self) -> PySide6.QtGui.QVector3D:
            ...

        def quadraticAttenuation(self) -> float:
            ...

        def setConstantAttenuation(self, value: float) -> None:
            ...

        def setCutOffAngle(self, cutOffAngle: float) -> None:
            ...

        def setLinearAttenuation(self, value: float) -> None:
            ...

        def setLocalDirection(self, localDirection: PySide6.QtGui.QVector3D) -> None:
            ...

        def setQuadraticAttenuation(self, value: float) -> None:
            ...

    class QStencilMask(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def backOutputMask(self) -> int:
            ...

        def frontOutputMask(self) -> int:
            ...

        def setBackOutputMask(self, backOutputMask: int) -> None:
            ...

        def setFrontOutputMask(self, frontOutputMask: int) -> None:
            ...

    class QStencilOperation(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def back(self) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments:
            ...

        def front(self) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments:
            ...

    class QStencilOperationArguments(PySide6.QtCore.QObject):
        Front: Qt3DRender.QStencilOperationArguments.FaceMode = ...
        Back: Qt3DRender.QStencilOperationArguments.FaceMode = ...
        FrontAndBack: Qt3DRender.QStencilOperationArguments.FaceMode = ...
        Zero: Qt3DRender.QStencilOperationArguments.Operation = ...
        Invert: Qt3DRender.QStencilOperationArguments.Operation = ...
        Keep: Qt3DRender.QStencilOperationArguments.Operation = ...
        Replace: Qt3DRender.QStencilOperationArguments.Operation = ...
        Increment: Qt3DRender.QStencilOperationArguments.Operation = ...
        Decrement: Qt3DRender.QStencilOperationArguments.Operation = ...
        IncrementWrap: Qt3DRender.QStencilOperationArguments.Operation = ...
        DecrementWrap: Qt3DRender.QStencilOperationArguments.Operation = ...

        class FaceMode(Enum):
            Front: Qt3DRender.QStencilOperationArguments.FaceMode = ...
            Back: Qt3DRender.QStencilOperationArguments.FaceMode = ...
            FrontAndBack: Qt3DRender.QStencilOperationArguments.FaceMode = ...

        class Operation(Enum):
            Zero: Qt3DRender.QStencilOperationArguments.Operation = ...
            Invert: Qt3DRender.QStencilOperationArguments.Operation = ...
            Keep: Qt3DRender.QStencilOperationArguments.Operation = ...
            Replace: Qt3DRender.QStencilOperationArguments.Operation = ...
            Increment: Qt3DRender.QStencilOperationArguments.Operation = ...
            Decrement: Qt3DRender.QStencilOperationArguments.Operation = ...
            IncrementWrap: Qt3DRender.QStencilOperationArguments.Operation = ...
            DecrementWrap: Qt3DRender.QStencilOperationArguments.Operation = ...

        def allTestsPassOperation(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation:
            ...

        def depthTestFailureOperation(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation:
            ...

        def faceMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.FaceMode:
            ...

        def setAllTestsPassOperation(
            self,
            operation: PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation,
        ) -> None:
            ...

        def setDepthTestFailureOperation(
            self,
            operation: PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation,
        ) -> None:
            ...

        def setStencilTestFailureOperation(
            self,
            operation: PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation,
        ) -> None:
            ...

        def stencilTestFailureOperation(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation:
            ...

    class QStencilTest(PySide6.Qt3DRender.Qt3DRender.QRenderState):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def back(self) -> PySide6.Qt3DRender.Qt3DRender.QStencilTestArguments:
            ...

        def front(self) -> PySide6.Qt3DRender.Qt3DRender.QStencilTestArguments:
            ...

    class QStencilTestArguments(PySide6.QtCore.QObject):
        Front: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...
        Back: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...
        FrontAndBack: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...
        Never: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        Less: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        Equal: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        LessOrEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        Greater: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        NotEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        GreaterOrEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
        Always: Qt3DRender.QStencilTestArguments.StencilFunction = ...

        class StencilFaceMode(Enum):
            Front: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...
            Back: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...
            FrontAndBack: Qt3DRender.QStencilTestArguments.StencilFaceMode = ...

        class StencilFunction(Enum):
            Never: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            Less: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            Equal: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            LessOrEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            Greater: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            NotEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            GreaterOrEqual: Qt3DRender.QStencilTestArguments.StencilFunction = ...
            Always: Qt3DRender.QStencilTestArguments.StencilFunction = ...

        def comparisonMask(self) -> int:
            ...

        def faceMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFaceMode:
            ...

        def referenceValue(self) -> int:
            ...

        def setComparisonMask(self, comparisonMask: int) -> None:
            ...

        def setReferenceValue(self, referenceValue: int) -> None:
            ...

        def setStencilFunction(
            self,
            stencilFunction: PySide6.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction,
        ) -> None:
            ...

        def stencilFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction:
            ...

    class QSubtreeEnabler(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        Persistent: Qt3DRender.QSubtreeEnabler.Enablement = ...
        SingleShot: Qt3DRender.QSubtreeEnabler.Enablement = ...

        class Enablement(Enum):
            Persistent: Qt3DRender.QSubtreeEnabler.Enablement = ...
            SingleShot: Qt3DRender.QSubtreeEnabler.Enablement = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def enablement(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QSubtreeEnabler.Enablement:
            ...

        def requestUpdate(self) -> None:
            ...

        def setEnablement(
            self, enablement: PySide6.Qt3DRender.Qt3DRender.QSubtreeEnabler.Enablement
        ) -> None:
            ...

    class QTechnique(PySide6.Qt3DCore.Qt3DCore.QNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addFilterKey(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def addParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

        def addRenderPass(
            self, pass_: PySide6.Qt3DRender.Qt3DRender.QRenderPass
        ) -> None:
            ...

        def filterKeys(self) -> List[PySide6.Qt3DRender.Qt3DRender.QFilterKey]:
            ...

        def graphicsApiFilter(self) -> PySide6.Qt3DRender.Qt3DRender.QGraphicsApiFilter:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeFilterKey(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def removeParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

        def removeRenderPass(
            self, pass_: PySide6.Qt3DRender.Qt3DRender.QRenderPass
        ) -> None:
            ...

        def renderPasses(self) -> List[PySide6.Qt3DRender.Qt3DRender.QRenderPass]:
            ...

    class QTechniqueFilter(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def addMatch(self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey) -> None:
            ...

        def addParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

        def matchAll(self) -> List[PySide6.Qt3DRender.Qt3DRender.QFilterKey]:
            ...

        def parameters(self) -> List[PySide6.Qt3DRender.Qt3DRender.QParameter]:
            ...

        def removeMatch(
            self, filterKey: PySide6.Qt3DRender.Qt3DRender.QFilterKey
        ) -> None:
            ...

        def removeParameter(self, p: PySide6.Qt3DRender.Qt3DRender.QParameter) -> None:
            ...

    class QTexture1D(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture1DArray(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture2D(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture2DArray(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture2DMultisample(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture2DMultisampleArray(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTexture3D(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTextureBuffer(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTextureCubeMap(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTextureCubeMapArray(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTextureData(object):
        def __init__(self) -> None:
            ...

        def comparisonFunction(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction:
            ...

        def comparisonMode(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode:
            ...

        def depth(self) -> int:
            ...

        def format(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat:
            ...

        def height(self) -> int:
            ...

        def isAutoMipMapGenerationEnabled(self) -> bool:
            ...

        def layers(self) -> int:
            ...

        def magnificationFilter(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter:
            ...

        def maximumAnisotropy(self) -> float:
            ...

        def minificationFilter(
            self,
        ) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter:
            ...

        def setAutoMipMapGenerationEnabled(
            self, isAutoMipMapGenerationEnabled: bool
        ) -> None:
            ...

        def setComparisonFunction(
            self,
            comparisonFunction: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction,
        ) -> None:
            ...

        def setComparisonMode(
            self,
            comparisonMode: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode,
        ) -> None:
            ...

        def setDepth(self, depth: int) -> None:
            ...

        def setFormat(
            self, arg__1: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat
        ) -> None:
            ...

        def setHeight(self, height: int) -> None:
            ...

        def setLayers(self, layers: int) -> None:
            ...

        def setMagnificationFilter(
            self, filter: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter
        ) -> None:
            ...

        def setMaximumAnisotropy(self, maximumAnisotropy: float) -> None:
            ...

        def setMinificationFilter(
            self, filter: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Filter
        ) -> None:
            ...

        def setTarget(
            self, target: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Target
        ) -> None:
            ...

        def setWidth(self, width: int) -> None:
            ...

        def setWrapModeX(
            self, wrapModeX: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def setWrapModeY(
            self, wrapModeY: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def setWrapModeZ(
            self, wrapModeZ: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def target(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.Target:
            ...

        def width(self) -> int:
            ...

        def wrapModeX(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

        def wrapModeY(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

        def wrapModeZ(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

    class QTextureDataUpdate(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, other: PySide6.Qt3DRender.Qt3DRender.QTextureDataUpdate
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def face(self) -> PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace:
            ...

        def layer(self) -> int:
            ...

        def mipLevel(self) -> int:
            ...

        def setFace(
            self, face: PySide6.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace
        ) -> None:
            ...

        def setLayer(self, layer: int) -> None:
            ...

        def setMipLevel(self, mipLevel: int) -> None:
            ...

        def setX(self, x: int) -> None:
            ...

        def setY(self, y: int) -> None:
            ...

        def setZ(self, z: int) -> None:
            ...

        def swap(self, other: PySide6.Qt3DRender.Qt3DRender.QTextureDataUpdate) -> None:
            ...

        def x(self) -> int:
            ...

        def y(self) -> int:
            ...

        def z(self) -> int:
            ...

    class QTextureImage(PySide6.Qt3DRender.Qt3DRender.QAbstractTextureImage):
        None_: Qt3DRender.QTextureImage.Status = ...
        Loading: Qt3DRender.QTextureImage.Status = ...
        Ready: Qt3DRender.QTextureImage.Status = ...
        Error: Qt3DRender.QTextureImage.Status = ...

        class Status(Enum):
            None_: Qt3DRender.QTextureImage.Status = ...
            Loading: Qt3DRender.QTextureImage.Status = ...
            Ready: Qt3DRender.QTextureImage.Status = ...
            Error: Qt3DRender.QTextureImage.Status = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def isMirrored(self) -> bool:
            ...

        def setMirrored(self, mirrored: bool) -> None:
            ...

        def setSource(self, source: Union[PySide6.QtCore.QUrl, str]) -> None:
            ...

        def setStatus(
            self, status: PySide6.Qt3DRender.Qt3DRender.QTextureImage.Status
        ) -> None:
            ...

        def source(self) -> PySide6.QtCore.QUrl:
            ...

        def status(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureImage.Status:
            ...

    class QTextureImageData(object):
        def __init__(self) -> None:
            ...

        def alignment(self) -> int:
            ...

        def cleanup(self) -> None:
            ...

        def data(
            self, layer: int = ..., face: int = ..., mipmapLevel: int = ...
        ) -> PySide6.QtCore.QByteArray:
            ...

        def depth(self) -> int:
            ...

        def faces(self) -> int:
            ...

        def height(self) -> int:
            ...

        def isCompressed(self) -> bool:
            ...

        def layers(self) -> int:
            ...

        def mipLevels(self) -> int:
            ...

        def setAlignment(self, alignment: int) -> None:
            ...

        def setData(
            self,
            data: Union[PySide6.QtCore.QByteArray, bytes],
            blockSize: int,
            isCompressed: bool = ...,
        ) -> None:
            ...

        def setDepth(self, depth: int) -> None:
            ...

        def setFaces(self, faces: int) -> None:
            ...

        def setHeight(self, height: int) -> None:
            ...

        def setImage(self, arg__1: Union[PySide6.QtGui.QImage, str]) -> None:
            ...

        def setLayers(self, layers: int) -> None:
            ...

        def setMipLevels(self, mipLevels: int) -> None:
            ...

        def setWidth(self, width: int) -> None:
            ...

        def width(self) -> int:
            ...

    class QTextureImageDataGenerator(PySide6.Qt3DCore.Qt3DCore.QAbstractFunctor):
        ...

    class QTextureLoader(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def isMirrored(self) -> bool:
            ...

        def setMirrored(self, mirrored: bool) -> None:
            ...

        def setSource(self, source: Union[PySide6.QtCore.QUrl, str]) -> None:
            ...

        def source(self) -> PySide6.QtCore.QUrl:
            ...

    class QTextureRectangle(PySide6.Qt3DRender.Qt3DRender.QAbstractTexture):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

    class QTextureWrapMode(PySide6.QtCore.QObject):
        Repeat: Qt3DRender.QTextureWrapMode.WrapMode = ...
        ClampToBorder: Qt3DRender.QTextureWrapMode.WrapMode = ...
        ClampToEdge: Qt3DRender.QTextureWrapMode.WrapMode = ...
        MirroredRepeat: Qt3DRender.QTextureWrapMode.WrapMode = ...

        class WrapMode(Enum):
            Repeat: Qt3DRender.QTextureWrapMode.WrapMode = ...
            ClampToBorder: Qt3DRender.QTextureWrapMode.WrapMode = ...
            ClampToEdge: Qt3DRender.QTextureWrapMode.WrapMode = ...
            MirroredRepeat: Qt3DRender.QTextureWrapMode.WrapMode = ...

        @overload
        def __init__(
            self,
            wrapMode: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode = ...,
            parent: Optional[PySide6.QtCore.QObject] = ...,
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            x: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode,
            y: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode,
            z: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode,
            parent: Optional[PySide6.QtCore.QObject] = ...,
        ) -> None:
            ...

        def setX(
            self, x: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def setY(
            self, y: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def setZ(
            self, z: PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode
        ) -> None:
            ...

        def x(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

        def y(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

        def z(self) -> PySide6.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode:
            ...

    class QViewport(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def gamma(self) -> float:
            ...

        def normalizedRect(self) -> PySide6.QtCore.QRectF:
            ...

        def setGamma(self, gamma: float) -> None:
            ...

        def setNormalizedRect(
            self, normalizedRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
        ) -> None:
            ...

    class QWaitFence(PySide6.Qt3DRender.Qt3DRender.QFrameGraphNode):
        NoHandle: Qt3DRender.QWaitFence.HandleType = ...
        OpenGLFenceId: Qt3DRender.QWaitFence.HandleType = ...

        class HandleType(Enum):
            NoHandle: Qt3DRender.QWaitFence.HandleType = ...
            OpenGLFenceId: Qt3DRender.QWaitFence.HandleType = ...

        def __init__(
            self, parent: Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...
        ) -> None:
            ...

        def handle(self) -> Any:
            ...

        def handleType(self) -> PySide6.Qt3DRender.Qt3DRender.QWaitFence.HandleType:
            ...

        def setHandle(self, handle: Any) -> None:
            ...

        def setHandleType(
            self, type: PySide6.Qt3DRender.Qt3DRender.QWaitFence.HandleType
        ) -> None:
            ...

        def setTimeout(self, timeout: int) -> None:
            ...

        def setWaitOnCPU(self, waitOnCPU: bool) -> None:
            ...

        def timeout(self) -> int:
            ...

        def waitOnCPU(self) -> bool:
            ...

    @staticmethod
    def swap(
        lhs: PySide6.Qt3DRender.Qt3DRender.QTextureDataUpdate,
        rhs: PySide6.Qt3DRender.Qt3DRender.QTextureDataUpdate,
    ) -> None:
        ...
