#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', ]

test_requirements = ['pytest>=3', ]

setup(
    author="gigahanma",
    author_email='random@example.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Reads data and manipulates data from CSV easily, also includes statistics functions",
    entry_points={
        'console_scripts': [
            'simplereader=simplereader.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='simplereader',
    name='simplereader',
    packages=find_packages(include=['simplereader', 'simplereader.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/haddad-github/simplereader',
    version='0.0.7',
    zip_safe=False,
)
