# About the documentation

README.md at the project root serves as the:

- project home page
- PYPI long description
- user manual

Design considerations:

- Most text is in the README.
- Python Package Index long description taken from the README.
- README is at the GitHub repository root.
- Examples in the README are fully syntax highlighted.
- Building a static copy of the documentation for offline use.
- No visible raw ReStructured text in the README rendered by GitHub.

## Implementation

- GitHub pages hosts the project website.
- GitHub hosts the repository and renders README.md.
- readthedocs.org hosts the HTML and creates the PDF for offline use.
- Nearly everything is in README.md. These aren't:
  - index.rst - Top level of the Sphinx documentation.
  - about.md - About the documentation (this page).
  - api.rst - Development tools API generated by
    Sphinx autodoc and napoleon.
  - recent_changes.md
  - CONTRIBUTING.md

## Tools

- GitHub Pages
- Sphinx
- myst_parser

myst_parser enables Sphinx to parse Markdown files.

## Files

These files are at the project root:

- _config.yml
- .readthedocs.yml
- index.rst
- README.md
- conf.py

GitHub page build consumes _config.yml.

Since conf.py is at the project root Sphinx searches the entire
project for document source files.  Additional
**exclude_patterns** keep out unwanted document source files.

The files below in the doc folder are not part of the documentation:
  - make_wrapped_examples.py
  - livelog.py
  - livelog_test_assertion.py
  - livelog_bad_session.py

### Read the Docs hosting

readthedocs.org hosts the Sphinx documentation.
**doc/requirements.txt** lists the build dependencies.
