# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['classy_imaginary',
 'classy_imaginary.enhancers',
 'classy_imaginary.enhancers.phraselists',
 'classy_imaginary.modules',
 'classy_imaginary.modules.diffusion',
 'classy_imaginary.modules.midas',
 'classy_imaginary.modules.midas.midas',
 'classy_imaginary.samplers',
 'classy_imaginary.vendored',
 'classy_imaginary.vendored.blip',
 'classy_imaginary.vendored.clip',
 'classy_imaginary.vendored.clipseg',
 'classy_imaginary.vendored.codeformer',
 'classy_imaginary.vendored.k_diffusion',
 'classy_imaginary.vendored.k_diffusion.models']

package_data = \
{'': ['*'],
 'classy_imaginary': ['configs/*'],
 'classy_imaginary.vendored': ['noodle_soup_prompts/*'],
 'classy_imaginary.vendored.blip': ['configs/*']}

install_requires = \
['Pillow>=8.0.0',
 'click-shell>=2.1',
 'click>=8.0.4',
 'diffusers',
 'einops==0.3.0',
 'fairscale>=0.4.4',
 'ftfy',
 'gfpgan>=1.3.7',
 'imageio==2.9.0',
 'kornia==0.6',
 'llvmlite>=0.39.1,<0.40.0',
 'numpy',
 'omegaconf==2.1.1',
 'open-clip-torch',
 'protobuf!=3.20.2,!=3.19.5',
 'psutil',
 'pytorch-lightning==1.4.2',
 'realesrgan>=0.3.0,<0.4.0',
 'requests',
 'timm>=0.4.12',
 'torch>=1.2.0',
 'torchdiffeq',
 'torchmetrics==0.6.0',
 'torchvision>=0.13.1',
 'tqdm',
 'transformers==4.19.2']

setup_kwargs = {
    'name': 'classy-imaginary',
    'version': '0.1.0',
    'description': 'This is not a useful package. It is a wrapper around imaginary to provide a Class interface.',
    'long_description': '# ImaginAIry 🤖🧠\n[![Downloads](https://pepy.tech/badge/imaginairy)](https://pepy.tech/project/imaginairy)\n[![image](https://img.shields.io/pypi/v/imaginairy.svg)](https://pypi.org/project/imaginairy/)\n[![image](https://img.shields.io/badge/license-MIT-green)](https://github.com/brycedrennan/imaginAIry/blob/master/LICENSE/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n[![Python Checks](https://github.com/brycedrennan/imaginAIry/actions/workflows/ci.yaml/badge.svg)](https://github.com/brycedrennan/imaginAIry/actions/workflows/ci.yaml)\n\nAI imagined images. Pythonic generation of stable diffusion images.\n\n"just works" on Linux and macOS(M1) (and maybe windows?).\n\n## Examples\n```bash\n# on macOS, make sure rust is installed first\n>> pip install classy-imaginary\n>> imagine "a scenic landscape" "a photo of a dog" "photo of a fruit bowl" "portrait photo of a freckled woman"\n# Stable Diffusion 2.1\n>> imagine --model SD-2.1 "a forest"\n```\n\n<details closed>\n<summary>Console Output</summary>\n\n```bash\n🤖🧠 received 4 prompt(s) and will repeat them 1 times to create 4 images.\nLoading model onto mps backend...\nGenerating 🖼  : "a scenic landscape" 512x512px seed:557988237 prompt-strength:7.5 steps:40 sampler-type:PLMS\n    PLMS Sampler: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 40/40 [00:29<00:00,  1.36it/s]\n    🖼  saved to: ./outputs/000001_557988237_PLMS40_PS7.5_a_scenic_landscape.jpg\nGenerating 🖼  : "a photo of a dog" 512x512px seed:277230171 prompt-strength:7.5 steps:40 sampler-type:PLMS\n    PLMS Sampler: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 40/40 [00:28<00:00,  1.41it/s]\n    🖼  saved to: ./outputs/000002_277230171_PLMS40_PS7.5_a_photo_of_a_dog.jpg\nGenerating 🖼  : "photo of a fruit bowl" 512x512px seed:639753980 prompt-strength:7.5 steps:40 sampler-type:PLMS\n    PLMS Sampler: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 40/40 [00:28<00:00,  1.40it/s]\n    🖼  saved to: ./outputs/000003_639753980_PLMS40_PS7.5_photo_of_a_fruit_bowl.jpg\nGenerating 🖼  : "portrait photo of a freckled woman" 512x512px seed:500686645 prompt-strength:7.5 steps:40 sampler-type:PLMS\n    PLMS Sampler: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 40/40 [00:29<00:00,  1.37it/s]\n    🖼  saved to: ./outputs/000004_500686645_PLMS40_PS7.5_portrait_photo_of_a_freckled_woman.jpg\n```\n</details>\n\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000019_786355545_PLMS50_PS7.5_a_scenic_landscape.jpg" height="256"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000032_337692011_PLMS40_PS7.5_a_photo_of_a_dog.jpg"  height="256"><br>\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000056_293284644_PLMS40_PS7.5_photo_of_a_bowl_of_fruit.jpg" height="256"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000078_260972468_PLMS40_PS7.5_portrait_photo_of_a_freckled_woman.jpg"  height="256">\n\n### Prompt Based Editing  [by clipseg](https://github.com/timojl/clipseg)\nSpecify advanced text based masks using boolean logic and strength modifiers. \nMask syntax:\n  - mask descriptions must be lowercase\n  - keywords (`AND`, `OR`, `NOT`) must be uppercase\n  - parentheses are supported \n  - mask modifiers may be appended to any mask or group of masks.  Example: `(dog OR cat){+5}` means that we\'ll\nselect any dog or cat and then expand the size of the mask area by 5 pixels.  Valid mask modifiers:\n    - `{+n}` - expand mask by n pixels\n    - `{-n}` - shrink mask by n pixels\n    - `{*n}` - multiply mask strength. will expand mask to areas that weakly matched the mask description\n    - `{/n}` - divide mask strength. will reduce mask to areas that most strongly matched the mask description. probably not useful\n\nWhen writing strength modifiers keep in mind that pixel values are between 0 and 1.\n\n```bash\n>> imagine \\\n    --init-image pearl_earring.jpg \\ \n    --mask-prompt "face AND NOT (bandana OR hair OR blue fabric){*6}" \\\n    --mask-mode keep \\\n    --init-image-strength .2 \\\n    --fix-faces \\\n    "a modern female president" "a female robot" "a female doctor" "a female firefighter"\n```\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/mask_examples/pearl000.jpg" height="200">➡️ \n<img src="assets/mask_examples/pearl_pres.png" height="200">\n<img src="assets/mask_examples/pearl_robot.png" height="200">\n<img src="assets/mask_examples/pearl_doctor.png" height="200">\n<img src="assets/mask_examples/pearl_firefighter.png" height="200">\n\n```bash\n>> imagine \\\n    --init-image fruit-bowl.jpg \\\n    --mask-prompt "fruit OR fruit stem{*6}" \\\n    --mask-mode replace \\\n    --mask-modify-original \\\n    --init-image-strength .1 \\\n    "a bowl of kittens" "a bowl of gold coins" "a bowl of popcorn" "a bowl of spaghetti"\n```\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000056_293284644_PLMS40_PS7.5_photo_of_a_bowl_of_fruit.jpg" height="200">➡️ \n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/mask_examples/bowl004.jpg" height="200">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/mask_examples/bowl001.jpg" height="200">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/mask_examples/bowl002.jpg" height="200">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/mask_examples/bowl003.jpg" height="200">\n\n\n### Face Enhancement [by CodeFormer](https://github.com/sczhou/CodeFormer)\n\n```bash\n>> imagine "a couple smiling" --steps 40 --seed 1 --fix-faces\n```\n<img src="https://github.com/brycedrennan/imaginAIry/raw/master/assets/000178_1_PLMS40_PS7.5_a_couple_smiling_nofix.png" height="256"> ➡️ \n<img src="https://github.com/brycedrennan/imaginAIry/raw/master/assets/000178_1_PLMS40_PS7.5_a_couple_smiling_fixed.png" height="256"> \n\n\n### Upscaling [by RealESRGAN](https://github.com/xinntao/Real-ESRGAN)\n```bash\n>> imagine "colorful smoke" --steps 40 --upscale\n```\n<img src="https://github.com/brycedrennan/imaginAIry/raw/master/assets/000206_856637805_PLMS40_PS7.5_colorful_smoke.jpg" height="128"> ➡️ \n<img src="https://github.com/brycedrennan/imaginAIry/raw/master/assets/000206_856637805_PLMS40_PS7.5_colorful_smoke_upscaled.jpg" height="256"> \n\n### Tiled Images\n```bash\n>> imagine  "gold coins" "a lush forest" "piles of old books" leaves --tile\n```\n\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000066_801493266_PLMS40_PS7.5_gold_coins.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000066_801493266_PLMS40_PS7.5_gold_coins.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000066_801493266_PLMS40_PS7.5_gold_coins.jpg" height="128">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000118_597948545_PLMS40_PS7.5_a_lush_forest.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000118_597948545_PLMS40_PS7.5_a_lush_forest.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000118_597948545_PLMS40_PS7.5_a_lush_forest.jpg" height="128">\n<br>\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000075_961095192_PLMS40_PS7.5_piles_of_old_books.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000075_961095192_PLMS40_PS7.5_piles_of_old_books.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000075_961095192_PLMS40_PS7.5_piles_of_old_books.jpg" height="128">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000040_527733581_PLMS40_PS7.5_leaves.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000040_527733581_PLMS40_PS7.5_leaves.jpg" height="128"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000040_527733581_PLMS40_PS7.5_leaves.jpg" height="128">\n#### 360 degree images\n```bash\nimagine --tile-x -w 1024 -h 512 "360 degree equirectangular panorama photograph of the desert"  --upscale\n```\n<img src="assets/desert_360.jpg" height="128">\n\n### Image-to-Image\nUse depth maps for amazing "translations" of existing images.\n\n```bash\n>> imagine --model SD-2.0-depth --init-image girl_with_a_pearl_earring_large.jpg --init-image-strength 0.05  "professional headshot photo of a woman with a pearl earring" -r 4 -w 1024 -h 1024 --steps 50\n```\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/tests/data/girl_with_a_pearl_earring.jpg" height="256"> ➡️ \n<img src="assets/pearl_depth_1.jpg" height="512">\n<img src="assets/pearl_depth_2.jpg" height="512"> \n<img src="assets/pearl_depth_3.jpg" height="512">\n\n### Prompt Expansion\nYou can use `{}` to randomly pull values from lists.  A list of values separated by `|` \n and enclosed in `{ }` will be randomly drawn from in a non-repeating fashion. Values that are surrounded by `_ _` will \n pull from a phrase list of the same name.   Folders containing .txt phraselist files may be specified via\n`--prompt_library_path`. The option may be specified multiple times.  Built-in categories:\n    \n      3d-term, adj-architecture, adj-beauty, adj-detailed, adj-emotion, adj-general, adj-horror, animal, art-movement, \n      art-site, artist, artist-botanical, artist-surreal, aspect-ratio, bird, body-of-water, body-pose, camera-brand,\n      camera-model, color, cosmic-galaxy, cosmic-nebula, cosmic-star, cosmic-term, dinosaur, eyecolor, f-stop, \n      fantasy-creature, fantasy-setting, fish, flower, focal-length, food, fruit, games, gen-modifier, hair, hd,\n      iso-stop, landscape-type, national-park, nationality, neg-weight, noun-beauty, noun-fantasy, noun-general, \n      noun-horror, occupation, photo-term, pop-culture, pop-location, punk-style, quantity, rpg-item, scenario-desc, \n      skin-color, spaceship, style, tree-species, trippy, world-heritage-site\n\n   Examples:\n\n   `imagine "a {lime|blue|silver|aqua} colored dog" -r 4 --seed 0` (note that it generates a dog of each color without repetition)\n\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000184_0_plms40_PS7.5_a_silver_colored_dog_[generated].jpg" height="200"><img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000186_0_plms40_PS7.5_a_aqua_colored_dog_[generated].jpg" height="200">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000210_0_plms40_PS7.5_a_lime_colored_dog_[generated].jpg" height="200">\n<img src="https://raw.githubusercontent.com/brycedrennan/imaginAIry/master/assets/000211_0_plms40_PS7.5_a_blue_colored_dog_[generated].jpg" height="200">\n\n   `imagine "a {_color_} dog" -r 4 --seed 0` will generate four, different colored dogs. The colors will be pulled from an included \n   phraselist of colors.\n    \n   `imagine "a {_spaceship_|_fruit_|hot air balloon}. low-poly" -r 4 --seed 0` will generate images of spaceships or fruits or a hot air balloon\n\n   Credit to [noodle-soup-prompts](https://github.com/WASasquatch/noodle-soup-prompts/) where most, but not all, of the wordlists originate.\n\n### Generate image captions (via [BLIP](https://github.com/salesforce/BLIP))\n```bash\n>> aimg describe assets/mask_examples/bowl001.jpg\na bowl full of gold bars sitting on a table\n```\n\n## Features\n \n - It makes images from text descriptions! 🎉\n - Generate images either in code or from command line.\n - It just works. Proper requirements are installed. model weights are automatically downloaded. No huggingface account needed. \n    (if you have the right hardware... and aren\'t on windows)\n - No more distorted faces!\n - Noisy logs are gone (which was surprisingly hard to accomplish)\n - WeightedPrompts let you smash together separate prompts (cat-dog)\n - Tile Mode creates tileable images\n - Prompt metadata saved into image file metadata\n - Edit images by describing the part you want edited (see example above)\n - Have AI generate captions for images `aimg describe <filename-or-url>`\n - Interactive prompt: just run `aimg`\n\n## How To\n\nFor full command line instructions run `aimg --help`\n\n```python\nfrom imaginairy import imagine, imagine_image_files, ImaginePrompt, WeightedPrompt, LazyLoadingImage\n\nurl = "https://upload.wikimedia.org/wikipedia/commons/thumb/6/6c/Thomas_Cole_-_Architect%E2%80%99s_Dream_-_Google_Art_Project.jpg/540px-Thomas_Cole_-_Architect%E2%80%99s_Dream_-_Google_Art_Project.jpg"\nprompts = [\n    ImaginePrompt("a scenic landscape", seed=1, upscale=True),\n    ImaginePrompt("a bowl of fruit"),\n    ImaginePrompt([\n        WeightedPrompt("cat", weight=1),\n        WeightedPrompt("dog", weight=1),\n    ]),\n    ImaginePrompt(\n        "a spacious building", \n        init_image=LazyLoadingImage(url=url)\n    ),\n    ImaginePrompt(\n        "a bowl of strawberries", \n        init_image=LazyLoadingImage(filepath="mypath/to/bowl_of_fruit.jpg"),\n        mask_prompt="fruit OR stem{*2}",  # amplify the stem mask x2\n        mask_mode="replace",\n        mask_modify_original=True,\n    ),\n    ImaginePrompt("strawberries", tile_mode=True),\n]\nfor result in imagine(prompts):\n    # do something\n    result.save("my_image.jpg")\n\n# or\n\nimagine_image_files(prompts, outdir="./my-art")\n\n```\n\n## Requirements\n- ~10 gb space for models to download\n- A decent computer with either a CUDA supported graphics card (and CUDA installed) or an M1 processor.\n- Python installed. Preferably Python 3.10.  (not conda)\n- For macOS [rust](https://www.rust-lang.org/tools/install) and setuptools-rust must be installed to compile the `tokenizer` library.\nThey can be installed via: `curl --proto \'=https\' --tlsv1.2 -sSf https://sh.rustup.rs | sh` and `pip install setuptools-rust`\n    \n\n## Running in Docker\nSee example Dockerfile (works on machine where you can pass the gpu into the container)\n```bash\ndocker build . -t imaginairy\n# you really want to map the cache or you end up wasting a lot of time and space redownloading the model weights\ndocker run -it --gpus all -v $HOME/.cache/huggingface:/root/.cache/huggingface -v $HOME/.cache/torch:/root/.cache/torch -v `pwd`/outputs:/outputs imaginairy /bin/bash\n```\n\n## Running on Google Colab\n[Example Colab](https://colab.research.google.com/drive/1rOvQNs0Cmn_yU1bKWjCOHzGVDgZkaTtO?usp=sharing)\n\n## ChangeLog\n**7.3.0**\n- feature: 🎉 depth-based image-to-image generations (and inpainting) \n- fix: k_euler_a produces more consistent images per seed (randomization respects the seed again)\n\n**7.2.0**\n- feature: 🎉 tile in a single dimension ("x" or "y").  This enables, with a bit of luck, generation of 360 VR images.\nTry this for example: `imagine --tile-x -w 1024 -h 512 "360 degree equirectangular panorama photograph of the mountains"  --upscale`\n\n**7.1.1**\n- fix: memory/speed regression introduced in 6.1.0\n- fix: model switching now clears memory better, thus avoiding out of memory errors\n\n**7.1.0**\n- feature: 🎉 Stable Diffusion 2.1.  Generated people are no longer (completely) distorted. \nUse with `--model SD-2.1` or `--model SD-2.0-v` \n\n**7.0.0**\n- feature: negative prompting.  `--negative-prompt` or `ImaginePrompt(..., negative_prompt="ugly, deformed, extra arms, etc")`\n- feature: a default negative prompt is added to all generations. Images in SD-2.0 don\'t look bad anymore. Images in 1.5 look improved as well.\n\n**6.1.2**\n- fix: add back in memory-efficient algorithms\n\n**6.1.1**\n- feature: xformers will be used if available (for faster generation)\n- fix: version metadata was broken\n\n**6.1.0**\n- feature: use different default steps and image sizes depending on sampler and model selceted\n- fix: #110 use proper version in image metadata\n- refactor: samplers all have their own class that inherits from ImageSampler\n- feature: 🎉🎉🎉 Stable Diffusion 2.0\n  - `--model SD-2.0` to use (it makes worse images than 1.5 though...) \n  - Tested on macOS and Linux\n  - All samplers working for new 512x512 model\n  - New inpainting model working\n  - 768x768 model working for all samplers except PLMS (`--model SD-2.0-v `)\n\n**5.1.0**\n- feature: add progress image callback\n\n**5.0.1**\n- fix: support larger images on M1. Fixes #8\n- fix: support CPU generation by disabling autocast on CPU. Fixes #81\n\n**5.0.0**\n- feature: 🎉 inpainting support using new inpainting model from RunwayML. It works really well! By default, the \ninpainting model will automatically be used for any image-masking task \n- feature: 🎉 new default sampler makes image generation more than twice as fast\n- feature: added `DPM++ 2S a` and `DPM++ 2M` samplers.\n- feature: improve progress image logging\n- fix: fix bug with `--show-work`. fixes #84\n- fix: add workaround for pytorch bug affecting macOS users using the new `DPM++ 2S a` and `DPM++ 2M` samplers.\n- fix: add workaround for pytorch mps bug affecting `k_dpm_fast` sampler. fixes #75\n- fix: larger image sizes now work on macOS. fixes #8\n\n**4.1.0**\n - feature: allow dynamic switching between models/weights `--model SD-1.5` or `--model SD-1.4` or `--model path/my-custom-weights.ckpt`)\n - feature: log total progress when generating images (image X out of Y)\n\n**4.0.0**\n - feature: stable diffusion 1.5 (slightly improved image quality)\n - feature: dilation and erosion of masks\n Previously the `+` and `-` characters in a mask (example: `face{+0.1}`) added to the grayscale value of any masked areas. This wasn\'t very useful. The new behavior is that the mask will expand or contract by the number of pixel specified. The technical terms for this are dilation and erosion.  This allows much greater control over the masked area.\n - feature: update k-diffusion samplers. add k_dpm_adaptive and k_dpm_fast\n - feature: img2img/inpainting supported on all samplers\n - refactor: consolidates img2img/txt2img code. consolidates schedules. consolidates masking\n - ci: minor logging improvements\n\n**3.0.1**\n - fix: k-samplers were broken\n\n**3.0.0**\n - feature: improved safety filter\n\n**2.4.0**\n - 🎉 feature: prompt expansion\n - feature: make (blip) photo captions more descriptive\n\n**2.3.1**\n - fix: face fidelity default was broken\n\n**2.3.0**\n - feature: model weights file can be specified via `--model-weights-path` argument at the command line\n - fix: set face fidelity default back to old value\n - fix: handle small images without throwing exception. credit to @NiclasEriksen\n - docs: add setuptools-rust as dependency for macos \n\n**2.2.1**\n - fix: init image is fully ignored if init-image-strength = 0\n\n**2.2.0**\n - feature: face enhancement fidelity is now configurable\n\n**2.1.0**\n - [improved masking accuracy from clipseg](https://github.com/timojl/clipseg/issues/8#issuecomment-1259150865)\n\n**2.0.3**\n - fix memory leak in face enhancer\n - fix blurry inpainting \n - fix for pillow compatibility\n\n**2.0.0**\n - 🎉 fix: inpainted areas correlate with surrounding image, even at 100% generation strength.  Previously if the generation strength was high enough the generated image\nwould be uncorrelated to the rest of the surrounding image.  It created terrible looking images.   \n - 🎉 feature: interactive prompt added. access by running `aimg`\n - 🎉 feature: Specify advanced text based masks using boolean logic and strength modifiers. Mask descriptions must be lowercase. Keywords uppercase.\n   Valid symbols: `AND`, `OR`, `NOT`, `()`, and mask strength modifier `{+0.1}` where `+` can be any of `+ - * /`. Single character boolean operators also work (`|`, `&`, `!`)\n - 🎉 feature: apply mask edits to original files with `mask_modify_original` (on by default)\n - feature: auto-rotate images if exif data specifies to do so\n - fix: mask boundaries are more accurate\n - fix: accept mask images in command line\n - fix: img2img algorithm was wrong and wouldn\'t at values close to 0 or 1\n\n**1.6.2**\n - fix: another bfloat16 fix\n\n**1.6.1**\n - fix: make sure image tensors come to the CPU as float32 so there aren\'t compatibility issues with non-bfloat16 cpus\n\n**1.6.0**\n - fix: *maybe* address #13 with `expected scalar type BFloat16 but found Float`\n   - at minimum one can specify `--precision full` now and that will probably fix the issue  \n - feature: tile mode can now be specified per-prompt\n\n**1.5.3**\n - fix: missing config file for describe feature\n\n**1.5.1**\n - img2img now supported with PLMS (instead of just DDIM)\n - added image captioning feature `aimg describe dog.jpg` => `a brown dog sitting on grass`\n - added new commandline tool `aimg` for additional image manipulation functionality\n\n**1.4.0**\n - support multiple additive targets for masking with `|` symbol.  Example: "fruit|stem|fruit stem"\n\n**1.3.0**\n - added prompt based image editing. Example: "fruit => gold coins"\n - test coverage improved\n\n**1.2.0**\n - allow urls as init-images\n\n**previous**\n - img2img actually does # of steps you specify  \n - performance optimizations\n - numerous other changes\n\n\n## Not Supported\n - a GUI. this is a python library\n - training\n - exploratory features that don\'t work well\n\n## Todo\n\n - Performance Optimizations\n   - ✅ https://github.com/huggingface/diffusers/blob/main/docs/source/optimization/fp16.mdx\n   - ✅ https://github.com/CompVis/stable-diffusion/compare/main...Doggettx:stable-diffusion:autocast-improvements#\n   - ✅ https://www.reddit.com/r/StableDiffusion/comments/xalaws/test_update_for_less_memory_usage_and_higher/\n   - https://github.com/neonsecret/stable-diffusion  \n   - https://github.com/CompVis/stable-diffusion/pull/177\n   - https://github.com/huggingface/diffusers/pull/532/files\n   - https://github.com/HazyResearch/flash-attention\n   - xformers improvements https://www.photoroom.com/tech/stable-diffusion-100-percent-faster-with-memory-efficient-attention/\n - Development Environment\n   - ✅ add tests\n   - ✅ set up ci (test/lint/format)\n   - ✅ unified pipeline (txt2img & img2img combined)\n   - ✅ setup parallel testing\n   - add docs\n   - remove yaml config\n   - delete more unused code\n   - faster latent logging https://discuss.huggingface.co/t/decoding-latents-to-rgb-without-upscaling/23204/9\n - Interface improvements\n   - ✅ init-image at command line\n   - ✅ prompt expansion\n   - ✅ interactive cli\n - Image Generation Features\n   - ✅ add k-diffusion sampling methods\n   - ✅ tiling\n   - generation videos/gifs\n   - Compositional Visual Generation\n     - https://github.com/energy-based-model/Compositional-Visual-Generation-with-Composable-Diffusion-Models-PyTorch\n     - https://colab.research.google.com/github/energy-based-model/Compositional-Visual-Generation-with-Composable-Diffusion-Models-PyTorch/blob/main/notebooks/demo.ipynb#scrollTo=wt_j3uXZGFAS\n   - negative prompting\n     - some syntax to allow it in a text string\n   - images as actual prompts instead of just init images. is this the same as textual inversion?\n     - requires model fine-tuning since SD1.4 expects 77x768 text encoding input\n     - https://twitter.com/Buntworthy/status/1566744186153484288\n     - https://github.com/justinpinkney/stable-diffusion\n     - https://github.com/LambdaLabsML/lambda-diffusers\n     - https://www.reddit.com/r/MachineLearning/comments/x6k5bm/n_stable_diffusion_image_variations_released/\n - Image Editing\n   - outpainting\n     - https://github.com/parlance-zz/g-diffuser-bot/search?q=noise&type=issues\n     - lama cleaner\n   - ✅ inpainting\n     - https://github.com/Jack000/glid-3-xl-stable \n     - https://github.com/andreas128/RePaint\n     - img2img but keeps img stable\n     - https://www.reddit.com/r/StableDiffusion/comments/xboy90/a_better_way_of_doing_img2img_by_finding_the/\n     - https://gist.github.com/trygvebw/c71334dd127d537a15e9d59790f7f5e1\n     - https://github.com/pesser/stable-diffusion/commit/bbb52981460707963e2a62160890d7ecbce00e79\n     - https://github.com/SHI-Labs/FcF-Inpainting https://praeclarumjj3.github.io/fcf-inpainting/\n   - ✅ text based image masking\n     - ✅ ClipSeg - https://github.com/timojl/clipseg\n     - https://github.com/facebookresearch/detectron2\n   - Attention Control Methods\n     - https://github.com/bloc97/CrossAttentionControl\n     - https://github.com/ChenWu98/cycle-diffusion\n - Image Enhancement\n   - Photo Restoration - https://github.com/microsoft/Bringing-Old-Photos-Back-to-Life\n   - Upscaling\n     - ✅ realesrgan \n     - ldm\n     - https://github.com/lowfuel/progrock-stable\n     - gobig\n     - stable super-res?\n       - todo: try with 1-0-0-0 mask at full image resolution (rencoding entire image+predicted image at every step)\n       - todo: use a gaussian pyramid and only include the "high-detail" level of the pyramid into the next step\n       - https://www.reddit.com/r/StableDiffusion/comments/xkjjf9/upscale_to_huge_sizes_and_add_detail_with_sd/\n   - ✅ face enhancers\n     - ✅ gfpgan - https://github.com/TencentARC/GFPGAN\n     - ✅ codeformer - https://github.com/sczhou/CodeFormer\n   - ✅ image describe feature - \n     - ✅ https://github.com/salesforce/BLIP\n     - 🚫 CLIP brute-force prompt reconstruction\n       - The accuracy of this approach is too low for me to include it in imaginAIry\n       - https://github.com/rmokady/CLIP_prefix_caption\n       - https://github.com/pharmapsychotic/clip-interrogator (blip + clip)\n     - https://github.com/KaiyangZhou/CoOp\n   - 🚫 CPU support.  While the code does actually work on some CPUs, the generation takes so long that I don\'t think it\'s\n    worth the effort to support this feature\n   - ✅ img2img for plms\n   - ✅ img2img for kdiff functions\n - Other\n   - Enhancement pipelines\n   - text-to-3d https://dreamfusionpaper.github.io/\n   - make a video https://github.com/lucidrains/make-a-video-pytorch\n   - animations\n     - https://github.com/francislabountyjr/stable-diffusion/blob/main/inferencing_notebook.ipynb\n     - https://www.youtube.com/watch?v=E7aAFEhdngI\n     - https://github.com/pytti-tools/frame-interpolation\n   - guided generation \n     - https://colab.research.google.com/drive/1dlgggNa5Mz8sEAGU0wFCHhGLFooW_pf1#scrollTo=UDeXQKbPTdZI\n     - https://colab.research.google.com/github/aicrumb/doohickey/blob/main/Doohickey_Diffusion.ipynb#scrollTo=PytCwKXCmPid\n     - https://github.com/mlfoundations/open_clip\n     - https://github.com/openai/guided-diffusion\n   - image variations https://github.com/lstein/stable-diffusion/blob/main/VARIATIONS.md\n   - textual inversion \n     - https://www.reddit.com/r/StableDiffusion/comments/xbwb5y/how_to_run_textual_inversion_locally_train_your/\n     - https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/sd_textual_inversion_training.ipynb#scrollTo=50JuJUM8EG1h\n     - https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/stable_diffusion_textual_inversion_library_navigator.ipynb\n     - https://github.com/Jack000/glid-3-xl-stable\n   - fix saturation at high CFG https://www.reddit.com/r/StableDiffusion/comments/xalo78/fixing_excessive_contrastsaturation_resulting/\n   - https://www.reddit.com/r/StableDiffusion/comments/xbrrgt/a_rundown_of_twenty_new_methodsoptions_added_to/\n   - ✅ deploy to pypi\n   - find similar images https://knn5.laion.ai/?back=https%3A%2F%2Fknn5.laion.ai%2F&index=laion5B&useMclip=false\n   - https://github.com/vicgalle/stable-diffusion-aesthetic-gradients\n\n## Notable Stable Diffusion Implementations\n - https://github.com/ahrm/UnstableFusion\n - https://github.com/AUTOMATIC1111/stable-diffusion-webui\n - https://github.com/blueturtleai/gimp-stable-diffusion\n - https://github.com/hafriedlander/stable-diffusion-grpcserver\n - https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines/stable_diffusion\n - https://github.com/lkwq007/stablediffusion-infinity\n - https://github.com/lstein/stable-diffusion\n - https://github.com/parlance-zz/g-diffuser-lib\n - https://github.com/hafriedlander/idea2art\n\n## Online Stable Diffusion Services\n - https://stablecog.com/ \n\n## Further Reading\n - [Prompt Engineering Handbook](https://openart.ai/promptbook)\n - Differences between samplers\n   - https://www.reddit.com/r/StableDiffusion/comments/xbeyw3/can_anyone_offer_a_little_guidance_on_the/\n - https://www.reddit.com/r/bigsleep/comments/xb5cat/wiskkeys_lists_of_texttoimage_systems_and_related/\n - https://huggingface.co/blog/annotated-diffusion\n - https://github.com/jessevig/bertviz\n - https://www.youtube.com/watch?v=5pIQFQZsNe8\n - https://jalammar.github.io/illustrated-transformer/\n - https://huggingface.co/blog/assets/78_annotated-diffusion/unet_architecture.jpg\n',
    'author': 'Hanoush',
    'author_email': 'hanoush87@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
