# coding: utf-8

"""
    Phrase API Reference

    The version of the OpenAPI document: 2.0.0
    Contact: support@phrase.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from phrase-api.configuration import Configuration


class ProjectUpdateParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'main_format': 'str',
        'shares_translation_memory': 'bool',
        'project_image': 'file',
        'remove_project_image': 'bool',
        'account_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'main_format': 'main_format',
        'shares_translation_memory': 'shares_translation_memory',
        'project_image': 'project_image',
        'remove_project_image': 'remove_project_image',
        'account_id': 'account_id'
    }

    def __init__(self, name=None, main_format=None, shares_translation_memory=None, project_image=None, remove_project_image=None, account_id=None, local_vars_configuration=None):  # noqa: E501
        """ProjectUpdateParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._main_format = None
        self._shares_translation_memory = None
        self._project_image = None
        self._remove_project_image = None
        self._account_id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if main_format is not None:
            self.main_format = main_format
        if shares_translation_memory is not None:
            self.shares_translation_memory = shares_translation_memory
        if project_image is not None:
            self.project_image = project_image
        if remove_project_image is not None:
            self.remove_project_image = remove_project_image
        if account_id is not None:
            self.account_id = account_id

    @property
    def name(self):
        """Gets the name of this ProjectUpdateParameters.  # noqa: E501

        Name of the project  # noqa: E501

        :return: The name of this ProjectUpdateParameters.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectUpdateParameters.

        Name of the project  # noqa: E501

        :param name: The name of this ProjectUpdateParameters.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def main_format(self):
        """Gets the main_format of this ProjectUpdateParameters.  # noqa: E501

        Main file format specified by its API Extension name. Used for locale downloads if no format is specified. For API Extension names of available file formats see <a href=\"https://help.phrase.com/help/supported-platforms-and-formats\">Format Guide</a> or our <a href=\"#formats\">Formats API Endpoint</a>.  # noqa: E501

        :return: The main_format of this ProjectUpdateParameters.  # noqa: E501
        :rtype: str
        """
        return self._main_format

    @main_format.setter
    def main_format(self, main_format):
        """Sets the main_format of this ProjectUpdateParameters.

        Main file format specified by its API Extension name. Used for locale downloads if no format is specified. For API Extension names of available file formats see <a href=\"https://help.phrase.com/help/supported-platforms-and-formats\">Format Guide</a> or our <a href=\"#formats\">Formats API Endpoint</a>.  # noqa: E501

        :param main_format: The main_format of this ProjectUpdateParameters.  # noqa: E501
        :type: str
        """

        self._main_format = main_format

    @property
    def shares_translation_memory(self):
        """Gets the shares_translation_memory of this ProjectUpdateParameters.  # noqa: E501

        Indicates whether the project should share the account's translation memory  # noqa: E501

        :return: The shares_translation_memory of this ProjectUpdateParameters.  # noqa: E501
        :rtype: bool
        """
        return self._shares_translation_memory

    @shares_translation_memory.setter
    def shares_translation_memory(self, shares_translation_memory):
        """Sets the shares_translation_memory of this ProjectUpdateParameters.

        Indicates whether the project should share the account's translation memory  # noqa: E501

        :param shares_translation_memory: The shares_translation_memory of this ProjectUpdateParameters.  # noqa: E501
        :type: bool
        """

        self._shares_translation_memory = shares_translation_memory

    @property
    def project_image(self):
        """Gets the project_image of this ProjectUpdateParameters.  # noqa: E501

        Image to identify the project  # noqa: E501

        :return: The project_image of this ProjectUpdateParameters.  # noqa: E501
        :rtype: file
        """
        return self._project_image

    @project_image.setter
    def project_image(self, project_image):
        """Sets the project_image of this ProjectUpdateParameters.

        Image to identify the project  # noqa: E501

        :param project_image: The project_image of this ProjectUpdateParameters.  # noqa: E501
        :type: file
        """

        self._project_image = project_image

    @property
    def remove_project_image(self):
        """Gets the remove_project_image of this ProjectUpdateParameters.  # noqa: E501

        Indicates whether the project image should be deleted.  # noqa: E501

        :return: The remove_project_image of this ProjectUpdateParameters.  # noqa: E501
        :rtype: bool
        """
        return self._remove_project_image

    @remove_project_image.setter
    def remove_project_image(self, remove_project_image):
        """Sets the remove_project_image of this ProjectUpdateParameters.

        Indicates whether the project image should be deleted.  # noqa: E501

        :param remove_project_image: The remove_project_image of this ProjectUpdateParameters.  # noqa: E501
        :type: bool
        """

        self._remove_project_image = remove_project_image

    @property
    def account_id(self):
        """Gets the account_id of this ProjectUpdateParameters.  # noqa: E501

        Account ID to specify the actual account the project should be created in. Required if the requesting user is a member of multiple accounts.  # noqa: E501

        :return: The account_id of this ProjectUpdateParameters.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this ProjectUpdateParameters.

        Account ID to specify the actual account the project should be created in. Required if the requesting user is a member of multiple accounts.  # noqa: E501

        :param account_id: The account_id of this ProjectUpdateParameters.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectUpdateParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProjectUpdateParameters):
            return True

        return self.to_dict() != other.to_dict()
