"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const json_1 = require("./json");
const tasks_1 = require("./tasks");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        var _b, _c, _d;
        super(project);
        const versionFile = '.version.tmp.json';
        this.changelogFile = '.changelog.tmp.md';
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            category: tasks_1.TaskCategory.RELEASE,
            condition: changesSinceLastRelease,
        });
        const listGitTags = [
            'git',
            '-c "versionsort.suffix=-"',
            'tag',
            '--sort="-version:refname"',
            '--list',
            '"v*"',
        ].join(' ');
        this.bumpTask.exec(`${listGitTags} | head -n1 > ${versionFile}`);
        this.bumpTask.exec('standard-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'standard-version -r 0.0.0',
        });
        project.addDevDeps('standard-version@^9');
        (_b = project.npmignore) === null || _b === void 0 ? void 0 : _b.addPatterns(`/${this.changelogFile}`);
        (_c = project.npmignore) === null || _c === void 0 ? void 0 : _c.addPatterns(`/${versionFile}`);
        (_d = project.npmignore) === null || _d === void 0 ? void 0 : _d.addPatterns('/.versionrc.json');
        project.gitignore.addPatterns(`/${this.changelogFile}`);
        project.gitignore.addPatterns(`/${versionFile}`);
        new json_1.JsonFile(project, '.versionrc.json', {
            obj: {
                packageFiles: [{
                        filename: versionFile,
                        type: 'plain-text',
                    }],
                bumpFiles: ['package.json'],
                commitAll: false,
                infile: this.changelogFile,
                header: '',
                skip: {
                    commit: true,
                    tag: true,
                },
            },
        });
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.17.81" };
//# sourceMappingURL=data:application/json;base64,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