import { TypeScriptAppProject, TypeScriptProjectOptions } from './typescript';
/**
 * @experimental
 */
export interface Cdk8sTypeScriptAppOptions extends TypeScriptProjectOptions {
    /**
     * (experimental) Minimum target version this library is tested against.
     *
     * @default "1.0.0-beta.10"
     * @experimental
     * @featured true
     */
    readonly cdk8sVersion: string;
    /**
     * (experimental) Use pinned version instead of caret version for CDK8s.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     * @experimental
     */
    readonly cdk8sVersionPinning?: boolean;
    /**
     * (experimental) The CDK8s app's entrypoint (relative to the source directory, which is "src" by default).
     *
     * @default "main.ts"
     * @experimental
     */
    readonly appEntrypoint?: string;
}
/**
 * (experimental) CDK8s app in TypeScript.
 *
 * @experimental
 * @pjid cdk8s-app-ts
 */
export declare class Cdk8sTypeScriptApp extends TypeScriptAppProject {
    /**
     * (experimental) The CDK8s version this app is using.
     *
     * @experimental
     */
    readonly cdk8sVersion: string;
    /**
     * (experimental) The CDK8s app entrypoint.
     *
     * @experimental
     */
    readonly appEntrypoint: string;
    /**
     * @experimental
     */
    constructor(options: Cdk8sTypeScriptAppOptions);
}
