"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const python_1 = require("../../python");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestPythonProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('dependencies', () => {
    const p = new TestPythonProject();
    p.addDependency('Django@3.1.5');
    p.addDependency('aws-cdk.core@*');
    p.addDevDependency('hypothesis@^6.0.3');
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('dependencies via ctor', () => {
    const p = new TestPythonProject({
        deps: [
            'Django@3.1.5',
            'aws-cdk.core',
        ],
        devDeps: [
            'hypothesis@^6.0.3',
        ],
    });
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('no pytest', () => {
    const p = new TestPythonProject({
        pytest: false,
    });
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('pytest maxfailures', () => {
    const p = new TestPythonProject({
        pytestOptions: {
            maxFailures: 3,
        },
    });
    expect(util_1.synthSnapshot(p)['.projen/tasks.json'].tasks.test.steps[0].exec).toContain('--maxfail=3');
});
class TestPythonProject extends python_1.PythonProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-python-project',
            moduleName: 'test_python_project',
            authorName: 'First Last',
            authorEmail: 'email@example.com',
            version: '0.1.0',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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