"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const java_1 = require("../../java");
const projenrc_1 = require("../../java/projenrc");
const render_options_1 = require("../../javascript/render-options");
const util_1 = require("../util");
test('projenrc.java support', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const pom = new java_1.Pom(project, {
        groupId: 'my.group.id',
        artifactId: 'hello-world',
        version: '1.2.3',
    });
    // WHEN
    new projenrc_1.Projenrc(project, pom, {
        projenVersion: '1.0.0',
    });
    // THEN
    expect(util_1.synthSnapshot(project)).toMatchSnapshot();
});
test('use a non-test scope', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const pom = new java_1.Pom(project, {
        groupId: 'my.group.id',
        artifactId: 'hello-world',
        version: '1.2.3',
    });
    // WHEN
    new projenrc_1.Projenrc(project, pom, {
        testScope: false,
        projenVersion: '7.7.7',
    });
    // THEN
    expect(util_1.synthSnapshot(project)).toMatchSnapshot();
});
test('set the class name', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const pom = new java_1.Pom(project, {
        groupId: 'my.group.id',
        artifactId: 'hello-world',
        version: '1.2.3',
    });
    // WHEN
    new projenrc_1.Projenrc(project, pom, {
        className: 'boom.bam.projenrc',
        projenVersion: '7.7.7',
    });
    // THEN
    expect(util_1.synthSnapshot(project)).toMatchSnapshot();
});
test('generate projenrc in java', () => {
    // GIVEN
    const project = new util_1.TestProject(render_options_1.renderProjenNewOptions('projen.java.JavaProject', {}));
    const pom = new java_1.Pom(project, {
        groupId: 'my.group.id',
        artifactId: 'hello-world',
        version: '1.2.3',
    });
    // WHEN
    new projenrc_1.Projenrc(project, pom);
    // THEN
    expect(util_1.synthSnapshot(project)['src/test/java/projenrc.java']).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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