# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (24,24,0,8,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        196 85
        276 0
        62 249
        123 110
        102 30
        175 154
        151 52
        97 41
        175 156
        116 45
        28 83
        304 8
        201 122
        310 114
        46 265
        216 131
        51 256
        316 69
        179 3
        131 198
        178 16
        260 286
        270 110
        276 155
        134 140
        291 69
        301 103
        183 308
        53 218
        197 291
        51 161
        184 61
        316 12
        183 152
        127 153
        203 68
        318 309
        19 133
        141 28
        279 304
        96 311
        153 248
        295 133
        11 2
        33 12
        263 295
        199 293
        117 27
        192 107
        306 223
        145 225
        14 306
        212 227
        91 158
        67 191
        167 278
        246 49
        224 269
        21 187
        209 273
        2 201
        238 294
        31 218
        82 88
        309 9
        5 148
        229 59
        295 303
        66 74
        155 162
        188 67
        82 32
        273 170
        142 315
        317 74
        297 157
        152 87
        142 317
        29 6
        297 27
        100 237
        307 241
        129 145
        63 315
        75 109
        187 239
        255 67
        97 70
        128 60
        112 180
        255 257
        119 22
        78 35
        315 221
        48 173
        245 45
        160 12
        34 143
        118 215
        244 235
        147 87
        292 33
        34 0
        272 259
        95 120
        240 241
        106 228
        54 60
        32 204
        37 17
        264 4
        65 132
        220 168
        177 140
        219 236
        15 257
        296 247
        160 265
        212 309
        243 274
        276 277
        148 149
        204 205
        309 310
        196 299
        192 3
        35 168
        117 300
        312 138
        211 233
        301 122
        167 88
        95 125
        209 36
        7 57
        13 202
        89 300
        90 302
        195 233
        1 62
        118 55
        182 209
        26 253
        2 61
        90 146
        242 161
        158 24
        239 240
        271 284
        138 103
        7 199
        139 299
        226 223
        84 290
        288 4
        232 41
        79 129
        150 137
        262 163
        28 169
        21 123
        263 316
        266 234
        298 252
        97 134
        175 150
        142 281
        16 254
        96 4
        184 200
        10 136
        254 3
        182 299
        233 55
        302 181
        101 294
        38 285
        78 114
        277 285
        102 253
        48 235
        245 115
        169 110
        176 36
        41 49
        62 280
        274 54
        56 152
        226 98
        230 146
        108 15
        125 218
        31 23
        192 269
        26 122
        250 64
        231 282
        232 283
        290 223
        89 250
        313 44
        133 269
        91 248
        80 72
        86 24
        303 206
        136 81
        255 88
        246 205
        106 52
        180 267
        227 220
        89 235
        295 33
        144 229
        243 119
        80 200
        267 43
        95 233
        229 168
        113 301
        221 254
        298 98
        108 32
        112 160
        294 46
        80 190
        151 40
        282 206
        194 65
        191 121
        19 74
        241 139
        38 253
        159 308
        227 121
        61 294
        211 308
        167 8
        289 76
        99 176
        39 126
        113 2
        104 23
        230 253
        78 9
        298 197
        210 28
        47 66
        73 57
        255 311
        142 107
        95 242
        91 151
        94 243
        41 25
        45 226
        177 70
        120 215
        34 219
        234 217
        177 216
        84 98
        50 52
        67 111
        275 152
        170 39
        280 86
        186 310
        96 319
        47 33
        111 203
        238 292
        266 198
        61 81
        118 164
        189 160
        13 150
        117 64
        237 220
        211 170
        271 146
        19 281
        178 213
        70 68
        89 262
        7 268
        50 280
        264 260
        242 31
        26 10
        93 214
        216 300
        286 205
        172 84
        46 129
        149 64
        237 153
        113 90
        317 206
        306 132
        166 5
        196 293
        151 44
        15 191
        185 288
        239 293
        282 252
        123 231
        232 124
        114 163
        106 87
        154 120
        135 172
        225 180
        130 216
        187 270
        16 245
        268 53
        257 181
        86 127
        221 213
        185 75
        109 286
        263 74
        311 205
        311 203
        58 279
        251 193
        105 66
        222 204
        310 272
        314 81
        182 37
        162 143
        297 42
        141 199
        53 6
        275 125
        132 43
        63 288
        312 219
        47 206
        130 128
        313 217
        21 105
        71 230
        283 130
        314 221
        71 143
        278 281
        244 166
        121 0
        271 143
        313 171
        314 172
        187 137
        58 76
        277 304
        305 46
        148 126
        100 174
        176 1
        73 234
        274 25
        275 159
        135 132
        261 39
        92 45
        35 40
        147 125
        252 172
        229 121
        22 24
        51 226
        135 115
        136 115
        144 22
        16 303
        171 127
        75 122
        117 198
        14 267
        185 319
        94 312
        173 157
        1 44
        186 188
        238 133
        110 12
        94 77
        236 247
        190 201
        150 240
        302 284
        283 134
        18 163
        21 291
        93 203
        265 267
        161 55
        191 318
        107 109
        27 29
        262 177
        178 263
        204 257
        289 281
        30 260
        184 10
        268 147
        60 24
        99 18
        101 19
        208 155
        108 212
        70 128
        313 280
        287 299
        17 85
        262 272
        305 194
        190 135
        78 99
        44 228
        319 247
        79 101
        116 298
        317 213
        188 82
        272 68
        242 65
        258 198
        5 261
        127 54
        202 164
        81 290
        307 27
        107 222
        165 42
        141 193
        275 215
        79 66
        230 301
        63 3
        156 215
        217 131
        169 69
        256 23
        289 222
        18 42
        176 40
        141 256
        136 254
        96 214
        134 171
        14 305
        100 144
        57 308
        185 103
        50 158
        112 270
        37 195
        83 241
        174 9
        175 17
        72 43
        58 224
        286 319
        166 250
        166 249
        112 13
        183 273
        182 202
        56 126
        169 92
        312 276
        200 58
        283 173
        119 219
        103 236
        287 36
        195 164
        113 285
        149 307
        224 222
        261 52
        217 140
        271 208
        10 190
        114 48
        289 181
        105 316
        220 9
        186 124
        178 116
        108 208
        59 174
        214 25
        104 207
        77 71
        7 266
        4 88
        168 248
        79 72
        154 195
        246 82
        49 68
        130 158
        261 62
        260 20
        94 162
        251 218
        123 47
        102 138
        124 48
        138 285
        305 290
        188 212
        194 145
        72 292
        244 35
        145 43
        75 315
        116 69
        50 131
        201 314
        11 80
        102 77
        93 128
        184 38
        30 288
        210 293
        13 139
        165 64
        207 83
        104 53
        92 256
        189 137
        318 59
        137 225
        278 269
        296 60
        165 196
        57 193
        240 85
        14 118
        238 200
        5 40
        292 265
        244 59
        186 49
        156 56
        111 259
        159 251
        258 268
        179 30
        149 85
        224 8
        97 54
        189 129
        266 165
        278 63
        249 174
        231 197
        56 209
        39 87
        106 258
        297 234
        287 42
        179 26
        156 202
        157 163
        38 279
        1 273
        101 11
        264 25
        154 225
        197 23
        155 227
        73 29
        270 210
        157 140
        277 302
        210 139
        161 306
        243 153
        296 214
        246 264
        194 120
        237 162
        99 249
        239 207
        0 284
        213 252
        91 171
        232 93
        37 170
        245 282
        231 92
        180 164
        65 84
        119 296
        11 76
        31 98
        318 259
        18 250
        148 36
        147 211
        20 247
        287 307
        104 199
        77 20
        235 259
        126 17
        71 236
        300 173
        55 159
        51 251
        258 29
        179 109
        83 6
        291 207
        105 189
        228 73
        208 304
        167 181
        100 86
        6 193
        183 228
        32 8
        34 144
        192 303
        22 248
        90 76
        146 279
        15 284
        274 20
        124 111
        115 223
        """

        self.waters = """
        0.18482 0.53649 0.15376
        0.68744 0.25334 0.25
        0.18744 0.75334 0.25
        0.81244 0.73105 0.625
        0.0 0.5996 0.68851
        0.18756 0.26896 0.125
        0.0 0.11555 0.65176
        0.5 0.14948 0.60986
        0.81244 0.64583 0.95566
        0.68744 0.40556 0.09027
        0.68756 0.76896 0.375
        0.31244 0.76896 0.125
        0.80982 0.92371 0.90572
        0.875 0.05251 0.00201
        0.81256 0.94996 0.25
        0.375 0.55251 0.00201
        0.80982 0.82565 0.64417
        0.31519 0.13428 0.08066
        0.625 0.28243 0.93448
        0.125 0.78243 0.93448
        0.625 0.55251 0.498
        0.31519 0.96351 0.84624
        0.18756 0.43574 0.34421
        0.375 0.00811 0.59228
        0.31256 0.40556 0.40973
        0.875 0.50811 0.59228
        0.625 0.71758 0.43448
        0.0 0.21789 0.75
        0.81256 0.05004 0.75
        0.0 0.18256 0.63813
        0.81244 0.64583 0.54435
        0.25 0.0 0.5
        0.68744 0.59444 0.90973
        0.68482 0.86572 0.91935
        0.30982 0.51568 0.25
        0.0 0.35052 0.10986
        0.875 0.21758 0.06552
        0.5 0.12638 0.14014
        0.81519 0.69406 0.25
        0.31519 0.19406 0.25
        0.0 0.30063 0.17135
        0.81519 0.46351 0.65376
        0.68756 0.23105 0.875
        0.5 0.9004 0.18851
        0.81244 0.26896 0.375
        0.80982 0.92371 0.59428
        0.0 0.88445 0.15176
        0.5 0.87362 0.85986
        0.0 0.37362 0.85986
        0.69019 0.48433 0.75
        0.31256 0.30138 0.44052
        0.75 0.0 0.5
        0.18756 0.26896 0.375
        0.18744 0.09444 0.59027
        0.625 0.4475 0.50201
        0.68482 0.03649 0.34624
        0.0 0.14674 0.19052
        0.68756 0.14583 0.54435
        0.625 0.71758 0.06552
        0.31256 0.40556 0.09027
        0.375 0.4475 0.50201
        0.0 0.78212 0.25
        0.5 0.28212 0.25
        0.0 0.69937 0.67135
        0.31244 0.23105 0.875
        0.31244 0.93574 0.34421
        0.31519 0.86572 0.91935
        0.125 0.50811 0.90773
        0.5 0.45243 0.75
        0.0 0.95243 0.75
        0.5 0.41415 0.65779
        0.5 0.58585 0.34221
        0.5 0.85052 0.10986
        0.81256 0.19862 0.55948
        0.19019 0.82565 0.85583
        0.31256 0.69862 0.55948
        0.375 0.71758 0.06552
        0.69019 0.57629 0.40572
        0.81244 0.35417 0.04435
        0.31244 0.85417 0.04435
        0.5 0.80063 0.17135
        0.0 0.81744 0.36187
        0.81244 0.56427 0.84421
        0.0 0.08387 0.75
        0.18744 0.90556 0.40973
        0.31244 0.14583 0.95566
        0.5 0.38445 0.34824
        0.19019 0.17435 0.35583
        0.0 0.5996 0.81149
        0.30982 0.32565 0.85583
        0.30982 0.67435 0.14417
        0.0 0.35052 0.39014
        0.68482 0.96351 0.65376
        0.18482 0.46351 0.65376
        0.81519 0.53649 0.34624
        0.31519 0.03649 0.34624
        0.18756 0.56427 0.65579
        0.69019 0.42371 0.59428
        0.125 0.9475 0.50201
        0.68744 0.30138 0.05948
        0.5 0.41614 0.25
        0.18744 0.80138 0.05948
        0.81519 0.63428 0.41935
        0.18482 0.63428 0.41935
        0.31244 0.06427 0.65579
        0.19019 0.92371 0.90572
        0.125 0.21758 0.43448
        0.5 0.71789 0.75
        0.625 0.55251 0.00201
        0.5 0.68256 0.63813
        0.68482 0.96351 0.84624
        0.18482 0.46351 0.84624
        0.75 0.0 0.0
        0.18482 0.69406 0.25
        0.81519 0.36572 0.91935
        0.68756 0.85417 0.45566
        0.0 0.91415 0.65779
        0.18744 0.24666 0.75
        0.80982 0.01568 0.25
        0.125 0.49189 0.40773
        0.19019 0.01568 0.25
        0.125 0.49189 0.09228
        0.375 0.71758 0.43448
        0.5 0.93313 0.81351
        0.0 0.43313 0.81351
        0.19019 0.07629 0.40572
        0.19019 0.17435 0.14417
        0.68744 0.40556 0.40973
        0.30982 0.42371 0.59428
        0.18744 0.90556 0.09027
        0.18482 0.36572 0.58066
        0.375 0.28243 0.56552
        0.5 0.9004 0.31149
        0.875 0.78243 0.93448
        0.81519 0.36572 0.58066
        0.5 0.85052 0.39014
        0.81256 0.80138 0.44052
        0.25 0.0 0.0
        0.0 0.62638 0.35986
        0.81256 0.09444 0.90973
        0.69019 0.32565 0.64417
        0.68756 0.06427 0.65579
        0.31256 0.74666 0.75
        0.5 0.54757 0.25
        0.31256 0.44996 0.25
        0.31244 0.93574 0.15579
        0.5 0.64674 0.19052
        0.31519 0.13428 0.41935
        0.125 0.21758 0.06552
        0.18744 0.19862 0.94052
        0.125 0.05251 0.00201
        0.0 0.30063 0.32865
        0.0 0.14674 0.30948
        0.81244 0.43574 0.34421
        0.31519 0.03649 0.15376
        0.81519 0.53649 0.15376
        0.0 0.08585 0.15779
        0.81519 0.30594 0.75
        0.18756 0.35417 0.45566
        0.80982 0.07629 0.40572
        0.875 0.9475 0.998
        0.625 0.99189 0.40773
        0.69019 0.51568 0.25
        0.69019 0.32565 0.85583
        0.68482 0.03649 0.15376
        0.5 0.19937 0.82865
        0.31256 0.30138 0.05948
        0.0 0.64948 0.89014
        0.0 0.4004 0.18851
        0.80982 0.98433 0.75
        0.5 0.16355 0.25
        0.81244 0.35417 0.45566
        0.31244 0.85417 0.45566
        0.0 0.33645 0.75
        0.5 0.38445 0.15176
        0.19019 0.07629 0.09428
        0.81244 0.26896 0.125
        0.5 0.35326 0.69052
        0.0 0.85326 0.69052
        0.68744 0.69862 0.55948
        0.625 0.99189 0.09228
        0.18756 0.64583 0.95566
        0.68482 0.13428 0.08066
        0.80982 0.17435 0.35583
        0.81256 0.75334 0.25
        0.18756 0.64583 0.54435
        0.81519 0.46351 0.84624
        0.375 0.00811 0.90773
        0.875 0.50811 0.90773
        0.125 0.9475 0.998
        0.5 0.80063 0.32865
        0.25 0.5 0.0
        0.68744 0.74666 0.75
        0.81256 0.09444 0.59027
        0.18744 0.94996 0.25
        0.5 0.06687 0.18649
        0.5 0.14948 0.89014
        0.31519 0.96351 0.65376
        0.31244 0.23105 0.625
        0.5 0.0996 0.68851
        0.68756 0.76896 0.125
        0.31244 0.76896 0.375
        0.80982 0.07629 0.09428
        0.30982 0.48433 0.75
        0.5 0.61555 0.84824
        0.5 0.58387 0.75
        0.5 0.83645 0.75
        0.18744 0.05004 0.75
        0.69019 0.57629 0.09428
        0.80982 0.17435 0.14417
        0.68756 0.06427 0.84421
        0.5 0.12638 0.35986
        0.75 0.5 0.0
        0.19019 0.82565 0.64417
        0.125 0.50811 0.59228
        0.0 0.04757 0.25
        0.30982 0.32565 0.64417
        0.625 0.28243 0.56552
        0.125 0.05251 0.498
        0.18482 0.53649 0.34624
        0.81244 0.43574 0.15579
        0.125 0.78243 0.56552
        0.5 0.68256 0.86187
        0.81256 0.90556 0.40973
        0.68744 0.69862 0.94052
        0.375 0.99189 0.09228
        0.875 0.9475 0.50201
        0.875 0.49189 0.09228
        0.875 0.21758 0.43448
        0.18756 0.43574 0.15579
        0.5 0.64674 0.30948
        0.5 0.93313 0.68649
        0.0 0.43313 0.68649
        0.5 0.06687 0.31351
        0.68756 0.23105 0.625
        0.18482 0.36572 0.91935
        0.30982 0.57629 0.40572
        0.68744 0.44996 0.25
        0.81256 0.80138 0.05948
        0.31244 0.06427 0.84421
        0.18744 0.09444 0.90973
        0.0 0.11555 0.84824
        0.375 0.99189 0.40773
        0.875 0.49189 0.40773
        0.18756 0.35417 0.04435
        0.68482 0.86572 0.58066
        0.68744 0.55004 0.75
        0.375 0.55251 0.498
        0.0 0.4004 0.31149
        0.5 0.31744 0.13813
        0.375 0.28243 0.93448
        0.875 0.05251 0.498
        0.31519 0.86572 0.58066
        0.69019 0.67435 0.35583
        0.875 0.78243 0.56552
        0.18756 0.56427 0.84421
        0.625 0.00811 0.59228
        0.31256 0.59444 0.90973
        0.18744 0.19862 0.55948
        0.30982 0.42371 0.90572
        0.68744 0.59444 0.59027
        0.31256 0.25334 0.25
        0.5 0.35326 0.80948
        0.0 0.85326 0.80948
        0.81244 0.56427 0.65579
        0.81256 0.90556 0.09027
        0.5 0.19937 0.67135
        0.68756 0.93574 0.15579
        0.31244 0.14583 0.54435
        0.81244 0.73105 0.875
        0.625 0.00811 0.90773
        0.5 0.58585 0.15779
        0.5 0.41415 0.84221
        0.68482 0.19406 0.25
        0.75 0.5 0.5
        0.0 0.08585 0.34221
        0.0 0.56687 0.18649
        0.0 0.62638 0.14014
        0.0 0.69937 0.82865
        0.69019 0.67435 0.14417
        0.5 0.31744 0.36187
        0.18756 0.73105 0.875
        0.5 0.87362 0.64014
        0.0 0.37362 0.64014
        0.30982 0.57629 0.09428
        0.0 0.66355 0.25
        0.5 0.61555 0.65176
        0.81256 0.19862 0.94052
        0.0 0.64948 0.60986
        0.31256 0.69862 0.94052
        0.0 0.88445 0.34824
        0.19019 0.98433 0.75
        0.68756 0.85417 0.04435
        0.5 0.0996 0.81149
        0.0 0.81744 0.13813
        0.80982 0.82565 0.85583
        0.25 0.5 0.5
        0.81256 0.24666 0.75
        0.19019 0.92371 0.59428
        0.68756 0.14583 0.95566
        0.18482 0.30594 0.75
        0.30982 0.67435 0.35583
        0.18482 0.63428 0.08066
        0.68482 0.80594 0.75
        0.81519 0.63428 0.08066
        0.0 0.91614 0.25
        0.68756 0.93574 0.34421
        0.0 0.18256 0.86187
        0.68482 0.13428 0.41935
        0.625 0.4475 0.998
        0.69019 0.42371 0.90572
        0.31256 0.55004 0.75
        0.0 0.56687 0.31351
        0.68744 0.30138 0.44052
        0.18744 0.80138 0.44052
        0.18756 0.73105 0.625
        0.0 0.91415 0.84221
        0.31519 0.80594 0.75
        0.375 0.4475 0.998
        0.31256 0.59444 0.59027
        """

        self.coord = "relative"

        self.cages = """
        14 -0.5 0.07008 -0.00405
        12 -0.5 -0.73036 0.75
        14 0.0 0.01319 0.6191
        14 0.0 0.01319 -0.1191
        12 0.23926 0.60833 0.25
        12 0.26074 -0.10833 -0.25
        12 0.76074 0.60833 0.25
        12 0.23926 0.39167 0.75
        14 0.0 -0.01319 -0.6191
        14 0.75023 0.84546 0.25
        16 0.0 0.28123 -0.0646
        12 1.0 1.23036 0.25
        14 0.5 0.07008 0.50405
        14 0.0 0.57008 -0.00405
        12 0.0 0.13994 0.48793
        12 0.5 0.98075 0.25
        14 0.5 0.48681 1.1191
        16 -0.5 0.21877 0.4354
        12 0.0 -0.23036 0.75
        16 0.5 0.21877 0.0646
        14 0.25023 -0.34546 -0.25
        14 -0.25023 0.34546 0.25
        14 0.5 0.48681 -0.6191
        16 -0.5 -0.21877 0.5646
        12 0.5 0.63994 0.01207
        12 0.5 0.73036 0.25
        14 1.0 0.57008 0.50405
        14 0.25023 0.34546 0.25
        12 -0.26074 -0.10833 0.75
        14 0.5 0.51319 0.6191
        14 0.5 0.51319 -0.1191
        12 -0.26074 0.10833 0.25
        12 0.5 0.36006 0.51207
        12 0.76074 0.39167 -0.25
        12 0.5 0.36006 -0.01207
        14 0.0 0.42992 -0.50405
        12 0.0 -0.13994 0.51207
        12 0.0 -0.48075 0.75
        14 0.75023 0.15454 -0.25
        14 -0.25023 -0.34546 0.75
        14 0.24977 0.15454 0.75
        12 0.0 0.13994 0.01207
        12 0.0 0.48075 0.25
        16 -0.5 -0.21877 -0.0646
        12 0.5 0.63994 0.48793
        14 0.24977 0.84546 0.25
        12 0.0 -0.13994 -0.01207
        14 0.0 0.42992 1.00405
        16 1.0 0.71877 0.0646
        12 0.26074 0.10833 0.25
        14 -0.5 -0.07008 -0.50405
        14 -0.5 -0.07008 1.00405
        16 0.0 0.28123 0.5646
        14 0.0 -0.01319 1.1191
        16 0.0 0.71877 0.4354
        12 0.5 0.01925 0.75
        """

        self.bondlen = 3

        self.cell = """
        14.0321230369449 51.73230145758777 24.874259610325154
        """

        self.density = 0.5297200188697532

        self.cell = cellvectors(a=14.0321230369449,
                                b=51.73230145758777,
                                c=24.874259610325154)
