"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const channel_types_1 = require("./channel-types");
class SlackNotifier extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { slackBotToken, slackSigningSecret, slackChannel, slackChannelId, slackChannelTypes, slackBotName, slackBotIcon, pipeline, stageNames } = props;
        this.environment = {
            SLACK_BOT_TOKEN: slackBotToken,
            SLACK_SIGNING_SECRET: slackSigningSecret,
            SLACK_CHANNEL: slackChannel || '',
            SLACK_CHANNEL_ID: slackChannelId || '',
            SLACK_CHANNEL_TYPES: (slackChannelTypes || [channel_types_1.ChannelTypes.PUBLIC]).join(','),
        };
        if (slackBotName) {
            this.environment.SLACK_BOT_NAME = slackBotName;
        }
        if (slackBotIcon) {
            this.environment.SLACK_BOT_ICON = slackBotIcon;
        }
        const notifier = new aws_lambda_1.Function(scope, 'SlackNotifierFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'notifier')),
            environment: this.environment,
        });
        notifier.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [pipeline.pipelineArn],
            actions: ['codepipeline:GetPipelineState', 'codepipeline:GetPipelineExecution'],
        }));
        pipeline.onStateChange('SlackPipelineNotifierRule', {
            target: new aws_events_targets_1.LambdaFunction(notifier),
        });
        const stageRule = new aws_events_1.Rule(this, 'SlackStageNotifierRule');
        stageRule.addTarget(new aws_events_targets_1.LambdaFunction(notifier));
        stageRule.addEventPattern({
            source: ['aws.codepipeline'],
            resources: [pipeline.pipelineArn],
            detailType: ['CodePipeline Stage Execution State Change'],
        });
        if (stageNames) {
            stageRule.addEventPattern({
                detail: {
                    stage: stageNames,
                },
            });
        }
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        if (this.environment.SLACK_CHANNEL && this.environment.SLACK_CHANNEL_ID) {
            return ['Redundant Configuration: Please configure slackChannel by id (prop slackChannelId) OR name (prop slackChannel)'];
        }
        if (!this.environment.SLACK_CHANNEL && !this.environment.SLACK_CHANNEL_ID) {
            return ['Missing Configuration: Please configure slackChannel by id (prop slackChannelId) or name (prop slackChannel)'];
        }
        return [];
    }
}
exports.SlackNotifier = SlackNotifier;
_a = JSII_RTTI_SYMBOL_1;
SlackNotifier[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-slack.SlackNotifier", version: "1.46.0" };
//# sourceMappingURL=data:application/json;base64,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