"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_sns_subscriptions_1 = require("@aws-cdk/aws-sns-subscriptions");
const channel_types_1 = require("./channel-types");
class SlackApprovalAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    bound(scope, stage, options) {
        const environment = {
            SLACK_BOT_TOKEN: this.props.slackBotToken,
            SLACK_SIGNING_SECRET: this.props.slackSigningSecret,
            SLACK_CHANNEL_TYPES: (this.props.slackChannelTypes || [channel_types_1.ChannelTypes.PUBLIC]).join(','),
        };
        if (this.props.slackChannel) {
            environment.SLACK_CHANNEL = this.props.slackChannel;
        }
        if (this.props.slackChannelId) {
            environment.SLACK_CHANNEL_ID = this.props.slackChannelId;
        }
        if (this.props.slackBotName) {
            environment.SLACK_BOT_NAME = this.props.slackBotName;
        }
        if (this.props.slackBotIcon) {
            environment.SLACK_BOT_ICON = this.props.slackBotIcon;
        }
        const approvalRequester = new aws_lambda_1.Function(scope, 'SlackApprovalRequesterFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-requester')),
            environment,
        });
        const topic = new aws_sns_1.Topic(scope, 'SlackApprovalTopic');
        topic.grantPublish(options.role);
        topic.addSubscription(new aws_sns_subscriptions_1.LambdaSubscription(approvalRequester));
        const approvalHandler = new aws_lambda_1.Function(scope, 'SlackApprovalHandlerFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-handler')),
            environment,
        });
        const api = new aws_apigateway_1.RestApi(scope, 'SlackApprovalApi');
        api.root.addProxy({
            defaultIntegration: new aws_apigateway_1.LambdaIntegration(approvalHandler),
        });
        approvalHandler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${stage.pipeline.pipelineArn}/${stage.stageName}/${this.props.actionName}`],
        }));
        return {
            configuration: {
                NotificationArn: topic.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            },
        };
    }
}
exports.SlackApprovalAction = SlackApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
SlackApprovalAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-slack.SlackApprovalAction", version: "1.46.0" };
//# sourceMappingURL=data:application/json;base64,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