# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SiteConnection(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SiteConnection - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'self_uri': 'str',
            'managed': 'bool',
            'type': 'str',
            'enabled': 'bool',
            'media_model': 'str',
            'edge_list': 'list[ConnectedEdge]',
            'core_site': 'bool',
            'primary_core_sites': 'list[DomainEntityRef]',
            'secondary_core_sites': 'list[DomainEntityRef]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'self_uri': 'selfUri',
            'managed': 'managed',
            'type': 'type',
            'enabled': 'enabled',
            'media_model': 'mediaModel',
            'edge_list': 'edgeList',
            'core_site': 'coreSite',
            'primary_core_sites': 'primaryCoreSites',
            'secondary_core_sites': 'secondaryCoreSites'
        }

        self._id = None
        self._name = None
        self._self_uri = None
        self._managed = None
        self._type = None
        self._enabled = None
        self._media_model = None
        self._edge_list = None
        self._core_site = None
        self._primary_core_sites = None
        self._secondary_core_sites = None

    @property
    def id(self):
        """
        Gets the id of this SiteConnection.


        :return: The id of this SiteConnection.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SiteConnection.


        :param id: The id of this SiteConnection.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this SiteConnection.


        :return: The name of this SiteConnection.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SiteConnection.


        :param name: The name of this SiteConnection.
        :type: str
        """
        
        self._name = name

    @property
    def self_uri(self):
        """
        Gets the self_uri of this SiteConnection.


        :return: The self_uri of this SiteConnection.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this SiteConnection.


        :param self_uri: The self_uri of this SiteConnection.
        :type: str
        """
        
        self._self_uri = self_uri

    @property
    def managed(self):
        """
        Gets the managed of this SiteConnection.


        :return: The managed of this SiteConnection.
        :rtype: bool
        """
        return self._managed

    @managed.setter
    def managed(self, managed):
        """
        Sets the managed of this SiteConnection.


        :param managed: The managed of this SiteConnection.
        :type: bool
        """
        
        self._managed = managed

    @property
    def type(self):
        """
        Gets the type of this SiteConnection.
        Connection method from site to site (Direct, Indirect, CloudProxy

        :return: The type of this SiteConnection.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SiteConnection.
        Connection method from site to site (Direct, Indirect, CloudProxy

        :param type: The type of this SiteConnection.
        :type: str
        """
        allowed_values = ["Direct", "Indirect", "CloudProxy"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def enabled(self):
        """
        Gets the enabled of this SiteConnection.
        Indicates if the current site is linked

        :return: The enabled of this SiteConnection.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this SiteConnection.
        Indicates if the current site is linked

        :param enabled: The enabled of this SiteConnection.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def media_model(self):
        """
        Gets the media_model of this SiteConnection.
        Media model for the current site.

        :return: The media_model of this SiteConnection.
        :rtype: str
        """
        return self._media_model

    @media_model.setter
    def media_model(self, media_model):
        """
        Sets the media_model of this SiteConnection.
        Media model for the current site.

        :param media_model: The media_model of this SiteConnection.
        :type: str
        """
        allowed_values = ["Premises", "Cloud"]
        if media_model.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_model -> " + media_model)
            self._media_model = "outdated_sdk_version"
        else:
            self._media_model = media_model

    @property
    def edge_list(self):
        """
        Gets the edge_list of this SiteConnection.
        All of the edges to which the site connects

        :return: The edge_list of this SiteConnection.
        :rtype: list[ConnectedEdge]
        """
        return self._edge_list

    @edge_list.setter
    def edge_list(self, edge_list):
        """
        Sets the edge_list of this SiteConnection.
        All of the edges to which the site connects

        :param edge_list: The edge_list of this SiteConnection.
        :type: list[ConnectedEdge]
        """
        
        self._edge_list = edge_list

    @property
    def core_site(self):
        """
        Gets the core_site of this SiteConnection.
        The core site

        :return: The core_site of this SiteConnection.
        :rtype: bool
        """
        return self._core_site

    @core_site.setter
    def core_site(self, core_site):
        """
        Sets the core_site of this SiteConnection.
        The core site

        :param core_site: The core_site of this SiteConnection.
        :type: bool
        """
        
        self._core_site = core_site

    @property
    def primary_core_sites(self):
        """
        Gets the primary_core_sites of this SiteConnection.
        List of site ids names and selfUris for the primary core sites

        :return: The primary_core_sites of this SiteConnection.
        :rtype: list[DomainEntityRef]
        """
        return self._primary_core_sites

    @primary_core_sites.setter
    def primary_core_sites(self, primary_core_sites):
        """
        Sets the primary_core_sites of this SiteConnection.
        List of site ids names and selfUris for the primary core sites

        :param primary_core_sites: The primary_core_sites of this SiteConnection.
        :type: list[DomainEntityRef]
        """
        
        self._primary_core_sites = primary_core_sites

    @property
    def secondary_core_sites(self):
        """
        Gets the secondary_core_sites of this SiteConnection.
        List of site ids names and selfUris for the secondary core sites

        :return: The secondary_core_sites of this SiteConnection.
        :rtype: list[DomainEntityRef]
        """
        return self._secondary_core_sites

    @secondary_core_sites.setter
    def secondary_core_sites(self, secondary_core_sites):
        """
        Sets the secondary_core_sites of this SiteConnection.
        List of site ids names and selfUris for the secondary core sites

        :param secondary_core_sites: The secondary_core_sites of this SiteConnection.
        :type: list[DomainEntityRef]
        """
        
        self._secondary_core_sites = secondary_core_sites

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

