# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ListItemComponent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ListItemComponent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'rmid': 'str',
            'type': 'str',
            'image': 'str',
            'title': 'str',
            'description': 'str',
            'actions': 'ContentActions'
        }

        self.attribute_map = {
            'id': 'id',
            'rmid': 'rmid',
            'type': 'type',
            'image': 'image',
            'title': 'title',
            'description': 'description',
            'actions': 'actions'
        }

        self._id = None
        self._rmid = None
        self._type = None
        self._image = None
        self._title = None
        self._description = None
        self._actions = None

    @property
    def id(self):
        """
        Gets the id of this ListItemComponent.
        An ID assigned to this list item.

        :return: The id of this ListItemComponent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ListItemComponent.
        An ID assigned to this list item.

        :param id: The id of this ListItemComponent.
        :type: str
        """
        
        self._id = id

    @property
    def rmid(self):
        """
        Gets the rmid of this ListItemComponent.
        An ID of the rich message instance.

        :return: The rmid of this ListItemComponent.
        :rtype: str
        """
        return self._rmid

    @rmid.setter
    def rmid(self, rmid):
        """
        Sets the rmid of this ListItemComponent.
        An ID of the rich message instance.

        :param rmid: The rmid of this ListItemComponent.
        :type: str
        """
        
        self._rmid = rmid

    @property
    def type(self):
        """
        Gets the type of this ListItemComponent.
        The type of list item to render.

        :return: The type of this ListItemComponent.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ListItemComponent.
        The type of list item to render.

        :param type: The type of this ListItemComponent.
        :type: str
        """
        allowed_values = ["ListItem", "ListItemBig"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def image(self):
        """
        Gets the image of this ListItemComponent.
        URL of an image.

        :return: The image of this ListItemComponent.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this ListItemComponent.
        URL of an image.

        :param image: The image of this ListItemComponent.
        :type: str
        """
        
        self._image = image

    @property
    def title(self):
        """
        Gets the title of this ListItemComponent.
        The main headline of the list item.

        :return: The title of this ListItemComponent.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this ListItemComponent.
        The main headline of the list item.

        :param title: The title of this ListItemComponent.
        :type: str
        """
        
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this ListItemComponent.
        Text to show in the list item description.

        :return: The description of this ListItemComponent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ListItemComponent.
        Text to show in the list item description.

        :param description: The description of this ListItemComponent.
        :type: str
        """
        
        self._description = description

    @property
    def actions(self):
        """
        Gets the actions of this ListItemComponent.
        The list item actions.

        :return: The actions of this ListItemComponent.
        :rtype: ContentActions
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """
        Sets the actions of this ListItemComponent.
        The list item actions.

        :param actions: The actions of this ListItemComponent.
        :type: ContentActions
        """
        
        self._actions = actions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

