# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AgentManagementUnitReference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AgentManagementUnitReference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'UserReference',
            'management_unit': 'ManagementUnitReference',
            'business_unit': 'BusinessUnitReference'
        }

        self.attribute_map = {
            'user': 'user',
            'management_unit': 'managementUnit',
            'business_unit': 'businessUnit'
        }

        self._user = None
        self._management_unit = None
        self._business_unit = None

    @property
    def user(self):
        """
        Gets the user of this AgentManagementUnitReference.
        The user (agent) for whom the management unit was requested

        :return: The user of this AgentManagementUnitReference.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this AgentManagementUnitReference.
        The user (agent) for whom the management unit was requested

        :param user: The user of this AgentManagementUnitReference.
        :type: UserReference
        """
        
        self._user = user

    @property
    def management_unit(self):
        """
        Gets the management_unit of this AgentManagementUnitReference.
        The management to which the user (agent) belongs

        :return: The management_unit of this AgentManagementUnitReference.
        :rtype: ManagementUnitReference
        """
        return self._management_unit

    @management_unit.setter
    def management_unit(self, management_unit):
        """
        Sets the management_unit of this AgentManagementUnitReference.
        The management to which the user (agent) belongs

        :param management_unit: The management_unit of this AgentManagementUnitReference.
        :type: ManagementUnitReference
        """
        
        self._management_unit = management_unit

    @property
    def business_unit(self):
        """
        Gets the business_unit of this AgentManagementUnitReference.
        The business unit to which the user (agent) belongs. Populate with expand=businessUnit

        :return: The business_unit of this AgentManagementUnitReference.
        :rtype: BusinessUnitReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit):
        """
        Sets the business_unit of this AgentManagementUnitReference.
        The business unit to which the user (agent) belongs. Populate with expand=businessUnit

        :param business_unit: The business_unit of this AgentManagementUnitReference.
        :type: BusinessUnitReference
        """
        
        self._business_unit = business_unit

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

