# coding: utf-8

"""
RoutingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RoutingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_routing_assessment(self, assessment_id, **kwargs):
        """
        Delete single benefit assessment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_assessment(assessment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assessment_id: Benefit Assessment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assessment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_assessment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assessment_id' is set
        if ('assessment_id' not in params) or (params['assessment_id'] is None):
            raise ValueError("Missing the required parameter `assessment_id` when calling `delete_routing_assessment`")


        resource_path = '/api/v2/routing/assessments/{assessmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'assessment_id' in params:
            path_params['assessmentId'] = params['assessment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_email_domain(self, domain_id, **kwargs):
        """
        Delete a domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_email_domain(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_email_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `delete_routing_email_domain`")


        resource_path = '/api/v2/routing/email/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_email_domain_route(self, domain_name, route_id, **kwargs):
        """
        Delete a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_email_domain_route(domain_name, route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_email_domain_route" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `delete_routing_email_domain_route`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `delete_routing_email_domain_route`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_predictor(self, predictor_id, **kwargs):
        """
        Delete single predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_predictor(predictor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str predictor_id: Predictor ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['predictor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_predictor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'predictor_id' is set
        if ('predictor_id' not in params) or (params['predictor_id'] is None):
            raise ValueError("Missing the required parameter `predictor_id` when calling `delete_routing_predictor`")


        resource_path = '/api/v2/routing/predictors/{predictorId}'.replace('{format}', 'json')
        path_params = {}
        if 'predictor_id' in params:
            path_params['predictorId'] = params['predictor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_queue(self, queue_id, **kwargs):
        """
        Delete a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_queue(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param bool force_delete: forceDelete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'force_delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_routing_queue`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'force_delete' in params:
            query_params['forceDelete'] = params['force_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_queue_member(self, queue_id, member_id, **kwargs):
        """
        Delete a queue member.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_queue_member(queue_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_queue_member" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_routing_queue_member`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `delete_routing_queue_member`")


        resource_path = '/api/v2/routing/queues/{queueId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_queue_user(self, queue_id, member_id, **kwargs):
        """
        DEPRECATED: use DELETE /routing/queues/{queueId}/members/{memberId}.  Delete queue member.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_queue_user(queue_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_queue_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_routing_queue_user`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `delete_routing_queue_user`")


        resource_path = '/api/v2/routing/queues/{queueId}/users/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_queue_wrapupcode(self, queue_id, code_id, **kwargs):
        """
        Delete a wrap-up code from a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_queue_wrapupcode(queue_id, code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str code_id: Code ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_queue_wrapupcode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_routing_queue_wrapupcode`")
        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `delete_routing_queue_wrapupcode`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_settings(self, **kwargs):
        """
        Delete an organization's routing settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_skill(self, skill_id, **kwargs):
        """
        Delete Routing Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_skill(skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str skill_id: Skill ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_skill" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `delete_routing_skill`")


        resource_path = '/api/v2/routing/skills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_sms_address(self, address_id, **kwargs):
        """
        Delete an Address by Id for SMS
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_sms_address(address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str address_id: Address ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_sms_address" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'address_id' is set
        if ('address_id' not in params) or (params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_routing_sms_address`")


        resource_path = '/api/v2/routing/sms/addresses/{addressId}'.replace('{format}', 'json')
        path_params = {}
        if 'address_id' in params:
            path_params['addressId'] = params['address_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_sms_phonenumber(self, address_id, **kwargs):
        """
        Delete a phone number provisioned for SMS.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_sms_phonenumber(address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str address_id: Address ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_sms_phonenumber" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'address_id' is set
        if ('address_id' not in params) or (params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_routing_sms_phonenumber`")


        resource_path = '/api/v2/routing/sms/phonenumbers/{addressId}'.replace('{format}', 'json')
        path_params = {}
        if 'address_id' in params:
            path_params['addressId'] = params['address_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_user_utilization(self, user_id, **kwargs):
        """
        Delete the user's max utilization settings and revert to the organization-wide default.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_user_utilization(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_user_utilization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_routing_user_utilization`")


        resource_path = '/api/v2/routing/users/{userId}/utilization'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_utilization(self, **kwargs):
        """
        Delete the organization-wide max utilization settings and revert to the system default.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_utilization(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_utilization" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_routing_wrapupcode(self, code_id, **kwargs):
        """
        Delete wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_routing_wrapupcode(code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_routing_wrapupcode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `delete_routing_wrapupcode`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_user_routinglanguage(self, user_id, language_id, **kwargs):
        """
        Remove routing language from user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user_routinglanguage(user_id, language_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str language_id: languageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'language_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_routinglanguage" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_user_routinglanguage`")
        # verify the required parameter 'language_id' is set
        if ('language_id' not in params) or (params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `delete_user_routinglanguage`")


        resource_path = '/api/v2/users/{userId}/routinglanguages/{languageId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_user_routingskill(self, user_id, skill_id, **kwargs):
        """
        Remove routing skill from user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user_routingskill(user_id, skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str skill_id: skillId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_routingskill" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_user_routingskill`")
        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `delete_user_routingskill`")


        resource_path = '/api/v2/users/{userId}/routingskills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_assessment(self, assessment_id, **kwargs):
        """
        Retrieve a single benefit assessment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_assessment(assessment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assessment_id: Benefit Assessment ID (required)
        :return: BenefitAssessment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assessment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_assessment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assessment_id' is set
        if ('assessment_id' not in params) or (params['assessment_id'] is None):
            raise ValueError("Missing the required parameter `assessment_id` when calling `get_routing_assessment`")


        resource_path = '/api/v2/routing/assessments/{assessmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'assessment_id' in params:
            path_params['assessmentId'] = params['assessment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BenefitAssessment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_assessments(self, **kwargs):
        """
        Retrieve all benefit assessments.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_assessments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param list[str] queue_id: Queue ID(s) to filter assessments by.
        :return: AssessmentListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'limit', 'page_size', 'queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_assessments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/assessments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'queue_id' in params:
            query_params['queueId'] = params['queue_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssessmentListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_assessments_job(self, job_id, **kwargs):
        """
        Retrieve a single benefit assessments job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_assessments_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: Benefit Assessment Job ID (required)
        :return: BenefitAssessmentJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_assessments_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_routing_assessments_job`")


        resource_path = '/api/v2/routing/assessments/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BenefitAssessmentJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_assessments_jobs(self, **kwargs):
        """
        Retrieve all benefit assessment jobs.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_assessments_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] division_id: Division ID(s) to filter assessment jobs by.
        :return: AssessmentJobListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_assessments_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/assessments/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssessmentJobListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_email_domain(self, domain_id, **kwargs):
        """
        Get domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_email_domain(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :return: InboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_email_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_routing_email_domain`")


        resource_path = '/api/v2/routing/email/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_email_domain_route(self, domain_name, route_id, **kwargs):
        """
        Get a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_email_domain_route(domain_name, route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_email_domain_route" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `get_routing_email_domain_route`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `get_routing_email_domain_route`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_email_domain_routes(self, domain_name, **kwargs):
        """
        Get routes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_email_domain_routes(domain_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str pattern: Filter routes by the route's pattern property
        :return: InboundRouteEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'page_size', 'page_number', 'pattern']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_email_domain_routes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `get_routing_email_domain_routes`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'pattern' in params:
            query_params['pattern'] = params['pattern']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRouteEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_email_domains(self, **kwargs):
        """
        Get domains
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_email_domains(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InboundDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_email_domains" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/email/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_email_setup(self, **kwargs):
        """
        Get email setup
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_email_setup(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EmailSetup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_email_setup" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/email/setup'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailSetup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_languages(self, **kwargs):
        """
        Get the list of supported languages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_languages(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Ascending or descending sort order
        :param str name: Name
        :param list[str] id: id
        :return: LanguageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_order', 'name', 'id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_languages" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/languages'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LanguageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_message_recipient(self, recipient_id, **kwargs):
        """
        Get a recipient
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_message_recipient(recipient_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str recipient_id: Recipient ID (required)
        :return: Recipient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recipient_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_message_recipient" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `get_routing_message_recipient`")


        resource_path = '/api/v2/routing/message/recipients/{recipientId}'.replace('{format}', 'json')
        path_params = {}
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recipient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_message_recipients(self, **kwargs):
        """
        Get recipients
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_message_recipients(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messenger_type: Messenger Type
        :param int page_size: Page size
        :param int page_number: Page number
        :return: RecipientListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messenger_type', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_message_recipients" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/message/recipients'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'messenger_type' in params:
            query_params['messengerType'] = params['messenger_type']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecipientListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_predictor(self, predictor_id, **kwargs):
        """
        Retrieve a single predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_predictor(predictor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str predictor_id: Predictor ID (required)
        :return: Predictor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['predictor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_predictor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'predictor_id' is set
        if ('predictor_id' not in params) or (params['predictor_id'] is None):
            raise ValueError("Missing the required parameter `predictor_id` when calling `get_routing_predictor`")


        resource_path = '/api/v2/routing/predictors/{predictorId}'.replace('{format}', 'json')
        path_params = {}
        if 'predictor_id' in params:
            path_params['predictorId'] = params['predictor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Predictor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_predictors(self, **kwargs):
        """
        Retrieve all predictors.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_predictors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param list[str] queue_id: Comma-separated list of queue Ids to filter by.
        :return: PredictorListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'limit', 'page_size', 'queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_predictors" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/predictors'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'queue_id' in params:
            query_params['queueId'] = params['queue_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PredictorListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_predictors_keyperformanceindicators(self, **kwargs):
        """
        Get a list of Key Performance Indicators available for the predictors.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_predictors_keyperformanceindicators(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[KeyPerformanceIndicator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_predictors_keyperformanceindicators" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/predictors/keyperformanceindicators'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[KeyPerformanceIndicator]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue(self, queue_id, **kwargs):
        """
        Get details about this queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_comparisonperiod(self, queue_id, comparison_period_id, **kwargs):
        """
        Get a Comparison Period.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_comparisonperiod(queue_id, comparison_period_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue id (required)
        :param str comparison_period_id: ComparisonPeriod id (required)
        :return: ComparisonPeriod
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'comparison_period_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_comparisonperiod" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_comparisonperiod`")
        # verify the required parameter 'comparison_period_id' is set
        if ('comparison_period_id' not in params) or (params['comparison_period_id'] is None):
            raise ValueError("Missing the required parameter `comparison_period_id` when calling `get_routing_queue_comparisonperiod`")


        resource_path = '/api/v2/routing/queues/{queueId}/comparisonperiods/{comparisonPeriodId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'comparison_period_id' in params:
            path_params['comparisonPeriodId'] = params['comparison_period_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ComparisonPeriod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_comparisonperiods(self, queue_id, **kwargs):
        """
        Get list of comparison periods
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_comparisonperiods(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue id (required)
        :return: ComparisonPeriodListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_comparisonperiods" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_comparisonperiods`")


        resource_path = '/api/v2/routing/queues/{queueId}/comparisonperiods'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ComparisonPeriodListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_estimatedwaittime(self, queue_id, **kwargs):
        """
        Get Estimated Wait Time
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_estimatedwaittime(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: queueId (required)
        :param str conversation_id: conversationId
        :return: EstimatedWaitTimePredictions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_estimatedwaittime" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_estimatedwaittime`")


        resource_path = '/api/v2/routing/queues/{queueId}/estimatedwaittime'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EstimatedWaitTimePredictions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_mediatype_estimatedwaittime(self, queue_id, media_type, **kwargs):
        """
        Get Estimated Wait Time
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_mediatype_estimatedwaittime(queue_id, media_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: queueId (required)
        :param str media_type: mediaType (required)
        :return: EstimatedWaitTimePredictions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'media_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_mediatype_estimatedwaittime" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_mediatype_estimatedwaittime`")
        # verify the required parameter 'media_type' is set
        if ('media_type' not in params) or (params['media_type'] is None):
            raise ValueError("Missing the required parameter `media_type` when calling `get_routing_queue_mediatype_estimatedwaittime`")


        resource_path = '/api/v2/routing/queues/{queueId}/mediatypes/{mediaType}/estimatedwaittime'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'media_type' in params:
            path_params['mediaType'] = params['media_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EstimatedWaitTimePredictions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_members(self, queue_id, **kwargs):
        """
        Get the members of this queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_members(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param int page_size: Page size [max 100]
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param list[str] expand: Which fields, if any, to expand.
        :param bool joined: Filter by joined status
        :param str name: Filter by queue member name
        :param list[str] profile_skills: Filter by profile skill
        :param list[str] skills: Filter by skill
        :param list[str] languages: Filter by language
        :param list[str] routing_status: Filter by routing status
        :param list[str] presence: Filter by presence
        :return: QueueMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'page_size', 'page_number', 'sort_by', 'expand', 'joined', 'name', 'profile_skills', 'skills', 'languages', 'routing_status', 'presence']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_members`")


        resource_path = '/api/v2/routing/queues/{queueId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'joined' in params:
            query_params['joined'] = params['joined']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'profile_skills' in params:
            query_params['profileSkills'] = params['profile_skills']
        if 'skills' in params:
            query_params['skills'] = params['skills']
        if 'languages' in params:
            query_params['languages'] = params['languages']
        if 'routing_status' in params:
            query_params['routingStatus'] = params['routing_status']
        if 'presence' in params:
            query_params['presence'] = params['presence']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_users(self, queue_id, **kwargs):
        """
        DEPRECATED: use GET /routing/queues/{queueId}/members.  Get the members of this queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_users(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param int page_size: Page size [max 100]
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param list[str] expand: Which fields, if any, to expand.
        :param bool joined: Filter by joined status
        :param str name: Filter by queue member name
        :param list[str] profile_skills: Filter by profile skill
        :param list[str] skills: Filter by skill
        :param list[str] languages: Filter by language
        :param list[str] routing_status: Filter by routing status
        :param list[str] presence: Filter by presence
        :return: QueueMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'page_size', 'page_number', 'sort_by', 'expand', 'joined', 'name', 'profile_skills', 'skills', 'languages', 'routing_status', 'presence']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'joined' in params:
            query_params['joined'] = params['joined']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'profile_skills' in params:
            query_params['profileSkills'] = params['profile_skills']
        if 'skills' in params:
            query_params['skills'] = params['skills']
        if 'languages' in params:
            query_params['languages'] = params['languages']
        if 'routing_status' in params:
            query_params['routingStatus'] = params['routing_status']
        if 'presence' in params:
            query_params['presence'] = params['presence']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queue_wrapupcodes(self, queue_id, **kwargs):
        """
        Get the wrap-up codes for a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queue_wrapupcodes(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: WrapupCodeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queue_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_routing_queue_wrapupcodes`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCodeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queues(self, **kwargs):
        """
        Get list of queues.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queues(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str name: Name
        :param list[str] id: ID(s)
        :param list[str] division_id: Division ID(s)
        :return: QueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'name', 'id', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queues" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queues_divisionviews(self, **kwargs):
        """
        Get a paged listing of simplified queue objects, filterable by name, queue ID(s), or division ID(s).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queues_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size [max value is 100]
        :param int page_number: Page number [max value is 5]
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name
        :param list[str] id: Queue ID(s)
        :param list[str] division_id: Division ID(s)
        :return: QueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'name', 'id', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queues_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queues_divisionviews_all(self, **kwargs):
        """
        Get a paged listing of simplified queue objects.  Can be used to get a digest of all queues in an organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queues_divisionviews_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size [max value is 500]
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: QueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queues_divisionviews_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues/divisionviews/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_queues_me(self, **kwargs):
        """
        Get a paged listing of queues the user is a member of.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_queues_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool joined: Joined
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: UserQueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['joined', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_queues_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'joined' in params:
            query_params['joined'] = params['joined']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserQueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_settings(self, **kwargs):
        """
        Get an organization's routing settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: RoutingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_settings_contactcenter(self, **kwargs):
        """
        Get Contact Center Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_settings_contactcenter(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ContactCenterSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_settings_contactcenter" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/settings/contactcenter'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactCenterSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_settings_transcription(self, **kwargs):
        """
        Get Transcription Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_settings_transcription(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: TranscriptionSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_settings_transcription" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/settings/transcription'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptionSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_skill(self, skill_id, **kwargs):
        """
        Get Routing Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_skill(skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str skill_id: Skill ID (required)
        :return: RoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_skill" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `get_routing_skill`")


        resource_path = '/api/v2/routing/skills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_skills(self, **kwargs):
        """
        Get the list of routing skills.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_skills(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Filter for results that start with this value
        :param list[str] id: id
        :return: SkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_skills" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/skills'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_sms_address(self, address_id, **kwargs):
        """
        Get an Address by Id for SMS
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_sms_address(address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str address_id: Address ID (required)
        :return: SmsAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_sms_address" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'address_id' is set
        if ('address_id' not in params) or (params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_routing_sms_address`")


        resource_path = '/api/v2/routing/sms/addresses/{addressId}'.replace('{format}', 'json')
        path_params = {}
        if 'address_id' in params:
            path_params['addressId'] = params['address_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsAddress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_sms_addresses(self, **kwargs):
        """
        Get a list of Addresses for SMS
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_sms_addresses(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SmsAddressEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_sms_addresses" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/sms/addresses'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsAddressEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_sms_availablephonenumbers(self, country_code, phone_number_type, **kwargs):
        """
        Get a list of available phone numbers for SMS provisioning.
        This request will return up to 30 random phone numbers matching the criteria specified.  To get additional phone numbers repeat the request.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_sms_availablephonenumbers(country_code, phone_number_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str country_code: The ISO 3166-1 alpha-2 country code of the county for which available phone numbers should be returned (required)
        :param str phone_number_type: Type of available phone numbers searched (required)
        :param str region: Region/province/state that can be used to restrict the numbers returned
        :param str city: City that can be used to restrict the numbers returned
        :param str area_code: Area code that can be used to restrict the numbers returned
        :param str pattern: A pattern to match phone numbers. Valid characters are '*' and [0-9a-zA-Z]. The '*' character will match any single digit.
        :param str address_requirement: This indicates whether the phone number requires to have an Address registered.
        :return: SMSAvailablePhoneNumberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code', 'phone_number_type', 'region', 'city', 'area_code', 'pattern', 'address_requirement']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_sms_availablephonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'country_code' is set
        if ('country_code' not in params) or (params['country_code'] is None):
            raise ValueError("Missing the required parameter `country_code` when calling `get_routing_sms_availablephonenumbers`")
        # verify the required parameter 'phone_number_type' is set
        if ('phone_number_type' not in params) or (params['phone_number_type'] is None):
            raise ValueError("Missing the required parameter `phone_number_type` when calling `get_routing_sms_availablephonenumbers`")


        resource_path = '/api/v2/routing/sms/availablephonenumbers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'country_code' in params:
            query_params['countryCode'] = params['country_code']
        if 'region' in params:
            query_params['region'] = params['region']
        if 'city' in params:
            query_params['city'] = params['city']
        if 'area_code' in params:
            query_params['areaCode'] = params['area_code']
        if 'phone_number_type' in params:
            query_params['phoneNumberType'] = params['phone_number_type']
        if 'pattern' in params:
            query_params['pattern'] = params['pattern']
        if 'address_requirement' in params:
            query_params['addressRequirement'] = params['address_requirement']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SMSAvailablePhoneNumberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_sms_phonenumber(self, address_id, **kwargs):
        """
        Get a phone number provisioned for SMS.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_sms_phonenumber(address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str address_id: Address ID (required)
        :return: SmsPhoneNumber
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_sms_phonenumber" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'address_id' is set
        if ('address_id' not in params) or (params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_routing_sms_phonenumber`")


        resource_path = '/api/v2/routing/sms/phonenumbers/{addressId}'.replace('{format}', 'json')
        path_params = {}
        if 'address_id' in params:
            path_params['addressId'] = params['address_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsPhoneNumber',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_sms_phonenumbers(self, **kwargs):
        """
        Get a list of provisioned phone numbers.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_sms_phonenumbers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_number: Filter on phone number address. Allowable characters are the digits '0-9' and the wild card character '\\*'. If just digits are present, a contains search is done on the address pattern. For example, '317' could be matched anywhere in the address. An '\\*' will match multiple digits. For example, to match a specific area code within the US a pattern like '1317*' could be used.
        :param str phone_number_type: Filter on phone number type
        :param str phone_number_status: Filter on phone number status
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SmsPhoneNumberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_number', 'phone_number_type', 'phone_number_status', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_sms_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/sms/phonenumbers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'phone_number' in params:
            query_params['phoneNumber'] = params['phone_number']
        if 'phone_number_type' in params:
            query_params['phoneNumberType'] = params['phone_number_type']
        if 'phone_number_status' in params:
            query_params['phoneNumberStatus'] = params['phone_number_status']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsPhoneNumberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_user_utilization(self, user_id, **kwargs):
        """
        Get the user's max utilization settings.  If not configured, the organization-wide default is returned.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_user_utilization(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: AgentMaxUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_user_utilization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_routing_user_utilization`")


        resource_path = '/api/v2/routing/users/{userId}/utilization'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentMaxUtilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_utilization(self, **kwargs):
        """
        Get the organization-wide max utilization settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_utilization(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Utilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_utilization" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Utilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_wrapupcode(self, code_id, **kwargs):
        """
        Get details about this wrap-up code.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_wrapupcode(code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_wrapupcode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `get_routing_wrapupcode`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_routing_wrapupcodes(self, **kwargs):
        """
        Get list of wrapup codes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_routing_wrapupcodes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Wrapup code's name ('Sort by' param is ignored unless this field is provided)
        :return: WrapupCodeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_routing_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/wrapupcodes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCodeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_queues(self, user_id, **kwargs):
        """
        Get queues for user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_queues(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param bool joined: Is joined to the queue
        :param list[str] division_id: Division ID(s)
        :return: UserQueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'page_size', 'page_number', 'joined', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_queues`")


        resource_path = '/api/v2/users/{userId}/queues'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'joined' in params:
            query_params['joined'] = params['joined']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserQueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_routinglanguages(self, user_id, **kwargs):
        """
        List routing language for user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_routinglanguages(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Ascending or descending sort order
        :return: UserLanguageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'page_size', 'page_number', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_routinglanguages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_routinglanguages`")


        resource_path = '/api/v2/users/{userId}/routinglanguages'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserLanguageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_routingskills(self, user_id, **kwargs):
        """
        List routing skills for user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_routingskills(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Ascending or descending sort order
        :return: UserSkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'page_size', 'page_number', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_routingskills" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_routingskills`")


        resource_path = '/api/v2/users/{userId}/routingskills'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_conversation(self, conversation_id, body, **kwargs):
        """
        Update attributes of an in-queue conversation
        Returns an object indicating the updated values of all settable attributes.  Supported attributes: priority (each point of priority is equivalent to one minute of time in queue).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_conversation(conversation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param RoutingConversationAttributes body: Conversation Attributes (required)
        :return: RoutingConversationAttributes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `patch_routing_conversation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_conversation`")


        resource_path = '/api/v2/routing/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingConversationAttributes',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_email_domain(self, domain_id, body, **kwargs):
        """
        Update domain settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_email_domain(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :param InboundDomainPatchRequest body: Domain settings (required)
        :return: InboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_email_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `patch_routing_email_domain`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_email_domain`")


        resource_path = '/api/v2/routing/email/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_email_domain_validate(self, domain_id, body, **kwargs):
        """
        Validate domain settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_email_domain_validate(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :param InboundDomainPatchRequest body: Domain settings (required)
        :return: InboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_email_domain_validate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `patch_routing_email_domain_validate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_email_domain_validate`")


        resource_path = '/api/v2/routing/email/domains/{domainId}/validate'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_email_outbound_domain(self, domain_id, body, **kwargs):
        """
        Request an update of the emails from /replyTo of an outbound domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_email_outbound_domain(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :param OutboundDomain body: domain with emails that need update set (required)
        :return: OutboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_email_outbound_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `patch_routing_email_outbound_domain`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_email_outbound_domain`")


        resource_path = '/api/v2/routing/email/outbound/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_predictor(self, predictor_id, **kwargs):
        """
        Update single predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_predictor(predictor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str predictor_id: Predictor ID (required)
        :param PatchPredictorRequest body: 
        :return: Predictor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['predictor_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_predictor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'predictor_id' is set
        if ('predictor_id' not in params) or (params['predictor_id'] is None):
            raise ValueError("Missing the required parameter `predictor_id` when calling `patch_routing_predictor`")


        resource_path = '/api/v2/routing/predictors/{predictorId}'.replace('{format}', 'json')
        path_params = {}
        if 'predictor_id' in params:
            path_params['predictorId'] = params['predictor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Predictor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_queue_member(self, queue_id, member_id, body, **kwargs):
        """
        Update the ring number OR joined status for a queue member.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_queue_member(queue_id, member_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :param QueueMember body: Queue Member (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_queue_member" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_routing_queue_member`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `patch_routing_queue_member`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_queue_member`")


        resource_path = '/api/v2/routing/queues/{queueId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_queue_members(self, queue_id, body, **kwargs):
        """
        Join or unjoin a set of users for a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_queue_members(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[QueueMember] body: Queue Members (required)
        :return: QueueMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_queue_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_routing_queue_members`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_queue_members`")


        resource_path = '/api/v2/routing/queues/{queueId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_queue_user(self, queue_id, member_id, body, **kwargs):
        """
        DEPRECATED: use PATCH /routing/queues/{queueId}/members/{memberId}.  Update the ring number OR joined status for a User in a Queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_queue_user(queue_id, member_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :param QueueMember body: Queue Member (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_queue_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_routing_queue_user`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `patch_routing_queue_user`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_queue_user`")


        resource_path = '/api/v2/routing/queues/{queueId}/users/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_queue_users(self, queue_id, body, **kwargs):
        """
        DEPRECATED: use PATCH /routing/queues/{queueId}/members.  Join or unjoin a set of users for a queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_queue_users(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[QueueMember] body: Queue Members (required)
        :return: QueueMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_queue_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_routing_queue_users`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_queue_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_routing_settings_contactcenter(self, body, **kwargs):
        """
        Update Contact Center Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_routing_settings_contactcenter(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactCenterSettings body: Contact Center Settings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_routing_settings_contactcenter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_routing_settings_contactcenter`")


        resource_path = '/api/v2/routing/settings/contactcenter'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_user_queue(self, queue_id, user_id, body, **kwargs):
        """
        Join or unjoin a queue for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_user_queue(queue_id, user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str user_id: User ID (required)
        :param UserQueue body: Queue Member (required)
        :return: UserQueue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_user_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_user_queue`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_user_queue`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_user_queue`")


        resource_path = '/api/v2/users/{userId}/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserQueue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_user_queues(self, user_id, body, **kwargs):
        """
        Join or unjoin a set of queues for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_user_queues(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param list[UserQueue] body: User Queues (required)
        :param list[str] division_id: Division ID(s)
        :return: UserQueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_user_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_user_queues`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_user_queues`")


        resource_path = '/api/v2/users/{userId}/queues'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserQueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_user_routinglanguage(self, user_id, language_id, body, **kwargs):
        """
        Update routing language proficiency or state.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_user_routinglanguage(user_id, language_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str language_id: languageId (required)
        :param UserRoutingLanguage body: Language (required)
        :return: UserRoutingLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'language_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_user_routinglanguage" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_user_routinglanguage`")
        # verify the required parameter 'language_id' is set
        if ('language_id' not in params) or (params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `patch_user_routinglanguage`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_user_routinglanguage`")


        resource_path = '/api/v2/users/{userId}/routinglanguages/{languageId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_user_routinglanguages_bulk(self, user_id, body, **kwargs):
        """
        Add bulk routing language to user. Max limit 50 languages
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_user_routinglanguages_bulk(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param list[UserRoutingLanguagePost] body: Language (required)
        :return: UserLanguageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_user_routinglanguages_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_user_routinglanguages_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_user_routinglanguages_bulk`")


        resource_path = '/api/v2/users/{userId}/routinglanguages/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserLanguageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_user_routingskills_bulk(self, user_id, body, **kwargs):
        """
        Bulk add routing skills to user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_user_routingskills_bulk(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param list[UserRoutingSkillPost] body: Skill (required)
        :return: UserSkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_user_routingskills_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_user_routingskills_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_user_routingskills_bulk`")


        resource_path = '/api/v2/users/{userId}/routingskills/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_queues_observations_query(self, body, **kwargs):
        """
        Query for queue observations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_queues_observations_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param QueueObservationQuery body: query (required)
        :return: QueueObservationQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_queues_observations_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_queues_observations_query`")


        resource_path = '/api/v2/analytics/queues/observations/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueObservationQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_assessments(self, **kwargs):
        """
        Create a benefit assessment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_assessments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateBenefitAssessmentRequest body: 
        :return: BenefitAssessment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_assessments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/assessments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BenefitAssessment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_assessments_jobs(self, **kwargs):
        """
        Create a benefit assessment job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_assessments_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateBenefitAssessmentJobRequest body: 
        :return: BenefitAssessmentJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_assessments_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/assessments/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BenefitAssessmentJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_email_domain_routes(self, domain_name, body, **kwargs):
        """
        Create a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_email_domain_routes(domain_name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param InboundRoute body: Route (required)
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_email_domain_routes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `post_routing_email_domain_routes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_email_domain_routes`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_email_domain_testconnection(self, domain_id, **kwargs):
        """
        Tests the custom SMTP server integration connection set on this domain
        The request body is optional. If omitted, this endpoint will just test the connection of the Custom SMTP Server. If the body is specified, there will be an attempt to send an email message to the server.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_email_domain_testconnection(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :param TestMessage body: TestMessage
        :return: TestMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_email_domain_testconnection" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_routing_email_domain_testconnection`")


        resource_path = '/api/v2/routing/email/domains/{domainId}/testconnection'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestMessage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_email_domains(self, body, **kwargs):
        """
        Create a domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_email_domains(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param InboundDomain body: Domain (required)
        :return: InboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_email_domains" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_email_domains`")


        resource_path = '/api/v2/routing/email/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_languages(self, body, **kwargs):
        """
        Create Language
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_languages(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Language body: Language (required)
        :return: Language
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_languages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_languages`")


        resource_path = '/api/v2/routing/languages'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Language',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_predictors(self, **kwargs):
        """
        Create a predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_predictors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreatePredictorRequest body: 
        :return: Predictor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_predictors" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/predictors'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Predictor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_queue_members(self, queue_id, body, **kwargs):
        """
        Bulk add or delete up to 100 queue members
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_queue_members(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[WritableEntity] body: Queue Members (required)
        :param bool delete: True to delete queue members
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body', 'delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_queue_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `post_routing_queue_members`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_queue_members`")


        resource_path = '/api/v2/routing/queues/{queueId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'delete' in params:
            query_params['delete'] = params['delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_queue_users(self, queue_id, body, **kwargs):
        """
        DEPRECATED: use POST /routing/queues/{queueId}/members.  Bulk add or delete up to 100 queue members.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_queue_users(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[WritableEntity] body: Queue Members (required)
        :param bool delete: True to delete queue members
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body', 'delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_queue_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `post_routing_queue_users`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_queue_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'delete' in params:
            query_params['delete'] = params['delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_queue_wrapupcodes(self, queue_id, body, **kwargs):
        """
        Add up to 100 wrap-up codes to a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_queue_wrapupcodes(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[WrapUpCodeReference] body: List of wrapup codes (required)
        :return: list[WrapupCode]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_queue_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `post_routing_queue_wrapupcodes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_queue_wrapupcodes`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[WrapupCode]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_queues(self, body, **kwargs):
        """
        Create a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_queues(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateQueueRequest body: Queue (required)
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_queues`")


        resource_path = '/api/v2/routing/queues'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_skills(self, body, **kwargs):
        """
        Create Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_skills(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RoutingSkill body: Skill (required)
        :return: RoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_skills" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_skills`")


        resource_path = '/api/v2/routing/skills'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_sms_addresses(self, body, **kwargs):
        """
        Provision an Address for SMS
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_sms_addresses(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SmsAddressProvision body: SmsAddress (required)
        :return: SmsAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_sms_addresses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_sms_addresses`")


        resource_path = '/api/v2/routing/sms/addresses'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsAddress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_sms_phonenumbers(self, body, **kwargs):
        """
        Provision a phone number for SMS
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_sms_phonenumbers(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SmsPhoneNumberProvision body: SmsPhoneNumber (required)
        :return: SmsPhoneNumber
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_sms_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_sms_phonenumbers`")


        resource_path = '/api/v2/routing/sms/phonenumbers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsPhoneNumber',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_routing_wrapupcodes(self, body, **kwargs):
        """
        Create a wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_routing_wrapupcodes(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WrapupCode body: WrapupCode (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_routing_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_routing_wrapupcodes`")


        resource_path = '/api/v2/routing/wrapupcodes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_user_routinglanguages(self, user_id, body, **kwargs):
        """
        Add routing language to user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_user_routinglanguages(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param UserRoutingLanguagePost body: Language (required)
        :return: UserRoutingLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_routinglanguages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_user_routinglanguages`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_user_routinglanguages`")


        resource_path = '/api/v2/users/{userId}/routinglanguages'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_user_routingskills(self, user_id, body, **kwargs):
        """
        Add routing skill to user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_user_routingskills(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param UserRoutingSkillPost body: Skill (required)
        :return: UserRoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_routingskills" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_user_routingskills`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_user_routingskills`")


        resource_path = '/api/v2/users/{userId}/routingskills'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_email_domain_route(self, domain_name, route_id, body, **kwargs):
        """
        Update a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_email_domain_route(domain_name, route_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :param InboundRoute body: Route (required)
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_email_domain_route" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `put_routing_email_domain_route`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `put_routing_email_domain_route`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_email_domain_route`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_message_recipient(self, recipient_id, body, **kwargs):
        """
        Update a recipient
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_message_recipient(recipient_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str recipient_id: Recipient ID (required)
        :param Recipient body: Recipient (required)
        :return: Recipient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recipient_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_message_recipient" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `put_routing_message_recipient`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_message_recipient`")


        resource_path = '/api/v2/routing/message/recipients/{recipientId}'.replace('{format}', 'json')
        path_params = {}
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recipient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_queue(self, queue_id, body, **kwargs):
        """
        Update a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_queue(queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param QueueRequest body: Queue (required)
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `put_routing_queue`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_queue`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_settings(self, body, **kwargs):
        """
        Update an organization's routing settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RoutingSettings body: Organization Settings (required)
        :return: RoutingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_settings`")


        resource_path = '/api/v2/routing/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_settings_transcription(self, body, **kwargs):
        """
        Update Transcription Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_settings_transcription(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TranscriptionSettings body: Organization Settings (required)
        :return: TranscriptionSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_settings_transcription" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_settings_transcription`")


        resource_path = '/api/v2/routing/settings/transcription'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptionSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_sms_phonenumber(self, address_id, body, **kwargs):
        """
        Update a phone number provisioned for SMS.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_sms_phonenumber(address_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str address_id: Address ID (required)
        :param SmsPhoneNumber body: SmsPhoneNumber (required)
        :return: SmsPhoneNumber
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_sms_phonenumber" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'address_id' is set
        if ('address_id' not in params) or (params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `put_routing_sms_phonenumber`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_sms_phonenumber`")


        resource_path = '/api/v2/routing/sms/phonenumbers/{addressId}'.replace('{format}', 'json')
        path_params = {}
        if 'address_id' in params:
            path_params['addressId'] = params['address_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SmsPhoneNumber',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_user_utilization(self, user_id, body, **kwargs):
        """
        Update the user's max utilization settings.  Include only those media types requiring custom configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_user_utilization(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param Utilization body: utilization (required)
        :return: AgentMaxUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_user_utilization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_routing_user_utilization`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_user_utilization`")


        resource_path = '/api/v2/routing/users/{userId}/utilization'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentMaxUtilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_utilization(self, body, **kwargs):
        """
        Update the organization-wide max utilization settings.  Include only those media types requiring custom configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_utilization(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Utilization body: utilization (required)
        :return: Utilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_utilization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_utilization`")


        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Utilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_routing_wrapupcode(self, code_id, body, **kwargs):
        """
        Update wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_routing_wrapupcode(code_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :param WrapupCode body: WrapupCode (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_routing_wrapupcode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `put_routing_wrapupcode`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_routing_wrapupcode`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_user_routingskill(self, user_id, skill_id, body, **kwargs):
        """
        Update routing skill proficiency or state.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_routingskill(user_id, skill_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str skill_id: skillId (required)
        :param UserRoutingSkill body: Skill (required)
        :return: UserRoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'skill_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_routingskill" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_user_routingskill`")
        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `put_user_routingskill`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_user_routingskill`")


        resource_path = '/api/v2/users/{userId}/routingskills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_user_routingskills_bulk(self, user_id, body, **kwargs):
        """
        Replace all routing skills assigned to a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_routingskills_bulk(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param list[UserRoutingSkillPost] body: Skill (required)
        :return: UserSkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_routingskills_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_user_routingskills_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_user_routingskills_bulk`")


        resource_path = '/api/v2/users/{userId}/routingskills/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
