# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class RemoteModelSource(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, model_connection: str=None, model_path: str=None):  # noqa: E501
        """RemoteModelSource - a model defined in Swagger

        :param model_connection: The model_connection of this RemoteModelSource.  # noqa: E501
        :type model_connection: str
        :param model_path: The model_path of this RemoteModelSource.  # noqa: E501
        :type model_path: str
        """
        self.swagger_types = {
            'model_connection': str,
            'model_path': str
        }

        self.attribute_map = {
            'model_connection': 'modelConnection',
            'model_path': 'modelPath'
        }

        self._model_connection = model_connection
        self._model_path = model_path

    @classmethod
    def from_dict(cls, dikt) -> 'RemoteModelSource':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RemoteModelSource of this RemoteModelSource.  # noqa: E501
        :rtype: RemoteModelSource
        """
        return util.deserialize_model(dikt, cls)

    @property
    def model_connection(self) -> str:
        """Gets the model_connection of this RemoteModelSource.

        ModelConnection is name of connection to object storage bucket where ML model files are expected  # noqa: E501

        :return: The model_connection of this RemoteModelSource.
        :rtype: str
        """
        return self._model_connection

    @model_connection.setter
    def model_connection(self, model_connection: str):
        """Sets the model_connection of this RemoteModelSource.

        ModelConnection is name of connection to object storage bucket where ML model files are expected  # noqa: E501

        :param model_connection: The model_connection of this RemoteModelSource.
        :type model_connection: str
        """

        self._model_connection = model_connection

    @property
    def model_path(self) -> str:
        """Gets the model_path of this RemoteModelSource.

        ModelPath is a directory inside ModelConnection where ML model files are located  # noqa: E501

        :return: The model_path of this RemoteModelSource.
        :rtype: str
        """
        return self._model_path

    @model_path.setter
    def model_path(self, model_path: str):
        """Sets the model_path of this RemoteModelSource.

        ModelPath is a directory inside ModelConnection where ML model files are located  # noqa: E501

        :param model_path: The model_path of this RemoteModelSource.
        :type model_path: str
        """

        self._model_path = model_path
