# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.packaging_integration_spec import PackagingIntegrationSpec  # noqa: F401,E501
from odahuflow.sdk.models.packaging_integration_status import PackagingIntegrationStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class PackagingIntegration(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, created_at: str=None, id: str=None, spec: PackagingIntegrationSpec=None, status: PackagingIntegrationStatus=None, updated_at: str=None):  # noqa: E501
        """PackagingIntegration - a model defined in Swagger

        :param created_at: The created_at of this PackagingIntegration.  # noqa: E501
        :type created_at: str
        :param id: The id of this PackagingIntegration.  # noqa: E501
        :type id: str
        :param spec: The spec of this PackagingIntegration.  # noqa: E501
        :type spec: PackagingIntegrationSpec
        :param status: The status of this PackagingIntegration.  # noqa: E501
        :type status: PackagingIntegrationStatus
        :param updated_at: The updated_at of this PackagingIntegration.  # noqa: E501
        :type updated_at: str
        """
        self.swagger_types = {
            'created_at': str,
            'id': str,
            'spec': PackagingIntegrationSpec,
            'status': PackagingIntegrationStatus,
            'updated_at': str
        }

        self.attribute_map = {
            'created_at': 'createdAt',
            'id': 'id',
            'spec': 'spec',
            'status': 'status',
            'updated_at': 'updatedAt'
        }

        self._created_at = created_at
        self._id = id
        self._spec = spec
        self._status = status
        self._updated_at = updated_at

    @classmethod
    def from_dict(cls, dikt) -> 'PackagingIntegration':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PackagingIntegration of this PackagingIntegration.  # noqa: E501
        :rtype: PackagingIntegration
        """
        return util.deserialize_model(dikt, cls)

    @property
    def created_at(self) -> str:
        """Gets the created_at of this PackagingIntegration.

        CreatedAt  # noqa: E501

        :return: The created_at of this PackagingIntegration.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at: str):
        """Sets the created_at of this PackagingIntegration.

        CreatedAt  # noqa: E501

        :param created_at: The created_at of this PackagingIntegration.
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def id(self) -> str:
        """Gets the id of this PackagingIntegration.

        Packaging integration id  # noqa: E501

        :return: The id of this PackagingIntegration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this PackagingIntegration.

        Packaging integration id  # noqa: E501

        :param id: The id of this PackagingIntegration.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> PackagingIntegrationSpec:
        """Gets the spec of this PackagingIntegration.

        Packaging integration specification  # noqa: E501

        :return: The spec of this PackagingIntegration.
        :rtype: PackagingIntegrationSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: PackagingIntegrationSpec):
        """Sets the spec of this PackagingIntegration.

        Packaging integration specification  # noqa: E501

        :param spec: The spec of this PackagingIntegration.
        :type spec: PackagingIntegrationSpec
        """

        self._spec = spec

    @property
    def status(self) -> PackagingIntegrationStatus:
        """Gets the status of this PackagingIntegration.

        Packaging integration status  # noqa: E501

        :return: The status of this PackagingIntegration.
        :rtype: PackagingIntegrationStatus
        """
        return self._status

    @status.setter
    def status(self, status: PackagingIntegrationStatus):
        """Sets the status of this PackagingIntegration.

        Packaging integration status  # noqa: E501

        :param status: The status of this PackagingIntegration.
        :type status: PackagingIntegrationStatus
        """

        self._status = status

    @property
    def updated_at(self) -> str:
        """Gets the updated_at of this PackagingIntegration.

        UpdatedAt  # noqa: E501

        :return: The updated_at of this PackagingIntegration.
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at: str):
        """Sets the updated_at of this PackagingIntegration.

        UpdatedAt  # noqa: E501

        :param updated_at: The updated_at of this PackagingIntegration.
        :type updated_at: str
        """

        self._updated_at = updated_at
