# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ModelDeploymentStatus(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, available_replicas: int=None, deployment: str=None, host_header: str=None, last_updated_time: str=None, model_name: str=None, model_version: str=None, replicas: int=None, state: str=None):  # noqa: E501
        """ModelDeploymentStatus - a model defined in Swagger

        :param available_replicas: The available_replicas of this ModelDeploymentStatus.  # noqa: E501
        :type available_replicas: int
        :param deployment: The deployment of this ModelDeploymentStatus.  # noqa: E501
        :type deployment: str
        :param host_header: The host_header of this ModelDeploymentStatus.  # noqa: E501
        :type host_header: str
        :param last_updated_time: The last_updated_time of this ModelDeploymentStatus.  # noqa: E501
        :type last_updated_time: str
        :param model_name: The model_name of this ModelDeploymentStatus.  # noqa: E501
        :type model_name: str
        :param model_version: The model_version of this ModelDeploymentStatus.  # noqa: E501
        :type model_version: str
        :param replicas: The replicas of this ModelDeploymentStatus.  # noqa: E501
        :type replicas: int
        :param state: The state of this ModelDeploymentStatus.  # noqa: E501
        :type state: str
        """
        self.swagger_types = {
            'available_replicas': int,
            'deployment': str,
            'host_header': str,
            'last_updated_time': str,
            'model_name': str,
            'model_version': str,
            'replicas': int,
            'state': str
        }

        self.attribute_map = {
            'available_replicas': 'availableReplicas',
            'deployment': 'deployment',
            'host_header': 'hostHeader',
            'last_updated_time': 'lastUpdatedTime',
            'model_name': 'modelName',
            'model_version': 'modelVersion',
            'replicas': 'replicas',
            'state': 'state'
        }

        self._available_replicas = available_replicas
        self._deployment = deployment
        self._host_header = host_header
        self._last_updated_time = last_updated_time
        self._model_name = model_name
        self._model_version = model_version
        self._replicas = replicas
        self._state = state

    @classmethod
    def from_dict(cls, dikt) -> 'ModelDeploymentStatus':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelDeploymentStatus of this ModelDeploymentStatus.  # noqa: E501
        :rtype: ModelDeploymentStatus
        """
        return util.deserialize_model(dikt, cls)

    @property
    def available_replicas(self) -> int:
        """Gets the available_replicas of this ModelDeploymentStatus.

        Number of available pods  # noqa: E501

        :return: The available_replicas of this ModelDeploymentStatus.
        :rtype: int
        """
        return self._available_replicas

    @available_replicas.setter
    def available_replicas(self, available_replicas: int):
        """Sets the available_replicas of this ModelDeploymentStatus.

        Number of available pods  # noqa: E501

        :param available_replicas: The available_replicas of this ModelDeploymentStatus.
        :type available_replicas: int
        """

        self._available_replicas = available_replicas

    @property
    def deployment(self) -> str:
        """Gets the deployment of this ModelDeploymentStatus.

        The model k8s deployment name  # noqa: E501

        :return: The deployment of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._deployment

    @deployment.setter
    def deployment(self, deployment: str):
        """Sets the deployment of this ModelDeploymentStatus.

        The model k8s deployment name  # noqa: E501

        :param deployment: The deployment of this ModelDeploymentStatus.
        :type deployment: str
        """

        self._deployment = deployment

    @property
    def host_header(self) -> str:
        """Gets the host_header of this ModelDeploymentStatus.

        Host header value is a routing key for Istio Ingress to forward a request to appropriate Knative Service  # noqa: E501

        :return: The host_header of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._host_header

    @host_header.setter
    def host_header(self, host_header: str):
        """Sets the host_header of this ModelDeploymentStatus.

        Host header value is a routing key for Istio Ingress to forward a request to appropriate Knative Service  # noqa: E501

        :param host_header: The host_header of this ModelDeploymentStatus.
        :type host_header: str
        """

        self._host_header = host_header

    @property
    def last_updated_time(self) -> str:
        """Gets the last_updated_time of this ModelDeploymentStatus.

        Time when credentials was updated  # noqa: E501

        :return: The last_updated_time of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time: str):
        """Sets the last_updated_time of this ModelDeploymentStatus.

        Time when credentials was updated  # noqa: E501

        :param last_updated_time: The last_updated_time of this ModelDeploymentStatus.
        :type last_updated_time: str
        """

        self._last_updated_time = last_updated_time

    @property
    def model_name(self) -> str:
        """Gets the model_name of this ModelDeploymentStatus.

        Model name discovered in ModelDeployment  # noqa: E501

        :return: The model_name of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._model_name

    @model_name.setter
    def model_name(self, model_name: str):
        """Sets the model_name of this ModelDeploymentStatus.

        Model name discovered in ModelDeployment  # noqa: E501

        :param model_name: The model_name of this ModelDeploymentStatus.
        :type model_name: str
        """

        self._model_name = model_name

    @property
    def model_version(self) -> str:
        """Gets the model_version of this ModelDeploymentStatus.

        Model version discovered in ModelDeployment  # noqa: E501

        :return: The model_version of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version: str):
        """Sets the model_version of this ModelDeploymentStatus.

        Model version discovered in ModelDeployment  # noqa: E501

        :param model_version: The model_version of this ModelDeploymentStatus.
        :type model_version: str
        """

        self._model_version = model_version

    @property
    def replicas(self) -> int:
        """Gets the replicas of this ModelDeploymentStatus.

        Expected number of pods under current load  # noqa: E501

        :return: The replicas of this ModelDeploymentStatus.
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas: int):
        """Sets the replicas of this ModelDeploymentStatus.

        Expected number of pods under current load  # noqa: E501

        :param replicas: The replicas of this ModelDeploymentStatus.
        :type replicas: int
        """

        self._replicas = replicas

    @property
    def state(self) -> str:
        """Gets the state of this ModelDeploymentStatus.

        The state of a model    \"Processing\" - A model was not deployed. Because some parameters of the                  custom resource are wrong. For example, there is not a model                  image in a Docker registry.   \"Ready\" - A model was deployed successfully.  # noqa: E501

        :return: The state of this ModelDeploymentStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str):
        """Sets the state of this ModelDeploymentStatus.

        The state of a model    \"Processing\" - A model was not deployed. Because some parameters of the                  custom resource are wrong. For example, there is not a model                  image in a Docker registry.   \"Ready\" - A model was deployed successfully.  # noqa: E501

        :param state: The state of this ModelDeploymentStatus.
        :type state: str
        """

        self._state = state
