# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.connection_reference import ConnectionReference  # noqa: F401,E501
from odahuflow.sdk.models.inference_service_triggers import InferenceServiceTriggers  # noqa: F401,E501
from odahuflow.sdk.models.model_source import ModelSource  # noqa: F401,E501
from odahuflow.sdk.models.resource_requirements import ResourceRequirements  # noqa: F401,E501
from odahuflow.sdk.models import util


class InferenceServiceSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, args: List[str]=None, command: List[str]=None, data_source: ConnectionReference=None, image: str=None, model_registry: ModelSource=None, node_selector: Dict[str, str]=None, output_destination: ConnectionReference=None, resources: ResourceRequirements=None, triggers: InferenceServiceTriggers=None):  # noqa: E501
        """InferenceServiceSpec - a model defined in Swagger

        :param args: The args of this InferenceServiceSpec.  # noqa: E501
        :type args: List[str]
        :param command: The command of this InferenceServiceSpec.  # noqa: E501
        :type command: List[str]
        :param data_source: The data_source of this InferenceServiceSpec.  # noqa: E501
        :type data_source: ConnectionReference
        :param image: The image of this InferenceServiceSpec.  # noqa: E501
        :type image: str
        :param model_registry: The model_registry of this InferenceServiceSpec.  # noqa: E501
        :type model_registry: ModelSource
        :param node_selector: The node_selector of this InferenceServiceSpec.  # noqa: E501
        :type node_selector: Dict[str, str]
        :param output_destination: The output_destination of this InferenceServiceSpec.  # noqa: E501
        :type output_destination: ConnectionReference
        :param resources: The resources of this InferenceServiceSpec.  # noqa: E501
        :type resources: ResourceRequirements
        :param triggers: The triggers of this InferenceServiceSpec.  # noqa: E501
        :type triggers: InferenceServiceTriggers
        """
        self.swagger_types = {
            'args': List[str],
            'command': List[str],
            'data_source': ConnectionReference,
            'image': str,
            'model_registry': ModelSource,
            'node_selector': Dict[str, str],
            'output_destination': ConnectionReference,
            'resources': ResourceRequirements,
            'triggers': InferenceServiceTriggers
        }

        self.attribute_map = {
            'args': 'args',
            'command': 'command',
            'data_source': 'dataSource',
            'image': 'image',
            'model_registry': 'modelRegistry',
            'node_selector': 'nodeSelector',
            'output_destination': 'outputDestination',
            'resources': 'resources',
            'triggers': 'triggers'
        }

        self._args = args
        self._command = command
        self._data_source = data_source
        self._image = image
        self._model_registry = model_registry
        self._node_selector = node_selector
        self._output_destination = output_destination
        self._resources = resources
        self._triggers = triggers

    @classmethod
    def from_dict(cls, dikt) -> 'InferenceServiceSpec':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InferenceServiceSpec of this InferenceServiceSpec.  # noqa: E501
        :rtype: InferenceServiceSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def args(self) -> List[str]:
        """Gets the args of this InferenceServiceSpec.

        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell  # noqa: E501

        :return: The args of this InferenceServiceSpec.
        :rtype: List[str]
        """
        return self._args

    @args.setter
    def args(self, args: List[str]):
        """Sets the args of this InferenceServiceSpec.

        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell  # noqa: E501

        :param args: The args of this InferenceServiceSpec.
        :type args: List[str]
        """

        self._args = args

    @property
    def command(self) -> List[str]:
        """Gets the command of this InferenceServiceSpec.

        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell  # noqa: E501

        :return: The command of this InferenceServiceSpec.
        :rtype: List[str]
        """
        return self._command

    @command.setter
    def command(self, command: List[str]):
        """Sets the command of this InferenceServiceSpec.

        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell  # noqa: E501

        :param command: The command of this InferenceServiceSpec.
        :type command: List[str]
        """

        self._command = command

    @property
    def data_source(self) -> ConnectionReference:
        """Gets the data_source of this InferenceServiceSpec.

        DataSource defines location input data files. Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object) Can be overridden in BatchInferenceJob definition  # noqa: E501

        :return: The data_source of this InferenceServiceSpec.
        :rtype: ConnectionReference
        """
        return self._data_source

    @data_source.setter
    def data_source(self, data_source: ConnectionReference):
        """Sets the data_source of this InferenceServiceSpec.

        DataSource defines location input data files. Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object) Can be overridden in BatchInferenceJob definition  # noqa: E501

        :param data_source: The data_source of this InferenceServiceSpec.
        :type data_source: ConnectionReference
        """

        self._data_source = data_source

    @property
    def image(self) -> str:
        """Gets the image of this InferenceServiceSpec.

        Image is OCI image that contains user defined prediction code  # noqa: E501

        :return: The image of this InferenceServiceSpec.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image: str):
        """Sets the image of this InferenceServiceSpec.

        Image is OCI image that contains user defined prediction code  # noqa: E501

        :param image: The image of this InferenceServiceSpec.
        :type image: str
        """

        self._image = image

    @property
    def model_registry(self) -> ModelSource:
        """Gets the model_registry of this InferenceServiceSpec.

        ModelRegistry defines location of ML model files  # noqa: E501

        :return: The model_registry of this InferenceServiceSpec.
        :rtype: ModelSource
        """
        return self._model_registry

    @model_registry.setter
    def model_registry(self, model_registry: ModelSource):
        """Sets the model_registry of this InferenceServiceSpec.

        ModelRegistry defines location of ML model files  # noqa: E501

        :param model_registry: The model_registry of this InferenceServiceSpec.
        :type model_registry: ModelSource
        """

        self._model_registry = model_registry

    @property
    def node_selector(self) -> Dict[str, str]:
        """Gets the node_selector of this InferenceServiceSpec.

        Node selector for specifying a node pool  # noqa: E501

        :return: The node_selector of this InferenceServiceSpec.
        :rtype: Dict[str, str]
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector: Dict[str, str]):
        """Sets the node_selector of this InferenceServiceSpec.

        Node selector for specifying a node pool  # noqa: E501

        :param node_selector: The node_selector of this InferenceServiceSpec.
        :type node_selector: Dict[str, str]
        """

        self._node_selector = node_selector

    @property
    def output_destination(self) -> ConnectionReference:
        """Gets the output_destination of this InferenceServiceSpec.

        OutputDestination defines location of directory with output files. Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object) Can be overridden in BatchInferenceJob definition  # noqa: E501

        :return: The output_destination of this InferenceServiceSpec.
        :rtype: ConnectionReference
        """
        return self._output_destination

    @output_destination.setter
    def output_destination(self, output_destination: ConnectionReference):
        """Sets the output_destination of this InferenceServiceSpec.

        OutputDestination defines location of directory with output files. Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object) Can be overridden in BatchInferenceJob definition  # noqa: E501

        :param output_destination: The output_destination of this InferenceServiceSpec.
        :type output_destination: ConnectionReference
        """

        self._output_destination = output_destination

    @property
    def resources(self) -> ResourceRequirements:
        """Gets the resources of this InferenceServiceSpec.

        Resources for model container The same format like k8s uses for pod resources.  # noqa: E501

        :return: The resources of this InferenceServiceSpec.
        :rtype: ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources: ResourceRequirements):
        """Sets the resources of this InferenceServiceSpec.

        Resources for model container The same format like k8s uses for pod resources.  # noqa: E501

        :param resources: The resources of this InferenceServiceSpec.
        :type resources: ResourceRequirements
        """

        self._resources = resources

    @property
    def triggers(self) -> InferenceServiceTriggers:
        """Gets the triggers of this InferenceServiceSpec.

        Triggers are describe how to run InferenceService  # noqa: E501

        :return: The triggers of this InferenceServiceSpec.
        :rtype: InferenceServiceTriggers
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers: InferenceServiceTriggers):
        """Sets the triggers of this InferenceServiceSpec.

        Triggers are describe how to run InferenceService  # noqa: E501

        :param triggers: The triggers of this InferenceServiceSpec.
        :type triggers: InferenceServiceTriggers
        """

        self._triggers = triggers
