# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.connection_reference import ConnectionReference  # noqa: F401,E501
from odahuflow.sdk.models.resource_requirements import ResourceRequirements  # noqa: F401,E501
from odahuflow.sdk.models import util


class InferenceJobSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, data_source: ConnectionReference=None, inference_service_id: str=None, node_selector: Dict[str, str]=None, output_destination: ConnectionReference=None, request_id: str=None, resources: ResourceRequirements=None):  # noqa: E501
        """InferenceJobSpec - a model defined in Swagger

        :param data_source: The data_source of this InferenceJobSpec.  # noqa: E501
        :type data_source: ConnectionReference
        :param inference_service_id: The inference_service_id of this InferenceJobSpec.  # noqa: E501
        :type inference_service_id: str
        :param node_selector: The node_selector of this InferenceJobSpec.  # noqa: E501
        :type node_selector: Dict[str, str]
        :param output_destination: The output_destination of this InferenceJobSpec.  # noqa: E501
        :type output_destination: ConnectionReference
        :param request_id: The request_id of this InferenceJobSpec.  # noqa: E501
        :type request_id: str
        :param resources: The resources of this InferenceJobSpec.  # noqa: E501
        :type resources: ResourceRequirements
        """
        self.swagger_types = {
            'data_source': ConnectionReference,
            'inference_service_id': str,
            'node_selector': Dict[str, str],
            'output_destination': ConnectionReference,
            'request_id': str,
            'resources': ResourceRequirements
        }

        self.attribute_map = {
            'data_source': 'dataSource',
            'inference_service_id': 'inferenceServiceId',
            'node_selector': 'nodeSelector',
            'output_destination': 'outputDestination',
            'request_id': 'requestId',
            'resources': 'resources'
        }

        self._data_source = data_source
        self._inference_service_id = inference_service_id
        self._node_selector = node_selector
        self._output_destination = output_destination
        self._request_id = request_id
        self._resources = resources

    @classmethod
    def from_dict(cls, dikt) -> 'InferenceJobSpec':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InferenceJobSpec of this InferenceJobSpec.  # noqa: E501
        :rtype: InferenceJobSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def data_source(self) -> ConnectionReference:
        """Gets the data_source of this InferenceJobSpec.

        DataSource defines location input data files. Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object) If nil then will be filled from BatchInferenceService.  # noqa: E501

        :return: The data_source of this InferenceJobSpec.
        :rtype: ConnectionReference
        """
        return self._data_source

    @data_source.setter
    def data_source(self, data_source: ConnectionReference):
        """Sets the data_source of this InferenceJobSpec.

        DataSource defines location input data files. Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object) If nil then will be filled from BatchInferenceService.  # noqa: E501

        :param data_source: The data_source of this InferenceJobSpec.
        :type data_source: ConnectionReference
        """

        self._data_source = data_source

    @property
    def inference_service_id(self) -> str:
        """Gets the inference_service_id of this InferenceJobSpec.

        InferenceServiceID refers to BatchInferenceService  # noqa: E501

        :return: The inference_service_id of this InferenceJobSpec.
        :rtype: str
        """
        return self._inference_service_id

    @inference_service_id.setter
    def inference_service_id(self, inference_service_id: str):
        """Sets the inference_service_id of this InferenceJobSpec.

        InferenceServiceID refers to BatchInferenceService  # noqa: E501

        :param inference_service_id: The inference_service_id of this InferenceJobSpec.
        :type inference_service_id: str
        """

        self._inference_service_id = inference_service_id

    @property
    def node_selector(self) -> Dict[str, str]:
        """Gets the node_selector of this InferenceJobSpec.

        Node selector for specifying a node pool  # noqa: E501

        :return: The node_selector of this InferenceJobSpec.
        :rtype: Dict[str, str]
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector: Dict[str, str]):
        """Sets the node_selector of this InferenceJobSpec.

        Node selector for specifying a node pool  # noqa: E501

        :param node_selector: The node_selector of this InferenceJobSpec.
        :type node_selector: Dict[str, str]
        """

        self._node_selector = node_selector

    @property
    def output_destination(self) -> ConnectionReference:
        """Gets the output_destination of this InferenceJobSpec.

        OutputDestination defines location of directory with output files. Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object) If nil then will be filled from BatchInferenceService.  # noqa: E501

        :return: The output_destination of this InferenceJobSpec.
        :rtype: ConnectionReference
        """
        return self._output_destination

    @output_destination.setter
    def output_destination(self, output_destination: ConnectionReference):
        """Sets the output_destination of this InferenceJobSpec.

        OutputDestination defines location of directory with output files. Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object) If nil then will be filled from BatchInferenceService.  # noqa: E501

        :param output_destination: The output_destination of this InferenceJobSpec.
        :type output_destination: ConnectionReference
        """

        self._output_destination = output_destination

    @property
    def request_id(self) -> str:
        """Gets the request_id of this InferenceJobSpec.

        BatchRequestID is unique identifier for InferenceJob that helps to correlate between Model input, model output and feedback Take into account that it is not the same as kubeflow InferenceRequest id Each InferenceJob can process more than one InferenceRequest (delivered in separate input file) So each BatchRequestID has set of corresponding InferenceRequest and their IDs  # noqa: E501

        :return: The request_id of this InferenceJobSpec.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id: str):
        """Sets the request_id of this InferenceJobSpec.

        BatchRequestID is unique identifier for InferenceJob that helps to correlate between Model input, model output and feedback Take into account that it is not the same as kubeflow InferenceRequest id Each InferenceJob can process more than one InferenceRequest (delivered in separate input file) So each BatchRequestID has set of corresponding InferenceRequest and their IDs  # noqa: E501

        :param request_id: The request_id of this InferenceJobSpec.
        :type request_id: str
        """

        self._request_id = request_id

    @property
    def resources(self) -> ResourceRequirements:
        """Gets the resources of this InferenceJobSpec.

        Resources for model container The same format like k8s uses for pod resources.  # noqa: E501

        :return: The resources of this InferenceJobSpec.
        :rtype: ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources: ResourceRequirements):
        """Sets the resources of this InferenceJobSpec.

        Resources for model container The same format like k8s uses for pod resources.  # noqa: E501

        :param resources: The resources of this InferenceJobSpec.
        :type resources: ResourceRequirements
        """

        self._resources = resources
