# RDFS serializations in Turtle(.ttl) format

RDFS_serialization_2_4_15 = """
@prefix cim:    <http://iec.ch/TC57/2013/CIM-schema-cim16#> .
@prefix dl:     <http://entsoe.eu/CIM/DiagramLayout/3/1#> .
@prefix dy:     <http://entsoe.eu/CIM/Dynamics/3/1#> .
@prefix entsoe: <http://entsoe.eu/CIM/SchemaExtension/3/1#> .
@prefix eq:     <http://entsoe.eu/CIM/EquipmentCore/3/1#> .
@prefix eq_bd:  <http://entsoe.eu/CIM/EquipmentBoundary/3/1#> .
@prefix gl:     <http://entsoe.eu/CIM/GeographicalLocation/2/1#> .
@prefix owl:    <http://www.w3.org/2002/07/owl#> .
@prefix rdfs:   <http://www.w3.org/2000/01/rdf-schema#> .
@prefix ssh:    <http://entsoe.eu/CIM/SteadyStateHypothesis/1/1#> .
@prefix sv:     <http://entsoe.eu/CIM/StateVariables/4/1#> .
@prefix tp:     <http://entsoe.eu/CIM/Topology/4/1#> .
@prefix tp_bd:  <http://entsoe.eu/CIM/TopologyBoundary/3/1#> .

tp:RdfAbout  a       rdfs:Class;
        owl:members  cim:DCNode , cim:Terminal , cim:DCTerminal , cim:ConnectivityNode , cim:ACDCConverterDCTerminal .

ssh:RdfAbout  a      rdfs:Class;
        owl:members  cim:SolarGeneratingUnit , cim:RatioTapChanger , cim:PhaseTapChangerSymmetrical , cim:LinearShuntCompensator , cim:ConformLoad , cim:Disconnector , cim:Terminal , cim:ACDCConverterDCTerminal , cim:CsConverter , cim:PhaseTapChangerAsymmetrical , cim:ControlArea , cim:NonlinearShuntCompensator , cim:StaticVarCompensator , cim:PhaseTapChangerTabular , cim:AsynchronousMachine , cim:LoadBreakSwitch , cim:EquivalentInjection , cim:PhaseTapChangerLinear , cim:GroundDisconnector , cim:GeneratingUnit , cim:EnergyConsumer , cim:EnergySource , cim:Switch , cim:VsConverter , cim:SynchronousMachine , cim:RegulatingControl , cim:NonConformLoad , cim:DCTerminal , cim:HydroGeneratingUnit , cim:NuclearGeneratingUnit , cim:Breaker , cim:StationSupply , cim:TapChangerControl , cim:WindGeneratingUnit , cim:ThermalGeneratingUnit , cim:ExternalNetworkInjection .

dy:RdfAbout  a       rdfs:Class;
        owl:members  cim:EnergyConsumer .

tp_bd:RdfAbout  a    rdfs:Class;
        owl:members  cim:ConnectivityNode .

eq:RdfEnum  a        rdfs:Class;
        owl:members  cim:GeneratorControlSource.unavailable , cim:PhaseCode.s1N , cim:PhaseCode.s2N , cim:UnitSymbol.m2 , cim:Currency.AUD , cim:UnitMultiplier.k , entsoe:LimitTypeKind.tct , cim:WindingConnection.A , cim:PhaseCode.AC , cim:PhaseCode.BC , cim:FuelType.oilShale , cim:RegulatingControlModeKind.activePower , cim:UnitSymbol.deg , cim:GeneratorControlSource.plantControl , entsoe:LimitTypeKind.tc , cim:DCPolarityKind.positive , cim:SynchronousMachineKind.generatorOrMotor , cim:OperationalLimitDirectionKind.low , cim:PetersenCoilModeKind.fixed , cim:SynchronousMachineKind.condenser , cim:SynchronousMachineKind.generatorOrCondenserOrMotor , cim:PhaseCode.C , cim:Currency.INR , cim:UnitSymbol.N , cim:UnitSymbol.m , cim:PhaseCode.AN , cim:PhaseCode.CN , cim:PhaseCode.BN , cim:UnitMultiplier.d , cim:SVCControlMode.voltage , cim:ControlAreaTypeKind.Forecast , cim:WindingConnection.Y , cim:CurveStyle.straightLineYValues , cim:HydroEnergyConversionKind.pumpAndGenerator , cim:Currency.RUR , cim:WindGenUnitKind.offshore , cim:WindGenUnitKind.onshore , cim:PetersenCoilModeKind.automaticPositioning , cim:ShortCircuitRotorKind.salientPole2 , cim:UnitMultiplier.none , cim:UnitMultiplier.T , cim:WindingConnection.I , cim:ShortCircuitRotorKind.turboSeries2 , cim:WindingConnection.Z , cim:Currency.SEK , cim:PetersenCoilModeKind.manual , cim:FuelType.oil , cim:SynchronousMachineKind.generator , cim:UnitMultiplier.c , entsoe:LimitTypeKind.patl , cim:PhaseCode.ABCN , cim:UnitMultiplier.p , cim:UnitSymbol.H , cim:UnitSymbol.V , cim:GeneratorControlSource.offAGC , cim:UnitSymbol.m3 , cim:UnitMultiplier.M , cim:RegulatingControlModeKind.powerFactor , cim:UnitSymbol.none , cim:UnitSymbol.VAh , cim:DCPolarityKind.middle , cim:Currency.JPY , cim:ControlAreaTypeKind.AGC , cim:CurveStyle.constantYValue , cim:UnitSymbol.S , cim:OperationalLimitDirectionKind.high , cim:HydroPlantStorageKind.storage , cim:UnitSymbol.A , cim:UnitSymbol.VA , cim:TransformerControlMode.volt , cim:DCConverterOperatingModeKind.monopolarMetallicReturn , cim:HydroEnergyConversionKind.generator , cim:Source.SUBSTITUTED , entsoe:LimitTypeKind.tatl , cim:WindingConnection.Yn , cim:WindingConnection.Zn , cim:RegulatingControlModeKind.currentFlow , cim:HydroPlantStorageKind.runOfRiver , cim:UnitMultiplier.G , cim:Currency.CHF , cim:UnitSymbol.degC , cim:UnitSymbol.g , cim:DCPolarityKind.negative , cim:SVCControlMode.reactivePower , entsoe:LimitTypeKind.lowVoltage , cim:Currency.other , cim:UnitSymbol.W , cim:UnitSymbol.h , cim:OperationalLimitDirectionKind.absoluteValue , cim:PhaseCode.ABC , cim:UnitMultiplier.m , cim:PhaseCode.s1 , cim:TransformerControlMode.reactive , cim:PhaseCode.BCN , cim:Currency.CAD , cim:PhaseCode.s12 , cim:DCConverterOperatingModeKind.monopolarGroundReturn , cim:Currency.NOK , cim:Source.PROCESS , cim:HydroPlantStorageKind.pumpedStorage , cim:UnitSymbol.s , cim:UnitSymbol.Pa , cim:WindingConnection.D , cim:RegulatingControlModeKind.admittance , cim:UnitSymbol.VAr , cim:PhaseCode.ABN , cim:PhaseCode.ACN , cim:PhaseCode.AB , cim:Currency.DKK , cim:PhaseCode.s12N , cim:PhaseCode.A , cim:Validity.QUESTIONABLE , cim:UnitSymbol.ohm , cim:UnitSymbol.Hz , cim:PhaseCode.N , cim:FuelType.lignite , cim:UnitSymbol.min , cim:UnitSymbol.rad , cim:SynchronousMachineKind.generatorOrCondenser , entsoe:LimitTypeKind.highVoltage , cim:ControlAreaTypeKind.Interchange , cim:FuelType.hardCoal , cim:PhaseCode.B , cim:UnitSymbol.VArh , cim:GeneratorControlSource.onAGC , cim:Currency.CNY , cim:Validity.GOOD , cim:UnitSymbol.Wh , cim:Validity.INVALID , entsoe:LimitTypeKind.patlt , cim:FuelType.coal , cim:ShortCircuitRotorKind.salientPole1 , cim:RegulatingControlModeKind.voltage , cim:UnitSymbol.J , cim:Source.DEFAULTED , cim:ShortCircuitRotorKind.turboSeries1 , cim:Currency.EUR , cim:Currency.USD , cim:UnitMultiplier.n , cim:UnitSymbol.F , cim:PhaseCode.s2 , cim:RegulatingControlModeKind.temperature , cim:UnitMultiplier.micro , cim:SynchronousMachineKind.motorOrCondenser , cim:Currency.GBP , cim:RegulatingControlModeKind.timeScheduled , cim:SynchronousMachineKind.motor , cim:RegulatingControlModeKind.reactivePower , cim:FuelType.gas , cim:DCConverterOperatingModeKind.bipolar .

eq_bd:RdfEnum  a     rdfs:Class;
        owl:members  cim:UnitSymbol.VA , cim:UnitSymbol.S , cim:UnitSymbol.V , cim:UnitSymbol.A , cim:UnitSymbol.VAh , cim:UnitMultiplier.n , cim:UnitSymbol.h , cim:UnitMultiplier.G , cim:UnitSymbol.J , cim:UnitSymbol.deg , cim:UnitSymbol.Hz , cim:UnitSymbol.ohm , cim:UnitSymbol.min , cim:UnitMultiplier.k , cim:UnitSymbol.m2 , cim:UnitSymbol.none , cim:UnitSymbol.F , cim:UnitMultiplier.m , cim:UnitSymbol.degC , cim:UnitSymbol.s , cim:UnitSymbol.VArh , cim:UnitMultiplier.p , cim:UnitSymbol.g , cim:UnitMultiplier.d , cim:UnitSymbol.m , cim:UnitSymbol.H , cim:UnitSymbol.Pa , cim:UnitSymbol.W , cim:UnitMultiplier.c , cim:UnitSymbol.VAr , cim:UnitSymbol.rad , cim:UnitSymbol.m3 , cim:UnitMultiplier.none , cim:UnitSymbol.N , cim:UnitMultiplier.T , cim:UnitMultiplier.M , cim:UnitSymbol.Wh , cim:UnitMultiplier.micro .

dy:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.V , cim:DroopSignalFeedbackKind.governorOutput , cim:GenericNonLinearLoadModelKind.loadAdaptive , cim:UnitSymbol.min , cim:FrancisGovernorControlKind.mechanicHydrolicTachoAccelerator , cim:IfdBaseKind.iffl , cim:InputSignalKind.rotorAngularFrequencyDeviation , cim:UnitSymbol.m2 , cim:ExcST6BOELselectorKind.beforeUEL , cim:ExcST7BUELselectorKind.outputHVgate , cim:UnitSymbol.deg , cim:InputSignalKind.rotorSpeed , cim:SynchronousMachineModelKind.subtransientTypeF , cim:ExcREXSFeedbackSignalKind.fieldVoltage , cim:ExcREXSFeedbackSignalKind.fieldCurrent , cim:DroopSignalFeedbackKind.fuelValveStroke , cim:UnitMultiplier.m , cim:UnitSymbol.ohm , cim:StaticLoadModelKind.zIP2 , cim:StaticLoadModelKind.constantZ , cim:IfdBaseKind.ifag , cim:UnitSymbol.H , cim:ExcIEEEST1AUELselectorKind.inputHVgateErrorSignal , cim:InputSignalKind.fieldCurrent , cim:UnitSymbol.N , cim:RemoteSignalKind.remoteBusVoltageFrequencyDeviation , cim:GenericNonLinearLoadModelKind.exponentialRecovery , cim:RemoteSignalKind.remoteBusVoltage , cim:InputSignalKind.busFrequency , cim:WindQcontrolModesKind.openLoopReactivePower , cim:InputSignalKind.busFrequencyDeviation , cim:FrancisGovernorControlKind.mechanicHydraulicTransientFeedback , cim:SynchronousMachineModelKind.subtransientTypeJ , cim:UnitSymbol.VAh , cim:SynchronousMachineModelKind.subtransientSimplifiedDirectAxis , cim:WindQcontrolModesKind.powerFactor , cim:UnitSymbol.VArh , cim:WindLVRTQcontrolModesKind.mode3 , cim:WindLookupTableFunctionKind.fdpf , cim:ExcIEEEST1AUELselectorKind.inputAddedToErrorSignal , cim:UnitMultiplier.none , cim:StaticLoadModelKind.zIP1 , cim:UnitMultiplier.p , cim:UnitSymbol.Pa , cim:IfdBaseKind.other , cim:ExcST6BOELselectorKind.afterUEL , cim:UnitSymbol.rad , cim:ExcST7BOELselectorKind.noOELinput , cim:ExcST7BOELselectorKind.outputLVgate , cim:WindQcontrolModesKind.reactivePower , cim:WindLookupTableFunctionKind.fpslip , cim:WindLookupTableFunctionKind.iqvdl , cim:UnitSymbol.h , cim:UnitSymbol.VAr , cim:RemoteSignalKind.remoteBranchCurrentAmplitude , cim:RotorKind.salientPole , cim:RemoteSignalKind.remotePuBusVoltageDerivative , cim:UnitSymbol.S , cim:ExcST7BUELselectorKind.noUELinput , cim:RemoteSignalKind.remoteBusVoltageAmplitude , cim:ExcST7BUELselectorKind.addVref , cim:InputSignalKind.generatorElectricalPower , cim:InputSignalKind.generatorAcceleratingPower , cim:UnitMultiplier.k , cim:ExcST6BOELselectorKind.noOELinput , cim:SynchronousMachineModelKind.subtransientSimplified , cim:InputSignalKind.busVoltage , cim:UnitSymbol.m3 , cim:IfdBaseKind.ifnl , cim:ExcIEEEST1AUELselectorKind.ignoreUELsignal , cim:WindLVRTQcontrolModesKind.mode2 , cim:UnitSymbol.g , cim:ExcST7BUELselectorKind.inputHVgate , cim:UnitMultiplier.d , cim:UnitSymbol.F , cim:UnitSymbol.Hz , cim:ExcST7BOELselectorKind.addVref , cim:UnitSymbol.none , cim:UnitMultiplier.T , cim:InputSignalKind.busVoltageDerivative , cim:RemoteSignalKind.remoteBusVoltageFrequency , cim:UnitSymbol.W , cim:RemoteSignalKind.remoteBusFrequency , cim:WindLookupTableFunctionKind.fpomega , cim:UnitSymbol.A , cim:UnitSymbol.VA , cim:FrancisGovernorControlKind.electromechanicalElectrohydraulic , cim:ExcST7BOELselectorKind.inputLVgate , cim:UnitSymbol.s , cim:InputSignalKind.branchCurrent , cim:WindLookupTableFunctionKind.ipvdl , cim:UnitSymbol.degC , cim:RemoteSignalKind.remoteBusFrequencyDeviation , cim:DroopSignalFeedbackKind.electricalPower , cim:UnitMultiplier.n , cim:DroopSignalFeedbackKind.none , cim:UnitSymbol.Wh , cim:RemoteSignalKind.remoteBusVoltageAmplitudeDerivative , cim:UnitMultiplier.M , cim:UnitMultiplier.G , cim:WindLVRTQcontrolModesKind.mode1 , cim:RotorKind.roundRotor , cim:StaticLoadModelKind.exponential , cim:ExcIEEEST1AUELselectorKind.inputHVgateVoltageOutput , cim:UnitMultiplier.c , cim:SynchronousMachineModelKind.subtransient , cim:UnitMultiplier.micro , cim:WindQcontrolModesKind.voltage , cim:UnitSymbol.m , cim:ExcREXSFeedbackSignalKind.outputVoltage , cim:UnitSymbol.J .

dl:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitMultiplier.T , cim:UnitSymbol.s , cim:UnitSymbol.none , cim:UnitSymbol.H , cim:UnitSymbol.ohm , cim:UnitMultiplier.k , cim:UnitSymbol.N , cim:UnitSymbol.VAr , cim:OrientationKind.negative , cim:UnitSymbol.Pa , cim:UnitSymbol.VAh , cim:UnitSymbol.VArh , cim:UnitSymbol.VA , cim:UnitMultiplier.p , cim:UnitSymbol.degC , cim:UnitSymbol.min , cim:UnitSymbol.S , cim:UnitSymbol.m3 , cim:UnitSymbol.Hz , cim:UnitSymbol.J , cim:UnitSymbol.V , cim:UnitMultiplier.m , cim:UnitMultiplier.G , cim:UnitSymbol.m , cim:UnitMultiplier.c , cim:UnitSymbol.F , cim:UnitSymbol.h , cim:UnitSymbol.g , cim:UnitSymbol.A , cim:UnitMultiplier.micro , cim:UnitSymbol.m2 , cim:UnitMultiplier.d , cim:UnitMultiplier.none , cim:UnitSymbol.rad , cim:UnitSymbol.W , cim:UnitMultiplier.M , cim:UnitSymbol.deg , cim:UnitSymbol.Wh , cim:UnitMultiplier.n .

ssh:RdfEnum  a       rdfs:Class;
        owl:members  cim:UnitSymbol.A , cim:UnitSymbol.none , cim:UnitMultiplier.G , cim:VsPpccControlKind.udc , cim:UnitSymbol.min , cim:UnitMultiplier.m , cim:VsPpccControlKind.pPccAndUdcDroop , cim:UnitSymbol.m , cim:UnitMultiplier.micro , cim:UnitMultiplier.T , cim:UnitSymbol.Hz , cim:UnitSymbol.J , cim:UnitSymbol.h , cim:UnitSymbol.F , cim:UnitSymbol.VA , cim:UnitSymbol.VAr , cim:UnitSymbol.m3 , cim:UnitSymbol.W , cim:CsPpccControlKind.activePower , cim:SynchronousMachineOperatingMode.condenser , cim:UnitMultiplier.M , cim:UnitSymbol.m2 , cim:UnitSymbol.H , cim:VsQpccControlKind.powerFactorPcc , cim:CsPpccControlKind.dcCurrent , cim:CsPpccControlKind.dcVoltage , cim:UnitMultiplier.c , cim:UnitSymbol.ohm , cim:AsynchronousMachineKind.generator , cim:UnitMultiplier.k , cim:VsQpccControlKind.voltagePcc , cim:UnitSymbol.Pa , cim:UnitSymbol.s , cim:UnitMultiplier.d , cim:CsOperatingModeKind.inverter , cim:VsPpccControlKind.pPccAndUdcDroopWithCompensation , cim:UnitSymbol.V , cim:UnitSymbol.rad , cim:UnitSymbol.VAh , cim:UnitMultiplier.none , cim:VsPpccControlKind.pPcc , cim:VsPpccControlKind.pPccAndUdcDroopPilot , cim:UnitSymbol.S , cim:UnitSymbol.degC , cim:UnitSymbol.Wh , cim:UnitSymbol.g , cim:UnitSymbol.deg , cim:UnitMultiplier.n , cim:CsOperatingModeKind.rectifier , cim:SynchronousMachineOperatingMode.motor , cim:UnitSymbol.N , cim:UnitSymbol.VArh , cim:AsynchronousMachineKind.motor , cim:UnitMultiplier.p , cim:VsQpccControlKind.reactivePcc , cim:SynchronousMachineOperatingMode.generator .

sv:RdfAbout  a       rdfs:Class;
        owl:members  cim:CsConverter , cim:VsConverter .

sv:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.ohm , cim:UnitSymbol.s , cim:UnitSymbol.m2 , cim:UnitMultiplier.none , cim:UnitSymbol.A , cim:UnitSymbol.h , cim:UnitSymbol.deg , cim:UnitSymbol.min , cim:UnitMultiplier.M , cim:UnitSymbol.S , cim:UnitSymbol.V , cim:UnitSymbol.Pa , cim:UnitSymbol.VAh , cim:UnitMultiplier.micro , cim:UnitMultiplier.G , cim:UnitSymbol.Wh , cim:UnitSymbol.H , cim:UnitSymbol.rad , cim:UnitSymbol.degC , cim:UnitSymbol.Hz , cim:UnitSymbol.none , cim:UnitSymbol.F , cim:UnitSymbol.m3 , cim:UnitMultiplier.c , cim:UnitMultiplier.p , cim:UnitSymbol.N , cim:UnitMultiplier.n , cim:UnitMultiplier.T , cim:UnitMultiplier.d , cim:UnitSymbol.m , cim:UnitSymbol.VAr , cim:UnitMultiplier.k , cim:UnitSymbol.VA , cim:UnitSymbol.VArh , cim:UnitSymbol.W , cim:UnitSymbol.J , cim:UnitSymbol.g , cim:UnitMultiplier.m .

"""

RDFS_serialization_3_0_0 = """
@prefix cim:  <http://iec.ch/TC57/CIM100#> .
@prefix dl:   <http://iec.ch/TC57/ns/CIM/DiagramLayout-EU/3.0#> .
@prefix dy:   <http://iec.ch/TC57/ns/CIM/Dynamics-EU/1.0#> .
@prefix eq:   <http://iec.ch/TC57/ns/CIM/CoreEquipment-EU/3.0#> .
@prefix eqbd: <http://iec.ch/TC57/ns/CIM/EquipmentBoundary-EU/3.0#> .
@prefix gl:   <http://iec.ch/TC57/ns/CIM/GeographicalLocation-EU/3.0#> .
@prefix op:   <http://iec.ch/TC57/ns/CIM/Operation-EU/3.0#> .
@prefix owl:  <http://www.w3.org/2002/07/owl#> .
@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
@prefix sc:   <http://iec.ch/TC57/ns/CIM/ShortCircuit-EU/3.0#> .
@prefix ssh:  <http://iec.ch/TC57/ns/CIM/SteadyStateHypothesis-EU/3.0#> .
@prefix sv:   <http://iec.ch/TC57/ns/CIM/StateVariables-EU/3.0#> .
@prefix tp:   <http://iec.ch/TC57/ns/CIM/Topology-EU/3.0#> .

sv:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.lPerh , cim:UnitSymbol.VArh , cim:UnitSymbol.molPerkg , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.onePerHz , cim:UnitMultiplier.P , cim:UnitSymbol.VPerV , cim:UnitSymbol.A , cim:UnitMultiplier.T , cim:UnitSymbol.m2 , cim:UnitSymbol.JPerK , cim:UnitMultiplier.d , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.degC , cim:UnitSymbol.charPers , cim:UnitSymbol.sPers , cim:UnitSymbol.S , cim:UnitSymbol.KPers , cim:UnitSymbol.PaPers , cim:UnitMultiplier.f , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.CPerkg , cim:UnitSymbol.mol , cim:UnitMultiplier.m , cim:UnitSymbol.gPerg , cim:UnitSymbol.VPerVA , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.N , cim:UnitSymbol.Oe , cim:UnitSymbol.Mx , cim:UnitSymbol.H , cim:UnitSymbol.Ah , cim:UnitSymbol.kg , cim:UnitSymbol.Vh , cim:UnitSymbol.VAh , cim:UnitSymbol.mmHg , cim:UnitSymbol.l , cim:UnitSymbol.K , cim:UnitSymbol.APerA , cim:UnitSymbol.A2 , cim:UnitSymbol.A2h , cim:UnitSymbol.m2Pers , cim:UnitSymbol.s , cim:UnitMultiplier.h , cim:UnitSymbol.kgPerJ , cim:UnitSymbol.F , cim:UnitSymbol.Gy , cim:UnitMultiplier.Y , cim:UnitSymbol.WPermK , cim:UnitSymbol.JPers , cim:UnitSymbol.dB , cim:UnitSymbol.rotPers , cim:UnitSymbol.mPers , cim:UnitSymbol.Wh , cim:UnitMultiplier.k , cim:UnitSymbol.cosPhi , cim:UnitSymbol.ha , cim:UnitSymbol.V2 , cim:UnitSymbol.none , cim:UnitSymbol.ppm , cim:UnitSymbol.onePerm , cim:UnitSymbol.As , cim:UnitSymbol.JPerm3 , cim:UnitMultiplier.none , cim:UnitSymbol.M , cim:UnitSymbol.radPers , cim:UnitSymbol.cd , cim:UnitSymbol.HzPers , cim:UnitMultiplier.n , cim:UnitSymbol.m3Perkg , cim:UnitSymbol.kgPerm3 , cim:UnitMultiplier.micro , cim:UnitSymbol.V , cim:UnitSymbol.tonne , cim:UnitMultiplier.c , cim:UnitSymbol.FPerm , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.GyPers , cim:UnitSymbol.HPerm , cim:UnitSymbol.kgm2 , cim:UnitSymbol.Vs , cim:UnitSymbol.bar , cim:UnitMultiplier.G , cim:UnitSymbol.mPers2 , cim:UnitSymbol.Wb , cim:UnitSymbol.Sv , cim:UnitSymbol.molPermol , cim:UnitSymbol.h , cim:UnitSymbol.Nm , cim:UnitSymbol.SPerm , cim:UnitSymbol.ohmm , cim:UnitSymbol.min , cim:UnitSymbol.G , cim:UnitSymbol.anglemin , cim:UnitMultiplier.Z , cim:UnitSymbol.kgm , cim:UnitSymbol.WPerA , cim:UnitMultiplier.p , cim:UnitSymbol.Qh , cim:UnitSymbol.VPerm , cim:UnitSymbol.dBm , cim:UnitMultiplier.a , cim:UnitSymbol.lPers , cim:UnitSymbol.Q , cim:UnitSymbol.WPerW , cim:UnitSymbol.deg , cim:UnitSymbol.character , cim:UnitMultiplier.E , cim:UnitSymbol.lPerl , cim:UnitSymbol.m3 , cim:UnitSymbol.rad , cim:UnitSymbol.Hz , cim:UnitSymbol.kat , cim:UnitMultiplier.y , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.T , cim:UnitSymbol.Pa , cim:UnitSymbol.ohmPerm , cim:UnitSymbol.lx , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.count , cim:UnitSymbol.V2h , cim:UnitSymbol.JPerkg , cim:UnitSymbol.W , cim:UnitSymbol.ohm , cim:UnitSymbol.WPersr , cim:UnitSymbol.m , cim:UnitSymbol.lm , cim:UnitSymbol.JPermol , cim:UnitSymbol.JPermolK , cim:UnitSymbol.ft3 , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.gal , cim:UnitSymbol.therm , cim:UnitSymbol.VPerHz , cim:UnitSymbol.Bq , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.m3Pers , cim:UnitSymbol.katPerm3 , cim:UnitSymbol.anglesec , cim:UnitSymbol.sr , cim:UnitSymbol.d , cim:UnitSymbol.A2s , cim:UnitSymbol.kn , cim:UnitSymbol.radPers2 , cim:UnitSymbol.WPers , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.C , cim:UnitMultiplier.da , cim:UnitSymbol.m3Perh , cim:UnitSymbol.VAr , cim:UnitSymbol.NPerm , cim:UnitSymbol.Btu , cim:UnitSymbol.APerm , cim:UnitSymbol.J , cim:UnitSymbol.rev , cim:UnitMultiplier.z , cim:UnitMultiplier.M , cim:UnitSymbol.VA , cim:UnitSymbol.Pas .

eq:RdfEnum  a        rdfs:Class;
        owl:members  cim:Currency.PKR , cim:Currency.UYU , cim:Currency.THB , cim:Currency.LSL , cim:UnitSymbol.lPers , cim:UnitSymbol.lm , cim:Currency.HKD , cim:UnitMultiplier.y , cim:Currency.HTG , cim:UnitSymbol.m3Pers , cim:UnitSymbol.ppm , cim:Currency.TND , cim:UnitSymbol.onePerm , cim:UnitSymbol.V2 , cim:UnitMultiplier.p , <http://iec.ch/TC57/CIM100-European#LimitKind.alarmVoltage> , cim:SynchronousMachineKind.condenser , cim:UnitSymbol.Btu , cim:UnitSymbol.kgPerJ , cim:WindingConnection.Yn , cim:UnitSymbol.JPerm3 , cim:Currency.KES , cim:Currency.KWD , cim:Currency.SAR , cim:UnitSymbol.degC , cim:Currency.AED , cim:UnitSymbol.m3Perkg , cim:Currency.MUR , cim:Currency.FKP , cim:UnitSymbol.JPermolK , cim:Currency.ANG , cim:UnitSymbol.m2 , cim:Currency.BOV , cim:UnitMultiplier.k , cim:Currency.SGD , cim:UnitSymbol.kg , cim:Currency.BZD , cim:Currency.LVL , cim:GeneratorControlSource.onAGC , cim:Currency.MRO , cim:PhaseCode.CN , <http://iec.ch/TC57/CIM100-European#LimitKind.operationalVoltageLimit> , cim:UnitSymbol.sr , cim:PhaseCode.s12N , cim:UnitSymbol.VA , cim:Currency.TJS , cim:UnitSymbol.Qh , cim:Currency.SEK , cim:Currency.JMD , cim:UnitSymbol.WPerW , cim:Currency.NGN , cim:HydroPlantStorageKind.pumpedStorage , cim:WindGenUnitKind.offshore , cim:UnitSymbol.radPers , cim:HydroEnergyConversionKind.generator , cim:WindingConnection.D , cim:UnitSymbol.gPerg , cim:UnitSymbol.F , cim:UnitSymbol.A2s , cim:ControlAreaTypeKind.Forecast , cim:HydroEnergyConversionKind.pumpAndGenerator , cim:Currency.NPR , cim:RegulatingControlModeKind.voltage , cim:UnitMultiplier.z , cim:Currency.BAM , cim:UnitSymbol.PaPers , cim:PhaseCode.ACN , cim:Currency.CHF , cim:Currency.CNY , cim:RegulatingControlModeKind.temperature , cim:UnitSymbol.character , cim:DCPolarityKind.positive , cim:Currency.AFN , cim:Currency.BRL , cim:FuelType.brownCoalLignite , cim:PhaseCode.BN , cim:Currency.AMD , cim:Currency.IRR , cim:Currency.GMD , cim:Currency.CZK , cim:OperationalLimitDirectionKind.absoluteValue , cim:UnitSymbol.Vs , cim:UnitSymbol.CPerm3 , cim:Currency.SDG , cim:UnitSymbol.Bq , cim:Currency.UAH , cim:Currency.PAB , cim:UnitSymbol.gal , cim:UnitSymbol.Gy , cim:WindingConnection.Y , cim:UnitSymbol.anglesec , cim:PhaseCode.C , cim:SynchronousMachineKind.generatorOrCondenserOrMotor , cim:Currency.ISK , cim:UnitSymbol.m2Pers , cim:Currency.VEF , cim:UnitSymbol.ohm , cim:Currency.MDL , <http://iec.ch/TC57/CIM100-European#LimitKind.highVoltage> , cim:Currency.RON , cim:PhaseCode.AN , cim:RegulatingControlModeKind.activePower , cim:Currency.INR , cim:UnitSymbol.VPerV , cim:UnitSymbol.HzPers , cim:Currency.GEL , cim:Currency.SLL , cim:UnitSymbol.mPers2 , cim:UnitSymbol.NPerm , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.d , cim:UnitSymbol.ha , cim:FuelType.peat , cim:PhaseCode.BC , cim:Currency.XCD , cim:UnitSymbol.therm , cim:UnitSymbol.JPerkg , cim:PhaseCode.s2 , cim:Currency.DOP , cim:Currency.KZT , cim:Currency.HNL , cim:UnitSymbol.VPerVA , cim:Currency.BDT , cim:UnitSymbol.WPermK , cim:UnitSymbol.kgPerm3 , cim:DCConverterOperatingModeKind.monopolarGroundReturn , cim:PhaseCode.X , cim:Currency.TRY , cim:UnitSymbol.J , cim:RegulatingControlModeKind.admittance , cim:Currency.BGN , cim:UnitSymbol.dBm , cim:Currency.VUV , cim:FuelType.oilShale , cim:UnitMultiplier.Y , cim:UnitSymbol.molPerm3 , cim:Currency.AOA , cim:Currency.MAD , cim:Currency.XPF , cim:Currency.EUR , cim:HydroTurbineKind.kaplan , cim:UnitMultiplier.micro , cim:HydroPlantStorageKind.runOfRiver , cim:UnitSymbol.count , cim:PhaseCode.s12 , cim:Currency.MVR , cim:UnitMultiplier.P , cim:Currency.CLP , cim:DCPolarityKind.middle , cim:Currency.TZS , cim:PhaseCode.none , cim:Currency.DZD , cim:UnitSymbol.s , cim:PhaseCode.ABN , cim:RegulatingControlModeKind.currentFlow , cim:Currency.QAR , cim:Currency.GIP , cim:Currency.ARS , cim:PhaseCode.AC , <http://iec.ch/TC57/CIM100-European#LimitKind.patlt> , cim:WindingConnection.I , cim:Currency.UZS , cim:Currency.BHD , cim:SynchronousMachineKind.motor , cim:PhaseCode.B , cim:FuelType.oil , cim:UnitSymbol.WPers , cim:Currency.SHP , <http://iec.ch/TC57/CIM100-European#LimitKind.lowVoltage> , cim:Currency.MWK , cim:Currency.MGA , cim:UnitMultiplier.h , cim:UnitSymbol.JPerkgK , <http://iec.ch/TC57/CIM100-European#LimitKind.patl> , cim:Currency.KMF , cim:UnitSymbol.mPers , cim:UnitSymbol.kgm , cim:Currency.MYR , cim:DCConverterOperatingModeKind.bipolar , cim:PhaseCode.XY , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.m3Perh , cim:Currency.TTD , cim:UnitSymbol.VArh , cim:Currency.DKK , cim:Currency.CUC , cim:FuelType.gas , cim:UnitSymbol.T , cim:HydroTurbineKind.francis , cim:Currency.NOK , cim:HydroTurbineKind.pelton , cim:PhaseCode.s1 , cim:UnitSymbol.K , cim:Currency.BTN , cim:UnitSymbol.h , cim:UnitMultiplier.Z , cim:Currency.PLN , cim:Currency.AWG , cim:Currency.BYR , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.Mx , cim:HydroPlantStorageKind.storage , cim:UnitSymbol.lPerh , cim:UnitSymbol.rev , cim:UnitMultiplier.n , cim:FuelType.lignite , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.Wb , cim:UnitSymbol.JPermol , cim:UnitSymbol.Wh , cim:Currency.PEN , cim:Currency.ERN , cim:Currency.MMK , cim:SynchronousMachineKind.generatorOrCondenser , cim:UnitSymbol.kn , cim:Currency.HUF , cim:Currency.XOF , cim:UnitSymbol.rad , cim:UnitSymbol.charPers , cim:Currency.ZWL , cim:Currency.LAK , cim:ControlAreaTypeKind.Interchange , cim:UnitSymbol.none , cim:Currency.USD , cim:FuelType.other , cim:Currency.SYP , cim:Currency.GTQ , cim:Currency.DJF , cim:Currency.PYG , cim:UnitSymbol.HPerm , cim:Currency.LYD , cim:Currency.ILS , cim:UnitSymbol.molPerkg , cim:UnitSymbol.cd , cim:UnitSymbol.GyPers , cim:WindGenUnitKind.onshore , cim:Currency.ALL , cim:UnitSymbol.V2h , cim:UnitSymbol.Vh , cim:Currency.MOP , cim:PhaseCode.AB , cim:UnitSymbol.JPerK , cim:PhaseCode.A , cim:UnitSymbol.A2h , cim:Currency.AZN , cim:UnitSymbol.SPerm , cim:Currency.IQD , cim:Currency.ZAR , cim:UnitSymbol.KPers , cim:CurveStyle.straightLineYValues , cim:UnitSymbol.APerm , cim:UnitSymbol.lx , cim:Currency.COP , cim:UnitMultiplier.m , cim:UnitMultiplier.none , <http://iec.ch/TC57/CIM100-European#LimitKind.tc> , cim:Currency.RWF , cim:SVCControlMode.voltage , cim:UnitSymbol.molPermol , cim:UnitSymbol.cosPhi , cim:UnitSymbol.CPerkg , cim:UnitMultiplier.d , cim:Currency.XAF , cim:Currency.GNF , cim:Currency.HRK , cim:UnitMultiplier.da , cim:UnitSymbol.APerA , cim:UnitSymbol.S , cim:Currency.PGK , cim:FuelType.hardCoal , cim:UnitSymbol.Pas , cim:UnitSymbol.m3Compensated , cim:Currency.IDR , cim:Currency.KPW , cim:Currency.KHR , cim:Currency.CDF , cim:UnitSymbol.A2 , cim:Currency.SZL , cim:Currency.ETB , cim:Currency.SBD , cim:UnitSymbol.ohmm , cim:Currency.TOP , cim:FuelType.coalDerivedGas , cim:Currency.UGX , cim:UnitSymbol.m , cim:Currency.GBP , cim:Currency.EEK , cim:UnitSymbol.Oe , cim:Currency.RSD , cim:Currency.PHP , cim:Currency.SOS , cim:Currency.WST , cim:SynchronousMachineKind.motorOrCondenser , <http://iec.ch/TC57/CIM100-European#LimitKind.warningVoltage> , cim:UnitSymbol.WPersr , cim:Currency.MXN , cim:SynchronousMachineKind.generator , cim:Currency.MKD , cim:UnitSymbol.VPerVAr , cim:FuelType.coal , cim:Currency.NIO , cim:GeneratorControlSource.plantControl , cim:Currency.BBD , cim:WindingConnection.A , cim:UnitMultiplier.E , cim:UnitSymbol.VAr , <http://iec.ch/TC57/CIM100-European#LimitKind.tct> , cim:PhaseCode.ABC , cim:UnitSymbol.Q , cim:RegulatingControlModeKind.reactivePower , cim:Currency.STD , cim:Currency.BWP , cim:Currency.KRW , <http://iec.ch/TC57/CIM100-European#LimitKind.stability> , cim:UnitSymbol.Pa , cim:UnitSymbol.kgm2 , cim:UnitSymbol.H , cim:OperationalLimitDirectionKind.low , cim:Currency.BND , cim:PhaseCode.N , cim:Currency.EGP , cim:PhaseCode.s2N , cim:Currency.BOB , cim:UnitSymbol.N , cim:UnitSymbol.Nm , cim:UnitSymbol.anglemin , cim:PhaseCode.ABCN , cim:OperationalLimitDirectionKind.high , cim:Currency.CLF , cim:Currency.MZN , cim:UnitSymbol.katPerm3 , cim:UnitMultiplier.T , cim:Currency.NZD , cim:UnitSymbol.kat , cim:PhaseCode.XN , cim:UnitSymbol.C , cim:Currency.OMR , cim:UnitSymbol.min , cim:Currency.LRD , cim:UnitSymbol.deg , cim:RegulatingControlModeKind.powerFactor , cim:Currency.VND , cim:PhaseCode.BCN , cim:UnitSymbol.JPers , cim:UnitSymbol.W , cim:RegulatingControlModeKind.timeScheduled , cim:Currency.CAD , cim:UnitSymbol.As , cim:UnitSymbol.mmHg , cim:Currency.BIF , cim:UnitSymbol.VPerHz , cim:UnitMultiplier.f , cim:Currency.MNT , cim:GeneratorControlSource.unavailable , cim:UnitSymbol.sPers , cim:Currency.BMD , cim:UnitSymbol.m3 , cim:Currency.GHS , cim:UnitSymbol.ohmPerm , cim:PhaseCode.s1N , cim:Currency.CRC , cim:Currency.COU , cim:GeneratorControlSource.offAGC , cim:UnitSymbol.onePerHz , cim:UnitSymbol.mPerm3 , cim:Currency.FJD , cim:UnitMultiplier.c , cim:UnitSymbol.Ah , cim:UnitSymbol.dB , cim:UnitSymbol.Sv , cim:Currency.BSD , cim:CurveStyle.constantYValue , cim:Currency.KGS , cim:Currency.KYD , cim:Currency.SCR , cim:UnitSymbol.A , cim:Currency.ZMK , cim:UnitSymbol.radPers2 , cim:UnitSymbol.VPerm , cim:UnitSymbol.Hz , cim:UnitSymbol.VAh , cim:Currency.RUB , cim:ControlAreaTypeKind.AGC , cim:UnitSymbol.l , cim:Currency.SRD , cim:UnitSymbol.m3Uncompensated , cim:UnitMultiplier.G , cim:Currency.LTL , cim:Currency.GYD , cim:UnitSymbol.ft3 , <http://iec.ch/TC57/CIM100-European#LimitKind.tatl> , cim:UnitSymbol.lPerl , cim:UnitMultiplier.M , cim:Currency.CUP , cim:PhaseCode.XYN , cim:Currency.JOD , cim:UnitSymbol.tonne , cim:DCConverterOperatingModeKind.monopolarMetallicReturn , cim:Currency.TMT , cim:SynchronousMachineKind.generatorOrMotor , cim:UnitSymbol.FPerm , cim:Currency.LBP , cim:UnitMultiplier.a , cim:UnitSymbol.HzPerHz , cim:WindingConnection.Zn , cim:UnitSymbol.WPerA , cim:Currency.CVE , cim:SVCControlMode.reactivePower , cim:Currency.AUD , cim:Currency.YER , cim:UnitSymbol.mol , cim:UnitSymbol.rotPers , cim:Currency.LKR , cim:DCPolarityKind.negative , cim:UnitSymbol.V , cim:UnitSymbol.G , cim:Currency.JPY , cim:Currency.TWD , cim:WindingConnection.Z , cim:UnitSymbol.bar , cim:Currency.NAD , cim:UnitSymbol.M .

sc:RdfAbout  a       rdfs:Class;
        owl:members  cim:PetersenCoil , cim:EnergySource , cim:PowerTransformer , cim:ExternalNetworkInjection , cim:ACLineSegment , cim:LinearShuntCompensator , cim:EquivalentBranch , cim:GroundingImpedance , cim:SeriesCompensator , cim:EquivalentInjection , cim:AsynchronousMachine , cim:PowerTransformerEnd , cim:SynchronousMachine , cim:NonlinearShuntCompensatorPoint , cim:BusbarSection .

dl:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.K , cim:UnitSymbol.C , cim:UnitSymbol.kgPerJ , cim:UnitSymbol.dB , cim:UnitSymbol.WPerW , cim:UnitSymbol.V2h , cim:UnitSymbol.JPerkg , cim:UnitSymbol.G , cim:UnitMultiplier.G , cim:UnitSymbol.sr , cim:UnitSymbol.VA , cim:UnitSymbol.NPerm , cim:UnitMultiplier.m , cim:UnitSymbol.character , cim:UnitSymbol.ha , cim:UnitMultiplier.P , cim:UnitSymbol.A2 , cim:UnitSymbol.kn , cim:UnitSymbol.SPerm , cim:UnitSymbol.l , cim:UnitSymbol.FPerm , cim:UnitSymbol.d , cim:UnitMultiplier.n , cim:UnitSymbol.H , cim:UnitSymbol.onePerm , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.M , cim:UnitSymbol.gPerg , cim:UnitMultiplier.T , cim:UnitSymbol.h , cim:UnitSymbol.deg , cim:UnitSymbol.GyPers , cim:UnitSymbol.KPers , cim:UnitSymbol.radPers , cim:UnitSymbol.PaPers , cim:UnitSymbol.rev , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.N , cim:UnitSymbol.ft3 , cim:UnitSymbol.S , cim:UnitMultiplier.a , cim:UnitSymbol.A2h , cim:UnitSymbol.m3Perh , cim:UnitSymbol.Pas , cim:UnitMultiplier.y , cim:UnitSymbol.Bq , cim:OrientationKind.positive , cim:UnitSymbol.lPers , cim:UnitSymbol.HPerm , cim:UnitSymbol.gal , cim:UnitSymbol.m2Pers , cim:UnitSymbol.ohmm , cim:UnitSymbol.ohm , cim:UnitSymbol.m2 , cim:UnitMultiplier.Z , cim:UnitSymbol.Sv , cim:UnitSymbol.molPerm3 , cim:UnitMultiplier.p , cim:UnitSymbol.Oe , cim:UnitSymbol.kgm , cim:UnitMultiplier.z , cim:UnitSymbol.T , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.anglemin , cim:UnitSymbol.JPers , cim:UnitSymbol.JPerK , cim:UnitSymbol.m3Pers , cim:UnitSymbol.molPermol , cim:UnitSymbol.anglesec , cim:UnitSymbol.rad , cim:UnitSymbol.cosPhi , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.WPers , cim:UnitSymbol.Btu , cim:UnitSymbol.lx , cim:UnitMultiplier.c , cim:UnitSymbol.tonne , cim:UnitSymbol.katPerm3 , cim:UnitSymbol.Qh , cim:UnitSymbol.Q , cim:UnitSymbol.molPerkg , cim:UnitSymbol.m3Uncompensated , cim:UnitMultiplier.d , cim:UnitMultiplier.f , cim:UnitSymbol.APerA , cim:UnitSymbol.Vh , cim:UnitSymbol.JPermol , cim:UnitSymbol.Wh , cim:UnitSymbol.lPerl , cim:UnitSymbol.HzPers , cim:UnitSymbol.onePerHz , cim:UnitSymbol.VAh , cim:UnitMultiplier.k , cim:UnitSymbol.CPerkg , cim:UnitSymbol.VPerVA , cim:UnitMultiplier.Y , cim:UnitSymbol.kgPerm3 , cim:UnitSymbol.cd , cim:UnitMultiplier.M , cim:UnitSymbol.V2 , cim:UnitSymbol.lPerh , cim:UnitSymbol.Pa , cim:UnitSymbol.m3Perkg , cim:UnitSymbol.mmHg , cim:UnitSymbol.APerm , cim:UnitSymbol.lm , cim:UnitSymbol.m3Compensated , cim:UnitMultiplier.micro , cim:UnitSymbol.Wb , cim:UnitSymbol.VPerm , cim:UnitSymbol.WPermK , cim:UnitSymbol.count , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.mPers , cim:UnitMultiplier.h , cim:UnitSymbol.ohmPerm , cim:UnitSymbol.ppm , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.Gy , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.WPerA , cim:UnitSymbol.VPerHz , cim:UnitSymbol.mPers2 , cim:UnitSymbol.Hz , cim:UnitSymbol.degC , cim:UnitSymbol.m3 , cim:UnitSymbol.JPerm3 , cim:UnitSymbol.min , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.JPermolK , cim:OrientationKind.negative , cim:UnitSymbol.s , cim:UnitSymbol.therm , cim:UnitSymbol.As , cim:UnitMultiplier.none , cim:UnitSymbol.rotPers , cim:UnitSymbol.none , cim:UnitMultiplier.da , cim:UnitSymbol.charPers , cim:UnitSymbol.kgm2 , cim:UnitSymbol.VAr , cim:UnitSymbol.kat , cim:UnitSymbol.VPerV , cim:UnitSymbol.A , cim:UnitSymbol.bar , cim:UnitSymbol.kg , cim:UnitSymbol.Vs , cim:UnitSymbol.Ah , cim:UnitMultiplier.E , cim:UnitSymbol.Mx , cim:UnitSymbol.m , cim:UnitSymbol.V , cim:UnitSymbol.WPersr , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.radPers2 , cim:UnitSymbol.J , cim:UnitSymbol.sPers , cim:UnitSymbol.A2s , cim:UnitSymbol.W , cim:UnitSymbol.mol , cim:UnitSymbol.Nm , cim:UnitSymbol.F , cim:UnitSymbol.VArh , cim:UnitSymbol.dBm .

op:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.lPerl , cim:UnitMultiplier.h , cim:UnitSymbol.H , cim:UnitSymbol.tonne , cim:UnitMultiplier.da , cim:UnitSymbol.charPers , cim:UnitSymbol.m2 , cim:UnitSymbol.ft3 , cim:PhaseCode.ABC , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.FPerm , cim:UnitSymbol.PaPers , cim:UnitSymbol.lx , cim:UnitSymbol.l , cim:UnitSymbol.A , cim:UnitMultiplier.n , cim:UnitSymbol.Bq , cim:PhaseCode.s1 , cim:UnitSymbol.Hz , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.K , cim:UnitSymbol.S , cim:UnitSymbol.Pa , cim:UnitSymbol.A2s , cim:Source.SUBSTITUTED , cim:UnitSymbol.As , cim:PhaseCode.X , cim:UnitSymbol.character , cim:UnitSymbol.WPermK , cim:UnitSymbol.A2h , cim:PhaseCode.AC , cim:PhaseCode.B , cim:UnitSymbol.d , cim:UnitSymbol.lm , cim:UnitMultiplier.f , cim:UnitSymbol.radPers2 , cim:UnitSymbol.kn , cim:Validity.QUESTIONABLE , cim:UnitSymbol.mol , cim:UnitSymbol.HzPers , cim:UnitSymbol.JPermol , cim:UnitSymbol.ha , cim:UnitMultiplier.m , cim:PhaseCode.CN , cim:UnitSymbol.C , cim:UnitSymbol.ppm , cim:UnitSymbol.J , cim:UnitSymbol.bar , cim:UnitMultiplier.T , cim:PhaseCode.s1N , cim:UnitSymbol.m3 , cim:UnitSymbol.kgPerJ , cim:Validity.GOOD , cim:UnitSymbol.JPerm3 , cim:PhaseCode.AN , cim:PhaseCode.XY , cim:UnitSymbol.kat , cim:UnitSymbol.KPers , cim:UnitSymbol.Qh , cim:UnitSymbol.m3Pers , cim:UnitSymbol.cosPhi , cim:UnitSymbol.none , cim:UnitSymbol.onePerHz , cim:UnitSymbol.VArh , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.VA , cim:UnitSymbol.APerm , cim:UnitSymbol.JPerK , cim:UnitSymbol.Nm , cim:UnitSymbol.m2Pers , cim:UnitSymbol.T , cim:PhaseCode.ABN , cim:UnitSymbol.APerA , cim:PhaseCode.s2 , cim:UnitSymbol.Gy , cim:UnitSymbol.HPerm , cim:UnitSymbol.count , cim:UnitSymbol.radPers , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.Sv , cim:UnitSymbol.NPerm , cim:PhaseCode.BN , cim:UnitMultiplier.z , cim:PhaseCode.C , cim:UnitMultiplier.d , cim:UnitSymbol.m3Perh , cim:PhaseCode.BC , cim:UnitSymbol.katPerm3 , cim:UnitSymbol.Ah , cim:UnitSymbol.molPermol , cim:PhaseCode.N , cim:UnitSymbol.WPersr , cim:UnitSymbol.onePerm , cim:UnitSymbol.Vs , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.gal , cim:UnitSymbol.kgm , cim:UnitSymbol.mPers2 , cim:UnitSymbol.kg , cim:PhaseCode.s12N , cim:UnitSymbol.WPerA , cim:UnitSymbol.anglesec , cim:UnitSymbol.ohmPerm , cim:UnitSymbol.degC , cim:UnitMultiplier.y , cim:UnitSymbol.Pas , cim:UnitSymbol.gPerg , cim:UnitSymbol.Oe , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.Btu , cim:UnitSymbol.Wb , cim:UnitSymbol.Q , cim:UnitSymbol.WPerW , cim:UnitSymbol.VPerm , cim:UnitSymbol.anglemin , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.mPers , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.rev , cim:UnitSymbol.s , cim:UnitSymbol.lPers , cim:UnitSymbol.CPerkg , cim:UnitSymbol.A2 , cim:UnitSymbol.m , cim:UnitSymbol.lPerh , cim:UnitSymbol.rad , cim:UnitSymbol.V2 , cim:UnitMultiplier.M , cim:PhaseCode.XN , cim:UnitSymbol.W , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.sPers , cim:PhaseCode.ACN , cim:Source.PROCESS , cim:PhaseCode.BCN , cim:PhaseCode.none , cim:UnitSymbol.ohm , cim:Validity.INVALID , cim:UnitMultiplier.Z , cim:UnitSymbol.sr , cim:UnitSymbol.JPermolK , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.ohmm , cim:UnitSymbol.m3Perkg , cim:UnitMultiplier.a , cim:UnitSymbol.h , cim:UnitSymbol.VAh , cim:UnitMultiplier.k , cim:PhaseCode.XYN , cim:UnitMultiplier.E , cim:UnitSymbol.G , cim:UnitSymbol.VAr , cim:UnitMultiplier.P , cim:UnitSymbol.dB , cim:UnitSymbol.V , cim:UnitSymbol.kgm2 , cim:UnitSymbol.V2h , cim:UnitSymbol.JPers , cim:UnitSymbol.deg , cim:PhaseCode.ABCN , cim:UnitMultiplier.micro , cim:UnitSymbol.WPers , cim:UnitSymbol.GyPers , cim:UnitMultiplier.Y , cim:UnitSymbol.SPerm , cim:UnitSymbol.therm , cim:Source.DEFAULTED , cim:UnitSymbol.mmHg , cim:UnitMultiplier.c , cim:PhaseCode.s12 , cim:UnitSymbol.rotPers , cim:UnitSymbol.min , cim:UnitSymbol.Mx , cim:UnitSymbol.cd , cim:UnitSymbol.VPerV , cim:UnitSymbol.VPerVA , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.F , cim:UnitSymbol.Vh , cim:UnitSymbol.N , cim:UnitMultiplier.G , cim:UnitSymbol.molPerkg , cim:UnitSymbol.dBm , cim:UnitSymbol.kgPerm3 , cim:UnitMultiplier.p , cim:PhaseCode.s2N , cim:PhaseCode.A , cim:PhaseCode.AB , cim:UnitSymbol.JPerkg , cim:UnitSymbol.M , cim:UnitMultiplier.none , cim:UnitSymbol.VPerHz , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.Wh .

ssh:RdfAbout  a      rdfs:Class;
        owl:members  cim:LoadBreakSwitch , cim:EquivalentInjection , cim:ConformLoad , cim:StationSupply , cim:CurrentLimit , cim:ACDCConverterDCTerminal , cim:HydroGeneratingUnit , cim:AsynchronousMachine , cim:PhaseTapChangerLinear , cim:GroundDisconnector , cim:Switch , cim:BatteryUnit , cim:VoltageLimit , cim:ActivePowerLimit , cim:DisconnectingCircuitBreaker , cim:SolarGeneratingUnit , cim:RatioTapChanger , cim:NonConformLoad , cim:WindGeneratingUnit , cim:RegulatingControl , cim:Jumper , cim:EnergyConsumer , cim:VsConverter , cim:ControlArea , cim:Disconnector , cim:LinearShuntCompensator , cim:SynchronousMachine , cim:ExternalNetworkInjection , cim:DCTerminal , cim:GeneratingUnit , cim:PhaseTapChangerAsymmetrical , cim:ApparentPowerLimit , cim:Fuse , cim:Breaker , cim:TapChangerControl , cim:ThermalGeneratingUnit , cim:StaticVarCompensator , cim:NonlinearShuntCompensator , cim:PhaseTapChangerTabular , cim:NuclearGeneratingUnit , cim:CsConverter , cim:PowerElectronicsConnection , cim:Terminal , cim:EnergySource , cim:PhaseTapChangerSymmetrical , cim:RegulatingCondEq .

ssh:RdfEnum  a       rdfs:Class;
        owl:members  cim:UnitMultiplier.z , cim:UnitSymbol.APerA , cim:VsPpccControlKind.phasePcc , cim:UnitSymbol.WPerA , cim:UnitSymbol.CPerkg , cim:UnitSymbol.Q , cim:UnitSymbol.kat , cim:UnitSymbol.mmHg , cim:UnitMultiplier.M , cim:AsynchronousMachineKind.generator , cim:UnitSymbol.W , cim:UnitSymbol.s , cim:UnitSymbol.charPers , cim:UnitSymbol.onePerHz , cim:UnitSymbol.F , cim:UnitSymbol.m3Perh , cim:UnitMultiplier.T , cim:UnitSymbol.anglesec , cim:UnitSymbol.m2 , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.M , cim:UnitSymbol.N , cim:UnitSymbol.kgPerJ , cim:BatteryStateKind.full , cim:UnitSymbol.Sv , cim:SynchronousMachineOperatingMode.condenser , cim:UnitSymbol.ppm , cim:CsPpccControlKind.dcVoltage , cim:UnitSymbol.bar , cim:BatteryStateKind.waiting , cim:UnitSymbol.VAr , cim:UnitSymbol.HPerm , cim:UnitSymbol.m3Perkg , cim:CsPpccControlKind.dcCurrent , cim:UnitMultiplier.m , cim:UnitMultiplier.c , cim:UnitSymbol.therm , cim:UnitSymbol.Btu , cim:UnitMultiplier.Y , cim:UnitSymbol.JPerK , cim:UnitSymbol.character , cim:UnitSymbol.Mx , cim:UnitSymbol.lPerl , cim:UnitSymbol.J , cim:UnitSymbol.KPers , cim:UnitSymbol.WPerW , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.tonne , cim:UnitSymbol.lPers , cim:VsPpccControlKind.udc , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.JPers , cim:SynchronousMachineOperatingMode.generator , cim:UnitSymbol.JPerm3 , cim:UnitSymbol.JPerkg , cim:BatteryStateKind.empty , cim:UnitSymbol.WPers , cim:UnitSymbol.G , cim:VsQpccControlKind.pulseWidthModulation , cim:UnitMultiplier.k , cim:UnitSymbol.ha , cim:UnitMultiplier.E , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.A2s , cim:UnitSymbol.Vs , cim:UnitSymbol.cd , cim:BatteryStateKind.discharging , cim:BatteryStateKind.charging , cim:UnitSymbol.VA , cim:UnitSymbol.Pas , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.H , cim:UnitMultiplier.micro , cim:UnitSymbol.cosPhi , cim:UnitSymbol.SPerm , cim:UnitSymbol.deg , cim:UnitSymbol.V2 , cim:VsPpccControlKind.pPcc , cim:UnitMultiplier.h , cim:UnitMultiplier.P , cim:UnitMultiplier.n , cim:UnitSymbol.PaPers , cim:UnitSymbol.Wh , cim:UnitSymbol.ft3 , cim:UnitSymbol.h , cim:UnitSymbol.C , cim:UnitSymbol.WPermK , cim:UnitSymbol.sPers , cim:UnitMultiplier.da , cim:UnitSymbol.JPermolK , cim:VsPpccControlKind.pPccAndUdcDroop , cim:VsPpccControlKind.pPccAndUdcDroopWithCompensation , cim:UnitSymbol.m , cim:UnitSymbol.Vh , cim:UnitSymbol.rev , cim:UnitSymbol.Pa , cim:UnitSymbol.rad , cim:UnitSymbol.HzPers , cim:UnitSymbol.none , cim:UnitSymbol.degC , cim:UnitSymbol.kgPerm3 , cim:UnitSymbol.ohmPerm , cim:UnitSymbol.APerm , cim:UnitSymbol.V2h , cim:UnitSymbol.d , cim:UnitMultiplier.y , cim:UnitSymbol.Gy , cim:UnitMultiplier.d , cim:UnitSymbol.count , cim:UnitSymbol.gPerg , cim:UnitSymbol.Wb , cim:UnitSymbol.radPers2 , cim:VsQpccControlKind.reactivePcc , cim:UnitSymbol.K , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.kn , cim:UnitSymbol.A2 , cim:UnitSymbol.m3Pers , cim:UnitSymbol.VPerVA , cim:UnitSymbol.Hz , cim:UnitSymbol.mPers , cim:UnitMultiplier.none , cim:UnitSymbol.ohm , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.onePerm , cim:UnitSymbol.VPerV , cim:UnitSymbol.mol , cim:UnitSymbol.VPerHz , cim:UnitSymbol.JPermol , cim:UnitMultiplier.a , cim:UnitSymbol.kg , cim:UnitSymbol.Qh , cim:UnitSymbol.VArh , cim:UnitSymbol.lx , cim:UnitSymbol.VAh , cim:UnitSymbol.gal , cim:UnitSymbol.min , cim:UnitSymbol.Nm , cim:UnitSymbol.dB , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.l , cim:UnitSymbol.anglemin , cim:UnitSymbol.V , cim:UnitMultiplier.G , cim:UnitSymbol.molPerkg , cim:UnitSymbol.radPers , cim:UnitSymbol.kgm2 , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.kgm , cim:UnitSymbol.dBm , cim:SynchronousMachineOperatingMode.motor , cim:UnitSymbol.WPersr , cim:UnitSymbol.FPerm , cim:UnitSymbol.NPerm , cim:CsOperatingModeKind.inverter , cim:UnitSymbol.lm , cim:UnitSymbol.Bq , cim:CsOperatingModeKind.rectifier , cim:UnitSymbol.m2Pers , cim:UnitSymbol.GyPers , cim:VsPpccControlKind.pPccAndUdcDroopPilot , cim:UnitSymbol.S , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.m3 , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.lPerh , cim:VsQpccControlKind.voltagePcc , cim:UnitMultiplier.p , cim:UnitSymbol.ohmm , cim:UnitSymbol.rotPers , cim:UnitMultiplier.f , cim:UnitSymbol.mPers2 , cim:UnitMultiplier.Z , cim:UnitSymbol.T , cim:VsQpccControlKind.powerFactorPcc , cim:CsPpccControlKind.activePower , cim:UnitSymbol.sr , cim:UnitSymbol.VPerm , cim:UnitSymbol.As , cim:UnitSymbol.A , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.katPerm3 , cim:UnitSymbol.Oe , cim:UnitSymbol.Ah , cim:UnitSymbol.A2h , cim:UnitSymbol.molPermol , cim:AsynchronousMachineKind.motor .

dy:RdfAbout  a       rdfs:Class;
        owl:members  cim:EnergyConsumer .

eqbd:RdfEnum  a      rdfs:Class;
        owl:members  cim:UnitSymbol.bar , cim:UnitSymbol.VPerV , cim:UnitSymbol.Pas , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.A , cim:UnitSymbol.KPers , cim:UnitMultiplier.da , cim:UnitMultiplier.G , cim:UnitSymbol.cd , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.kg , cim:UnitSymbol.m3Perkg , cim:UnitSymbol.HzPers , cim:UnitMultiplier.d , cim:UnitSymbol.Bq , cim:UnitSymbol.onePerHz , cim:UnitSymbol.S , cim:UnitSymbol.FPerm , cim:UnitSymbol.Wh , cim:UnitSymbol.N , cim:UnitMultiplier.c , cim:UnitSymbol.charPers , cim:UnitSymbol.As , cim:UnitSymbol.WPers , cim:UnitSymbol.tonne , cim:UnitMultiplier.m , cim:UnitSymbol.M , cim:UnitSymbol.VAr , cim:UnitSymbol.H , cim:UnitSymbol.Ah , cim:UnitSymbol.therm , cim:UnitSymbol.VPerHz , cim:UnitSymbol.V2 , cim:UnitSymbol.CPerkg , cim:UnitSymbol.lx , cim:UnitSymbol.ohm , cim:UnitSymbol.radPers2 , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.mmHg , cim:UnitSymbol.kgm , cim:UnitSymbol.VPerm , cim:UnitSymbol.Gy , cim:UnitSymbol.lPerh , cim:UnitSymbol.WPersr , cim:UnitSymbol.Wb , cim:UnitSymbol.Vh , cim:UnitMultiplier.n , cim:UnitSymbol.m3Pers , cim:UnitSymbol.m2 , cim:UnitSymbol.NPerm , cim:UnitMultiplier.none , cim:UnitSymbol.lPerl , cim:UnitMultiplier.h , cim:UnitSymbol.VArh , cim:UnitSymbol.WPerA , cim:UnitSymbol.deg , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.kat , cim:UnitSymbol.V2h , cim:UnitMultiplier.Z , cim:UnitSymbol.GyPers , cim:UnitSymbol.radPers , cim:UnitSymbol.sr , cim:UnitSymbol.m2Pers , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.lm , cim:UnitSymbol.kgPerm3 , cim:UnitSymbol.V , cim:UnitSymbol.ohmPerm , cim:UnitMultiplier.k , cim:UnitSymbol.degC , cim:UnitSymbol.onePerm , cim:UnitSymbol.anglemin , cim:UnitMultiplier.Y , cim:UnitMultiplier.P , cim:UnitSymbol.s , cim:UnitSymbol.mPers2 , cim:UnitSymbol.WPerW , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.d , cim:UnitMultiplier.E , cim:UnitSymbol.A2h , cim:UnitSymbol.mPers , cim:UnitSymbol.C , cim:UnitSymbol.molPerkg , cim:UnitSymbol.W , cim:UnitSymbol.VAh , cim:UnitSymbol.VA , cim:UnitSymbol.APerm , cim:UnitSymbol.Q , cim:UnitSymbol.m , cim:UnitSymbol.SPerm , cim:UnitSymbol.JPerK , cim:UnitSymbol.dB , cim:UnitSymbol.Sv , cim:UnitSymbol.Btu , cim:UnitSymbol.h , cim:UnitSymbol.rev , cim:UnitMultiplier.a , cim:UnitSymbol.JPermolK , cim:UnitSymbol.JPerkg , cim:UnitSymbol.molPermol , cim:UnitSymbol.G , cim:UnitSymbol.l , cim:UnitSymbol.Qh , cim:UnitSymbol.VPerVA , cim:UnitSymbol.JPers , cim:UnitSymbol.kgPerJ , cim:UnitSymbol.Hz , cim:UnitSymbol.K , cim:UnitSymbol.T , cim:UnitSymbol.JPerm3 , cim:UnitSymbol.mol , cim:UnitSymbol.none , cim:UnitSymbol.Pa , cim:UnitSymbol.anglesec , cim:UnitSymbol.sPers , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.lPers , cim:UnitSymbol.gal , cim:UnitSymbol.J , cim:UnitSymbol.Oe , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.cosPhi , cim:UnitSymbol.Nm , cim:UnitMultiplier.z , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.ha , cim:UnitSymbol.APerA , cim:UnitSymbol.kn , cim:UnitSymbol.A2 , cim:UnitMultiplier.f , cim:UnitMultiplier.M , cim:UnitSymbol.count , cim:UnitSymbol.ppm , cim:UnitMultiplier.T , cim:UnitSymbol.gPerg , cim:UnitSymbol.m3Perh , cim:UnitMultiplier.p , cim:UnitMultiplier.y , cim:UnitSymbol.PaPers , cim:UnitSymbol.WPermK , cim:UnitSymbol.character , cim:UnitSymbol.kgm2 , cim:UnitSymbol.rotPers , cim:UnitSymbol.F , cim:UnitSymbol.ohmm , cim:UnitSymbol.min , cim:UnitSymbol.ft3 , cim:UnitSymbol.dBm , cim:UnitSymbol.m3 , cim:UnitSymbol.HPerm , cim:UnitSymbol.Vs , cim:UnitSymbol.JPermol , cim:UnitMultiplier.micro , cim:UnitSymbol.Mx , cim:UnitSymbol.rad , cim:UnitSymbol.A2s , cim:UnitSymbol.katPerm3 .

tp:RdfAbout  a       rdfs:Class;
        owl:members  cim:Terminal , cim:ACDCConverterDCTerminal , cim:DCNode , cim:DCTerminal , cim:ConnectivityNode .

dy:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.Nm , cim:ExcST7BUELselectorKind.inputHVgate , cim:ExcST7BOELselectorKind.noOELinput , cim:WindQcontrolModeKind.voltage , cim:UnitSymbol.As , cim:UnitSymbol.kg , cim:ExcST6BOELselectorKind.afterUEL , cim:UnitMultiplier.da , cim:UnitSymbol.VArh , cim:WindLookupTableFunctionKind.tuunder , cim:UnitSymbol.ha , cim:UnitSymbol.SPerm , cim:UnitSymbol.Vs , cim:UnitSymbol.HPerm , cim:UnitSymbol.GyPers , cim:UnitMultiplier.d , cim:UnitSymbol.JPermol , cim:RemoteSignalKind.remoteBranchCurrentAmplitude , cim:UnitSymbol.mPers , cim:UnitMultiplier.p , cim:WindUVRTQcontrolModeKind.mode0 , cim:UnitMultiplier.m , cim:UnitMultiplier.Z , cim:WindLookupTableFunctionKind.pwp , cim:UnitSymbol.WPerW , cim:WindQcontrolModeKind.powerFactor , cim:ExcST6BOELselectorKind.beforeUEL , cim:UnitSymbol.kn , cim:UnitSymbol.lx , cim:WindLookupTableFunctionKind.tuover , cim:UnitMultiplier.z , cim:InputSignalKind.generatorElectricalPower , cim:UnitMultiplier.none , cim:ExcREXSFeedbackSignalKind.outputVoltage , cim:WindLookupTableFunctionKind.qminp , cim:UnitSymbol.anglesec , cim:RemoteSignalKind.remoteBusVoltageAmplitude , cim:UnitMultiplier.Y , cim:UnitMultiplier.T , cim:UnitSymbol.NPerm , cim:UnitSymbol.s , cim:UnitSymbol.Vh , cim:RemoteSignalKind.remoteBusFrequency , cim:GovHydro4ModelKind.simple , cim:UnitSymbol.molPermol , cim:UnitSymbol.dBm , cim:UnitSymbol.dB , cim:RemoteSignalKind.remoteBusVoltage , cim:UnitSymbol.Pas , cim:SynchronousMachineModelKind.subtransientTypeJ , cim:UnitMultiplier.micro , cim:UnitSymbol.lPerh , cim:InputSignalKind.busVoltageDerivative , cim:StaticLoadModelKind.zIP1 , cim:UnitSymbol.kat , cim:ExcST7BUELselectorKind.noUELinput , cim:InputSignalKind.busFrequencyDeviation , cim:UnitSymbol.mol , cim:UnitSymbol.bar , cim:UnitSymbol.Wb , cim:UnitMultiplier.E , cim:RemoteSignalKind.remotePuBusVoltageDerivative , cim:UnitMultiplier.P , cim:UnitSymbol.VPerV , cim:UnitSymbol.rotPers , cim:StaticLoadModelKind.constantZ , cim:ExcIEEEST1AUELselectorKind.inputHVgateErrorSignal , cim:UnitSymbol.ppm , cim:RotorKind.salientPole , cim:DroopSignalFeedbackKind.fuelValveStroke , cim:WindLookupTableFunctionKind.qmaxp , cim:UnitSymbol.m2 , cim:WindLookupTableFunctionKind.tfover , cim:UnitSymbol.VPerVA , cim:DroopSignalFeedbackKind.governorOutput , cim:WindPlantQcontrolModeKind.uqStatic , cim:WindPlantQcontrolModeKind.powerFactor , cim:UnitSymbol.cosPhi , cim:RemoteSignalKind.remoteBusVoltageAmplitudeDerivative , cim:InputSignalKind.branchCurrent , cim:WindLookupTableFunctionKind.iqmax , cim:WindLookupTableFunctionKind.qminu , cim:UnitSymbol.cd , cim:WindLookupTableFunctionKind.omegap , cim:UnitSymbol.anglemin , cim:UnitSymbol.HzPers , cim:WindUVRTQcontrolModeKind.mode1 , cim:IfdBaseKind.ifnl , cim:InputSignalKind.rotorSpeed , cim:UnitSymbol.lm , cim:UnitSymbol.mPers2 , cim:UnitSymbol.gal , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.FPerm , cim:UnitSymbol.WPerm2sr , cim:WindPlantQcontrolModeKind.voltageControl , cim:UnitSymbol.JPerK , cim:SynchronousMachineModelKind.subtransient , cim:UnitSymbol.H , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.V2h , cim:UnitSymbol.radPers , cim:GovHydro4ModelKind.kaplan , cim:UnitSymbol.h , cim:UnitMultiplier.f , cim:UnitSymbol.rad , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.ft3 , cim:UnitSymbol.katPerm3 , cim:StaticLoadModelKind.exponential , cim:GenericNonLinearLoadModelKind.loadAdaptive , cim:UnitSymbol.gPerg , cim:StaticLoadModelKind.zIP2 , cim:ExcREXSFeedbackSignalKind.fieldCurrent , cim:UnitSymbol.G , cim:UnitSymbol.radPers2 , cim:ExcST6BOELselectorKind.noOELinput , cim:WindLookupTableFunctionKind.qwp , cim:UnitSymbol.m3Perh , cim:UnitSymbol.WPers , cim:WindUVRTQcontrolModeKind.mode2 , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.PaPers , cim:UnitSymbol.Q , cim:UnitSymbol.lPers , cim:GenericNonLinearLoadModelKind.exponentialRecovery , cim:UnitSymbol.therm , cim:InputSignalKind.generatorMechanicalPower , cim:UnitSymbol.KPers , cim:UnitSymbol.VAr , cim:ExcST7BOELselectorKind.inputLVgate , cim:UnitSymbol.WPerA , cim:UnitSymbol.m3Perkg , cim:UnitSymbol.m3 , cim:WindLookupTableFunctionKind.prr , cim:UnitSymbol.VPerHz , cim:RemoteSignalKind.remoteBusFrequencyDeviation , cim:UnitSymbol.none , cim:UnitSymbol.Mx , cim:UnitSymbol.Oe , cim:WindLookupTableFunctionKind.tfunder , cim:InputSignalKind.busFrequency , cim:UnitSymbol.A2 , cim:UnitSymbol.ohm , cim:RotorKind.roundRotor , cim:UnitSymbol.lPerl , cim:UnitSymbol.J , cim:InputSignalKind.generatorAcceleratingPower , cim:WindQcontrolModeKind.openLooppowerFactor , cim:UnitSymbol.APerA , cim:UnitMultiplier.M , cim:RemoteSignalKind.remoteBusVoltageFrequencyDeviation , cim:UnitSymbol.m3Pers , cim:UnitSymbol.V2 , cim:IfdBaseKind.iffl , cim:UnitSymbol.charPers , cim:UnitMultiplier.h , cim:UnitSymbol.JPermolK , cim:UnitSymbol.T , cim:WindLookupTableFunctionKind.ipmax , cim:UnitSymbol.onePerm , cim:UnitSymbol.character , cim:InputSignalKind.fieldCurrent , cim:UnitSymbol.degC , cim:UnitSymbol.Qh , cim:UnitSymbol.F , cim:UnitSymbol.VPerm , cim:RemoteSignalKind.remoteBusVoltageFrequency , cim:UnitSymbol.count , cim:UnitMultiplier.a , cim:UnitSymbol.Ah , cim:UnitSymbol.min , cim:UnitSymbol.onePerHz , cim:UnitSymbol.S , cim:InputSignalKind.rotorAngularFrequencyDeviation , cim:UnitSymbol.N , cim:SynchronousMachineModelKind.subtransientSimplifiedDirectAxis , cim:SynchronousMachineModelKind.subtransientTypeF , cim:UnitSymbol.A2h , cim:UnitSymbol.m , cim:UnitSymbol.VA , cim:UnitMultiplier.k , cim:ExcST7BUELselectorKind.addVref , cim:ExcST7BOELselectorKind.outputLVgate , cim:UnitSymbol.WPersr , cim:UnitSymbol.ohmPerm , cim:ExcREXSFeedbackSignalKind.fieldVoltage , cim:UnitSymbol.mmHg , cim:UnitSymbol.JPerkg , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.Sv , cim:WindQcontrolModeKind.reactivePower , cim:UnitSymbol.kgm , cim:InputSignalKind.busVoltage , cim:UnitSymbol.ohmm , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.l , cim:UnitSymbol.m2Pers , cim:ExcIEEEST1AUELselectorKind.inputAddedToErrorSignal , cim:ExcST7BUELselectorKind.outputHVgate , cim:DroopSignalFeedbackKind.none , cim:UnitSymbol.Btu , cim:UnitSymbol.kgm2 , cim:FrancisGovernorControlKind.electromechanicalElectrohydraulic , cim:UnitSymbol.sr , cim:DroopSignalFeedbackKind.electricalPower , cim:WindLookupTableFunctionKind.qmaxu , cim:FrancisGovernorControlKind.mechanicHydraulicTransientFeedback , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.APerm , cim:UnitSymbol.K , cim:WindPlantQcontrolModeKind.reactivePower , cim:UnitSymbol.W , cim:ExcIEEEST1AUELselectorKind.ignoreUELsignal , cim:UnitMultiplier.c , cim:UnitSymbol.A , cim:UnitMultiplier.G , cim:UnitSymbol.JPers , cim:ExcIEEEST1AUELselectorKind.inputHVgateVoltageOutput , cim:UnitSymbol.kgPerm3 , cim:ExcST7BOELselectorKind.addVref , cim:UnitSymbol.WPermK , cim:FrancisGovernorControlKind.mechanicHydrolicTachoAccelerator , cim:UnitSymbol.sPers , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.Bq , cim:UnitSymbol.VAh , cim:UnitMultiplier.y , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.rev , cim:WindLookupTableFunctionKind.tcwdu , cim:UnitSymbol.CPerkg , cim:UnitSymbol.deg , cim:UnitMultiplier.n , cim:UnitSymbol.Gy , cim:UnitSymbol.CPerm3 , cim:SynchronousMachineModelKind.subtransientSimplified , cim:WindQcontrolModeKind.openLoopReactivePower , cim:IfdBaseKind.ifag , cim:UnitSymbol.Hz , cim:UnitSymbol.kgPerJ , cim:GovHydro4ModelKind.francisPelton , cim:UnitSymbol.tonne , cim:UnitSymbol.d , cim:UnitSymbol.A2s , cim:UnitSymbol.M , cim:UnitSymbol.Pa , cim:UnitSymbol.Wh , cim:UnitSymbol.JPerm3 , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.V , cim:UnitSymbol.C , cim:UnitSymbol.molPerkg , cim:WindLookupTableFunctionKind.tduwt .

sc:RdfEnum  a        rdfs:Class;
        owl:members  cim:UnitSymbol.s , cim:UnitSymbol.l , cim:UnitSymbol.WPerm2sr , cim:UnitSymbol.rotPers , cim:UnitMultiplier.z , cim:UnitSymbol.Oe , cim:UnitSymbol.Vh , cim:UnitSymbol.lPers , cim:UnitSymbol.gal , cim:UnitMultiplier.Z , cim:UnitSymbol.sr , cim:UnitSymbol.A2h , cim:UnitMultiplier.d , cim:UnitMultiplier.y , cim:UnitSymbol.CPerkg , cim:UnitSymbol.JPerkg , cim:UnitSymbol.A , cim:UnitSymbol.kat , cim:UnitMultiplier.h , cim:UnitSymbol.F , cim:UnitSymbol.K , cim:UnitSymbol.Qh , cim:UnitSymbol.kgPerm3 , cim:UnitSymbol.Pas , cim:UnitMultiplier.da , cim:UnitSymbol.lx , cim:UnitMultiplier.c , cim:UnitSymbol.Wb , cim:UnitMultiplier.M , cim:UnitSymbol.WPerm2 , cim:UnitSymbol.A2s , cim:UnitSymbol.Nm , cim:UnitSymbol.m3 , cim:UnitSymbol.J , cim:UnitSymbol.therm , cim:UnitSymbol.mPers2 , cim:UnitSymbol.V , cim:UnitSymbol.anglemin , cim:UnitSymbol.m , cim:PetersenCoilModeKind.fixed , cim:UnitSymbol.ohmm , cim:UnitSymbol.character , cim:UnitSymbol.m3Uncompensated , cim:UnitSymbol.ohmPerm , cim:PetersenCoilModeKind.manual , cim:UnitSymbol.VPerV , cim:UnitMultiplier.f , cim:UnitSymbol.m3Perh , cim:UnitSymbol.JPers , cim:UnitSymbol.PaPers , cim:UnitMultiplier.a , cim:UnitSymbol.JPerK , cim:UnitSymbol.CPerm3 , cim:UnitSymbol.deg , cim:UnitSymbol.h , cim:UnitSymbol.molPerm3 , cim:UnitSymbol.rad , cim:ShortCircuitRotorKind.turboSeries2 , cim:UnitSymbol.H , cim:UnitSymbol.radPers , cim:UnitSymbol.onePerm , cim:UnitSymbol.JPerm3 , cim:UnitSymbol.VAr , cim:UnitSymbol.V2 , cim:UnitSymbol.FPerm , cim:UnitSymbol.VPerVA , cim:UnitSymbol.Wh , cim:UnitSymbol.HzPers , cim:UnitSymbol.Hz , cim:UnitSymbol.kgm , cim:UnitSymbol.sPers , cim:UnitMultiplier.m , cim:UnitSymbol.CPerm2 , cim:UnitSymbol.JPerm2 , cim:UnitSymbol.ha , cim:UnitSymbol.KPers , cim:UnitMultiplier.none , cim:UnitSymbol.Gy , cim:UnitSymbol.G , cim:UnitSymbol.VAh , cim:UnitMultiplier.E , cim:UnitSymbol.WPerW , cim:UnitSymbol.HPerm , cim:PetersenCoilModeKind.automaticPositioning , cim:UnitSymbol.kgm2 , cim:UnitSymbol.molPermol , cim:UnitSymbol.onePerHz , cim:UnitSymbol.ppm , cim:UnitSymbol.WPermK , cim:UnitSymbol.gPerg , cim:ShortCircuitRotorKind.salientPole1 , cim:UnitSymbol.VPerm , cim:UnitSymbol.ft3 , cim:UnitSymbol.N , cim:UnitSymbol.APerA , cim:UnitSymbol.WPers , cim:UnitSymbol.lm , cim:UnitSymbol.VArh , cim:UnitSymbol.W , cim:UnitSymbol.mol , cim:UnitSymbol.m3Pers , cim:UnitSymbol.min , cim:UnitSymbol.radPers2 , cim:UnitSymbol.m2 , cim:UnitSymbol.T , cim:UnitSymbol.lPerl , cim:UnitSymbol.SPerm , cim:UnitMultiplier.p , cim:UnitSymbol.WPerA , cim:UnitSymbol.mmHg , cim:UnitMultiplier.P , cim:UnitSymbol.Mx , cim:UnitSymbol.A2 , cim:UnitSymbol.m3Perkg , cim:UnitSymbol.JPerkgK , cim:UnitSymbol.kg , cim:UnitSymbol.Bq , cim:UnitSymbol.HzPerHz , cim:UnitSymbol.mPerm3 , cim:UnitSymbol.degC , cim:UnitSymbol.dB , cim:UnitSymbol.S , cim:UnitSymbol.charPers , cim:UnitSymbol.rev , cim:UnitSymbol.V2h , cim:UnitSymbol.tonne , cim:UnitSymbol.mPers , cim:UnitSymbol.count , cim:UnitSymbol.none , cim:ShortCircuitRotorKind.salientPole2 , cim:UnitSymbol.kn , cim:ShortCircuitRotorKind.turboSeries1 , cim:UnitSymbol.Pa , cim:UnitSymbol.cd , cim:UnitMultiplier.n , cim:UnitSymbol.d , cim:UnitSymbol.VPerVAr , cim:UnitSymbol.WPersr , cim:UnitSymbol.As , cim:UnitSymbol.JPermol , cim:UnitMultiplier.Y , cim:UnitSymbol.VPerHz , cim:UnitSymbol.Sv , cim:UnitMultiplier.k , cim:UnitSymbol.katPerm3 , cim:UnitSymbol.NPerm , cim:UnitSymbol.molPerkg , cim:UnitSymbol.ohm , cim:UnitSymbol.bar , cim:UnitSymbol.APerm , cim:UnitSymbol.cosPhi , cim:UnitSymbol.m3Compensated , cim:UnitSymbol.Q , cim:UnitMultiplier.G , cim:UnitSymbol.Vs , cim:UnitSymbol.Ah , cim:UnitSymbol.Btu , cim:UnitSymbol.VA , cim:UnitMultiplier.micro , cim:UnitSymbol.dBm , cim:UnitSymbol.C , cim:UnitSymbol.GyPers , cim:UnitSymbol.m2Pers , cim:UnitSymbol.lPerh , cim:UnitSymbol.M , cim:UnitSymbol.kgPerJ , cim:UnitSymbol.anglesec , cim:UnitSymbol.JPermolK , cim:UnitMultiplier.T .

sv:RdfAbout  a       rdfs:Class;
        owl:members  cim:VsConverter , cim:CsConverter .
"""