# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class AccessPolicyUpdateKind(str, Enum):

    add = "add"
    replace = "replace"
    remove = "remove"

class CertificatePermissions(str, Enum):

    get = "get"
    list = "list"
    delete = "delete"
    create = "create"
    import_enum = "import"
    update = "update"
    managecontacts = "managecontacts"
    getissuers = "getissuers"
    listissuers = "listissuers"
    setissuers = "setissuers"
    deleteissuers = "deleteissuers"
    manageissuers = "manageissuers"
    recover = "recover"
    purge = "purge"
    backup = "backup"
    restore = "restore"

class CreateMode(str, Enum):
    """The vault's create mode to indicate whether the vault need to be recovered or not.
    """

    recover = "recover"
    default = "default"

class KeyPermissions(str, Enum):

    encrypt = "encrypt"
    decrypt = "decrypt"
    wrap_key = "wrapKey"
    unwrap_key = "unwrapKey"
    sign = "sign"
    verify = "verify"
    get = "get"
    list = "list"
    create = "create"
    update = "update"
    import_enum = "import"
    delete = "delete"
    backup = "backup"
    restore = "restore"
    recover = "recover"
    purge = "purge"

class ManagedHsmSkuName(str, Enum):
    """SKU of the managed HSM Pool
    """

    standard_b1 = "Standard_B1"
    custom_b32 = "Custom_B32"

class NetworkRuleAction(str, Enum):
    """The default action when no rule from ipRules and from virtualNetworkRules match. This is only
    used after the bypass property has been evaluated.
    """

    allow = "Allow"
    deny = "Deny"

class NetworkRuleBypassOptions(str, Enum):
    """Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not
    specified the default is 'AzureServices'.
    """

    azure_services = "AzureServices"
    none = "None"

class PrivateEndpointConnectionProvisioningState(str, Enum):
    """The current provisioning state.
    """

    succeeded = "Succeeded"
    creating = "Creating"
    updating = "Updating"
    deleting = "Deleting"
    failed = "Failed"
    disconnected = "Disconnected"

class PrivateEndpointServiceConnectionStatus(str, Enum):
    """The private endpoint connection status.
    """

    pending = "Pending"
    approved = "Approved"
    rejected = "Rejected"
    disconnected = "Disconnected"

class ProvisioningState(str, Enum):
    """Provisioning state.
    """

    succeeded = "Succeeded"  #: The managed HSM Pool has been full provisioned.
    provisioning = "Provisioning"  #: The managed HSM Pool is currently being provisioned.
    failed = "Failed"  #: Provisioning of the managed HSM Pool has failed.
    updating = "Updating"  #: The managed HSM Pool is currently being updated.
    deleting = "Deleting"  #: The managed HSM Pool is currently being deleted.
    activated = "Activated"  #: The managed HSM pool is ready for normal use.
    security_domain_restore = "SecurityDomainRestore"  #: The managed HSM pool is waiting for a security domain restore action.
    restoring = "Restoring"  #: The managed HSM pool is being restored from full HSM backup.

class Reason(str, Enum):
    """The reason that a vault name could not be used. The Reason element is only returned if
    NameAvailable is false.
    """

    account_name_invalid = "AccountNameInvalid"
    already_exists = "AlreadyExists"

class SecretPermissions(str, Enum):

    get = "get"
    list = "list"
    set = "set"
    delete = "delete"
    backup = "backup"
    restore = "restore"
    recover = "recover"
    purge = "purge"

class SkuName(str, Enum):
    """SKU name to specify whether the key vault is a standard vault or a premium vault.
    """

    standard = "standard"
    premium = "premium"

class StoragePermissions(str, Enum):

    get = "get"
    list = "list"
    delete = "delete"
    set = "set"
    update = "update"
    regeneratekey = "regeneratekey"
    recover = "recover"
    purge = "purge"
    backup = "backup"
    restore = "restore"
    setsas = "setsas"
    listsas = "listsas"
    getsas = "getsas"
    deletesas = "deletesas"
